package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchMoveVnNavigationScripts invokes the cloudcallcenter.BatchMoveVnNavigationScripts API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/batchmovevnnavigationscripts.html
func (client *Client) BatchMoveVnNavigationScripts(request *BatchMoveVnNavigationScriptsRequest) (response *BatchMoveVnNavigationScriptsResponse, err error) {
	response = CreateBatchMoveVnNavigationScriptsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchMoveVnNavigationScriptsWithChan invokes the cloudcallcenter.BatchMoveVnNavigationScripts API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/batchmovevnnavigationscripts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchMoveVnNavigationScriptsWithChan(request *BatchMoveVnNavigationScriptsRequest) (<-chan *BatchMoveVnNavigationScriptsResponse, <-chan error) {
	responseChan := make(chan *BatchMoveVnNavigationScriptsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchMoveVnNavigationScripts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchMoveVnNavigationScriptsWithCallback invokes the cloudcallcenter.BatchMoveVnNavigationScripts API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/batchmovevnnavigationscripts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchMoveVnNavigationScriptsWithCallback(request *BatchMoveVnNavigationScriptsRequest, callback func(response *BatchMoveVnNavigationScriptsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchMoveVnNavigationScriptsResponse
		var err error
		defer close(result)
		response, err = client.BatchMoveVnNavigationScripts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchMoveVnNavigationScriptsRequest is the request struct for api BatchMoveVnNavigationScripts
type BatchMoveVnNavigationScriptsRequest struct {
	*requests.RpcRequest
	NavigationScriptIds *[]string `position:"Query" name:"NavigationScriptIds"  type:"Repeated"`
	InstanceId          string    `position:"Query" name:"InstanceId"`
	TargetCategoryId    string    `position:"Query" name:"TargetCategoryId"`
}

// BatchMoveVnNavigationScriptsResponse is the response struct for api BatchMoveVnNavigationScripts
type BatchMoveVnNavigationScriptsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchMoveVnNavigationScriptsRequest creates a request to invoke BatchMoveVnNavigationScripts API
func CreateBatchMoveVnNavigationScriptsRequest() (request *BatchMoveVnNavigationScriptsRequest) {
	request = &BatchMoveVnNavigationScriptsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "BatchMoveVnNavigationScripts", "", "")
	request.Method = requests.GET
	return
}

// CreateBatchMoveVnNavigationScriptsResponse creates a response to parse from BatchMoveVnNavigationScripts response
func CreateBatchMoveVnNavigationScriptsResponse() (response *BatchMoveVnNavigationScriptsResponse) {
	response = &BatchMoveVnNavigationScriptsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
