package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SignOutGroup invokes the ccc.SignOutGroup API synchronously
func (client *Client) SignOutGroup(request *SignOutGroupRequest) (response *SignOutGroupResponse, err error) {
	response = CreateSignOutGroupResponse()
	err = client.DoAction(request, response)
	return
}

// SignOutGroupWithChan invokes the ccc.SignOutGroup API asynchronously
func (client *Client) SignOutGroupWithChan(request *SignOutGroupRequest) (<-chan *SignOutGroupResponse, <-chan error) {
	responseChan := make(chan *SignOutGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SignOutGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SignOutGroupWithCallback invokes the ccc.SignOutGroup API asynchronously
func (client *Client) SignOutGroupWithCallback(request *SignOutGroupRequest, callback func(response *SignOutGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SignOutGroupResponse
		var err error
		defer close(result)
		response, err = client.SignOutGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SignOutGroupRequest is the request struct for api SignOutGroup
type SignOutGroupRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	DeviceId   string `position:"Query" name:"DeviceId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// SignOutGroupResponse is the response struct for api SignOutGroup
type SignOutGroupResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateSignOutGroupRequest creates a request to invoke SignOutGroup API
func CreateSignOutGroupRequest() (request *SignOutGroupRequest) {
	request = &SignOutGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "SignOutGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateSignOutGroupResponse creates a response to parse from SignOutGroup response
func CreateSignOutGroupResponse() (response *SignOutGroupResponse) {
	response = &SignOutGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
