package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateDnsGtmCnameRrCanUse invokes the alidns.ValidateDnsGtmCnameRrCanUse API synchronously
func (client *Client) ValidateDnsGtmCnameRrCanUse(request *ValidateDnsGtmCnameRrCanUseRequest) (response *ValidateDnsGtmCnameRrCanUseResponse, err error) {
	response = CreateValidateDnsGtmCnameRrCanUseResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateDnsGtmCnameRrCanUseWithChan invokes the alidns.ValidateDnsGtmCnameRrCanUse API asynchronously
func (client *Client) ValidateDnsGtmCnameRrCanUseWithChan(request *ValidateDnsGtmCnameRrCanUseRequest) (<-chan *ValidateDnsGtmCnameRrCanUseResponse, <-chan error) {
	responseChan := make(chan *ValidateDnsGtmCnameRrCanUseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateDnsGtmCnameRrCanUse(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateDnsGtmCnameRrCanUseWithCallback invokes the alidns.ValidateDnsGtmCnameRrCanUse API asynchronously
func (client *Client) ValidateDnsGtmCnameRrCanUseWithCallback(request *ValidateDnsGtmCnameRrCanUseRequest, callback func(response *ValidateDnsGtmCnameRrCanUseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateDnsGtmCnameRrCanUseResponse
		var err error
		defer close(result)
		response, err = client.ValidateDnsGtmCnameRrCanUse(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateDnsGtmCnameRrCanUseRequest is the request struct for api ValidateDnsGtmCnameRrCanUse
type ValidateDnsGtmCnameRrCanUseRequest struct {
	*requests.RpcRequest
	CnameMode    string `position:"Query" name:"CnameMode"`
	CnameZone    string `position:"Query" name:"CnameZone"`
	CnameRr      string `position:"Query" name:"CnameRr"`
	CnameType    string `position:"Query" name:"CnameType"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// ValidateDnsGtmCnameRrCanUseResponse is the response struct for api ValidateDnsGtmCnameRrCanUse
type ValidateDnsGtmCnameRrCanUseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateValidateDnsGtmCnameRrCanUseRequest creates a request to invoke ValidateDnsGtmCnameRrCanUse API
func CreateValidateDnsGtmCnameRrCanUseRequest() (request *ValidateDnsGtmCnameRrCanUseRequest) {
	request = &ValidateDnsGtmCnameRrCanUseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "ValidateDnsGtmCnameRrCanUse", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidateDnsGtmCnameRrCanUseResponse creates a response to parse from ValidateDnsGtmCnameRrCanUse response
func CreateValidateDnsGtmCnameRrCanUseResponse() (response *ValidateDnsGtmCnameRrCanUseResponse) {
	response = &ValidateDnsGtmCnameRrCanUseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
