package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportSuspEvents invokes the aegis.ExportSuspEvents API synchronously
// api document: https://help.aliyun.com/api/aegis/exportsuspevents.html
func (client *Client) ExportSuspEvents(request *ExportSuspEventsRequest) (response *ExportSuspEventsResponse, err error) {
	response = CreateExportSuspEventsResponse()
	err = client.DoAction(request, response)
	return
}

// ExportSuspEventsWithChan invokes the aegis.ExportSuspEvents API asynchronously
// api document: https://help.aliyun.com/api/aegis/exportsuspevents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExportSuspEventsWithChan(request *ExportSuspEventsRequest) (<-chan *ExportSuspEventsResponse, <-chan error) {
	responseChan := make(chan *ExportSuspEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportSuspEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportSuspEventsWithCallback invokes the aegis.ExportSuspEvents API asynchronously
// api document: https://help.aliyun.com/api/aegis/exportsuspevents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExportSuspEventsWithCallback(request *ExportSuspEventsRequest, callback func(response *ExportSuspEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportSuspEventsResponse
		var err error
		defer close(result)
		response, err = client.ExportSuspEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportSuspEventsRequest is the request struct for api ExportSuspEvents
type ExportSuspEventsRequest struct {
	*requests.RpcRequest
	TimeEnd          string `position:"Query" name:"TimeEnd"`
	SourceIp         string `position:"Query" name:"SourceIp"`
	Name             string `position:"Query" name:"Name"`
	Dealed           string `position:"Query" name:"Dealed"`
	Remark           string `position:"Query" name:"Remark"`
	From             string `position:"Query" name:"From"`
	TimeStart        string `position:"Query" name:"TimeStart"`
	Lang             string `position:"Query" name:"Lang"`
	Levels           string `position:"Query" name:"Levels"`
	ParentEventTypes string `position:"Query" name:"ParentEventTypes"`
	Status           string `position:"Query" name:"Status"`
}

// ExportSuspEventsResponse is the response struct for api ExportSuspEvents
type ExportSuspEventsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	FileName  int    `json:"FileName" xml:"FileName"`
	Id        int    `json:"Id" xml:"Id"`
}

// CreateExportSuspEventsRequest creates a request to invoke ExportSuspEvents API
func CreateExportSuspEventsRequest() (request *ExportSuspEventsRequest) {
	request = &ExportSuspEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ExportSuspEvents", "vipaegis", "openAPI")
	return
}

// CreateExportSuspEventsResponse creates a response to parse from ExportSuspEvents response
func CreateExportSuspEventsResponse() (response *ExportSuspEventsResponse) {
	response = &ExportSuspEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
