package databricks

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// CustomParameterType enumerates the values for custom parameter type.
type CustomParameterType string

const (
	// CustomParameterTypeBool ...
	CustomParameterTypeBool CustomParameterType = "Bool"
	// CustomParameterTypeObject ...
	CustomParameterTypeObject CustomParameterType = "Object"
	// CustomParameterTypeString ...
	CustomParameterTypeString CustomParameterType = "String"
)

// PossibleCustomParameterTypeValues returns an array of possible values for the CustomParameterType const type.
func PossibleCustomParameterTypeValues() []CustomParameterType {
	return []CustomParameterType{CustomParameterTypeBool, CustomParameterTypeObject, CustomParameterTypeString}
}

// KeySource enumerates the values for key source.
type KeySource string

const (
	// KeySourceDefault ...
	KeySourceDefault KeySource = "Default"
	// KeySourceMicrosoftKeyvault ...
	KeySourceMicrosoftKeyvault KeySource = "Microsoft.Keyvault"
)

// PossibleKeySourceValues returns an array of possible values for the KeySource const type.
func PossibleKeySourceValues() []KeySource {
	return []KeySource{KeySourceDefault, KeySourceMicrosoftKeyvault}
}

// PeeringProvisioningState enumerates the values for peering provisioning state.
type PeeringProvisioningState string

const (
	// PeeringProvisioningStateDeleting ...
	PeeringProvisioningStateDeleting PeeringProvisioningState = "Deleting"
	// PeeringProvisioningStateFailed ...
	PeeringProvisioningStateFailed PeeringProvisioningState = "Failed"
	// PeeringProvisioningStateSucceeded ...
	PeeringProvisioningStateSucceeded PeeringProvisioningState = "Succeeded"
	// PeeringProvisioningStateUpdating ...
	PeeringProvisioningStateUpdating PeeringProvisioningState = "Updating"
)

// PossiblePeeringProvisioningStateValues returns an array of possible values for the PeeringProvisioningState const type.
func PossiblePeeringProvisioningStateValues() []PeeringProvisioningState {
	return []PeeringProvisioningState{PeeringProvisioningStateDeleting, PeeringProvisioningStateFailed, PeeringProvisioningStateSucceeded, PeeringProvisioningStateUpdating}
}

// PeeringState enumerates the values for peering state.
type PeeringState string

const (
	// PeeringStateConnected ...
	PeeringStateConnected PeeringState = "Connected"
	// PeeringStateDisconnected ...
	PeeringStateDisconnected PeeringState = "Disconnected"
	// PeeringStateInitiated ...
	PeeringStateInitiated PeeringState = "Initiated"
)

// PossiblePeeringStateValues returns an array of possible values for the PeeringState const type.
func PossiblePeeringStateValues() []PeeringState {
	return []PeeringState{PeeringStateConnected, PeeringStateDisconnected, PeeringStateInitiated}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
	// PrivateEndpointConnectionProvisioningStateUpdating ...
	PrivateEndpointConnectionProvisioningStateUpdating PrivateEndpointConnectionProvisioningState = "Updating"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded, PrivateEndpointConnectionProvisioningStateUpdating}
}

// PrivateLinkServiceConnectionStatus enumerates the values for private link service connection status.
type PrivateLinkServiceConnectionStatus string

const (
	// PrivateLinkServiceConnectionStatusApproved ...
	PrivateLinkServiceConnectionStatusApproved PrivateLinkServiceConnectionStatus = "Approved"
	// PrivateLinkServiceConnectionStatusDisconnected ...
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = "Disconnected"
	// PrivateLinkServiceConnectionStatusPending ...
	PrivateLinkServiceConnectionStatusPending PrivateLinkServiceConnectionStatus = "Pending"
	// PrivateLinkServiceConnectionStatusRejected ...
	PrivateLinkServiceConnectionStatusRejected PrivateLinkServiceConnectionStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns an array of possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{PrivateLinkServiceConnectionStatusApproved, PrivateLinkServiceConnectionStatusDisconnected, PrivateLinkServiceConnectionStatusPending, PrivateLinkServiceConnectionStatusRejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreated ...
	ProvisioningStateCreated ProvisioningState = "Created"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleted ...
	ProvisioningStateDeleted ProvisioningState = "Deleted"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateReady ...
	ProvisioningStateReady ProvisioningState = "Ready"
	// ProvisioningStateRunning ...
	ProvisioningStateRunning ProvisioningState = "Running"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateCanceled, ProvisioningStateCreated, ProvisioningStateCreating, ProvisioningStateDeleted, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateReady, ProvisioningStateRunning, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// RequiredNsgRules enumerates the values for required nsg rules.
type RequiredNsgRules string

const (
	// RequiredNsgRulesAllRules ...
	RequiredNsgRulesAllRules RequiredNsgRules = "AllRules"
	// RequiredNsgRulesNoAzureDatabricksRules ...
	RequiredNsgRulesNoAzureDatabricksRules RequiredNsgRules = "NoAzureDatabricksRules"
	// RequiredNsgRulesNoAzureServiceRules ...
	RequiredNsgRulesNoAzureServiceRules RequiredNsgRules = "NoAzureServiceRules"
)

// PossibleRequiredNsgRulesValues returns an array of possible values for the RequiredNsgRules const type.
func PossibleRequiredNsgRulesValues() []RequiredNsgRules {
	return []RequiredNsgRules{RequiredNsgRulesAllRules, RequiredNsgRulesNoAzureDatabricksRules, RequiredNsgRulesNoAzureServiceRules}
}
