create table Language
(
    Lang_Code char(2) not null
        constraint Language_pk
            primary key clustered,
    Lang_Name varchar(40) not null
        constraint Language_ak
            unique
)
go

create table Country 
(
    Ctr_Code char(2) not null
        constraint Country_pk
            primary key nonclustered,
    Ctr_Name varchar(80) not null
        constraint Country_ak
            unique,
    Lang_Code char(2) references Language        
)
go

create table Country_Synonym (
    Ctr_Code char(2) not null
        constraint Country_Synonym_Country_fk
            references Country,
    Lang_Code char(2) references Language,
    Syn_Name varchar(80) not null
)
    with (memory_optimized = ON, system_versioning = OFF)
go

alter table Country
    add /* languages */ Language_1 char(2) null,
                        Language_2 char(2) null
go

create index Country_Synonym_Code_Name_ui
    on Country_Synonym (Ctr_Code, Syn_Name)
go

alter table Country_Synonym
    add constraint Country_Synonym_pk
        primary key (Ctr_Code, Syn_Name)
go


create view Country_with_Language
as
select C.*,
       L.Lang_Name
from Country C,
     Language L
where C.Lang_Code = L.Lang_Code
go