/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.lang.ASTNode;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssStubElementTypes;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/psi/css/inspections/CssInvalidCustomPropertyAtRuleDeclarationUtils;", "", "<init>", "()V", "Companion", "intellij.css.analysis"})
public final class CssInvalidCustomPropertyAtRuleDeclarationUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/psi/css/inspections/CssInvalidCustomPropertyAtRuleDeclarationUtils$Companion;", "", "<init>", "()V", "getAbsentDeclarations", "", "", "node", "Lcom/intellij/lang/ASTNode;", "quote", "", "intellij.css.analysis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getAbsentDeclarations(@NotNull ASTNode node, char quote) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            boolean hasSyntax = false;
            boolean isUniversalSyntax = true;
            boolean hasInitialValue = false;
            boolean hasInherits = false;
            block10: for (ASTNode child : node.getChildren(TokenSet.ANY)) {
                ASTNode property;
                if (!Intrinsics.areEqual((Object)child.getElementType(), (Object)((Object)CssStubElementTypes.CSS_DECLARATION)) || !Intrinsics.areEqual((Object)(property = child.getFirstChildNode()).getElementType(), (Object)CssElementTypes.CSS_IDENT)) continue;
                switch (property.getText()) {
                    case "syntax": {
                        if (!Intrinsics.areEqual((Object)child.getLastChildNode().getText(), (Object)"\"*\"") && !Intrinsics.areEqual((Object)child.getLastChildNode().getText(), (Object)"'*'")) {
                            isUniversalSyntax = false;
                        }
                        hasSyntax = true;
                        continue block10;
                    }
                    case "initial-value": {
                        hasInitialValue = true;
                        continue block10;
                    }
                    case "inherits": {
                        hasInherits = true;
                    }
                }
            }
            Map absentProperties = new LinkedHashMap();
            if (!hasSyntax) {
                absentProperties.put("syntax", quote + "*" + quote);
            }
            if (!isUniversalSyntax && !hasInitialValue) {
                absentProperties.put("initial-value", "unset");
            }
            if (!hasInherits) {
                absentProperties.put("inherits", "false");
            }
            return absentProperties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

