/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.nodejs.NpmInstallQuickFix;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.ConfigureNodePathIntentionAction;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterExecutionSuppressor;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSLinterUtil {
    public static final Logger LOG = Logger.getInstance(JSLinterUtil.class);
    public static final NotificationGroup NOTIFICATION_GROUP = (NotificationGroup)Cancellation.forceNonCancellableSectionInClassInitializer(() -> NotificationGroupManager.getInstance().getNotificationGroup("Linters"));
    private static final HtmlChunk.Element RED_FONT = HtmlChunk.tag((String)"font").attr("color", "#" + ColorUtil.toHex((Color)JBColor.RED));

    private JSLinterUtil() {
    }

    @Nullable
    public static PackageJsonData getTopLevelPackageJsonData(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(0);
        }
        return (file = JSLinterConfigFileUtil.findDistinctConfigInContentRoots(project, Collections.singletonList("package.json"))) != null ? PackageJsonData.getOrCreate(file) : null;
    }

    static void createAnnotation(@NotNull AnnotationHolder holder, @NotNull HighlightSeverity severity, @Nullable TextAttributes forcedTextAttributes, @NotNull TextRange range, @NotNull @InspectionMessage String message, @NotNull @NlsContexts.Tooltip String tooltip, boolean afterEndOfLine, @NotNull List<? extends IntentionAction> fixes, @NotNull HighlightDisplayKey key, @Nullable ProblemGroup problemGroup) {
        if (holder == null) {
            JSLinterUtil.$$$reportNull$$$0(1);
        }
        if (severity == null) {
            JSLinterUtil.$$$reportNull$$$0(2);
        }
        if (range == null) {
            JSLinterUtil.$$$reportNull$$$0(3);
        }
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(4);
        }
        if (tooltip == null) {
            JSLinterUtil.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            JSLinterUtil.$$$reportNull$$$0(6);
        }
        if (key == null) {
            JSLinterUtil.$$$reportNull$$$0(7);
        }
        AnnotationBuilder builder2 = holder.newAnnotation(severity, message).range(range).needsUpdateOnTyping(false).tooltip(tooltip);
        if (forcedTextAttributes != null) {
            builder2 = builder2.enforcedTextAttributes(forcedTextAttributes);
        }
        if (afterEndOfLine) {
            builder2 = builder2.afterEndOfLine();
        }
        if (problemGroup != null) {
            builder2 = builder2.problemGroup(problemGroup);
        }
        for (IntentionAction intentionAction : fixes) {
            builder2 = builder2.newFix(intentionAction).key(key).registerFix();
        }
        builder2.create();
    }

    @NotNull
    public static TextAttributes getTextAttributes(@Nullable EditorColorsScheme editorColorsScheme, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightSeverity severity) {
        TextAttributes textAttributes;
        if (severityRegistrar == null) {
            JSLinterUtil.$$$reportNull$$$0(8);
        }
        if (severity == null) {
            JSLinterUtil.$$$reportNull$$$0(9);
        }
        if ((textAttributes = severityRegistrar.getTextAttributesBySeverity(severity)) != null) {
            TextAttributes textAttributes2 = textAttributes;
            if (textAttributes2 == null) {
                JSLinterUtil.$$$reportNull$$$0(10);
            }
            return textAttributes2;
        }
        EditorColorsScheme colorsScheme = JSLinterUtil.getColorsScheme(editorColorsScheme);
        HighlightInfoType.HighlightInfoTypeImpl infoType = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
        TextAttributesKey key = infoType.getAttributesKey();
        TextAttributes textAttributes3 = colorsScheme.getAttributes(key);
        if (textAttributes3 == null) {
            JSLinterUtil.$$$reportNull$$$0(11);
        }
        return textAttributes3;
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        if (customScheme != null) {
            EditorColorsScheme editorColorsScheme = customScheme;
            if (editorColorsScheme == null) {
                JSLinterUtil.$$$reportNull$$$0(12);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            JSLinterUtil.$$$reportNull$$$0(13);
        }
        return editorColorsScheme;
    }

    @NotNull
    public static List<JSLinterError> limitErrorsAtTheSamePosition(@NotNull @Unmodifiable List<? extends JSLinterError> errors, int limit) {
        if (errors == null) {
            JSLinterUtil.$$$reportNull$$$0(14);
        }
        errors = ContainerUtil.sorted(errors, (o1, o2) -> o1.compareFully((JSLinterError)o2));
        JSLinterError prev = null;
        ArrayList<JSLinterError> limited = new ArrayList<JSLinterError>();
        int count = 0;
        for (JSLinterError error : errors) {
            if (prev != null && prev.compareLogicalPositionTo(error) == 0) {
                if (prev.getDescription().equals(error.getDescription())) continue;
                ++count;
            } else {
                count = 1;
            }
            if (count <= limit) {
                limited.add(error);
            }
            prev = error;
        }
        ArrayList<JSLinterError> arrayList = limited;
        if (arrayList == null) {
            JSLinterUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static TextFieldWithBrowseButton createTextFieldWithBrowseButton(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String description, @NotNull Disposable uiDisposable) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(16);
        }
        if (description == null) {
            JSLinterUtil.$$$reportNull$$$0(17);
        }
        if (uiDisposable == null) {
            JSLinterUtil.$$$reportNull$$$0(18);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(new JTextField(0));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(description);
        JTextField textField = (JTextField)textFieldWithBrowseButton.getChildComponent();
        textField.setDisabledTextColor(UIUtil.getLabelDisabledForeground());
        textFieldWithBrowseButton.addBrowseFolderListener(project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, uiDisposable);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            JSLinterUtil.$$$reportNull$$$0(19);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    public static JEditorPane createDefaultContent(@NotNull @Nls String message) {
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(20);
        }
        return JSLinterUtil.createHtmlViewer(message, null);
    }

    @NotNull
    public static JEditorPane createHtmlViewer(@NotNull @Nls String innerBodyHtml, @Nullable Font font) {
        if (innerBodyHtml == null) {
            JSLinterUtil.$$$reportNull$$$0(21);
        }
        if (font == null) {
            font = StartupUiUtil.getLabelFont();
        }
        JEditorPane pane = SwingHelper.createHtmlViewer((boolean)true, (Font)font, null, null);
        String html = HtmlChunk.html().children(new HtmlChunk[]{HtmlChunk.head().addRaw(UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getLabelForeground(), null, null)), HtmlChunk.body().addRaw(innerBodyHtml)}).toString();
        pane.setText(html);
        JEditorPane jEditorPane = pane;
        if (jEditorPane == null) {
            JSLinterUtil.$$$reportNull$$$0(22);
        }
        return jEditorPane;
    }

    private static int getRadioIconWidth() {
        Icon icon = UIManager.getIcon("RadioButton.icon");
        if (icon != null) {
            return icon.getIconWidth();
        }
        return 12;
    }

    public static int getMarginForRadioButton(@NotNull JRadioButton radioButton) {
        if (radioButton == null) {
            JSLinterUtil.$$$reportNull$$$0(23);
        }
        return radioButton.getInsets().left + radioButton.getMargin().left + JSLinterUtil.getRadioIconWidth() + radioButton.getIconTextGap();
    }

    public static boolean isVueFile(@NotNull PsiFile file) {
        Language vue;
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(24);
        }
        return (vue = Language.findLanguageByID((String)"Vue")) != null && vue.equals(file.getLanguage());
    }

    public static boolean isPureHtmlFile(@NotNull PsiFile file) {
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(25);
        }
        if (file.getLanguage() == HTMLLanguage.INSTANCE) {
            FileType fileTypeByName = FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName());
            return fileTypeByName == HtmlFileType.INSTANCE;
        }
        return false;
    }

    @NotNull
    public static String getAbsoluteOrRelativePathToProjectRoot(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile root;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(26);
        }
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(27);
        }
        if ((root = project.getBaseDir()) != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    JSLinterUtil.$$$reportNull$$$0(28);
                }
                return string;
            }
            String string = root.getName() + File.separatorChar + relativePath;
            if (string == null) {
                JSLinterUtil.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (string == null) {
            JSLinterUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    public static IntentionAction createDetailsAction(@NotNull Project project, @NotNull VirtualFile fileToLint, @Nullable GeneralCommandLine commandLine, @NotNull ProcessOutput output, @Nullable Icon icon) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(31);
        }
        if (fileToLint == null) {
            JSLinterUtil.$$$reportNull$$$0(32);
        }
        if (output == null) {
            JSLinterUtil.$$$reportNull$$$0(33);
        }
        String presentableFilePath = (String)ReadAction.compute(() -> project.isDisposed() ? fileToLint.getPresentableUrl() : JSLinterUtil.getAbsoluteOrRelativePathToProjectRoot(project, fileToLint));
        return new JsqtViewProcessOutputAction(JavaScriptBundle.message("javascript.linter.error.failed.to.lint", presentableFilePath), icon, commandLine, null, output);
    }

    @NotNull
    public static VirtualFile checkPath(@NotNull String path2, boolean isDir, @NotNull String fieldName) throws ExecutionException {
        VirtualFile result2;
        if (path2 == null) {
            JSLinterUtil.$$$reportNull$$$0(34);
        }
        if (fieldName == null) {
            JSLinterUtil.$$$reportNull$$$0(35);
        }
        if ((result2 = JSLinterUtil.createVirtualFileOrNull(path2, isDir)) == null) {
            throw new ExecutionException(JavaScriptBundle.message("javascript.linter.error.specify.correct.path.to", fieldName));
        }
        VirtualFile virtualFile = result2;
        if (virtualFile == null) {
            JSLinterUtil.$$$reportNull$$$0(36);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile createVirtualFileOrNull(@NotNull String path2, boolean isDir) {
        VirtualFile virtualFile;
        if (path2 == null) {
            JSLinterUtil.$$$reportNull$$$0(37);
        }
        if ((virtualFile = JSLinterConfigFileUtil.findLocalFileByPath(path2)) == null || !virtualFile.isValid() || isDir != virtualFile.isDirectory()) {
            return null;
        }
        return virtualFile;
    }

    @Contract(value="_,null,_,_,_ -> !null")
    @Nullable
    public static JSLinterFileLevelAnnotation validateInterpreterAndPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable NodePackage nodePackage, @NotNull String packageName, @Nullable VirtualFile contextFile) {
        String errorMessage;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(38);
        }
        if (packageName == null) {
            JSLinterUtil.$$$reportNull$$$0(39);
        }
        if ((errorMessage = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter2)) != null) {
            JSLinterStandardFixes fixes = new JSLinterStandardFixes().setShowEditSettings(false).setEditConfig(false).setOtherFixes(Collections.singletonList(new ConfigureNodePathIntentionAction()));
            return new JSLinterFileLevelAnnotation(null, StringUtil.decapitalize((String)errorMessage), HighlightSeverity.ERROR, fixes);
        }
        String packagePath = nodePackage != null ? nodePackage.getSystemDependentPath() : "";
        JSLinterFileLevelAnnotation annotation = JSLinterExecutionSuppressor.annotationFromExecutionSuppressor(project, packagePath);
        if (annotation != null) {
            return annotation;
        }
        if (nodePackage == null || !(interpreter2 instanceof NodeJsRemoteInterpreter) && !nodePackage.isValid(project)) {
            return JSLinterUtil.createLinterPackageError(project, packagePath, packageName, contextFile);
        }
        return null;
    }

    public static JSLinterFileLevelAnnotation createLinterPackageError(@NotNull Project project, @NotNull String packagePath, @NonNls @NotNull String packageName, @Nullable VirtualFile contextFile) {
        String projectBasePath;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(40);
        }
        if (packagePath == null) {
            JSLinterUtil.$$$reportNull$$$0(41);
        }
        if (packageName == null) {
            JSLinterUtil.$$$reportNull$$$0(42);
        }
        if (StringUtil.isEmptyOrSpaces((String)packagePath)) {
            LOG.debug(String.format("Path to package %s is empty", packageName));
            return new JSLinterFileLevelAnnotation(JavaScriptBundle.message("javascript.linter.error.no.path.to.package", packageName));
        }
        File path2 = new File(packagePath);
        if (path2.getParentFile() != null && "node_modules".equals(path2.getParentFile().getName()) && (projectBasePath = project.getBasePath()) != null && FileUtil.isAncestor((File)new File(projectBasePath), (File)path2, (boolean)true)) {
            VirtualFile packageJson;
            LOG.debug(String.format("Package %s is not installed in path %s", packageName, packagePath));
            String message = JavaScriptBundle.message("javascript.linter.error.package.not.installed", packageName);
            JSLinterFileLevelAnnotation annotation = new JSLinterFileLevelAnnotation(null, message, HighlightSeverity.ERROR, new JSLinterStandardFixes());
            VirtualFile virtualFile = packageJson = contextFile != null ? PackageJsonUtil.findUpPackageJson(contextFile) : null;
            if (packageJson != null) {
                annotation.getFixes().setOtherFixes(Collections.singletonList(new NpmInstallQuickFix(project, packageJson)));
            }
            return annotation;
        }
        LOG.debug(String.format("Path to package %s is invalid: %s", packageName, packagePath));
        return new JSLinterFileLevelAnnotation(JavaScriptBundle.message("javascript.linter.error.invalid.path.to.package", packageName));
    }

    @Nullable
    public static Document getDocumentForElement(@NotNull PsiElement element) {
        if (element == null) {
            JSLinterUtil.$$$reportNull$$$0(43);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && psiFile.isValid()) {
            psiFile = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile.getOriginalFile());
            return PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        }
        return null;
    }

    public static void reportCodeStyleSettingsAlreadyImported(@NotNull Project project, String toolName) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(44);
        }
        NOTIFICATION_GROUP.createNotification(JavaScriptBundle.message("javascript.linter.import.nothing.to.import", toolName), NotificationType.INFORMATION).notify(project);
    }

    public static void reportCodeStyleSettingsImported(@NotNull Project project, @NotNull String linterName, @NotNull VirtualFile file, @NotNull Collection<String> importedRuleNames, @Nullable Runnable resetAction) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(45);
        }
        if (linterName == null) {
            JSLinterUtil.$$$reportNull$$$0(46);
        }
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(47);
        }
        if (importedRuleNames == null) {
            JSLinterUtil.$$$reportNull$$$0(48);
        }
        Object message = JavaScriptBundle.message("javascript.linter.import.notification", linterName, file.getName());
        if (!importedRuleNames.isEmpty()) {
            String rulesText = StringUtil.join(importedRuleNames, (String)", ");
            message = (String)message + "\n" + JavaScriptBundle.message("javascript.linter.import.notification.rules.applied", importedRuleNames.size() == 1 ? "rule was" : "rules were", rulesText);
        }
        JSLinterUtil.reportCodeStyleSettingsImported(project, (String)message, file, resetAction);
    }

    public static void reportCodeStyleSettingsImported(final @NotNull Project project, @NotNull @NlsContexts.NotificationContent String message, final @Nullable VirtualFile file, final @Nullable Runnable resetAction) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(49);
        }
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(50);
        }
        Notification notification = NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION);
        if (file != null) {
            notification.addAction((AnAction)new NotificationAction(JavaScriptBundle.message("javascript.linter.import.notification.edit", file.getName())){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!file.isValid()) {
                        return;
                    }
                    if (project.isDisposed()) {
                        return;
                    }
                    PsiNavigationSupport.getInstance().createNavigatable(project, file, 0).navigate(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterUtil$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (resetAction != null) {
            notification.addAction((AnAction)new NotificationAction(JavaScriptBundle.message("javascript.linter.import.notification.reset", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (project.isDisposed()) {
                        return;
                    }
                    resetAction.run();
                    NOTIFICATION_GROUP.createNotification(JavaScriptBundle.message("javascript.linter.import.notification.restored", new Object[0]), NotificationType.INFORMATION).notify(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterUtil$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification.notify(project);
    }

    @NotNull
    @Nls
    public static String getRedErrorTextHtml(@InspectionMessage String errorMessage) {
        String string = new HtmlBuilder().append((HtmlChunk)RED_FONT.addText(errorMessage)).wrapWithHtmlBody().toString();
        if (string == null) {
            JSLinterUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public static CharSequence convertLineSeparatorsToFileOriginal(@NotNull Project project, @NotNull CharSequence fileContent, @NotNull VirtualFile file) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(52);
        }
        if (fileContent == null) {
            JSLinterUtil.$$$reportNull$$$0(53);
        }
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(54);
        }
        CharSequence charSequence = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(project, fileContent, file);
        if (charSequence == null) {
            JSLinterUtil.$$$reportNull$$$0(55);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 15, 19, 22, 28, 29, 30, 36, 51, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: 
            case 20: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiDisposable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerBodyHtml";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "radioButton";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePath";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedRuleNames";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "limitErrorsAtTheSamePosition";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextFieldWithBrowseButton";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlViewer";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteOrRelativePathToProjectRoot";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPath";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedErrorTextHtml";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparatorsToFileOriginal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelPackageJsonData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 51: 
            case 55: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "limitErrorsAtTheSamePosition";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTextFieldWithBrowseButton";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlViewer";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMarginForRadioButton";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isVueFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isPureHtmlFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteOrRelativePathToProjectRoot";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsAction";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualFileOrNull";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "validateInterpreterAndPackage";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createLinterPackageError";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentForElement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "reportCodeStyleSettingsAlreadyImported";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "reportCodeStyleSettingsImported";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparatorsToFileOriginal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 15, 19, 22, 28, 29, 30, 36, 51, 55 -> new IllegalStateException(string);
        };
    }
}

