/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingLibraryIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryListGroup
extends ActionGroup {
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Project project = e != null ? e.getProject() : null;
        AnAction[] anActionArray = project != null ? JSLibraryListGroup.getLibraryActions(project) : AnAction.EMPTY_ARRAY;
        if (anActionArray == null) {
            JSLibraryListGroup.$$$reportNull$$$0(0);
        }
        return anActionArray;
    }

    private static AnAction @NotNull [] getLibraryActions(@NotNull Project project) {
        if (project == null) {
            JSLibraryListGroup.$$$reportNull$$$0(1);
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        List<ScriptingLibraryModel> libraries = JSLibraryListGroup.sort(libraryManager.getAllLibraries());
        boolean predefinedSeparator = false;
        for (ScriptingLibraryModel library : libraries) {
            if (library.isPredefined() && !predefinedSeparator) {
                actions.add(new Separator(JavaScriptBundle.message("titled.separator.predefined", new Object[0])));
                predefinedSeparator = true;
            }
            actions.add((Object)new MySetJsLibraryAction(library, mappings));
        }
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            JSLibraryListGroup.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    @NotNull
    private static List<ScriptingLibraryModel> sort(ScriptingLibraryModel @NotNull [] libraries) {
        if (libraries == null) {
            JSLibraryListGroup.$$$reportNull$$$0(3);
        }
        ArrayList<ScriptingLibraryModel> result2 = new ArrayList<ScriptingLibraryModel>(Arrays.asList(libraries));
        result2.sort((lib1, lib2) -> {
            if (lib1.isPredefined() != lib2.isPredefined()) {
                return lib1.isPredefined() ? 1 : -1;
            }
            return lib1.getName().compareToIgnoreCase(lib2.getName());
        });
        ArrayList<ScriptingLibraryModel> arrayList = result2;
        if (arrayList == null) {
            JSLibraryListGroup.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/ui/JSLibraryListGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/ui/JSLibraryListGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class MySetJsLibraryAction
    extends AnAction {
        private final ScriptingLibraryModel myLibrary;
        private final JSLibraryMappings myMappings;

        private MySetJsLibraryAction(@NotNull ScriptingLibraryModel library, @NotNull JSLibraryMappings mappings) {
            if (library == null) {
                MySetJsLibraryAction.$$$reportNull$$$0(0);
            }
            if (mappings == null) {
                MySetJsLibraryAction.$$$reportNull$$$0(1);
            }
            super(StringUtil.escapeMnemonics((String)library.getName()), null, null);
            this.myLibrary = library;
            this.myMappings = mappings;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySetJsLibraryAction.$$$reportNull$$$0(2);
            }
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            Presentation presentation = e.getPresentation();
            if (file == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setEnabledAndVisible(true);
            if (this.myMappings.isLibraryInScopeFor(file, this.myLibrary.getName())) {
                presentation.setIcon(ScriptingLibraryIcons.CHECKED_ICON);
                if (this.myMappings.isAssociatedWith(file, this.myLibrary.getName())) {
                    presentation.setDescription(JavaScriptBundle.messagePointer("action.don.t.use.library.description", new Object[0]));
                } else {
                    presentation.setEnabled(false);
                    presentation.setDescription(JavaScriptBundle.messagePointer("action.already.set.for.containing.folder.or.project.description", new Object[0]));
                }
            } else {
                presentation.setIcon(ScriptingLibraryIcons.UNCHECKED_ICON);
                presentation.setDescription(JavaScriptBundle.messagePointer("action.use.library.description", new Object[0]));
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MySetJsLibraryAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MySetJsLibraryAction.$$$reportNull$$$0(4);
            }
            Project project = e.getProject();
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (project == null || file == null) {
                return;
            }
            WriteAction.run(() -> {
                JSLibraryManager manager = JSLibraryManager.getInstance(project);
                ScriptingLibraryMappings mappings = manager.getLibraryMappings();
                if (this.myMappings.isLibraryInScopeFor(file, this.myLibrary.getName())) {
                    if (this.myMappings.isAssociatedWith(file, this.myLibrary.getName())) {
                        mappings.disassociate(file, this.myLibrary.getName());
                    }
                } else {
                    mappings.associate(file, this.myLibrary.getName(), this.myLibrary.isPredefined());
                }
                manager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappings";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/library/ui/JSLibraryListGroup$MySetJsLibraryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/library/ui/JSLibraryListGroup$MySetJsLibraryAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

