/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.builders;

import com.carrotsearch.hppc.IntIntHashMap;
import java.util.BitSet;
import morfologik.fsa.FSA;
import morfologik.fsa.FSA5;

public final class FSAInfo {
    public final int nodeCount;
    public final int arcsCount;
    public final int arcsCountTotal;
    public final int finalStatesCount;
    public final int size;

    public FSAInfo(FSA fsa) {
        NodeVisitor w = new NodeVisitor(fsa);
        int root = fsa.getRootNode();
        if (root > 0) {
            w.visitNode(root);
        }
        this.nodeCount = 1 + w.nodes;
        this.arcsCount = 1 + w.arcs;
        this.arcsCountTotal = 1 + w.totalArcs;
        FinalStateVisitor fsv = new FinalStateVisitor(fsa);
        this.finalStatesCount = fsv.visitNode(fsa.getRootNode());
        this.size = fsa instanceof FSA5 ? ((FSA5)fsa).arcs.length : 0;
    }

    public FSAInfo(int nodeCount, int arcsCount, int arcsCountTotal, int finalStatesCount) {
        this.nodeCount = nodeCount;
        this.arcsCount = arcsCount;
        this.arcsCountTotal = arcsCountTotal;
        this.finalStatesCount = finalStatesCount;
        this.size = 0;
    }

    public String toString() {
        return "Nodes: " + this.nodeCount + ", arcs visited: " + this.arcsCount + ", arcs total: " + this.arcsCountTotal + ", final states: " + this.finalStatesCount + ", size: " + this.size;
    }

    private static class FinalStateVisitor {
        final IntIntHashMap visitedNodes = new IntIntHashMap();
        private final FSA fsa;

        FinalStateVisitor(FSA fsa) {
            this.fsa = fsa;
        }

        public int visitNode(int node) {
            int index = this.visitedNodes.indexOf(node);
            if (index >= 0) {
                return this.visitedNodes.indexGet(index);
            }
            int fromHere = 0;
            int arc = this.fsa.getFirstArc(node);
            while (arc != 0) {
                if (this.fsa.isArcFinal(arc)) {
                    ++fromHere;
                }
                if (!this.fsa.isArcTerminal(arc)) {
                    fromHere += this.visitNode(this.fsa.getEndNode(arc));
                }
                arc = this.fsa.getNextArc(arc);
            }
            this.visitedNodes.put(node, fromHere);
            return fromHere;
        }
    }

    private static class NodeVisitor {
        final BitSet visitedArcs = new BitSet();
        final BitSet visitedNodes = new BitSet();
        int nodes;
        int arcs;
        int totalArcs;
        private final FSA fsa;

        NodeVisitor(FSA fsa) {
            this.fsa = fsa;
        }

        public void visitNode(int node) {
            if (this.visitedNodes.get(node)) {
                return;
            }
            this.visitedNodes.set(node);
            ++this.nodes;
            int arc = this.fsa.getFirstArc(node);
            while (arc != 0) {
                if (!this.visitedArcs.get(arc)) {
                    ++this.arcs;
                }
                ++this.totalArcs;
                this.visitedArcs.set(arc);
                if (!this.fsa.isArcTerminal(arc)) {
                    this.visitNode(this.fsa.getEndNode(arc));
                }
                arc = this.fsa.getNextArc(arc);
            }
        }
    }
}

