/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.editor.SqlColors;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.symbols.DasPsiWrappingSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlAnnotator
implements Annotator,
DumbAware {
    private static boolean ourTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private static Logger LOG = Logger.getInstance(SqlAnnotator.class);

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SqlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SqlAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof IsExternal) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(SqlColors.SQL_EXTERNAL_TOOL).create();
        } else if (element instanceof SqlElement) {
            try {
                ((SqlElement)element).accept((SqlVisitor)new Visitor(holder));
            }
            catch (IndexNotReadyException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    public static PsiElement getTargetByIdElement(PsiElement o, boolean forceResolved) {
        PsiElement candidate2;
        PsiElement parent = o.getParent();
        if (parent instanceof SqlDefinition && ((SqlDefinition)parent).getNameElement() == o) {
            candidate2 = parent;
        } else if (parent instanceof SqlReferenceExpression) {
            PsiElement target2 = ((SqlReferenceExpression)parent).resolve();
            candidate2 = forceResolved || target2 != null ? target2 : parent;
        } else {
            candidate2 = null;
        }
        return SqlAnnotator.getTargetElement(candidate2);
    }

    private static PsiElement getTargetElement(PsiElement candidate2) {
        DasObject result2;
        if (candidate2 instanceof DasSynonym && ((DasSynonym)candidate2).getKind() == SqlDbElementType.SYNONYM && ((result2 = DasUtil.resolveFinalTarget((DasSynonym)candidate2)) == null || result2 instanceof PsiElement)) {
            return (PsiElement)result2;
        }
        return candidate2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/editor/SqlAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends SqlVisitor {
        private final AnnotationHolder myHolder;

        Visitor(AnnotationHolder holder) {
            this.myHolder = holder;
        }

        protected final void setHighlighting(@NotNull PsiElement element, TextAttributesKey key2) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.setHighlighting(element, key2, null, false);
        }

        protected final void setHighlighting(@NotNull PsiElement element, TextAttributesKey key2, @InspectionMessage @Nullable String message, boolean forceErase) {
            ASTNode firstChild;
            if (element == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            HighlightSeverity severity = ourTestMode && message != null ? HighlightSeverity.WEAK_WARNING : HighlightSeverity.INFORMATION;
            String actualMessage = message == null && ourTestMode ? key2.getExternalName() : message;
            ASTNode node = element.getNode();
            ASTNode aSTNode = firstChild = node == null ? null : node.getFirstChildNode();
            if (forceErase || firstChild != null && firstChild.getElementType() instanceof SqlKeywordTokenType) {
                if (actualMessage == null) {
                    this.myHolder.newSilentAnnotation(severity).range(element).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
                } else {
                    this.myHolder.newAnnotation(severity, actualMessage).range(element).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
                }
            }
            if (actualMessage == null) {
                this.myHolder.newSilentAnnotation(severity).range(element).textAttributes(key2).create();
            } else {
                this.myHolder.newAnnotation(severity, actualMessage).range(element).textAttributes(key2).create();
            }
        }

        public void visitSqlIdentifier(SqlIdentifier o) {
            this.highlightDefinitionElement(SqlAnnotator.getTargetByIdElement((PsiElement)o, false), (SqlElement)o);
        }

        public void visitSqlTypeElement(SqlTypeElement o) {
            for (ASTNode node : o.getNode().getChildren(null)) {
                if (node.getElementType() == SqlCommonTokens.SQL_LEFT_PAREN) break;
                if (!(node.getElementType() instanceof SqlKeywordTokenType)) continue;
                PsiElement psi = node.getPsi();
                this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(psi).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
                this.setHighlighting(psi, SqlColors.SQL_TYPE);
            }
        }

        public void visitSqlReferenceExpression(SqlReferenceExpression o) {
            SqlIdentifier identifier = o.getIdentifier();
            SqlExpression qualifier = o.getQualifierExpression();
            if (identifier == null && qualifier == null) {
                this.highlightDefinitionElement(SqlAnnotator.getTargetElement(o.resolve()), (SqlElement)o);
            }
        }

        public void visitSqlStringLiteralExpression(SqlStringLiteralExpression o) {
            PsiReference ref2 = o.getReference();
            if (ref2 != null) {
                this.highlightDefinitionElement(ref2.resolve(), (SqlElement)o);
            }
        }

        public void visitSqlParameter(SqlParameter o) {
            this.highlightDefinitionElement((PsiElement)o, (SqlElement)o);
        }

        private static boolean isOuterQueryColumn(SqlElement elementToHighlight) {
            SqlTableExpression tableExpression;
            if (!(elementToHighlight instanceof SqlIdentifier)) {
                return false;
            }
            PsiElement ref2 = elementToHighlight.getParent();
            if (!(ref2 instanceof SqlReferenceExpression)) {
                return false;
            }
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref2, SqlQueryExpression.class);
            SqlTableExpression sqlTableExpression = tableExpression = query != null ? query.getTableExpression() : null;
            if (tableExpression == null) {
                return false;
            }
            ResolveResult result2 = ((SqlReferenceExpression)ref2).getReference().resolveSingle();
            if (result2 == null || result2.getElement() == ref2) {
                return false;
            }
            PsiElement qualifier = result2 instanceof SqlResolveResult ? ((SqlResolveResult)result2).getImmediateQualifier() : null;
            return qualifier instanceof SqlExpression && !PsiTreeUtil.isAncestor((PsiElement)tableExpression, (PsiElement)qualifier, (boolean)true);
        }

        private void setColumnHighlighting(SqlElement elementToHighlight) {
            boolean isOuterQueryColumn = Visitor.isOuterQueryColumn(elementToHighlight);
            TextAttributesKey key2 = isOuterQueryColumn ? SqlColors.SQL_OUTER_QUERY_COLUMN : SqlColors.SQL_COLUMN;
            String message = isOuterQueryColumn ? SqlBundle.message((String)"SqlAnnotator.inspection.message.outer.query.column", (Object[])new Object[0]) : null;
            this.setHighlighting((PsiElement)elementToHighlight, key2, message, false);
        }

        private static boolean isRoutine(SqlReferenceExpression expression) {
            if (DbImplUtilCore.isRoutine(expression.getReferenceElementType().getTargetKind())) {
                return true;
            }
            DasSymbol symbol = expression.resolveSymbol();
            return symbol != null && DbImplUtilCore.isRoutine(symbol.getKind());
        }

        private boolean highlightByObjectKind(SqlElement elementToHighlight, ObjectKind kind) {
            if (kind == SqlDbElementType.SCHEMA) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_SCHEMA);
            } else if (kind == SqlDbElementType.TABLE) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_TABLE);
            } else if (kind == SqlDbElementType.COLUMN) {
                this.setColumnHighlighting(elementToHighlight);
            } else if (kind == SqlDbElementType.LOCAL_ALIAS) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_LOCAL_ALIAS);
            } else if (kind == SqlDbElementType.QUERY_PARAMETER) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PARAMETER);
            } else if (kind == SqlDbElementType.ARGUMENT) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_VARIABLE);
            } else if (kind == SqlDbElementType.VARIABLE) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_VARIABLE);
            } else if (kind == SqlDbElementType.LABEL) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_LABEL);
            } else if (DbImplUtilCore.isRoutine(kind)) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
            } else {
                TextAttributesKey key2 = SqlImplUtil.getSqlDialectSafe((PsiElement)elementToHighlight).getHighlightingByCustomKind(kind);
                if (key2 == null) {
                    return false;
                }
                this.setHighlighting((PsiElement)elementToHighlight, key2);
            }
            return true;
        }

        private void highlightDefinitionElement(PsiElement target2, SqlElement elementToHighlight) {
            if (target2 == null) {
                return;
            }
            if (target2 instanceof SqlReferenceExpression) {
                if (SqlImplUtil.isAsteriskRef(target2)) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_SYNTHETIC_ENTITY);
                    return;
                }
                if (this.highlightByObjectKind(elementToHighlight, ((SqlReferenceExpression)target2).getKind())) {
                    return;
                }
                if (Visitor.isRoutine((SqlReferenceExpression)target2)) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
                } else {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_DATABASE_OBJECT);
                }
            } else if (target2 instanceof DasPsiWrappingSymbol) {
                DasObject object = ((DasPsiWrappingSymbol)target2).getDasObject();
                if (object instanceof BuiltinFunction) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
                } else {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_DATABASE_OBJECT);
                }
            } else if (target2 instanceof SqlDefinition) {
                this.highlightByObjectKind(elementToHighlight, ((SqlDefinition)target2).getKind());
            } else if (target2 instanceof SqlFunctionCallExpression) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
            } else if (target2 instanceof SqlParameter) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PARAMETER);
            } else if (target2 instanceof DasColumn) {
                this.setColumnHighlighting(elementToHighlight);
            } else if (target2 instanceof DasTable) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_TABLE);
            } else if (target2 instanceof DasRoutine) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
            } else if (target2 instanceof DasNamespace) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_SCHEMA);
            } else if (target2 instanceof DasUserDefinedType) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_TYPE);
            } else {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_DATABASE_OBJECT);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/editor/SqlAnnotator$Visitor", "setHighlighting"));
        }
    }
}

