/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.VmElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.DbmsObjectEditorFactoryKt;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelIdentity;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.DbModelResetHelper;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbDuplicateObjectAction;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.database.schemaEditor.ui.DbFamilyTableEditor;
import com.intellij.database.schemaEditor.ui.DbStructureEditorActions;
import com.intellij.database.schemaEditor.ui.DbStructureEditorDnD;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeTreeModel;
import com.intellij.database.schemaEditor.ui.DbVisualEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureEditor<E extends BasicElement>
extends DbVisualEditorBase<E, DbStructureModelState> {
    public static final DataKey<DbStructureEditor<?>> KEY = DataKey.create((String)"DbStructureEditor");
    private final DbStructureNodeTreeModel myStructureTreeModel;
    private final JBEditorTabs myTabs;
    private final JTree myTree;
    private final JComponent myComponent;
    private final History myHistory;
    private final Map<DbModelRef<?, ?>, DbVisualEditor<?, ?>> myCache;
    private boolean myDblClickEditing;

    @NotNull
    private DbVisualEditor<?, ?> createEditorPage(DbModelRef<?, ?> m) {
        Object editor2;
        Object obj2 = m.getState();
        if (obj2 instanceof DbObjectModelState) {
            DbObjectModelState os = (DbObjectModelState)obj2;
            editor2 = Objects.requireNonNull(this.getController().createEditor(m.castState(os)));
            DbVisualEditor dbVisualEditor = (DbVisualEditor)editor2;
            if (dbVisualEditor == null) {
                DbStructureEditor.$$$reportNull$$$0(0);
            }
            return dbVisualEditor;
        }
        editor2 = m.getState();
        if (editor2 instanceof DbStructureFamilyModelState) {
            DbStructureFamilyModelState fs = (DbStructureFamilyModelState)editor2;
            editor2 = new DbFamilyTableEditor(this.getController(), m.castState(fs));
            DbVisualEditor dbVisualEditor = (DbVisualEditor)DbmsObjectEditorFactoryKt.init(editor2);
            if (dbVisualEditor == null) {
                DbStructureEditor.$$$reportNull$$$0(1);
            }
            return dbVisualEditor;
        }
        throw new AssertionError((Object)("Unexpected model " + String.valueOf(m)));
    }

    public DbStructureEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbStructureModelState> modelRef) {
        if (controller == null) {
            DbStructureEditor.$$$reportNull$$$0(2);
        }
        if (modelRef == null) {
            DbStructureEditor.$$$reportNull$$$0(3);
        }
        super(controller, modelRef);
        this.myHistory = new History((Place.Navigator)new MyNavigator());
        this.myCache = FactoryMap.createMap(this::createEditorPage, LinkedHashMap::new);
        this.myDblClickEditing = PropertiesComponent.getInstance().getBoolean("DbStructureEditor.dblClickEditing", false);
        this.myStructureTreeModel = new DbStructureNodeTreeModel(controller, controller);
        this.myTree = new DnDAwareTree(this.myStructureTreeModel){

            public void processMouseEvent(MouseEvent e) {
                if (DbStructureEditor.this.myDblClickEditing && e.getClickCount() == 2) {
                    DbStructureEditor.this.editByDblClick(e);
                }
                super.processMouseEvent(e);
            }
        };
        this.myTree.setRootVisible(false);
        this.myTabs = this.createTabs(controller);
        StructureRenderer renderer2 = controller.getBuilder().createStructureRenderer(controller);
        renderer2.setHighlighter(n -> {
            if (!this.myDblClickEditing) {
                return false;
            }
            DbModelState s = (DbModelState)ObjectUtils.tryCast(n.getState(), DbStructureObjectModelState.class);
            ElementIdentity id = s == null ? null : n.getIdentity();
            TabInfo curTab = this.myTabs.getSelectedInfo();
            DbVisualEditor<?, ?> curEditor = DbStructureEditor.extractEditor(curTab);
            ElementIdentity curId = curEditor == null ? null : curEditor.getIdentity();
            return id != null && curId != null && (id == curId || curId instanceof MultiElementIdentity && ((MultiElementIdentity)curId).getIdentities().contains(id));
        });
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)renderer2));
        DbStructureEditorActions.CreateObjectGroup addAction = new DbStructureEditorActions.CreateObjectGroup();
        DbStructureEditorActions.DeleteAction removeAction = new DbStructureEditorActions.DeleteAction();
        DbDuplicateObjectAction dupAction = new DbDuplicateObjectAction();
        DbStructureEditorActions.MoveAction moveUpAction = new DbStructureEditorActions.MoveAction(true);
        DbStructureEditorActions.MoveAction moveDownAction = new DbStructureEditorActions.MoveAction(false);
        DbStructureEditorActions.EditAction editSource = new DbStructureEditorActions.EditAction();
        DbStructureEditorActions.ToggleDblClickAction dbClickEditing = new DbStructureEditorActions.ToggleDblClickAction();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).addExtraAction((AnAction)addAction).addExtraAction((AnAction)removeAction).addExtraAction((AnAction)dupAction).addExtraAction((AnAction)moveUpAction).addExtraAction((AnAction)moveDownAction).addExtraAction((AnAction)editSource).addExtraAction((AnAction)dbClickEditing).setPreferredSize((Dimension)JBUI.size((int)350, (int)300));
        AnAction extra = ActionManager.getInstance().getAction("DbStructureEditor.Toolbar.Ext");
        if (extra != null) {
            decorator.addExtraAction(extra);
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction back = actionManager.getAction("Back");
        AnAction fwd = actionManager.getAction("Forward");
        if (back != null) {
            decorator.addExtraAction((AnAction)new RightAligned(back));
        }
        if (fwd != null) {
            decorator.addExtraAction((AnAction)new RightAligned(fwd));
        }
        JComponent component = UiDataProvider.wrapComponent((JComponent)decorator.createPanel(), sink -> {
            Object[] paths = this.myTree.getSelectionPaths();
            sink.set(PlatformCoreDataKeys.SELECTED_ITEM, paths == null || paths.length == 0 ? null : paths[0].getLastPathComponent());
            sink.set(PlatformCoreDataKeys.SELECTED_ITEMS, paths == null ? null : ContainerUtil.map2Array((Object[])paths, TreePath::getLastPathComponent));
        });
        Splitter splitter = new Splitter(false, 0.5f);
        splitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.DISTRIBUTE);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setFirstComponent(component);
        splitter.setSecondComponent((JComponent)this.myTabs);
        this.myComponent = UiDataProvider.wrapComponent((JComponent)splitter, sink -> {
            sink.set(KEY, (Object)this);
            sink.set(History.KEY, (Object)this.myHistory);
        });
        DefaultActionGroup contextMenu = this.getController().getBuilder().createStructureContextMenu();
        DbStructureEditorActions.registerActionsRecursively((AnAction)contextMenu, this.myTree);
        PopupHandler.installPopupMenu((JComponent)this.myTree, (ActionGroup)contextMenu, (String)ActionPlaces.getPopupPlace((String)"DbStructureEditor.Context"));
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (DbStructureEditor.this.myDblClickEditing) {
                    return;
                }
                DbStructureEditor.this.editBySelection();
            }
        });
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c2) {
                return DbStructureEditor.this.getTransferable();
            }

            @Override
            public int getSourceActions(JComponent c2) {
                return 1;
            }
        });
        this.setupDnD();
        splitter.setDefaultProportion();
        this.applyDblClickEditingState();
    }

    private void setupDnD() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        DnDManager.getInstance().registerTarget((DnDTarget)new DbStructureEditorDnD.TreeDnDTarget(this), (JComponent)this.myTree);
        DnDManager.getInstance().registerSource(new DnDSource(){

            public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
                if (dragOrigin == null) {
                    4.$$$reportNull$$$0(0);
                }
                return action == DnDAction.MOVE;
            }

            public DnDDragStartBean startDragging(DnDAction action, @NotNull Point dragOrigin) {
                if (dragOrigin == null) {
                    4.$$$reportNull$$$0(1);
                }
                return new DnDDragStartBean((Object)DbStructureEditor.this.getTransferable(), dragOrigin);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dragOrigin";
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canStartDragging";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startDragging";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (JComponent)this.myTree);
        this.myTree.setDragEnabled(true);
    }

    @Nullable
    private Transferable getTransferable() {
        ElementIdentity<?> identity = MultiElementIdentity.asSingleIdentityFiltered(this.getSelectedIds());
        return identity == null ? null : new DbStructureEditorDnD.DbIdTransferable(this.getController(), identity);
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusComponent() {
        TabInfo current = this.myTabs.getSelectedInfo();
        if (current == null) {
            JTree jTree = this.myTree;
            if (jTree == null) {
                DbStructureEditor.$$$reportNull$$$0(4);
            }
            return jTree;
        }
        JComponent jComponent = (JComponent)ObjectUtils.chooseNotNull((Object)current.getLastFocusOwner(), (Object)current.getPreferredFocusableComponent());
        if (jComponent == null) {
            DbStructureEditor.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    public void addTabsListener(final @NotNull Consumer<ElementIdentity<?>> consumer) {
        if (consumer == null) {
            DbStructureEditor.$$$reportNull$$$0(6);
        }
        this.myTabs.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                DbVisualEditor<?, ?> editor2 = DbStructureEditor.extractEditor(newSelection);
                consumer.accept(editor2 == null ? null : editor2.getIdentity());
            }

            public void tabRemoved(@NotNull TabInfo tabToRemove) {
                if (tabToRemove == null) {
                    5.$$$reportNull$$$0(0);
                }
                this.selectionChanged(tabToRemove, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabToRemove", "com/intellij/database/schemaEditor/ui/DbStructureEditor$5", "tabRemoved"));
            }
        });
    }

    @NotNull
    private JBEditorTabs createTabs(@NotNull DbEditorController controller) {
        if (controller == null) {
            DbStructureEditor.$$$reportNull$$$0(7);
        }
        final ProperTabs tabs = new ProperTabs(controller.getProject(), controller){

            @NotNull
            public List<TabInfo> getVisibleInfos() {
                ArrayList<TabInfo> res2 = new ArrayList<TabInfo>(this.getTabs());
                res2.retainAll(super.getVisibleInfos());
                ArrayList<TabInfo> arrayList = res2;
                if (arrayList == null) {
                    6.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @Nullable
            protected JComponent getFocusOwnerToStore() {
                JComponent owner = super.getFocusOwnerToStore();
                if (owner == null) {
                    return null;
                }
                EditorTextField etf = (EditorTextField)ComponentUtil.getParentOfType(EditorTextField.class, (Component)owner);
                return etf == null ? owner : etf;
            }

            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    6.$$$reportNull$$$0(1);
                }
                super.uiDataSnapshot(sink);
                JBIterable nodes2 = DbStructureEditor.this.getNodesForSelectedTab().collect();
                sink.set(PlatformCoreDataKeys.SELECTED_ITEM, DbStructureEditor.this.getNodesForSelectedTab().first());
                sink.set(PlatformCoreDataKeys.SELECTED_ITEMS, nodes2.isEmpty() ? null : nodes2.toList().toArray());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$6";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sink";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisibleInfos";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "uiDataSnapshot";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        tabs.setPreferredSize((Dimension)JBUI.size((int)600, (int)500));
        tabs.addTabMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TabInfo info2;
                if (UIUtil.isCloseClick((MouseEvent)e) && (info2 = tabs.findInfo(e)) != null) {
                    tabs.removeTab(info2);
                }
            }
        });
        tabs.setTabLabelActionsAutoHide(false);
        tabs.setRequestFocusOnLastFocusedComponent(true);
        tabs.setPopupGroup((ActionGroup)new DefaultActionGroup(new AnAction[]{new DbStructureEditorActions.PinTabAction(), new DbStructureEditorActions.CloseTabAction(), new DbStructureEditorActions.RevertAction()}), "debuggerTabPopup", true);
        tabs.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                DbStructureEditor.this.myTree.repaint();
                if (newSelection != null) {
                    DbStructureEditor.this.myHistory.pushQueryPlace();
                }
            }

            public void tabRemoved(@NotNull TabInfo tabToRemove) {
                DbVisualEditor<?, ?> editor2;
                MultiElementIdentity multiId;
                if (tabToRemove == null) {
                    8.$$$reportNull$$$0(0);
                }
                MultiElementIdentity multiElementIdentity = multiId = (editor2 = DbStructureEditor.extractEditor(tabToRemove)) == null ? null : (MultiElementIdentity)ObjectUtils.tryCast(editor2.getIdentity(), MultiElementIdentity.class);
                if (multiId == null) {
                    return;
                }
                DbStructureEditor.this.unregister(editor2.getModelRef());
                DbEditorModel ss = DbStructureEditor.this.getController().getModelController().getStructureNodeModel(multiId);
                if (ss != null) {
                    ss.unregister();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabToRemove", "com/intellij/database/schemaEditor/ui/DbStructureEditor$8", "tabRemoved"));
            }
        }, controller);
        controller.getEventDispatcher().addListener((EventListener)new DbEditorListener(){

            @Override
            public void removed(@NotNull DbEditor<?, ?> editor2) {
                DbStructureNodeEditor se;
                DbModelRef model;
                if (editor2 == null) {
                    9.$$$reportNull$$$0(0);
                }
                DbModelRef dbModelRef = model = (se = (DbStructureNodeEditor)ObjectUtils.tryCast(editor2, DbStructureNodeEditor.class)) == null ? null : DbStructureEditor.structure2pageModel(se.getModelRef());
                if (model != null) {
                    DbStructureEditor.this.unregister(model);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/schemaEditor/ui/DbStructureEditor$9", "removed"));
            }
        }, (Disposable)controller);
        this.myStructureTreeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent event) {
                DbStructureNodeEditor<?, ?> editor2 = DbStructureNodeTreeModel.getEditor(event.getTreePath());
                DbModelRef objectRef = editor2 == null ? null : ((DbStructureNodeState)editor2.getState()).getObjectRef();
                TabInfo info2 = DbStructureEditor.this.findTabByModel(objectRef);
                if (info2 != null) {
                    DbStructureEditor.this.updateTab(info2);
                }
            }

            private void modifyIfRoot(TreeModelEvent event) {
                if (this.isRootEvent(event)) {
                    DbStructureEditor.this.modified();
                }
            }

            private boolean isRootEvent(TreeModelEvent event) {
                TreePath path = event.getTreePath();
                if (path == null || path.getLastPathComponent() == DbStructureEditor.this.getStructure().getRoot()) {
                    return true;
                }
                DbStructureNodeEditor<?, ?> e = DbStructureNodeTreeModel.getEditor(path);
                Object parent = e == null ? null : DbStructureEditor.this.getStructure().getParentNode(e);
                return DbStructureEditor.this.getStructure().getRoot() == parent || parent instanceof DbStructureModelState.Group;
            }

            public void treeNodesInserted(TreeModelEvent event) {
                this.modifyIfRoot(event);
            }

            public void treeNodesRemoved(TreeModelEvent event) {
                this.validateTabs();
                this.modifyIfRoot(event);
            }

            public void treeStructureChanged(TreeModelEvent event) {
                this.validateTabs();
                this.modifyIfRoot(event);
            }

            private void validateTabs() {
                for (TabInfo tab : DbStructureEditor.this.myTabs.getTabs()) {
                    boolean dropped;
                    DbVisualEditor<?, ?> editor2 = DbStructureEditor.extractEditor(tab);
                    if (editor2 == null || !(dropped = this.isDropped(DbStructureEditor.this.page2structure(editor2)))) continue;
                    DbStructureEditor.this.myTabs.removeTab(tab);
                }
            }

            private <E2 extends BasicElement, S extends DbStructureNodeState<?, ?>> boolean isDropped(@Nullable DbStructureNodeEditor<E2, S> se) {
                JBIterable models2 = DbStructureEditor.this.getExpandedModelsFor(se).collect();
                return models2.isEmpty() || models2.find(m -> !DbStructureEditor.this.getStructure().isInTree(DbStructureEditor.this.getStructure().pathOf(m))) != null;
            }
        });
        ProperTabs properTabs = tabs;
        if (properTabs == null) {
            DbStructureEditor.$$$reportNull$$$0(8);
        }
        return properTabs;
    }

    private void unregister(@NotNull DbModelRef<?, ?> ref2) {
        DbVisualEditor<?, DbObjectModelState<?>> page;
        if (ref2 == null) {
            DbStructureEditor.$$$reportNull$$$0(9);
        }
        if ((page = this.removeCachedEditor(ref2)) != null) {
            page.unregister(false);
        } else if (ref2.getIdentity() instanceof MultiElementIdentity) {
            ref2.unregister(this.getController().getModelController());
        }
    }

    @Nullable
    private TabInfo findTabByModel(@Nullable DbModelRef<?, ?> pageModel) {
        if (pageModel == null) {
            return null;
        }
        int sz = this.myTabs.getTabCount();
        for (int i2 = 0; i2 < sz; ++i2) {
            TabInfo tab = this.myTabs.getTabAt(i2);
            DbVisualEditor<?, ?> editor2 = DbStructureEditor.extractEditor(tab);
            if (editor2 == null || editor2.getModelRef() != pageModel) continue;
            return tab;
        }
        return null;
    }

    @Nullable
    private TabInfo findTab(@Nullable DbVisualEditor<?, ?> pageEditor) {
        return pageEditor == null ? null : this.myTabs.findInfo(pageEditor);
    }

    @NotNull
    private JBIterable<DbStructureNodeEditor<?, ?>> getNodesForSelectedTab() {
        TabInfo info2 = this.myTabs.getTargetInfo();
        DbVisualEditor<?, ?> pageEditor = DbStructureEditor.extractEditor(info2);
        JBIterable jBIterable = this.getExpandedModelsFor(this.page2structure(pageEditor)).filterMap(r -> DbStructureNodeTreeModel.getEditor(this.getController(), r));
        if (jBIterable == null) {
            DbStructureEditor.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private <E extends BasicElement, S extends DbStructureNodeState<?, ?>> JBIterable<DbModelRef<E, S>> getExpandedModelsFor(@Nullable DbStructureNodeEditor<E, S> structureEditor) {
        if (structureEditor == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbStructureEditor.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        DbModelIdentity modelId = structureEditor.getModelRef().getModelIdentity();
        @NotNull DbEditorModelController modelController = this.getController().getModelController();
        JBIterable jBIterable = MultiElementIdentity.expand(modelId.getIdentity()).filterMap(id -> DbModelRef.create(modelController.resolveModel(modelId.switchTo(id))));
        if (jBIterable == null) {
            DbStructureEditor.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Nullable
    TabInfo getCurrentTab(@NotNull AnActionEvent e) {
        TabLabel tabLbl;
        TabInfo info2;
        if (e == null) {
            DbStructureEditor.$$$reportNull$$$0(13);
        }
        TabInfo tabInfo = info2 = (tabLbl = (TabLabel)UIUtil.getParentOfType(TabLabel.class, (Component)((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)))) == null ? null : tabLbl.getInfo();
        if (info2 == null) {
            return this.myTabs.getTargetInfo();
        }
        return info2;
    }

    @Nullable
    public DbEditor<?, ?> getSelectedEditor() {
        TabInfo info2 = this.myTabs.getSelectedInfo();
        if (info2 == null) {
            return null;
        }
        return DbStructureEditor.extractEditor(info2);
    }

    private void editBySelection() {
        this.edit(this.getSelectedNodes(), false);
    }

    public void edit(JBIterable<DbStructureNodeEditor<?, ?>> selected, boolean requestFocus) {
        DbModelRef<?, DbStructureNodeState> ref2 = this.getEditorOrMultiEditorRef(selected);
        this.selectEditor(ref2, false, false, requestFocus, true);
    }

    @Nullable
    private DbModelRef<?, ? extends DbStructureNodeState> getEditorOrMultiEditorRef(@NotNull JBIterable<DbStructureNodeEditor<?, ?>> selected) {
        DbStructureNodeEditor first2;
        if (selected == null) {
            DbStructureEditor.$$$reportNull$$$0(14);
        }
        if ((first2 = (DbStructureNodeEditor)selected.first()) == null) {
            return null;
        }
        if (first2.getState() instanceof DbStructureFamilyModelState) {
            return first2.getModelRef();
        }
        ElementIdentity identity = MultiElementIdentity.asSingleIdentityFiltered(selected.map(DbEditor::getIdentity), first2.getIdentity().getMetaObject());
        return identity == null ? null : this.getStructureModelRef(identity);
    }

    @NotNull
    private JBIterable<DbStructureNodeEditor<?, ?>> getSelectedNodes() {
        JBIterable jBIterable = JBIterable.of((Object[])this.myTree.getSelectionPaths()).filterMap(DbStructureNodeTreeModel::getEditor).collect();
        if (jBIterable == null) {
            DbStructureEditor.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<ElementIdentity<?>> getSelectedIds() {
        JBIterable selected = JBIterable.of((Object[])this.myTree.getSelectionPaths()).filterMap(DbStructureEditor::extractIdentity);
        JBIterable jBIterable = selected.collect();
        if (jBIterable == null) {
            DbStructureEditor.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @Nullable
    private static ElementIdentity<?> extractIdentity(TreePath p2) {
        DbModelRef<?, DbStructureNodeState> model = DbStructureEditor.extractModelRef(p2);
        DbStructureObjectModelState state = (DbStructureObjectModelState)ObjectUtils.tryCast((Object)(model == null ? null : model.getState()), DbStructureObjectModelState.class);
        return state == null ? null : model.getIdentity();
    }

    private void editByDblClick(MouseEvent e) {
        TreePath path = this.myTree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            DbModelRef<?, DbStructureNodeState> m = DbStructureEditor.extractModelRef(path);
            this.selectEditor(m, false, false, true, true);
        }
        e.consume();
    }

    public boolean isDblClickEditing() {
        return this.myDblClickEditing;
    }

    public void setDblClickEditing(boolean dblClickEditing) {
        this.myDblClickEditing = dblClickEditing;
        PropertiesComponent.getInstance().setValue("DbStructureEditor.dblClickEditing", this.myDblClickEditing, false);
        this.applyDblClickEditingState();
        if (!this.myDblClickEditing) {
            this.editBySelection();
        }
    }

    private void applyDblClickEditingState() {
        this.myTree.setToggleClickCount(this.myDblClickEditing ? -1 : 2);
    }

    public DbStructureNodeTreeModel getStructure() {
        return this.myStructureTreeModel;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void removeNode(@Nullable DbStructureNodeEditor<?, ?> node, boolean changeSelection) {
        if (node == null || !(node.getState() instanceof DbStructureObjectModelState)) {
            return;
        }
        DbStructureNodeEditor parent = DbStructureNodeTreeModel.getParentEditorImpl(node);
        if (parent == null) {
            Object pn = this.myStructureTreeModel.getParentNode(node);
            if (pn == null) {
                return;
            }
            node.unregister(false);
            return;
        }
        ArrayList children2 = new ArrayList(parent.getChildren());
        int idx = children2.indexOf(node);
        if (idx == -1) {
            return;
        }
        if (changeSelection) {
            int selIdx = idx + 1;
            if (selIdx >= children2.size()) {
                selIdx = idx - 1;
            }
            DbStructureNodeEditor newSelection = selIdx < 0 ? parent : (DbStructureNodeEditor)children2.get(selIdx);
            this.myTree.setSelectionPath(this.getStructure().pathOf(newSelection));
        }
        children2.remove(idx);
        parent.setChildren(children2);
    }

    protected void insertNode(DbStructureNodeEditor<?, ?> parent, int idx, DbStructureNodeEditor<?, ?> node, boolean changeSelection) {
        ArrayList children2 = new ArrayList(parent.getChildren());
        children2.add(idx, node);
        parent.setChildren(children2);
        if (changeSelection) {
            this.myTree.setSelectionPath(this.getStructure().pathOf(node));
        }
    }

    public void edit(@NotNull DbModelRef<?, ? extends DbStructureNodeState> model) {
        if (model == null) {
            DbStructureEditor.$$$reportNull$$$0(17);
        }
        this.selectEditor(model, false, false, true, true);
    }

    public void edit(@NotNull ElementIdentity<?> identity) {
        if (identity == null) {
            DbStructureEditor.$$$reportNull$$$0(18);
        }
        this.selectEditor(identity, false, false, true, true);
    }

    @NotNull
    private <T extends BasicElement> DbModelRef<T, DbStructureObjectModelState<T>> getStructureModelRef(@NotNull ElementIdentity<T> identity) {
        DbEditorModelController controller;
        DbEditorModel<T, DbStructureObjectModelState<T>> model;
        if (identity == null) {
            DbStructureEditor.$$$reportNull$$$0(19);
        }
        if ((model = (controller = this.getController().getModelController()).getStructureNodeModel(identity)) != null) {
            return new DbModelRef<T, DbStructureObjectModelState<T>>(model);
        }
        if (identity instanceof MultiElementIdentity) {
            for (ElementIdentity id : ((MultiElementIdentity)identity).getIdentities()) {
                controller.createObjectEditorModel(id);
            }
        }
        model = controller.createStructureNodeModel(identity);
        DbModelResetHelper.resetOne(controller, null, identity);
        return new DbModelRef<T, DbStructureObjectModelState<T>>(model);
    }

    public void expandAll(@Nullable ElementIdentity<?> id) {
        DbModelRef<?, DbStructureObjectModelState<?>> model = id == null ? null : this.getStructureModelRef(id);
        DbStructureNodeEditor<?, DbStructureObjectModelState<?>> editor2 = model == null ? null : this.getController().getStructureNodeEditor(model);
        TreePath path = this.myStructureTreeModel.pathOf(editor2);
        if (path != null) {
            TreeUtil.expand((JTree)this.myTree, (TreeVisitor)new TreeVisitor.ByTreePath<Object>(path, (Function)Functions.id()){

                @NotNull
                protected TreeVisitor.Action visit(@NotNull TreePath path, @NotNull Object component, int depth) {
                    if (path == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    if (component == null) {
                        11.$$$reportNull$$$0(1);
                    }
                    TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                    if (action == null) {
                        11.$$$reportNull$$$0(2);
                    }
                    return action;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "component";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$11";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$11";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visit";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visit";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            }, p2 -> {});
        }
    }

    public void selectEditor(@Nullable ElementIdentity<?> id, boolean selectInTree, boolean openInBg, boolean requestFocus, boolean closeUnpinned) {
        DbModelRef<?, DbStructureObjectModelState<?>> model = id == null ? null : this.getStructureModelRef(id);
        this.selectEditor(model, selectInTree, openInBg, requestFocus, closeUnpinned);
    }

    void selectEditor(@Nullable DbModelRef<?, ? extends DbStructureNodeState> model, boolean selectInTree, boolean openInBg, boolean requestFocus, boolean closeUnpinned) {
        DbVisualEditor<?, ?> editor2 = this.structure2page(model);
        this.selectEditor(editor2, selectInTree, openInBg, requestFocus, closeUnpinned);
    }

    @Nullable
    private DbVisualEditor<?, DbObjectModelState<?>> getOrCreateEditor(@Nullable DbModelRef<?, DbObjectModelState<?>> m) {
        return m == null ? null : this.myCache.get(m);
    }

    @Nullable
    private DbVisualEditor<?, DbObjectModelState<?>> removeCachedEditor(@Nullable DbModelRef<?, ?> m) {
        return m == null ? null : this.myCache.remove(m);
    }

    @Nullable
    private DbVisualEditor<?, DbStructureFamilyModelState<?>> getOrCreateEditor2(@Nullable DbModelRef<?, DbStructureFamilyModelState<?>> m) {
        return m == null ? null : this.myCache.get(m);
    }

    @Nullable
    private DbVisualEditor<?, DbStructureFamilyModelState<?>> removeCachedEditor2(@Nullable DbModelRef<?, DbStructureFamilyModelState<?>> m) {
        return m == null ? null : this.myCache.remove(m);
    }

    @Nullable
    private DbStructureNodeEditor<?, ?> page2structure(@Nullable DbVisualEditor<?, ?> page) {
        if (page == null) {
            return null;
        }
        Object s = page.getState();
        if (s instanceof DbStructureFamilyModelState) {
            DbStructureFamilyModelState s2 = (DbStructureFamilyModelState)s;
            return DbStructureNodeTreeModel.getEditor(this.getController(), page.getModelRef().castState(s2));
        }
        if (page.getState() instanceof DbObjectModelState) {
            return DbStructureNodeTreeModel.getEditor(this.getController(), page.getIdentity());
        }
        throw new AssertionError((Object)("Not a page editor " + String.valueOf(page)));
    }

    @Nullable
    private DbVisualEditor<?, ?> structure2page(@NotNull DbStructureNodeEditor<?, ?> structure) {
        if (structure == null) {
            DbStructureEditor.$$$reportNull$$$0(20);
        }
        return this.structure2page(structure.getModelRef());
    }

    @Nullable
    private DbVisualEditor<?, ?> structure2page(@Nullable DbModelRef<?, ? extends DbStructureNodeState> structure) {
        DbModelRef<?, ?> model = DbStructureEditor.structure2pageModel(structure);
        return model == null ? null : this.myCache.get(model);
    }

    @Nullable
    private static DbModelRef<?, ?> structure2pageModel(@Nullable DbModelRef<?, ? extends DbStructureNodeState> structure) {
        if (structure == null) {
            return null;
        }
        DbStructureNodeState dbStructureNodeState = structure.getState();
        if (dbStructureNodeState instanceof DbStructureFamilyModelState) {
            DbStructureFamilyModelState fs = (DbStructureFamilyModelState)dbStructureNodeState;
            return structure.castState(fs);
        }
        dbStructureNodeState = structure.getState();
        if (dbStructureNodeState instanceof DbStructureObjectModelState) {
            DbStructureObjectModelState ss = (DbStructureObjectModelState)dbStructureNodeState;
            return ss.getObjectRef();
        }
        throw new AssertionError((Object)("Not a structure editor " + String.valueOf(structure)));
    }

    private void selectEditor(@Nullable DbVisualEditor<?, ?> pageEditor, boolean selectInTree, boolean openInBg, boolean requestFocus, boolean closeUnpinned) {
        this.selectTab(pageEditor, openInBg, requestFocus, closeUnpinned);
        DbStructureNodeEditor<?, ?> node = this.page2structure(pageEditor);
        if (selectInTree) {
            this.selectInTree(node);
        } else {
            this.expandInTree(node);
        }
        this.myTree.repaint();
    }

    private void selectTab(@Nullable DbVisualEditor<?, ?> pageEditor, boolean openInBg, boolean requestFocus, boolean closeUnpinned) {
        int idx;
        TabInfo info2;
        TabInfo sel = this.myTabs.getSelectedInfo();
        if (pageEditor == null && sel == null) {
            return;
        }
        if (pageEditor != null && sel != null && pageEditor.equals(DbStructureEditor.extractEditor(sel))) {
            if (requestFocus) {
                this.myTabs.select(sel, true);
            }
            return;
        }
        if (pageEditor != null && (info2 = this.findTab(pageEditor)) != null) {
            if (!openInBg) {
                this.myTabs.select(info2, requestFocus);
            }
            return;
        }
        int n = closeUnpinned ? this.closeUnpinnedTabs((Condition<TabInfo>)(openInBg ? s -> s == sel : null)) : (idx = this.myTabs.getTabCount() - 1);
        if (pageEditor != null) {
            JComponent component = pageEditor.getComponent();
            GridLayoutManager gl = (GridLayoutManager)ObjectUtils.tryCast((Object)component.getLayout(), GridLayoutManager.class);
            if (gl != null && gl.getRowCount() == 1 && component.getComponentCount() == 1) {
                GridConstraints gc = gl.getConstraintsForComponent(component.getComponent(0));
                gc.setUseParentLayout(false);
            }
            JBScrollPane scrollPane = DbStructureEditor.createScrollPaneWithOpaqueScrollbars(component);
            TabInfo info3 = new TabInfo((JComponent)scrollPane);
            info3.setObject(pageEditor);
            info3.setPreferredFocusableComponent(pageEditor.getPreferredFocusComponent());
            info3.setTabLabelActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new DbStructureEditorActions.PinTabAction()}), "debuggerTabToolbar");
            this.myTabs.addTab(info3, idx);
            if (!openInBg) {
                this.myTabs.select(info3, requestFocus);
            }
            this.updateTab(info3);
        }
    }

    @NotNull
    private static JBScrollPane createScrollPaneWithOpaqueScrollbars(@NotNull JComponent component) {
        if (component == null) {
            DbStructureEditor.$$$reportNull$$$0(21);
        }
        return new JBScrollPane(component){

            public JScrollBar createVerticalScrollBar() {
                return 12.createScrollBar(1);
            }

            @NotNull
            public JScrollBar createHorizontalScrollBar() {
                return 12.createScrollBar(0);
            }

            @NotNull
            private static JBScrollBar createScrollBar(int vertical) {
                return new JBScrollBar(vertical){

                    public void setOpaque(boolean isOpaque) {
                        super.setOpaque(true);
                    }
                };
            }
        };
    }

    private void selectInTree(@Nullable DbStructureNodeEditor<?, ?> editor2) {
        TreePath path = this.getStructure().pathOf(editor2);
        this.myTree.setSelectionPath(path);
        if (path != null) {
            TreeUtil.scrollToVisible((JTree)this.myTree, (TreePath)path, (boolean)false);
        }
    }

    private void expandInTree(@Nullable DbStructureNodeEditor<?, ?> editor2) {
        TreePath path = this.getStructure().pathOf(editor2);
        if (path != null) {
            path = path.getParentPath();
        }
        this.myTree.expandPath(path);
    }

    private int closeUnpinnedTabs(@Nullable Condition<TabInfo> keepExtra) {
        List tabs = this.myTabs.getTabs();
        ArrayList<TabInfo> toRemove = new ArrayList<TabInfo>(tabs.size());
        int idx = -1;
        TabInfo sel = this.myTabs.getSelectedInfo();
        for (int i2 = 0; i2 < tabs.size(); ++i2) {
            boolean keep;
            TabInfo tab = (TabInfo)tabs.get(i2);
            boolean bl = keep = tab.isPinned() || keepExtra != null && keepExtra.value((Object)tab);
            if (!keep) {
                toRemove.add(tab);
            }
            if (tab != sel) continue;
            idx = i2 + 1 - toRemove.size();
        }
        for (TabInfo t : toRemove) {
            this.closeEditor(t);
        }
        return idx == -1 ? tabs.size() - toRemove.size() : idx;
    }

    void closeEditor(TabInfo t) {
        ElementIdentity identity;
        DbVisualEditor<?, ?> editor2 = DbStructureEditor.extractEditor(t);
        ElementIdentity elementIdentity = identity = editor2 == null ? null : editor2.getIdentity();
        if (identity instanceof MultiElementIdentity) {
            this.removeCachedEditor(editor2.getModelRef());
            editor2.unregister(false);
            DbEditorModel mm = this.getController().getModelController().getStructureNodeModel(identity);
            if (mm != null) {
                mm.unregister();
            }
        }
        this.myTabs.removeTab(t);
    }

    @Nullable
    private static DbVisualEditor<?, ?> extractEditor(@Nullable TabInfo t) {
        return t == null ? null : (DbVisualEditor)ObjectUtils.tryCast((Object)t.getObject(), DbVisualEditor.class);
    }

    private void updateTab(@NotNull TabInfo info2) {
        if (info2 == null) {
            DbStructureEditor.$$$reportNull$$$0(22);
        }
        if (!this.myTabs.getTabs().contains(info2)) {
            return;
        }
        this.updateTab(info2, DbStructureEditor.extractEditor(info2));
    }

    private <E extends BasicElement> void updateTab(@NotNull TabInfo info2, @Nullable DbVisualEditor<E, ?> editor2) {
        Object properties2;
        if (info2 == null) {
            DbStructureEditor.$$$reportNull$$$0(23);
        }
        if (editor2 == null) {
            return;
        }
        if (editor2.getState() instanceof DbObjectModelState) {
            ElementIdentity identity = editor2.getIdentity();
            properties2 = StructureRenderer.getObjectToRender(this.getController(), identity);
            Icon baseIcon = this.getController().getBuilder().getIcon((BasicElement)properties2);
            info2.setIcon(baseIcon);
            info2.clearText(false);
            String prefix = this.getController().getBuilder().getDisplayNamePrefix(identity);
            if (prefix != null) {
                info2.append(prefix, SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
            }
            Color color = DbStructureEditor.getFgColor(this.getController().getModelController().getStructureNodeModel(identity));
            String name2 = this.getController().getBuilder().getDisplayName(identity, properties2);
            info2.append(StringUtil.trimMiddle((String)name2, (int)20), SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, color, null, null));
        }
        if ((properties2 = editor2.getState()) instanceof DbStructureFamilyModelState) {
            DbStructureFamilyModelState fs = (DbStructureFamilyModelState)properties2;
            ElementIdentity identity = editor2.getIdentity();
            Object properties3 = StructureRenderer.getObjectToRender(this.getController(), identity);
            String name3 = this.getController().getBuilder().getDisplayName(identity, properties3);
            info2.setText(fs.getMetaObject().kind.getPluralPresentableName());
            info2.append(" (" + StringUtil.trimMiddle((String)name3, (int)20) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            info2.setIcon(this.getController().getBuilder().getIcon((BasicElement)fs.getMetaObject().newDataObject()));
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DbStructureEditor.$$$reportNull$$$0(24);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbStructureEditor.$$$reportNull$$$0(25);
        }
        return fieldSize;
    }

    @Override
    public boolean isVertical() {
        return true;
    }

    @Override
    public boolean isScrolling() {
        return true;
    }

    @Override
    protected void applyImpl() {
    }

    @Override
    protected void resetImpl() {
        this.myStructureTreeModel.setRoots(DbStructureModelState.Group.mapWithGroups(((DbStructureModelState)this.getState()).getRoots(), DbModelRef.class, r -> this.getController().createStructureNodeEditor(r)));
    }

    @Nullable
    private static Color getFgColor(DbEditorModel<?, ? extends DbStructureNodeState> m) {
        FileStatus status;
        Color fg = null;
        if (m != null && (status = DbStructureEditor.getStatus(m)) != FileStatus.NOT_CHANGED) {
            fg = status.getColor();
        }
        return fg;
    }

    @Nullable
    static DbModelRef<?, ? extends DbStructureNodeState> extractModelRef(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        DbStructureNodeEditor<?, ?> editor2 = DbStructureNodeTreeModel.getEditor(path);
        return editor2 == null ? null : editor2.getModelRef();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6, 7, 9, 13, 14, 17, 18, 19, 20, 21, 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPage";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesForSelectedTab";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedModelsFor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedIds";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTabsListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTabs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentTab";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEditorOrMultiEditorRef";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStructureModelRef";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "structure2page";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPaneWithOpaqueScrollbars";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateTab";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6, 7, 9, 13, 14, 17, 18, 19, 20, 21, 22, 23 -> new IllegalArgumentException(string);
        };
    }

    private class MyNavigator
    implements Place.Navigator {
        private static final String EDITOR = "editor";

        private MyNavigator() {
        }

        @Nullable
        public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
            DbVisualEditor<?, ?> editor2 = MyNavigator.getModelRef(place);
            if (!this.isValid(editor2)) {
                return ActionCallback.REJECTED;
            }
            DbStructureEditor.this.selectEditor(editor2, true, false, requestFocus, true);
            if (!requestFocus) {
                IdeFocusManager.getInstance((Project)DbStructureEditor.this.getController().getProject()).requestFocus((Component)DbStructureEditor.this.myTree, false);
            }
            return ActionCallback.DONE;
        }

        @Nullable
        private static DbVisualEditor<?, ?> getModelRef(@Nullable Place place) {
            return (DbVisualEditor)ObjectUtils.tryCast((Object)(place == null ? null : place.getPath(EDITOR)), DbVisualEditor.class);
        }

        public void queryPlace(@NotNull Place place) {
            if (place == null) {
                MyNavigator.$$$reportNull$$$0(0);
            }
            DbVisualEditor<?, ?> editor2 = DbStructureEditor.extractEditor(DbStructureEditor.this.myTabs.getSelectedInfo());
            place.putPath(EDITOR, editor2);
        }

        public boolean isValid(@NotNull Place place) {
            if (place == null) {
                MyNavigator.$$$reportNull$$$0(1);
            }
            DbVisualEditor<?, ?> editor2 = MyNavigator.getModelRef(place);
            return this.isValid(editor2);
        }

        private boolean isValid(DbVisualEditor<?, ?> editor2) {
            DbObjectModelState ms;
            Object s;
            if (editor2 == null || (s = editor2.getState()) instanceof DbObjectModelState && (ms = (DbObjectModelState)s).isDropped()) {
                return false;
            }
            if (!DbStructureEditor.this.getController().isEditorRegistered(editor2)) {
                return false;
            }
            DbEditorModelController controller = DbStructureEditor.this.getController().getModelController();
            return controller.isModelRegistered(editor2.getModelRef());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "place";
            objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$MyNavigator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "queryPlace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValid";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class StructureRenderer
    extends NodeRenderer {
        private final DbEditorController myController;
        private Condition<DbStructureNodeEditor<?, ?>> myHighlighter;

        public StructureRenderer(@NotNull DbEditorController controller) {
            if (controller == null) {
                StructureRenderer.$$$reportNull$$$0(0);
            }
            this.myController = controller;
        }

        @Nullable
        protected final PresentationData getPresentation(Object node) {
            DbStructureNodeEditor editor2 = (DbStructureNodeEditor)ObjectUtils.tryCast((Object)node, DbStructureNodeEditor.class);
            if (editor2 != null) {
                return this.getPresentation(editor2);
            }
            DbStructureModelState.Group group = (DbStructureModelState.Group)ObjectUtils.tryCast((Object)node, DbStructureModelState.Group.class);
            if (group != null) {
                return StructureRenderer.getGroupPresentation(group);
            }
            return null;
        }

        @NotNull
        private static PresentationData getGroupPresentation(DbStructureModelState.Group<?> group) {
            PresentationData data = new PresentationData(group.name, null, DatabaseIcons.ObjectGroup, null);
            data.addText(data.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            DbNodeDescriptor.addSpaceDelimiter(data);
            DbNodeDescriptor.showCount(data, null, group.children.size());
            PresentationData presentationData = data;
            if (presentationData == null) {
                StructureRenderer.$$$reportNull$$$0(1);
            }
            return presentationData;
        }

        @NotNull
        protected PresentationData getPresentation(@NotNull DbStructureNodeEditor<?, ?> editor2) {
            DbEditorModel model;
            Object s;
            if (editor2 == null) {
                StructureRenderer.$$$reportNull$$$0(2);
            }
            if ((s = (model = editor2.getModelRef().resolve(editor2.getController().getModelController())).getState()) instanceof DbStructureObjectModelState) {
                DbStructureObjectModelState state = (DbStructureObjectModelState)s;
                return this.getPresentationData(editor2, model.castState(state));
            }
            s = model.getState();
            if (s instanceof DbStructureFamilyModelState) {
                DbStructureFamilyModelState state = (DbStructureFamilyModelState)s;
                SimpleTextAttributes mainAttrs = this.getMainAttributes(editor2);
                Color fg = DbStructureEditor.getFgColor(model);
                BasicMetaObject meta = state.getMetaObject();
                Icon icon = meta.kindOf(VmElement.class) ? DatabaseIcons.VirtualFolder : DatabaseIcons.ObjectGroup;
                PresentationData data = new PresentationData(meta.kind.getPluralPresentableName(), null, icon, null);
                data.addText(data.getPresentableText(), mainAttrs);
                DbNodeDescriptor.addSpaceDelimiter(data);
                DbNodeDescriptor.showCount(data, null, state.getStructureChildren().size());
                data.setForcedTextForeground(fg);
                PresentationData presentationData = data;
                if (presentationData == null) {
                    StructureRenderer.$$$reportNull$$$0(3);
                }
                return presentationData;
            }
            return new PresentationData("Error", null, null, CodeInsightColors.ERRORS_ATTRIBUTES);
        }

        @NotNull
        private SimpleTextAttributes getMainAttributes(@NotNull DbStructureNodeEditor<?, ?> editor2) {
            if (editor2 == null) {
                StructureRenderer.$$$reportNull$$$0(4);
            }
            SimpleTextAttributes simpleTextAttributes = this.isHighlighted(editor2) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                StructureRenderer.$$$reportNull$$$0(5);
            }
            return simpleTextAttributes;
        }

        @NotNull
        private <E extends BasicElement> PresentationData getPresentationData(@NotNull DbStructureNodeEditor<?, ?> editor2, @NotNull DbEditorModel<E, DbStructureObjectModelState<?>> model) {
            if (editor2 == null) {
                StructureRenderer.$$$reportNull$$$0(6);
            }
            if (model == null) {
                StructureRenderer.$$$reportNull$$$0(7);
            }
            SimpleTextAttributes mainAttrs = this.getMainAttributes(editor2);
            Color fg = DbStructureEditor.getFgColor(model);
            E properties2 = StructureRenderer.getObjectToRender(this.myController, model.getIdentity());
            String name2 = this.myController.getBuilder().getDisplayName(model.getIdentity(), properties2);
            PresentationData data = new PresentationData(name2, null, null, null);
            String prefix = this.myController.getBuilder().getDisplayNamePrefix(model.getIdentity());
            if (prefix != null) {
                data.addText(prefix, SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
            }
            data.addText(name2, mainAttrs);
            data.setIcon(this.myController.getBuilder().getIcon((BasicElement)properties2));
            Dbms dbms = editor2.getDbms();
            DescriptionService descriptionService = ModelFacade.forDbms(dbms).getDescriptionService();
            DvViewOptions databaseViewOptions = DvViewOptionsFun.getDatabaseViewOptions(this.myController.getProject());
            DbNodeDescriptor.updatePresentationAdditions(this.myController.getProject(), data, properties2, descriptionService, databaseViewOptions);
            String text2 = this.myController.getBuilder().getLocationText(this.myController, model.getIdentity());
            if (text2 != null) {
                data.addText("  ", SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
                data.addText(text2, SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
            }
            data.setForcedTextForeground(fg);
            PresentationData presentationData = data;
            if (presentationData == null) {
                StructureRenderer.$$$reportNull$$$0(8);
            }
            return presentationData;
        }

        @NotNull
        public static <T extends BasicElement> T getObjectToRender(@NotNull DbEditorModel<T, DbObjectModelState<T>> m) {
            T obj2;
            DbEditorModelController controller;
            ElementOwner actualOwner;
            if (m == null) {
                StructureRenderer.$$$reportNull$$$0(9);
            }
            if ((actualOwner = (controller = m.getController()).getActualOwner()) != null && (obj2 = actualOwner.find(m.getIdentity())) != null) {
                T t = obj2;
                if (t == null) {
                    StructureRenderer.$$$reportNull$$$0(10);
                }
                return t;
            }
            T t = m.getState().getProperties();
            if (t == null) {
                StructureRenderer.$$$reportNull$$$0(11);
            }
            return t;
        }

        @NotNull
        public static <T extends BasicElement> T getObjectToRender(@NotNull DbEditorController controller, @NotNull ElementIdentity<T> id) {
            if (controller == null) {
                StructureRenderer.$$$reportNull$$$0(12);
            }
            if (id == null) {
                StructureRenderer.$$$reportNull$$$0(13);
            }
            return StructureRenderer.getObjectToRender(controller.getModelController(), id);
        }

        @NotNull
        private static <T extends BasicElement> T getObjectToRender(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<T> id) {
            ElementOwner actualOwner;
            T res2;
            if (controller == null) {
                StructureRenderer.$$$reportNull$$$0(14);
            }
            if (id == null) {
                StructureRenderer.$$$reportNull$$$0(15);
            }
            T t = res2 = (actualOwner = controller.getActualOwner()) == null ? null : (T)actualOwner.find(id);
            if (res2 != null) {
                T t2 = res2;
                if (t2 == null) {
                    StructureRenderer.$$$reportNull$$$0(16);
                }
                return t2;
            }
            T state = StructureRenderer.getProperties(controller, id);
            if (state != null) {
                T t3 = state;
                if (t3 == null) {
                    StructureRenderer.$$$reportNull$$$0(17);
                }
                return t3;
            }
            ElementOwner oOwner = controller.getMatcher().getOriginalOwner();
            state = oOwner == null ? null : oOwner.find(id);
            T t4 = state == null ? id.getMetaObject().newDataObject() : state;
            if (t4 == null) {
                StructureRenderer.$$$reportNull$$$0(18);
            }
            return t4;
        }

        @Nullable
        public static <T extends BasicElement> T getProperties(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<T> id) {
            DbObjectModelState<T> state;
            if (controller == null) {
                StructureRenderer.$$$reportNull$$$0(19);
            }
            if (id == null) {
                StructureRenderer.$$$reportNull$$$0(20);
            }
            return (state = controller.getObjectModelState(id)) != null ? (T)state.getProperties() : null;
        }

        private boolean isHighlighted(DbStructureNodeEditor<?, ?> node) {
            return this.myHighlighter != null && this.myHighlighter.value(node);
        }

        public void setHighlighter(Condition<DbStructureNodeEditor<?, ?>> highlighter) {
            this.myHighlighter = highlighter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5, 8, 10, 11, 16, 17, 18 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$StructureRenderer";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
                case 13: 
                case 15: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$StructureRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupPresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainAttributes";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationData";
                    break;
                }
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectToRender";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getMainAttributes";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationData";
                    break;
                }
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjectToRender";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getProperties";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5, 8, 10, 11, 16, 17, 18 -> new IllegalStateException(string);
            };
        }
    }

    private static class RightAligned
    extends AnActionWrapper
    implements RightAlignedToolbarAction {
        RightAligned(@NotNull AnAction action) {
            if (action == null) {
                RightAligned.$$$reportNull$$$0(0);
            }
            super(action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/schemaEditor/ui/DbStructureEditor$RightAligned", "<init>"));
        }
    }

    public static class ProperTabs
    extends JBEditorTabs {
        public ProperTabs(@Nullable Project project, @NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                ProperTabs.$$$reportNull$$$0(0);
            }
            super(project, parentDisposable);
        }

        @NotNull
        public Dimension getMinimumSize() {
            Dimension ms = super.getMinimumSize();
            if (this.isPreferredSizeSet()) {
                Dimension msSet = this.minimumSize();
                return new Dimension(Math.max(ms.width, msSet.width), Math.max(ms.height, msSet.height));
            }
            Dimension dimension = ms;
            if (dimension == null) {
                ProperTabs.$$$reportNull$$$0(1);
            }
            return dimension;
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension ps = super.getPreferredSize();
            if (this.isPreferredSizeSet()) {
                Dimension psSet = this.preferredSize();
                return new Dimension(Math.max(ps.width, psSet.width), Math.max(ps.height, psSet.height));
            }
            Dimension dimension = ps;
            if (dimension == null) {
                ProperTabs.$$$reportNull$$$0(2);
            }
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$ProperTabs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditor$ProperTabs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMinimumSize";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

