/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.state;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class DbObjectCollectionModelState<C extends BasicElement, S extends DbModelState>
extends DbEditorModelBase.StateBase {
    private final List<DbModelRef<C, S>> myCollection = new ArrayList<DbModelRef<C, S>>();

    public void setCollection(@NotNull DbEditorModelController controller, @NotNull List<DbModelRef<C, S>> col) {
        if (controller == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(0);
        }
        if (col == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(1);
        }
        if (this.myCollection.equals(col)) {
            return;
        }
        LinkedHashSet<DbModelRef<C, S>> toCleanup = new LinkedHashSet<DbModelRef<C, S>>(this.myCollection);
        col.forEach(toCleanup::remove);
        this.myCollection.clear();
        this.myCollection.addAll(col);
        for (DbModelRef dbModelRef : toCleanup) {
            this.doDropChild(controller, dbModelRef);
        }
        for (DbModelRef dbModelRef : this.myCollection) {
            dbModelRef.register(controller);
        }
        this.modified();
    }

    protected void doDropChild(@NotNull DbEditorModelController controller, @NotNull DbModelRef<C, S> c2) {
        if (controller == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(2);
        }
        if (c2 == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(3);
        }
        c2.unregister(controller);
    }

    public List<DbModelRef<C, S>> getCollection() {
        return Collections.unmodifiableList(this.myCollection);
    }

    public Iterable<DbModelRef<C, S>> getIterable() {
        return this.myCollection;
    }

    public void removeChild(@NotNull DbEditorModelController controller, @NotNull Predicate<DbModelRef<C, S>> predicate) {
        if (controller == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(4);
        }
        if (predicate == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(5);
        }
        for (int i2 = 0; i2 < this.myCollection.size(); ++i2) {
            DbModelRef<C, S> c2 = this.myCollection.get(i2);
            if (!predicate.test(c2)) continue;
            this.myCollection.remove(i2);
            this.doDropChild(controller, c2);
            this.modified();
            break;
        }
    }

    public void addChild(@NotNull DbEditorModel<C, S> child) {
        DbModelRef<C, S> ref2;
        if (child == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(6);
        }
        if (this.myCollection.contains(ref2 = new DbModelRef<C, S>(child))) {
            return;
        }
        this.myCollection.add(ref2);
        child.register();
        this.modified();
    }

    @Override
    public boolean register(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(7);
        }
        if (!super.register(model)) {
            return false;
        }
        for (DbModelRef<C, S> ref2 : this.myCollection) {
            ref2.register(model.getController());
        }
        return true;
    }

    @Override
    public boolean unregister(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbObjectCollectionModelState.$$$reportNull$$$0(8);
        }
        if (!super.unregister(model)) {
            return false;
        }
        for (DbModelRef<C, S> ref2 : this.myCollection) {
            ref2.unregister(model.getController());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/state/DbObjectCollectionModelState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setCollection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doDropChild";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChild";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addChild";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "unregister";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

