/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiElementIdentity<E extends BasicElement>
implements ElementIdentity<E> {
    private final BasicMetaObject<E> myMeta;
    private final List<ElementIdentity<E>> myIdentities;

    public MultiElementIdentity(@NotNull BasicMetaObject<E> meta, @NotNull List<ElementIdentity<E>> identities) {
        if (meta == null) {
            MultiElementIdentity.$$$reportNull$$$0(0);
        }
        if (identities == null) {
            MultiElementIdentity.$$$reportNull$$$0(1);
        }
        this.myMeta = meta;
        this.myIdentities = List.copyOf(identities);
    }

    @Override
    @NotNull
    public BasicMetaObject<E> getMetaObject() {
        BasicMetaObject<E> basicMetaObject = this.myMeta;
        if (basicMetaObject == null) {
            MultiElementIdentity.$$$reportNull$$$0(2);
        }
        return basicMetaObject;
    }

    @NotNull
    public List<ElementIdentity<E>> getIdentities() {
        List<ElementIdentity<E>> list = this.myIdentities;
        if (list == null) {
            MultiElementIdentity.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiElementIdentity)) {
            return false;
        }
        MultiElementIdentity identity = (MultiElementIdentity)o;
        return this.myMeta.equals(identity.myMeta) && this.myIdentities.equals(identity.myIdentities);
    }

    public int hashCode() {
        return Objects.hash(this.myMeta, this.myIdentities);
    }

    @NotNull
    public static <E extends BasicElement> MultiElementIdentity<E> create(@NotNull List<ElementIdentity<E>> identities) {
        if (identities == null) {
            MultiElementIdentity.$$$reportNull$$$0(4);
        }
        ElementIdentity any = Objects.requireNonNull((ElementIdentity)ContainerUtil.getFirstItem(identities));
        return new MultiElementIdentity(any.getMetaObject(), identities);
    }

    @Nullable
    public static <E extends BasicElement> ElementIdentity<E> asSingleIdentity(@NotNull JBIterable<ElementIdentity<E>> objects) {
        ElementIdentity identity;
        if (objects == null) {
            MultiElementIdentity.$$$reportNull$$$0(5);
        }
        if ((identity = (ElementIdentity)objects.single()) != null) {
            return identity;
        }
        if (objects.isEmpty()) {
            return null;
        }
        return MultiElementIdentity.create(objects.toList());
    }

    @Nullable
    public static ElementIdentity<?> asSingleIdentityFiltered(@NotNull JBIterable<ElementIdentity<?>> objects) {
        ElementIdentity identity;
        if (objects == null) {
            MultiElementIdentity.$$$reportNull$$$0(6);
        }
        return MultiElementIdentity.asSingleIdentityFiltered(objects, (identity = (ElementIdentity)objects.first()) == null ? null : identity.getMetaObject());
    }

    @Nullable
    public static <E extends BasicElement> ElementIdentity<E> asSingleIdentityFiltered(@NotNull JBIterable<ElementIdentity<?>> objects, @Nullable BasicMetaObject<E> meta) {
        if (objects == null) {
            MultiElementIdentity.$$$reportNull$$$0(7);
        }
        return meta == null ? null : MultiElementIdentity.asSingleIdentity(objects.filterMap(id -> ElementIdentity.tryCast(id, meta)));
    }

    @Nullable
    public static <E extends BasicElement> List<ElementIdentity<E>> getIdentities(@Nullable ElementIdentity<E> identity) {
        return identity instanceof MultiElementIdentity ? ((MultiElementIdentity)identity).getIdentities() : null;
    }

    @NotNull
    public static <E extends BasicElement> JBIterable<ElementIdentity<E>> expand(@Nullable ElementIdentity<E> identity) {
        List<ElementIdentity<E>> identities = MultiElementIdentity.getIdentities(identity);
        JBIterable jBIterable = identities != null ? JBIterable.from(((MultiElementIdentity)identity).getIdentities()) : JBIterable.of(identity);
        if (jBIterable == null) {
            MultiElementIdentity.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identities";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/MultiElementIdentity";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/MultiElementIdentity";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentities";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asSingleIdentity";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "asSingleIdentityFiltered";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8 -> new IllegalStateException(string);
        };
    }
}

