/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaReferenceListId;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.references.BasicAndReference;
import com.intellij.database.model.properties.references.BasicByColumnPositionsOrNamesReference;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.model.properties.references.BasicKeyByIndexReference;
import com.intellij.database.model.properties.references.BasicPositionReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicRefImporter {
    public static final BasicRefImporter INSTANCE = new BasicRefImporter();

    @Nullable
    public final BasicReference importReferenceWithAnyId(@Nullable BasicMetaObject<?> meta, @NotNull BasicMetaId refId, @NotNull NameValueGetter<String> properties2) {
        NameValueGetter<String> wrapped;
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(0);
        }
        if (properties2 == null) {
            BasicRefImporter.$$$reportNull$$$0(1);
        }
        return (wrapped = BasicRefImporter.wrap(properties2, refId)) == null ? null : this.importReferenceImpl(meta, refId, wrapped);
    }

    @Nullable
    public final BasicReference importReference(@Nullable BasicMetaObject<?> meta, @NotNull BasicMetaReferenceId<?> refId, @NotNull NameValueGetter<String> properties2) {
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(2);
        }
        if (properties2 == null) {
            BasicRefImporter.$$$reportNull$$$0(3);
        }
        return this.importReferenceWithAnyId(meta, refId, properties2);
    }

    @NotNull
    public final List<BasicReference> importReference(@Nullable BasicMetaObject<?> meta, @NotNull BasicMetaReferenceListId<?> refId, @NotNull NameValueGetter<String> properties2) {
        NameValueGetter<String> wrapped;
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(4);
        }
        if (properties2 == null) {
            BasicRefImporter.$$$reportNull$$$0(5);
        }
        return (wrapped = BasicRefImporter.wrap(properties2, refId)) == null ? Collections.emptyList() : BasicRefImporter.importReferencesImpl(wrapped, (Function<NameValueGetter<String>, BasicReference>)((Function)props -> this.importReferenceImpl(meta, refId, (NameValueGetter<String>)props)));
    }

    @Nullable
    private BasicReference importReferenceImpl(@Nullable BasicMetaObject<?> meta, @NotNull BasicMetaId refId, @NotNull NameValueGetter<String> properties2) {
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(6);
        }
        if (properties2 == null) {
            BasicRefImporter.$$$reportNull$$$0(7);
        }
        return this.importReferenceImpl(meta, refId, properties2, (Function<? super NameValueGetter<String>, ? extends BasicReference>)((Function)props -> this.importReferenceImpl(meta, refId, (NameValueGetter<String>)props)));
    }

    @Nullable
    protected BasicReference importReferenceImpl(@Nullable BasicMetaObject<?> meta, @NotNull BasicMetaId refId, @NotNull NameValueGetter<String> properties2, @NotNull Function<? super NameValueGetter<String>, ? extends BasicReference> sub) {
        BasicReference res2;
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(8);
        }
        if (properties2 == null) {
            BasicRefImporter.$$$reportNull$$$0(9);
        }
        if (sub == null) {
            BasicRefImporter.$$$reportNull$$$0(10);
        }
        if ((res2 = BasicAndReference.importProperties(properties2, sub)) != null) {
            return res2;
        }
        if (meta != null && (res2 = BasicInlineObjectReference.importProperties(meta, refId, properties2)) != null) {
            return res2;
        }
        res2 = BasicPositionReference.importProperties(properties2);
        if (res2 != null) {
            return res2;
        }
        res2 = BasicIdOrNameReference.importProperties(properties2);
        if (res2 != null) {
            return res2;
        }
        res2 = BasicByColumnPositionsOrNamesReference.importProperties(properties2);
        if (res2 != null) {
            return res2;
        }
        res2 = BasicKeyByIndexReference.importProperties(properties2, sub);
        return res2;
    }

    @NotNull
    protected static List<BasicReference> importReferencesImpl(@NotNull NameValueGetter<String> properties2, @NotNull Function<NameValueGetter<String>, BasicReference> importer) {
        if (properties2 == null) {
            BasicRefImporter.$$$reportNull$$$0(11);
        }
        if (importer == null) {
            BasicRefImporter.$$$reportNull$$$0(12);
        }
        DeMultiplexer deMultiplexer = new DeMultiplexer(properties2);
        ArrayList res2 = null;
        while (true) {
            BasicReference ref2 = (BasicReference)importer.fun((Object)deMultiplexer);
            if (deMultiplexer.isEof()) break;
            if (res2 == null) {
                res2 = new ArrayList();
            }
            res2.add(ref2);
            deMultiplexer.next();
        }
        if (res2 != null) {
            BasicMetaUtils.trimNulls(res2);
        }
        List<BasicReference> list = res2 == null || res2.isEmpty() ? Collections.emptyList() : res2;
        if (list == null) {
            BasicRefImporter.$$$reportNull$$$0(13);
        }
        return list;
    }

    public static void exportReference(@Nullable BasicReference ref2, @NotNull BasicMetaId refId, @NotNull NameValueConsumer<? super String> consumer) {
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            BasicRefImporter.$$$reportNull$$$0(15);
        }
        if (ref2 == null) {
            return;
        }
        ref2.exportProperties(BasicRefImporter.wrap(consumer, refId));
    }

    public static void exportReference(@NotNull List<BasicReference> refs, @NotNull BasicMetaId refId, @NotNull NameValueConsumer<? super String> consumer) {
        if (refs == null) {
            BasicRefImporter.$$$reportNull$$$0(16);
        }
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(17);
        }
        if (consumer == null) {
            BasicRefImporter.$$$reportNull$$$0(18);
        }
        if (refs.isEmpty()) {
            return;
        }
        Multiplexer multiplexer = new Multiplexer();
        for (BasicReference ref2 : refs) {
            BasicRefImporter.exportReference(ref2, refId, (NameValueConsumer<? super String>)multiplexer);
            multiplexer.next();
        }
        multiplexer.multiplex(consumer);
    }

    @Nullable
    private static NameValueGetter<String> wrap(@NotNull NameValueGetter<String> delegate, final @NotNull BasicMetaId refId) {
        if (delegate == null) {
            BasicRefImporter.$$$reportNull$$$0(19);
        }
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(20);
        }
        if (!delegate.hasSubNames(BasicRefImporter.propName(refId, ""))) {
            return null;
        }
        return new NameValueGetter.MapName<String>(delegate){

            @Override
            @NotNull
            protected String map(@NotNull String name2) {
                if (name2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = BasicRefImporter.propName(refId, name2);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/model/properties/references/BasicRefImporter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/model/properties/references/BasicRefImporter$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static NameValueConsumer<String> wrap(@NotNull NameValueConsumer<? super String> delegate, @NotNull BasicMetaId refId) {
        if (delegate == null) {
            BasicRefImporter.$$$reportNull$$$0(21);
        }
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(22);
        }
        NameValueConsumer<String> nameValueConsumer = (name2, value) -> delegate.accept(BasicRefImporter.propName(refId, name2), (String)value);
        if (nameValueConsumer == null) {
            BasicRefImporter.$$$reportNull$$$0(23);
        }
        return nameValueConsumer;
    }

    @Nullable
    public static NameValueGetter<String> wrap(@NotNull NameValueGetter<String> delegate, final @NotNull String prefix) {
        if (delegate == null) {
            BasicRefImporter.$$$reportNull$$$0(24);
        }
        if (prefix == null) {
            BasicRefImporter.$$$reportNull$$$0(25);
        }
        if (!delegate.hasSubNames(prefix)) {
            return null;
        }
        return new NameValueGetter.MapName<String>(delegate){

            @Override
            @NotNull
            protected String map(@NotNull String name2) {
                if (name2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = prefix + name2;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/model/properties/references/BasicRefImporter$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/model/properties/references/BasicRefImporter$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static NameValueConsumer<String> wrap(@NotNull NameValueConsumer<? super String> delegate, @NotNull String prefix) {
        if (delegate == null) {
            BasicRefImporter.$$$reportNull$$$0(26);
        }
        if (prefix == null) {
            BasicRefImporter.$$$reportNull$$$0(27);
        }
        NameValueConsumer<String> nameValueConsumer = (name2, value) -> delegate.accept(prefix + name2, (String)value);
        if (nameValueConsumer == null) {
            BasicRefImporter.$$$reportNull$$$0(28);
        }
        return nameValueConsumer;
    }

    private static String propName(@NotNull BasicMetaId refId, @NotNull String name2) {
        if (refId == null) {
            BasicRefImporter.$$$reportNull$$$0(29);
        }
        if (name2 == null) {
            BasicRefImporter.$$$reportNull$$$0(30);
        }
        if (refId.name.equals("SchemaRef")) {
            return "Schema" + name2;
        }
        if (refId.name.endsWith("Ref")) {
            String prefix = refId.name.substring(0, refId.name.length() - 3);
            return name2.equals("Name") ? prefix : prefix + name2;
        }
        return refId.name + name2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 23, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refId";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sub";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importer";
                break;
            }
            case 13: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicRefImporter";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 19: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicRefImporter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "importReferencesImpl";
                break;
            }
            case 23: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importReferenceWithAnyId";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importReference";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importReferenceImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "importReferencesImpl";
                break;
            }
            case 13: 
            case 23: 
            case 28: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "exportReference";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "propName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 23, 28 -> new IllegalStateException(string);
        };
    }

    private static class DeMultiplexer
    implements NameValueGetter<String> {
        int idx = 0;
        int maxSize = 0;
        final NameValueGetter<String> myProperties;
        final Map<String, List<String>> deMultiplexed = new HashMap<String, List<String>>();

        private DeMultiplexer(NameValueGetter<String> properties2) {
            this.myProperties = properties2;
        }

        @Override
        @Nullable
        public String get(@NotNull String name2) {
            List<String> serialized;
            if (name2 == null) {
                DeMultiplexer.$$$reportNull$$$0(0);
            }
            if ((serialized = this.deMultiplexed.get(name2)) == null) {
                String key2 = StringUtil.pluralize((String)name2);
                String props = this.myProperties.get(key2);
                serialized = PropertyConverter.importListOfString(props);
                this.maxSize = Math.max(this.maxSize, serialized.size());
                this.deMultiplexed.put(name2, serialized);
            }
            return this.idx < serialized.size() ? StringUtil.nullize((String)serialized.get(this.idx)) : null;
        }

        @Override
        public boolean hasSubNames(@NotNull String name2) {
            if (name2 == null) {
                DeMultiplexer.$$$reportNull$$$0(1);
            }
            return this.myProperties.hasSubNames(name2);
        }

        public boolean isEof() {
            return this.idx >= this.maxSize;
        }

        public void next() {
            ++this.idx;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/intellij/database/model/properties/references/BasicRefImporter$DeMultiplexer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasSubNames";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Multiplexer
    implements NameValueConsumer<String> {
        int idx = 0;
        final Map<String, List<String>> multiplexed = FactoryMap.create(k -> new ArrayList());

        private Multiplexer() {
        }

        @Override
        public void accept(@NotNull String name2, @NotNull String value) {
            if (name2 == null) {
                Multiplexer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                Multiplexer.$$$reportNull$$$0(1);
            }
            List<String> values = this.multiplexed.get(name2);
            while (this.idx >= values.size()) {
                values.add("");
            }
            values.set(this.idx, value);
        }

        public void next() {
            ++this.idx;
        }

        public void multiplex(@NotNull NameValueConsumer<? super String> consumer) {
            if (consumer == null) {
                Multiplexer.$$$reportNull$$$0(2);
            }
            for (Map.Entry<String, List<String>> entry : this.multiplexed.entrySet()) {
                String key2 = StringUtil.pluralize((String)entry.getKey());
                String value = PropertyConverter.exportListOfString(entry.getValue());
                if (value == null) continue;
                consumer.accept(key2, value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/properties/references/BasicRefImporter$Multiplexer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "multiplex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

