/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/docker/agent/util/JsonArraySortingModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "<init>", "()V", "intellij.clouds.docker.agent"})
@ApiStatus.Internal
public final class JsonArraySortingModule
extends SimpleModule {
    public JsonArraySortingModule() {
        super("Json Array Sorting Module");
        this.setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifyArraySerializer(SerializationConfig config2, ArrayType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer2) {
                Class<Object[]> clazz = Object[].class;
                return (JsonSerializer)new StdSerializer<Object[]>(clazz){

                    public void serialize(Object[] value, JsonGenerator gen, SerializerProvider provider) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
                        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                        Object[] $this$sortedBy$iv = value;
                        boolean $i$f$sortedBy = false;
                        List sortedValue = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                T it = a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)it.toString());
                                it = b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toString())));
                            }
                        });
                        gen.writeStartArray();
                        for (E element : sortedValue) {
                            gen.writeObject(element);
                        }
                        gen.writeEndArray();
                    }
                };
            }

            public JsonSerializer<?> modifyCollectionLikeSerializer(SerializationConfig config2, CollectionLikeType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer2) {
                Class<List> clazz = List.class;
                return (JsonSerializer)new StdSerializer<List<?>>(clazz){

                    public void serialize(List<?> value, JsonGenerator gen, SerializerProvider provider) {
                        Intrinsics.checkNotNullParameter(value, (String)"value");
                        Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
                        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                        Iterable $this$sortedBy$iv = value;
                        boolean $i$f$sortedBy = false;
                        List sortedValue = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                T it = a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)String.valueOf(it));
                                it = b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)String.valueOf(it))));
                            }
                        });
                        gen.writeStartArray();
                        for (E element : sortedValue) {
                            gen.writeObject(element);
                        }
                        gen.writeEndArray();
                    }
                };
            }

            public JsonSerializer<?> modifyMapLikeSerializer(SerializationConfig config2, MapLikeType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer2) {
                Class<Map> clazz = Map.class;
                return (JsonSerializer)new StdSerializer<Map<?, ?>>(clazz){

                    public void serialize(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider) {
                        Intrinsics.checkNotNullParameter(value, (String)"value");
                        Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
                        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                        Iterable $this$sortedBy$iv = value.entrySet();
                        boolean $i$f$sortedBy = false;
                        List sortedEntries = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                Map.Entry it = (Map.Entry)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)String.valueOf(it.getKey()));
                                it = (Map.Entry)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)String.valueOf(it.getKey()))));
                            }
                        });
                        gen.writeStartObject();
                        for (Map.Entry entry : sortedEntries) {
                            K key = entry.getKey();
                            V data2 = entry.getValue();
                            gen.writeFieldName(String.valueOf(key));
                            gen.writeObject(data2);
                        }
                        gen.writeEndObject();
                    }
                };
            }

            public List<BeanPropertyWriter> orderProperties(SerializationConfig config2, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
                List list2;
                block3: {
                    block2: {
                        list2 = beanProperties;
                        if (list2 == null) break block2;
                        Iterable $this$sortedBy$iv = list2;
                        boolean $i$f$sortedBy = false;
                        list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                BeanPropertyWriter it = (BeanPropertyWriter)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)it.getName());
                                it = (BeanPropertyWriter)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                            }
                        });
                        if (list2 != null && (list2 = CollectionsKt.toMutableList((Collection)list2)) != null) break block3;
                    }
                    List list3 = super.orderProperties(config2, beanDesc, beanProperties);
                    list2 = list3;
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"orderProperties(...)");
                }
                return list2;
            }
        });
    }
}

