/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public abstract class ToTemporalDurationNode
extends JavaScriptBaseNode {
    protected ToTemporalDurationNode() {
    }

    public abstract JSTemporalDurationObject execute(Object var1);

    @Specialization
    protected JSTemporalDurationObject toTemporalDuration(Object item, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode) {
        JSTemporalDurationRecord result2;
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)item;
            if (JSTemporalDuration.isJSTemporalDuration(itemObj)) {
                return (JSTemporalDurationObject)itemObj;
            }
            result2 = JSTemporalDuration.toTemporalDurationRecord(itemObj);
        } else {
            TruffleString string = toStringNode.executeString(item);
            result2 = JSTemporalDuration.parseTemporalDurationString(string);
        }
        return JSTemporalDuration.createTemporalDuration(this.getLanguage().getJSContext(), this.getRealm(), result2.getYears(), result2.getMonths(), result2.getWeeks(), result2.getDays(), result2.getHours(), result2.getMinutes(), result2.getSeconds(), result2.getMilliseconds(), result2.getMicroseconds(), result2.getNanoseconds(), this, errorBranch);
    }
}

