/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainDateFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalPlainDateFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainDateFunction> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainDateFunctionBuiltins();

    protected TemporalPlainDateFunctionBuiltins() {
        super(JSTemporalPlainDate.CLASS_NAME, TemporalPlainDateFunction.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainDateFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalPlainDateFunctionBuiltinsFactory.JSTemporalPlainDateFromNodeGen.create(context2, builtin, TemporalPlainDateFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context2));
            }
            case 1: {
                return TemporalPlainDateFunctionBuiltinsFactory.JSTemporalPlainDateCompareNodeGen.create(context2, builtin, TemporalPlainDateFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum TemporalPlainDateFunction implements BuiltinEnum<TemporalPlainDateFunction>
    {
        from(1),
        compare(2);

        private final int length;

        private TemporalPlainDateFunction(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSTemporalPlainDateFromNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainDateFromNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateObject from(Object item, Object optParam, @Cached TemporalGetOptionNode getOptionNode, @Cached ToTemporalDateNode toTemporalDate, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            if (item instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject dtItem = (JSTemporalPlainDateObject)item;
                TemporalUtil.toTemporalOverflow(options, getOptionNode);
                return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), dtItem.getYear(), dtItem.getMonth(), dtItem.getDay(), dtItem.getCalendar(), this, errorBranch);
            }
            return toTemporalDate.execute(item, options);
        }
    }

    public static abstract class JSTemporalPlainDateCompareNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainDateCompareNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected int compare(Object obj1, Object obj2, @Cached ToTemporalDateNode toTemporalDate) {
            JSTemporalPlainDateObject one = toTemporalDate.execute(obj1);
            JSTemporalPlainDateObject two = toTemporalDate.execute(obj2);
            return TemporalUtil.compareISODate(one.getYear(), one.getMonth(), one.getDay(), two.getYear(), two.getMonth(), two.getDay());
        }
    }
}

