/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.documentation.comments;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocComment;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocCommentTagDescriptor;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocConnectionTimeoutTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNameTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoAutoEncodingTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoCookieJarTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoLogResponseTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoRedirectTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocSocketTimeoutTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocUseOsCredentialsTag;
import com.intellij.httpClient.http.request.psi.HttpRequestTokenTypeSets;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J&\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/http/request/documentation/comments/HttpDocTagsDocumentationProvider;", "Lcom/intellij/lang/documentation/DocumentationProvider;", "<init>", "()V", "generateDoc", "", "Lorg/jetbrains/annotations/Nls;", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "getDocumentationElementForLookupItem", "psiManager", "Lcom/intellij/psi/PsiManager;", "item", "", "getCustomDocumentationElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "contextElement", "targetOffset", "", "intellij.restClient"})
public final class HttpDocTagsDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String generateDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        PsiElement psiElement = element;
        return psiElement instanceof HttpDocNoRedirectTag ? RestClientBundle.message("http.request.doc.comment.documentation.no.redirect", new Object[0]) : (psiElement instanceof HttpDocNoLogResponseTag ? RestClientBundle.message("http.request.doc.comment.documentation.no.log", new Object[0]) : (psiElement instanceof HttpDocNoCookieJarTag ? RestClientBundle.message("http.request.doc.comment.documentation.no.cookie", new Object[0]) : (psiElement instanceof HttpDocNoAutoEncodingTag ? RestClientBundle.message("http.request.doc.comment.documentation.no.auto.encoding", new Object[0]) : (psiElement instanceof HttpDocNameTag ? RestClientBundle.message("http.request.doc.comment.documentation.name", new Object[0]) : (psiElement instanceof HttpDocUseOsCredentialsTag ? RestClientBundle.message("http.request.doc.comment.documentation.use.os.credentials", new Object[0]) : (psiElement instanceof HttpDocSocketTimeoutTag ? RestClientBundle.message("http.request.doc.comment.documentation.socket.timeout", new Object[0]) : (psiElement instanceof HttpDocConnectionTimeoutTag ? RestClientBundle.message("http.request.doc.comment.documentation.connection.timeout", new Object[0]) : null)))))));
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object item, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(item instanceof HttpDocCommentTagDescriptor)) {
            return null;
        }
        String string = ((HttpDocCommentTagDescriptor)item).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        if (HttpRequestPsiUtils.isOfTypes(element, HttpRequestTokenTypeSets.DOC_TAGS) && Intrinsics.areEqual((Object)text2, (Object)element.getText())) {
            return element;
        }
        PsiManager psiManager2 = psiManager;
        Project project = psiManager2 != null ? psiManager2.getProject() : null;
        if (((CharSequence)text2).length() == 0 || project == null) {
            return null;
        }
        HttpRequestPsiFile httpRequestPsiFile = HttpRequestPsiFactory.createDummyFile(project, "#" + text2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)httpRequestPsiFile), (String)"createDummyFile(...)");
        HttpRequestPsiFile file = httpRequestPsiFile;
        HttpDocComment docComment = (HttpDocComment)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)file), HttpDocComment.class);
        Object object = docComment;
        if (object == null || (object = object.getTags()) == null) {
            object = new ArrayList();
        }
        Object tags = object;
        return (PsiElement)CollectionsKt.singleOrNull((List)tags);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor2, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        PsiElement tagElement;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof HttpRequestPsiFile)) {
            return null;
        }
        PsiElement psiElement = tagElement = contextElement == null || contextElement instanceof PsiWhiteSpace ? ((HttpRequestPsiFile)file).findElementAt(targetOffset - 1) : contextElement;
        if (tagElement != null && HttpRequestPsiUtils.isOfTypes(tagElement, HttpRequestTokenTypeSets.DOC_TAGS)) {
            return tagElement.getParent();
        }
        return null;
    }
}

