/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Faker;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;

public class DateAndTime {
    private static final int DEFAULT_MIN_AGE = 18;
    private static final int DEFAULT_MAX_AGE = 65;
    private final Faker faker;

    protected DateAndTime(Faker faker) {
        this.faker = faker;
    }

    public Date future(int atMost, TimeUnit unit) {
        Date now = new Date();
        Date aBitLaterThanNow = new Date(now.getTime() + 1000L);
        return this.future(atMost, unit, aBitLaterThanNow);
    }

    public Date future(int atMost, int minimum, TimeUnit unit) {
        Date now = new Date();
        Date minimumDate = new Date(now.getTime() + unit.toMillis(minimum));
        return this.future(atMost - minimum, unit, minimumDate);
    }

    public Date future(int atMost, TimeUnit unit, Date referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return new Date(futureMillis += 1L + this.faker.random().nextLong(upperBound - 1L));
    }

    public Date past(int atMost, TimeUnit unit) {
        Date now = new Date();
        Date aBitEarlierThanNow = new Date(now.getTime() - 1000L);
        return this.past(atMost, unit, aBitEarlierThanNow);
    }

    public Date past(int atMost, int minimum, TimeUnit unit) {
        Date now = new Date();
        Date minimumDate = new Date(now.getTime() - unit.toMillis(minimum));
        return this.past(atMost - minimum, unit, minimumDate);
    }

    public Date past(int atMost, TimeUnit unit, Date referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return new Date(futureMillis -= 1L + this.faker.random().nextLong(upperBound - 1L));
    }

    public Date between(Date from2, Date to) throws IllegalArgumentException {
        if (to.before(from2)) {
            throw new IllegalArgumentException("Invalid date range, the upper bound date is before the lower bound.");
        }
        if (from2.equals(to)) {
            return from2;
        }
        long offsetMillis = this.faker.random().nextLong(to.getTime() - from2.getTime());
        return new Date(from2.getTime() + offsetMillis);
    }

    public Date birthday() {
        return this.birthday(18, 65);
    }

    public Date birthday(int minAge, int maxAge) {
        int currentYear = Calendar.getInstance().get(1);
        int currentMonth = Calendar.getInstance().get(2);
        int currentDay = Calendar.getInstance().get(5);
        GregorianCalendar from2 = new GregorianCalendar(currentYear - maxAge, currentMonth, currentDay);
        GregorianCalendar to = new GregorianCalendar(currentYear - minAge, currentMonth, currentDay);
        return this.between(from2.getTime(), to.getTime());
    }
}

