/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaAnnotatorChecker
implements JsonValidationHost {
    private static final Set<JsonSchemaType> PRIMITIVE_TYPES = Set.of(JsonSchemaType._integer, JsonSchemaType._number, JsonSchemaType._boolean, JsonSchemaType._string, JsonSchemaType._null);
    private final Map<PsiElement, JsonValidationError> myErrors;
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonComplianceCheckerOptions myOptions;
    private boolean myHadTypeError;
    private static final JsonSchemaType[] NO_TYPES = new JsonSchemaType[0];

    public JsonSchemaAnnotatorChecker(@NotNull Project project, @NotNull JsonComplianceCheckerOptions options) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(0);
        }
        if (options == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myOptions = options;
        this.myErrors = new HashMap<PsiElement, JsonValidationError>();
    }

    @Override
    @NotNull
    public Map<PsiElement, JsonValidationError> getErrors() {
        Map<PsiElement, JsonValidationError> map = this.myErrors;
        if (map == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(2);
        }
        return map;
    }

    public boolean isHadTypeError() {
        return this.myHadTypeError;
    }

    public static JsonSchemaAnnotatorChecker checkByMatchResult(@NotNull Project project, @NotNull JsonValueAdapter elementToCheck, @NotNull MatchResult result, @NotNull JsonComplianceCheckerOptions options) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(3);
        }
        if (elementToCheck == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(4);
        }
        if (result == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(5);
        }
        if (options == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(6);
        }
        ArrayList<JsonSchemaAnnotatorChecker> checkers = new ArrayList<JsonSchemaAnnotatorChecker>();
        if (result.myExcludingSchemas.isEmpty() && result.mySchemas.size() == 1) {
            JsonSchemaAnnotatorChecker checker2 = new JsonSchemaAnnotatorChecker(project, options);
            checker2.checkByScheme(elementToCheck, result.mySchemas.iterator().next());
            checkers.add(checker2);
        } else {
            if (!result.mySchemas.isEmpty()) {
                checkers.add((JsonSchemaAnnotatorChecker)JsonSchemaAnnotatorChecker.processSchemasVariants(project, result.mySchemas, elementToCheck, false, options).getSecond());
            }
            if (!result.myExcludingSchemas.isEmpty()) {
                List list = ContainerUtil.map(result.myExcludingSchemas, group -> (JsonSchemaAnnotatorChecker)JsonSchemaAnnotatorChecker.processSchemasVariants(project, group, elementToCheck, true, options).getSecond());
                checkers.add(JsonSchemaAnnotatorChecker.mergeErrors(project, list, options, result.myExcludingSchemas));
            }
        }
        if (checkers.isEmpty()) {
            return null;
        }
        if (checkers.size() == 1) {
            return (JsonSchemaAnnotatorChecker)checkers.get(0);
        }
        return checkers.stream().filter(checker -> !checker.isHadTypeError()).findFirst().orElse((JsonSchemaAnnotatorChecker)checkers.get(0));
    }

    private static JsonSchemaAnnotatorChecker mergeErrors(@NotNull Project project, @NotNull List<JsonSchemaAnnotatorChecker> list, @NotNull JsonComplianceCheckerOptions options, @NotNull List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(7);
        }
        if (list == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(8);
        }
        if (options == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(9);
        }
        if (excludingSchemas == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(10);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, options);
        for (JsonSchemaAnnotatorChecker ch : list) {
            for (Map.Entry<PsiElement, JsonValidationError> element : ch.myErrors.entrySet()) {
                JsonValidationError error = element.getValue();
                if (error.getFixableIssueKind() == JsonValidationError.FixableIssueKind.ProhibitedProperty) {
                    String propertyName = ((JsonValidationError.ProhibitedPropertyIssueData)error.getIssueData()).propertyName;
                    boolean skip = false;
                    for (Collection<? extends JsonSchemaObject> objects : excludingSchemas) {
                        boolean propExists = objects.stream().filter(o -> !o.hasOwnExtraPropertyProhibition()).anyMatch(obj -> obj.getPropertyByName(propertyName) != null);
                        if (!propExists) continue;
                        skip = true;
                    }
                    if (skip) continue;
                }
                checker.myErrors.put(element.getKey(), error);
            }
        }
        return checker;
    }

    @Override
    public void error(@InspectionMessage String error, PsiElement holder, JsonErrorPriority priority) {
        this.error(error, holder, JsonValidationError.FixableIssueKind.None, null, priority);
    }

    @Override
    public void error(PsiElement newHolder, JsonValidationError error) {
        this.error(error.getMessage(), newHolder, error.getFixableIssueKind(), error.getIssueData(), error.getPriority());
    }

    @Override
    public void error(@InspectionMessage String error, PsiElement holder, JsonValidationError.FixableIssueKind fixableIssueKind, JsonValidationError.IssueData data, JsonErrorPriority priority) {
        if (this.myErrors.containsKey(holder)) {
            return;
        }
        this.myErrors.put(holder, new JsonValidationError(error, fixableIssueKind, data, priority));
    }

    @Override
    public void typeError(@NotNull PsiElement value, @Nullable JsonSchemaType currentType, JsonSchemaType ... allowedTypes) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(11);
        }
        if (allowedTypes == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(12);
        }
        if (allowedTypes.length == 0) {
            return;
        }
        String currentTypeDesc = currentType == null ? "" : " " + JsonBundle.message((String)"schema.validation.actual", (Object[])new Object[0]) + currentType.getName() + ".";
        String prefix = JsonBundle.message((String)"schema.validation.incompatible.types", (Object[])new Object[0]) + "\n";
        if (allowedTypes.length == 1) {
            this.error(prefix + " " + JsonBundle.message((String)"schema.validation.required.one", (Object[])new Object[]{allowedTypes[0].getName(), currentTypeDesc}), value, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
        } else {
            String typesText = Arrays.stream(allowedTypes).map(JsonSchemaType::getName).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
            this.error(prefix + " " + JsonBundle.message((String)"schema.validation.required.one.of", (Object[])new Object[]{typesText, currentTypeDesc}), value, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
        }
        this.myHadTypeError = true;
    }

    @Override
    public MatchResult resolve(JsonSchemaObject schemaObject, @Nullable JsonValueAdapter inspectedElementAdapter) {
        return new JsonSchemaResolver(this.myProject, schemaObject, new JsonPointerPosition(), inspectedElementAdapter).detailedResolve();
    }

    @Override
    @Nullable
    public JsonValidationHost checkByMatchResult(JsonValueAdapter adapter, MatchResult result, JsonComplianceCheckerOptions options) {
        return JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, adapter, result, options);
    }

    @Override
    public boolean isValid() {
        return this.myErrors.isEmpty() && !this.myHadTypeError;
    }

    public boolean checkByScheme(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(13);
        }
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(14);
        }
        JsonSchemaType instanceFieldType = JsonSchemaType.getType(value);
        boolean isValid = true;
        for (JsonSchemaValidation validation : schema.getValidations(instanceFieldType, value)) {
            if ((isValid &= validation.validate(value, schema, instanceFieldType, this, this.myOptions)) || !this.myOptions.shouldStopValidationAfterAnyErrorFound()) continue;
            return false;
        }
        return isValid;
    }

    @Override
    public void checkObjectBySchemaRecordErrors(@NotNull JsonSchemaObject schema, @NotNull JsonValueAdapter object) {
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(15);
        }
        if (object == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(16);
        }
        this.checkObjectBySchemaRecordErrors(schema, object, new JsonPointerPosition());
    }

    public void checkObjectBySchemaRecordErrors(@NotNull JsonSchemaObject schema, @NotNull JsonValueAdapter object, @NotNull JsonPointerPosition position) {
        JsonSchemaAnnotatorChecker checker;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(17);
        }
        if (object == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(18);
        }
        if (position == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(19);
        }
        if ((checker = JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, object, new JsonSchemaResolver(this.myProject, schema, position, object).detailedResolve(), this.myOptions)) != null) {
            this.myHadTypeError = checker.isHadTypeError();
            this.myErrors.putAll(checker.getErrors());
        }
    }

    @Override
    public void addErrorsFrom(JsonValidationHost otherHost) {
        this.myErrors.putAll(((JsonSchemaAnnotatorChecker)otherHost).myErrors);
    }

    @Override
    public boolean hasRecordedErrorsFor(@NotNull JsonValueAdapter inspectedValueAdapter) {
        if (inspectedValueAdapter == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(20);
        }
        return this.myErrors.containsKey(inspectedValueAdapter.getDelegate());
    }

    @NotNull
    private static Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> processSchemasVariants(@NotNull Project project, @NotNull Collection<? extends JsonSchemaObject> collection, @NotNull JsonValueAdapter value, boolean isOneOf, JsonComplianceCheckerOptions options) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(21);
        }
        if (collection == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(22);
        }
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(23);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, options);
        JsonSchemaType type = JsonSchemaType.getType(value);
        JsonSchemaObject selected = null;
        if (type == null) {
            if (!value.isShouldBeIgnored()) {
                checker.typeError(value.getDelegate(), null, JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            }
        } else {
            ArrayList<JsonSchemaObject> filtered = new ArrayList<JsonSchemaObject>(collection.size());
            JsonSchemaType altType = value.getAlternateType(type);
            for (JsonSchemaObject jsonSchemaObject : collection) {
                if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(jsonSchemaObject, type) && !JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(jsonSchemaObject, altType)) continue;
                filtered.add(jsonSchemaObject);
            }
            if (filtered.isEmpty()) {
                checker.typeError(value.getDelegate(), altType, JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            } else if (filtered.size() == 1) {
                selected = (JsonSchemaObject)filtered.get(0);
                checker.checkByScheme(value, selected);
            } else {
                selected = isOneOf ? checker.processOneOf(value, filtered) : checker.processAnyOf(value, filtered);
            }
        }
        Pair pair = Pair.create(selected, (Object)checker);
        if (pair == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(24);
        }
        return pair;
    }

    public static JsonSchemaType[] getExpectedTypes(Collection<? extends JsonSchemaObject> schemas) {
        ArrayList<JsonSchemaType> list = new ArrayList<JsonSchemaType>();
        for (JsonSchemaObject jsonSchemaObject : schemas) {
            JsonSchemaType type = jsonSchemaObject.getType();
            if (type != null) {
                list.add(type);
                continue;
            }
            Set<JsonSchemaType> variants = jsonSchemaObject.getTypeVariants();
            if (variants == null) continue;
            list.addAll(variants);
        }
        return list.isEmpty() ? NO_TYPES : list.toArray(NO_TYPES);
    }

    public static boolean areSchemaTypesCompatible(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType type) {
        JsonSchemaType matchingSchemaType;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(25);
        }
        if (type == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(26);
        }
        if ((matchingSchemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type)) != null) {
            return matchingSchemaType.equals((Object)type);
        }
        if (schema.getEnum() != null) {
            return PRIMITIVE_TYPES.contains((Object)type);
        }
        return true;
    }

    @Nullable
    public static JsonSchemaType getMatchingSchemaType(@NotNull JsonSchemaObject schema, @Nullable JsonSchemaType input) {
        JsonSchemaType matchType;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(27);
        }
        if ((matchType = schema.getType()) != null) {
            if (JsonSchemaType._integer.equals((Object)input) && JsonSchemaType._number.equals((Object)matchType)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (JsonSchemaType._number.equals((Object)matchType) || JsonSchemaType._integer.equals((Object)matchType) || JsonSchemaType._string.equals((Object)matchType))) {
                return input;
            }
            return matchType;
        }
        if (schema.getTypeVariants() != null) {
            Set<JsonSchemaType> matchTypes = schema.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (JsonSchemaType._integer.equals((Object)input) && matchTypes.contains((Object)JsonSchemaType._number)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (matchTypes.contains((Object)JsonSchemaType._number) || matchTypes.contains((Object)JsonSchemaType._integer) || matchTypes.contains((Object)JsonSchemaType._string))) {
                return input;
            }
            return matchTypes.iterator().next();
        }
        if (JsonSchemaObjectReadingUtils.hasProperties(schema) && JsonSchemaType._object.equals((Object)input)) {
            return JsonSchemaType._object;
        }
        return null;
    }

    @Nullable
    public static String getValue(PsiElement propValue, JsonSchemaObject schema) {
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(propValue, schema);
        assert (walker != null);
        JsonValueAdapter adapter = walker.createValueAdapter(propValue);
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return null;
        }
        return walker.getNodeTextForValidation(propValue);
    }

    private JsonSchemaObject processOneOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> oneOf) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(28);
        }
        ArrayList<JsonSchemaAnnotatorChecker> candidateErroneousCheckers = new ArrayList<JsonSchemaAnnotatorChecker>();
        ArrayList<JsonSchemaObject> candidateErroneousSchemas = new ArrayList<JsonSchemaObject>();
        SmartList correct = new SmartList();
        for (JsonSchemaObject object : oneOf) {
            if (object.hasChildNode("instanceof") || object.hasChildNode("typeof") || object.isShouldValidateAgainstJSType()) continue;
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, this.myOptions);
            checker.checkByScheme(value, object);
            if (checker.isCorrect()) {
                candidateErroneousCheckers.clear();
                candidateErroneousSchemas.clear();
                correct.add(object);
                continue;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        if (correct.size() == 1) {
            return (JsonSchemaObject)correct.get(0);
        }
        if (!correct.isEmpty()) {
            JsonSchemaType type = JsonSchemaType.getType(value);
            if (type != null && new HashSet(correct).size() > 1 && !JsonSchemaAnnotatorChecker.schemesDifferWithNotCheckedProperties((List<JsonSchemaObject>)correct)) {
                this.error(JsonBundle.message((String)"schema.validation.to.more.than.one", (Object[])new Object[0]), value.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
            return (JsonSchemaObject)ContainerUtil.getLastItem((List)correct);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, true);
    }

    private static boolean schemesDifferWithNotCheckedProperties(@NotNull List<JsonSchemaObject> list) {
        if (list == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(29);
        }
        return list.stream().anyMatch(s -> !StringUtil.isEmptyOrSpaces((String)s.getFormat()));
    }

    @NotNull
    private static AverageFailureAmount getAverageFailureAmount(@NotNull JsonSchemaAnnotatorChecker checker) {
        if (checker == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(30);
        }
        int lowPriorityCount = 0;
        boolean hasMedium = false;
        boolean hasMissing = false;
        boolean hasHard = false;
        Collection<JsonValidationError> values = checker.getErrors().values();
        for (JsonValidationError value : values) {
            switch (value.getPriority()) {
                case LOW_PRIORITY: {
                    ++lowPriorityCount;
                    break;
                }
                case MISSING_PROPS: {
                    hasMissing = true;
                    break;
                }
                case MEDIUM_PRIORITY: {
                    hasMedium = true;
                    break;
                }
                case TYPE_MISMATCH: {
                    hasHard = true;
                    break;
                }
                case NOT_SCHEMA: {
                    AverageFailureAmount averageFailureAmount = AverageFailureAmount.NotSchema;
                    if (averageFailureAmount == null) {
                        JsonSchemaAnnotatorChecker.$$$reportNull$$$0(31);
                    }
                    return averageFailureAmount;
                }
            }
        }
        if (hasHard) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.Hard;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(32);
            }
            return averageFailureAmount;
        }
        if (hasMissing) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.MissingItems;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(33);
            }
            return averageFailureAmount;
        }
        if (hasMedium) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.Medium;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(34);
            }
            return averageFailureAmount;
        }
        AverageFailureAmount averageFailureAmount = lowPriorityCount <= 3 ? AverageFailureAmount.Light : AverageFailureAmount.Medium;
        if (averageFailureAmount == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(35);
        }
        return averageFailureAmount;
    }

    private JsonSchemaObject processAnyOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> anyOf) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(36);
        }
        ArrayList<JsonSchemaAnnotatorChecker> candidateErroneousCheckers = new ArrayList<JsonSchemaAnnotatorChecker>();
        ArrayList<JsonSchemaObject> candidateErroneousSchemas = new ArrayList<JsonSchemaObject>();
        for (JsonSchemaObject object : anyOf) {
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, this.myOptions);
            checker.checkByScheme(value, object);
            if (checker.isCorrect()) {
                return object;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, false);
    }

    @Nullable
    private JsonSchemaObject showErrorsAndGetLeastErroneous(@NotNull List<JsonSchemaAnnotatorChecker> candidateErroneousCheckers, @NotNull List<JsonSchemaObject> candidateErroneousSchemas, boolean isOneOf) {
        if (candidateErroneousCheckers == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(37);
        }
        if (candidateErroneousSchemas == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(38);
        }
        JsonSchemaObject current = null;
        JsonSchemaObject currentWithMinAverage = null;
        Optional<AverageFailureAmount> minAverage = candidateErroneousCheckers.stream().map(c -> JsonSchemaAnnotatorChecker.getAverageFailureAmount(c)).min(Comparator.comparingInt(c -> c.ordinal()));
        int min = minAverage.orElse(AverageFailureAmount.Hard).ordinal();
        int minErrorCount = candidateErroneousCheckers.stream().map(c -> c.getErrors().size()).min(Integer::compareTo).orElse(Integer.MAX_VALUE);
        MultiMap errorsWithMinAverage = new MultiMap();
        MultiMap allErrors = new MultiMap();
        for (int i = 0; i < candidateErroneousCheckers.size(); ++i) {
            boolean isMoreThanAverage;
            JsonSchemaAnnotatorChecker checker = candidateErroneousCheckers.get(i);
            boolean isMoreThanMinErrors = checker.getErrors().size() > minErrorCount;
            boolean bl = isMoreThanAverage = JsonSchemaAnnotatorChecker.getAverageFailureAmount(checker).ordinal() > min;
            if (isMoreThanMinErrors) continue;
            if (isMoreThanAverage) {
                currentWithMinAverage = candidateErroneousSchemas.get(i);
            } else {
                current = candidateErroneousSchemas.get(i);
            }
            for (Map.Entry<Object, JsonValidationError> entry : checker.getErrors().entrySet()) {
                (isMoreThanAverage ? errorsWithMinAverage : allErrors).putValue((Object)((PsiElement)entry.getKey()), (Object)entry.getValue());
            }
        }
        if (allErrors.isEmpty()) {
            allErrors = errorsWithMinAverage;
        }
        for (Map.Entry entry : allErrors.entrySet()) {
            Collection value = (Collection)entry.getValue();
            if (value.isEmpty()) continue;
            if (value.size() == 1) {
                this.error((PsiElement)entry.getKey(), (JsonValidationError)value.iterator().next());
                continue;
            }
            JsonValidationError error = JsonSchemaAnnotatorChecker.tryMergeErrors(value, isOneOf);
            if (error != null) {
                this.error((PsiElement)entry.getKey(), error);
                continue;
            }
            for (JsonValidationError jsonValidationError : value) {
                this.error((PsiElement)entry.getKey(), jsonValidationError);
            }
        }
        if (current == null) {
            current = currentWithMinAverage;
        }
        if (current == null) {
            current = (JsonSchemaObject)ContainerUtil.getLastItem(candidateErroneousSchemas);
        }
        return current;
    }

    @Nullable
    private static JsonValidationError tryMergeErrors(@NotNull Collection<JsonValidationError> errors, boolean isOneOf) {
        if (errors == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(39);
        }
        JsonValidationError.FixableIssueKind commonIssueKind = null;
        for (JsonValidationError error : errors) {
            JsonValidationError.FixableIssueKind currentIssueKind = error.getFixableIssueKind();
            if (currentIssueKind == JsonValidationError.FixableIssueKind.None) {
                return null;
            }
            if (commonIssueKind == null) {
                commonIssueKind = currentIssueKind;
                continue;
            }
            if (currentIssueKind == commonIssueKind) continue;
            return null;
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.NonEnumValue) {
            String prefix = JsonBundle.message((String)"schema.validation.enum.mismatch", (Object[])new Object[]{""});
            @NlsSafe String text = errors.stream().map(e -> StringUtil.trimEnd((String)StringUtil.trimStart((String)e.getMessage(), (String)prefix), (String)prefix)).map(e -> StringUtil.split((String)e, (String)", ")).flatMap(e -> e.stream()).distinct().sorted().collect(Collectors.joining(", "));
            return new JsonValidationError(prefix + text, commonIssueKind, null, errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.MissingProperty) {
            String sets = (String)errors.stream().map(e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData()).map(d -> d.getMessage(false)).collect(NlsMessages.joiningOr());
            return new JsonValidationError(JsonBundle.message((String)(isOneOf ? "schema.validation.one.of.property.sets.required" : "schema.validation.at.least.one.of.property.sets.required"), (Object[])new Object[]{sets}), isOneOf ? JsonValidationError.FixableIssueKind.MissingOneOfProperty : JsonValidationError.FixableIssueKind.MissingAnyOfProperty, new JsonValidationError.MissingOneOfPropsIssueData(ContainerUtil.map(errors, e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData())), errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.ProhibitedType) {
            Set allTypes = errors.stream().map(e -> (JsonValidationError.TypeMismatchIssueData)e.getIssueData()).flatMap(d -> Arrays.stream(d.expectedTypes)).collect(Collectors.toSet());
            if (allTypes.size() == 1) {
                return errors.iterator().next();
            }
            List<String> actualInfos = errors.stream().map(e -> e.getMessage()).map(JsonSchemaAnnotatorChecker::fetchActual).distinct().toList();
            String actualInfo = actualInfos.size() == 1 ? " " + JsonBundle.message((String)"schema.validation.actual", (Object[])new Object[0]) + actualInfos.get(0) + "." : "";
            String commonTypeMessage = JsonBundle.message((String)"schema.validation.incompatible.types", (Object[])new Object[0]) + "\n" + JsonBundle.message((String)"schema.validation.required.one.of", (Object[])new Object[]{allTypes.stream().map(t -> t.getDescription()).sorted().collect(Collectors.joining(", ")), actualInfo});
            return new JsonValidationError(commonTypeMessage, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData((JsonSchemaType[])ContainerUtil.toArray(allTypes, JsonSchemaType[]::new)), errors.iterator().next().getPriority());
        }
        return null;
    }

    private static String fetchActual(String message) {
        String actualMessage = JsonBundle.message((String)"schema.validation.actual", (Object[])new Object[0]);
        int actual = message.indexOf(actualMessage);
        if (actual == -1) {
            return null;
        }
        String substring = message.endsWith(actualMessage) ? message.substring(0, actual) : message.substring(actual + actualMessage.length());
        return StringUtil.trimEnd((String)substring, (String)".");
    }

    public boolean isCorrect() {
        return this.myErrors.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 24, 31, 32, 33, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 24: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludingSchemas";
                break;
            }
            case 11: 
            case 13: 
            case 23: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedTypes";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectedValueAdapter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateErroneousCheckers";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateErroneousSchemas";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "processSchemasVariants";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAverageFailureAmount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 24: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkByMatchResult";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mergeErrors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "typeError";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkByScheme";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectBySchemaRecordErrors";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasRecordedErrorsFor";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processSchemasVariants";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "areSchemaTypesCompatible";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingSchemaType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processOneOf";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "schemesDifferWithNotCheckedProperties";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAverageFailureAmount";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processAnyOf";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showErrorsAndGetLeastErroneous";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeErrors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 24, 31, 32, 33, 34, 35 -> new IllegalStateException(string);
        };
    }

    private static enum AverageFailureAmount {
        Light,
        MissingItems,
        Medium,
        Hard,
        NotSchema;

    }
}

