/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.template.lang.core.templateLanguages;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.template.lang.core.templateLanguages.PyTemplateLanguageSubstitutorDelegate;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTemplateLanguageSubstitutor
extends LanguageSubstitutor {
    public Language getLanguage(@NotNull VirtualFile vFile, @NotNull Project project) {
        if (vFile == null) {
            PyTemplateLanguageSubstitutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PyTemplateLanguageSubstitutor.$$$reportNull$$$0(1);
        }
        return (Language)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            Module module;
            VirtualFile virtualFile = vFile;
            if (virtualFile instanceof VirtualFileWindow) {
                virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)(virtualFile = VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile)), (Project)project)) == null || module.isDisposed()) {
                return null;
            }
            Language language = PyTemplateLanguageSubstitutor.getImplicitLanguageToSubstitute(virtualFile, module);
            if (language != null) {
                return language;
            }
            language = TemplatesService.getInstance(module).getTemplateLanguage();
            if (language == null) {
                return null;
            }
            if (PyTemplateLanguageSubstitutor.isTemplateForbidden(vFile, module)) {
                return null;
            }
            String fileName = vFile.getName();
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (FileType possibleType : TemplatesService.getInstance(module).getTemplateFileTypes()) {
                for (FileNameMatcher matcher : fileTypeManager.getAssociations(possibleType)) {
                    if (!matcher.acceptsCharSequence((CharSequence)fileName)) continue;
                    return language;
                }
            }
            return null;
        }));
    }

    private static boolean isTemplateForbidden(@NotNull VirtualFile file, @NotNull Module module) {
        if (file == null) {
            PyTemplateLanguageSubstitutor.$$$reportNull$$$0(2);
        }
        if (module == null) {
            PyTemplateLanguageSubstitutor.$$$reportNull$$$0(3);
        }
        for (PyTemplateLanguageSubstitutorDelegate delegate : PyTemplateLanguageSubstitutorDelegate.EP.getExtensionList()) {
            if (!delegate.isTemplateForbidden(file, module)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Language getImplicitLanguageToSubstitute(@NotNull VirtualFile file, @NotNull Module module) {
        if (file == null) {
            PyTemplateLanguageSubstitutor.$$$reportNull$$$0(4);
        }
        if (module == null) {
            PyTemplateLanguageSubstitutor.$$$reportNull$$$0(5);
        }
        for (PyTemplateLanguageSubstitutorDelegate delegate : PyTemplateLanguageSubstitutorDelegate.EP.getExtensionList()) {
            Language language = delegate.getImplicitLanguage(file, module);
            if (language == null) continue;
            return language;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/template/lang/core/templateLanguages/PyTemplateLanguageSubstitutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTemplateForbidden";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getImplicitLanguageToSubstitute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

