/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref.admin;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoAdminClass;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!J \u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020#0&0%2\u0006\u0010 \u001a\u00020!J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100%2\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/python/django/ref/admin/DjangoAdminModelUtil;", "", "<init>", "()V", "UPPER_CASE_MATCHER", "Lkotlin/text/Regex;", "getRegisterDecorator", "", "modelClassName", "generateRegisterDecorator", "Lcom/jetbrains/python/psi/PyDecoratorList;", "project", "Lcom/intellij/openapi/project/Project;", "generateAdminModelPsiForModel", "Lcom/jetbrains/python/psi/PyClass;", "djangoModelClass", "Lcom/jetbrains/django/model/modelApi/DjangoModelClass;", "generateAdminClassName", "updateImportsForAdminModel", "", "adminFile", "Lcom/intellij/psi/PsiFile;", "adminModelClassPsi", "Lcom/intellij/psi/PsiElement;", "generateDjangoModelClassNameToAdminFileName", "updateImportForQualifiedName", "file", "qualifiedName", "anchor", "isModelAdminIsAlreadyDefinedInAdminModule", "", "modelClass", "djangoAppModel", "Lcom/jetbrains/django/model/applications/DjangoUnnamedApplicationModel;", "findAdminClassForModel", "Lcom/jetbrains/django/model/modelApi/DjangoAdminClass;", "findRegisteredModelsInApp", "", "Lkotlin/Pair;", "findNotRegisteredModelsInApp", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoAdminModelUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoAdminModelUtil.kt\ncom/intellij/python/django/ref/admin/DjangoAdminModelUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n295#2,2:138\n774#2:140\n865#2,2:141\n1368#2:143\n1454#2,2:144\n1557#2:146\n1628#2,3:147\n1456#2,3:150\n774#2:153\n865#2,2:154\n1557#2:156\n1628#2,3:157\n*S KotlinDebug\n*F\n+ 1 DjangoAdminModelUtil.kt\ncom/intellij/python/django/ref/admin/DjangoAdminModelUtil\n*L\n98#1:138,2\n110#1:140\n110#1:141,2\n113#1:143\n113#1:144,2\n115#1:146\n115#1:147,3\n113#1:150,3\n125#1:153\n125#1:154,2\n129#1:156\n129#1:157,3\n*E\n"})
public final class DjangoAdminModelUtil {
    @NotNull
    public static final DjangoAdminModelUtil INSTANCE = new DjangoAdminModelUtil();
    @NotNull
    private static final Regex UPPER_CASE_MATCHER = new Regex("[A-Z]");

    private DjangoAdminModelUtil() {
    }

    private final String getRegisterDecorator(String modelClassName) {
        return "@admin.register(" + modelClassName + ")";
    }

    @NotNull
    public final PyDecoratorList generateRegisterDecorator(@NotNull String modelClassName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)modelClassName, (String)"modelClassName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyElementGenerator elementFactory = PyElementGenerator.getInstance((Project)project);
        String[] stringArray = new String[]{this.getRegisterDecorator(modelClassName)};
        PyDecoratorList pyDecoratorList = elementFactory.createDecoratorList(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)pyDecoratorList, (String)"createDecoratorList(...)");
        return pyDecoratorList;
    }

    @NotNull
    public final PyClass generateAdminModelPsiForModel(@NotNull DjangoModelClass djangoModelClass) {
        Intrinsics.checkNotNullParameter((Object)djangoModelClass, (String)"djangoModelClass");
        String string = djangoModelClass.getPyClass().getName();
        if (string == null) {
            string = "";
        }
        String modelClassName = string;
        PyElementGenerator elementFactory = PyElementGenerator.getInstance((Project)djangoModelClass.getPyClass().getProject());
        String djangoAdminModelCode = StringsKt.trimIndent((String)("\n" + this.getRegisterDecorator(modelClassName) + "\nclass " + this.generateAdminClassName(modelClassName) + "(admin.ModelAdmin):\n    pass\n"));
        Object object = elementFactory.createFromText(LanguageLevel.forElement((PsiElement)((PsiElement)djangoModelClass.getPyClass())), PyClass.class, djangoAdminModelCode);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createFromText(...)");
        return (PyClass)object;
    }

    @NotNull
    public final String generateAdminClassName(@NotNull String modelClassName) {
        Intrinsics.checkNotNullParameter((Object)modelClassName, (String)"modelClassName");
        return modelClassName + "Admin";
    }

    public final void updateImportsForAdminModel(@NotNull PsiFile adminFile, @Nullable DjangoModelClass djangoModelClass, @NotNull PsiElement adminModelClassPsi) {
        Intrinsics.checkNotNullParameter((Object)adminFile, (String)"adminFile");
        Intrinsics.checkNotNullParameter((Object)adminModelClassPsi, (String)"adminModelClassPsi");
        DjangoModelClass djangoModelClass2 = djangoModelClass;
        if (djangoModelClass2 != null) {
            DjangoModelClass it = djangoModelClass2;
            boolean bl = false;
            INSTANCE.updateImportForQualifiedName(adminFile, it.getPyClass().getQualifiedName(), adminModelClassPsi);
        }
        this.updateImportForQualifiedName(adminFile, "django.contrib.admin", adminModelClassPsi);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String generateDjangoModelClassNameToAdminFileName(@NotNull DjangoModelClass djangoModelClass) {
        String string;
        block6: {
            block5: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)djangoModelClass, (String)"djangoModelClass");
                string = djangoModelClass.getPyClass().getName();
                if (string == null) break block5;
                String string3 = string;
                if (((CharSequence)string3).length() > 0) {
                    void it;
                    char c = string3.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.lowercase((char)it, (Locale)locale));
                    String string4 = string3;
                    int n = 1;
                    String string5 = string4.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    string2 = stringBuilder2.append(string5).toString();
                } else {
                    string2 = string = string3;
                }
                if (string2 != null) break block6;
            }
            return null;
        }
        String decapitalizedDjangoModelClassName = string;
        return UPPER_CASE_MATCHER.replace((CharSequence)decapitalizedDjangoModelClassName, DjangoAdminModelUtil::generateDjangoModelClassNameToAdminFileName$lambda$2) + ".py";
    }

    private final void updateImportForQualifiedName(PsiFile file, String qualifiedName, PsiElement anchor) {
        String string = PythonStringUtil.removeLastSuffix((String)qualifiedName, (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeLastSuffix(...)");
        String from = string;
        String name = PythonStringUtil.getLastSuffix((String)qualifiedName, (String)".");
        AddImportHelper.addOrUpdateFromImportStatement((PsiFile)file, (String)from, (String)name, null, null, (PsiElement)anchor);
    }

    public final boolean isModelAdminIsAlreadyDefinedInAdminModule(@NotNull DjangoModelClass modelClass, @NotNull DjangoUnnamedApplicationModel djangoAppModel) {
        Intrinsics.checkNotNullParameter((Object)modelClass, (String)"modelClass");
        Intrinsics.checkNotNullParameter((Object)djangoAppModel, (String)"djangoAppModel");
        return this.findAdminClassForModel(modelClass, djangoAppModel) != null;
    }

    @Nullable
    public final DjangoAdminClass findAdminClassForModel(@NotNull DjangoModelClass modelClass, @NotNull DjangoUnnamedApplicationModel djangoAppModel) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)djangoAppModel, (String)"djangoAppModel");
            Iterable $this$firstOrNull$iv = this.findRegisteredModelsInApp(djangoAppModel);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)modelClass)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Pair pair = v0;
        return pair != null ? (DjangoAdminClass)pair.getSecond() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Pair<DjangoModelClass, DjangoAdminClass>> findRegisteredModelsInApp(@NotNull DjangoUnnamedApplicationModel djangoAppModel) {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)djangoAppModel, (String)"djangoAppModel");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)djangoAppModel.getApplicationRootFolder().getProject(), (PsiFile)((PsiFile)djangoAppModel.getModel()));
        List list = djangoAppModel.getAdminClasses(typeEvalContext);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdminClasses(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DjangoAdminClass it = (DjangoAdminClass)element$iv$iv;
            boolean bl = false;
            if (!it.isDefinedInApplication(djangoAppModel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List admins = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = admins;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DjangoAdminClass djangoAdminClass = (DjangoAdminClass)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)typeEvalContext);
            Iterable iterable2 = djangoAdminClass.getRegisteredModels(typeEvalContext);
            boolean $i$f$map = false;
            void var16_21 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DjangoModelClass djangoModelClass = (DjangoModelClass)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it, (Object)djangoAdminClass));
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set registeredModels = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return registeredModels;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<DjangoModelClass> findNotRegisteredModelsInApp(@NotNull DjangoUnnamedApplicationModel djangoAppModel) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)djangoAppModel, (String)"djangoAppModel");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)djangoAppModel.getApplicationRootFolder().getProject(), (PsiFile)((PsiFile)djangoAppModel.getModel()));
        List list = djangoAppModel.getModelClasses(typeEvalContext);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getModelClasses(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DjangoModelClass it = (DjangoModelClass)element$iv$iv;
            boolean bl = false;
            if (!it.isDefinedInApplication(djangoAppModel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set models = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = this.findRegisteredModelsInApp(djangoAppModel);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((DjangoModelClass)it.getFirst());
        }
        Set registeredModels = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Set notRegisteredModels = SetsKt.minus((Set)models, (Iterable)registeredModels);
        return notRegisteredModels;
    }

    private static final CharSequence generateDjangoModelClassNameToAdminFileName$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getValue().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return "_" + string;
    }
}

