/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ContentProviders;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.internal.GAsyncReadyCallbackHelper;
import org.eclipse.swt.internal.GTK4GlibFuture;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Display;

class ClipboardProxyGTK4 {
    private static String ID = "CLIPBOARD PROXY OBJECT";
    private Display display;
    private Clipboard activeClipboard = null;
    private Clipboard activePrimaryClipboard = null;
    private final ContentProviders contentProviders = ContentProviders.getInstance();

    static ClipboardProxyGTK4 _getInstance(Display display) {
        if (!GTK.GTK4) {
            throw new UnsupportedOperationException("Illegal attempt to use GTK4 ClipboardProxy on GTK3");
        }
        ClipboardProxyGTK4 proxy = (ClipboardProxyGTK4)display.getData(ID);
        if (proxy != null) {
            return proxy;
        }
        proxy = new ClipboardProxyGTK4(display);
        display.setData(ID, proxy);
        display.disposeExec(() -> {
            ClipboardProxyGTK4 clipbordProxy = (ClipboardProxyGTK4)display.getData(ID);
            if (clipbordProxy == null) {
                return;
            }
            display.setData(ID, null);
            clipbordProxy.dispose();
        });
        return proxy;
    }

    private ClipboardProxyGTK4(Display display) {
        this.display = display;
    }

    void clear(Clipboard owner, int clipboards, boolean takeOwnership) {
        if ((clipboards & 1) != 0 && (takeOwnership || this.activeClipboard == owner && GTK4.gdk_clipboard_is_local(Clipboard.GTKCLIPBOARD))) {
            GTK4.gdk_clipboard_set_content(Clipboard.GTKCLIPBOARD, 0L);
            ContentProviders.CLIPBOARD_DATA.CLIPBOARD.clear();
        }
        if ((takeOwnership || (clipboards & 2) != 0 && this.activePrimaryClipboard == owner) && GTK4.gdk_clipboard_is_local(Clipboard.GTKPRIMARYCLIPBOARD)) {
            GTK4.gdk_clipboard_set_content(Clipboard.GTKPRIMARYCLIPBOARD, 0L);
            ContentProviders.CLIPBOARD_DATA.PRIMARYCLIPBOARD.clear();
        }
    }

    private void dispose() {
        if (this.display == null) {
            return;
        }
        CompletableFuture<Boolean> storeClipboardFuture = this.storeClipboard(Clipboard.GTKCLIPBOARD);
        CompletableFuture<Boolean> storeSelectionFuture = this.storeClipboard(Clipboard.GTKPRIMARYCLIPBOARD);
        CompletableFuture<Void> combined = CompletableFuture.allOf(storeClipboardFuture, storeSelectionFuture);
        try {
            GTK4GlibFuture.get(this.display, combined, Duration.ofSeconds(10L));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        this.display = null;
    }

    private CompletableFuture<Boolean> storeClipboard(final long clipboard) {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        GAsyncReadyCallbackHelper.run(new GAsyncReadyCallbackHelper.Async(){

            @Override
            public void async(long callback) {
                GTK4.gdk_clipboard_store_async(clipboard, 0, 0L, callback, 0L);
            }

            @Override
            public void callback(long result) {
                future.complete(GTK4.gdk_clipboard_store_finish(clipboard, result, null));
            }
        });
        return future;
    }

    boolean setData(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        boolean result = false;
        if ((clipboards & 1) != 0 || (clipboards & 2) != 0) {
            long clipboard = clipboards == 2 ? Clipboard.GTKPRIMARYCLIPBOARD : Clipboard.GTKCLIPBOARD;
            ContentProviders.CLIPBOARD_DATA clipboardType = ContentProviders.CLIPBOARD_DATA.fromDNDConstants(clipboards);
            long providers = this.contentProviders.createContentProviders(data, dataTypes, clipboardType);
            if (providers != 0L) {
                result = GTK4.gdk_clipboard_set_content(clipboard, providers);
                if (clipboards == 2) {
                    this.activePrimaryClipboard = owner;
                } else {
                    this.activeClipboard = owner;
                }
            }
        }
        return result;
    }

    public CompletableFuture<Object> getData(Clipboard owner, Transfer transfer, int clipboards) {
        final long clipboard = clipboards == 2 ? Clipboard.GTKPRIMARYCLIPBOARD : Clipboard.GTKCLIPBOARD;
        final long gType = this.contentProviders.getGType(transfer);
        final CompletableFuture<Object> future = new CompletableFuture<Object>();
        GAsyncReadyCallbackHelper.run(new GAsyncReadyCallbackHelper.Async(){

            @Override
            public void async(long callback) {
                GTK4.gdk_clipboard_read_value_async(clipboard, gType, 0, 0L, callback, 0L);
            }

            @Override
            public void callback(long result) {
                long gvalue = GTK4.gdk_clipboard_read_value_finish(clipboard, result, null);
                if (gvalue == 0L) {
                    future.complete(null);
                } else {
                    Object object = ClipboardProxyGTK4.this.contentProviders.getObject(gvalue);
                    future.complete(object);
                }
            }
        });
        return future;
    }
}

