/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Locale;
import org.apache.commons.text.similarity.FuzzyScore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FuzzyScoreTest {
    private static final FuzzyScore ENGLISH_SCORE = new FuzzyScore(Locale.ENGLISH);

    @Test
    public void testGetFuzzyScore() {
        Assertions.assertEquals((int)0, (Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)0, (Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"b"));
        Assertions.assertEquals((int)1, (Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Room", (CharSequence)"o"));
        Assertions.assertEquals((int)1, (Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"w"));
        Assertions.assertEquals((int)2, (Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"ws"));
        Assertions.assertEquals((int)4, (Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"wo"));
        Assertions.assertEquals((int)3, (Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Apache Software Foundation", (CharSequence)"asf"));
    }

    @Test
    public void testGetFuzzyScore_NullNullLocale() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ENGLISH_SCORE.fuzzyScore(null, null));
    }

    @Test
    public void testGetFuzzyScore_NullStringLocale() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ENGLISH_SCORE.fuzzyScore(null, (CharSequence)"not null"));
    }

    @Test
    public void testGetFuzzyScore_StringNullLocale() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ENGLISH_SCORE.fuzzyScore((CharSequence)"not null", null));
    }

    @Test
    public void testGetLocale() {
        Locale locale = Locale.CANADA_FRENCH;
        FuzzyScore fuzzyScore = new FuzzyScore(locale);
        Locale localeTwo = fuzzyScore.getLocale();
        Assertions.assertSame((Object)localeTwo, (Object)locale);
    }

    @Test
    public void testMissingLocale() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FuzzyScore((Locale)null));
    }
}

