﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Collections.Generic;
using System.Reflection;
using Cake.Core.IO;

namespace Cake.Core.Scripting
{
    /// <summary>
    /// Represents the script conventions used by Cake.
    /// </summary>
    public interface IScriptConventions
    {
        /// <summary>
        /// Gets the default namespaces.
        /// </summary>
        /// <returns>A list containing all default namespaces.</returns>
        IReadOnlyList<string> GetDefaultNamespaces();

        /// <summary>
        /// Gets the default assemblies.
        /// </summary>
        /// <param name="root">The root to where to find Cake related assemblies.</param>
        /// <returns>A list containing all default assemblies.</returns>
        IReadOnlyList<Assembly> GetDefaultAssemblies(DirectoryPath root);

        /// <summary>
        /// Gets the default defines.
        /// </summary>
        /// <returns>A list containing all default defines.</returns>
        IReadOnlyList<string> GetDefaultDefines();
    }
}