// Source: https://github.com/rust-lang/rust/blob/master/compiler/rustc_span/src/symbol.rs

module Fable.Transforms.Rust.AST.Symbols

// After modifying this list adjust `is_special`, `is_used_keyword`/`is_unused_keyword`,
// this should be rarely necessary though if the keywords are kept in alphabetic order.
module kw =
    // Special reserved identifiers used internally for elided lifetimes
    // unnamed method parameters crate root module error recovery etc.
    let Empty = ""
    let PathRoot = "{{root}}"
    let DollarCrate = "$crate"
    let Underscore = "_"

    // Keywords that are used in stable Rust.
    let As = "as"
    let Break = "break"
    let Const = "const"
    let Continue = "continue"
    let Crate = "crate"
    let Else = "else"
    let Enum = "enum"
    let Extern = "extern"
    let False = "false"
    let Fn = "fn"
    let For = "for"
    let If = "if"
    let Impl = "impl"
    let In = "in"
    let Let = "let"
    let Loop = "loop"
    let Match = "match"
    let Mod = "mod"
    let Move = "move"
    let Mut = "mut"
    let Pub = "pub"
    let Ref = "ref"
    let Return = "return"
    let SelfLower = "self"
    let SelfUpper = "Self"
    let Static = "static"
    let Struct = "struct"
    let Super = "super"
    let Trait = "trait"
    let True = "true"
    let Type = "type"
    let Unsafe = "unsafe"
    let Use = "use"
    let Where = "where"
    let While = "while"

    // Keywords that are used in unstable Rust or reserved for future use.
    let Abstract = "abstract"
    let Become = "become"
    let Box = "box"
    let Do = "do"
    let Final = "final"
    let Macro = "macro"
    let Override = "override"
    let Priv = "priv"
    let Typeof = "typeof"
    let Unsized = "unsized"
    let Virtual = "virtual"
    let Yield = "yield"

    // Edition-specific keywords that are used in stable Rust.
    let Async = "async" // >=  2018 Edition only
    let Await = "await" // >=  2018 Edition only
    let Dyn = "dyn" // >=  2018 Edition only

    // Edition-specific keywords that are used in unstable Rust or reserved for future use.
    let Try = "try" // >=  2018 Edition only

    // Special lifetime names
    let UnderscoreLifetime = "'_"
    let StaticLifetime = "'static"

    // Weak keywords have special meaning only in specific contexts.
    let Auto = "auto"
    let Catch = "catch"
    let Default = "default"
    let MacroRules = "macro_rules"
    let Raw = "raw"
    let Union = "union"

    let RustKeywords =
        [
            // Special reserved identifiers used internally for elided lifetimes
            // unnamed method parameters crate root module error recovery etc.
            Empty
            PathRoot
            DollarCrate
            Underscore

            // Keywords that are used in stable Rust.
            As
            Break
            Const
            Continue
            Crate
            Else
            Enum
            Extern
            False
            Fn
            For
            If
            Impl
            In
            Let
            Loop
            Match
            Mod
            Move
            Mut
            Pub
            Ref
            Return
            SelfLower
            SelfUpper
            Static
            Struct
            Super
            Trait
            True
            Type
            Unsafe
            Use
            Where
            While

            // Keywords that are used in unstable Rust or reserved for future use.
            Abstract
            Become
            Box
            Do
            Final
            Macro
            Override
            Priv
            Typeof
            Unsized
            Virtual
            Yield

            // Edition-specific keywords that are used in stable Rust.
            Async
            Await
            Dyn

            // Edition-specific keywords that are used in unstable Rust or reserved for future use.
            Try

            // Special lifetime names
            UnderscoreLifetime
            StaticLifetime

            // Weak keywords have special meaning only in specific contexts.
            Auto
            Catch
            Default
            MacroRules
            Raw
            Union
        ]

    let RustPrelude =
        [
            "Copy"
            "Send"
            "Sized"
            "Sync"
            "Unpin"
            "drop"
            "Drop"
            "Fn"
            "FnMut"
            "FnOnce"
            "Box"
            "ToOwned"
            "Clone"
            "PartialEq"
            "PartialOrd"
            "Eq"
            "Ord"
            "AsRef"
            "AsMut"
            "Into"
            "From"
            "Default"
            "Iterator"
            "Extend"
            "IntoIterator"
            "DoubleEndedIterator"
            "ExactSizeIterator"
            "Option"
            "Some"
            "None"
            "Result"
            "Ok"
            "Err"
            "String"
            "ToString"
            "TryFrom"
            "TryInto"
            "Vec"
            "FromIterator"
        ]

// Pre-interned symbols that can be referred to with `rustc_span::sym::*`.
//
// The symbol is the stringified identifier unless otherwise specified, in
// which case the name should mention the non-identifier punctuation.
// E.g. `sym::proc_dash_macro` represents "proc-macro", and it shouldn't be
// called `sym::proc_macro` because then it's easy to mistakenly think it
// represents "proc_macro".
//
// As well as the symbols listed, there are symbols for the strings
// "0", "1", ..., "9", which are accessible via `sym::integer`.
//
// The proc macro will abort if symbols are not in alphabetical order (as
// defined by `impl Ord for str`) or if any symbols are duplicated. Vim
// users can sort the list by selecting it and executing the command
// `:'<,'>!LC_ALL=C sort`.
//
// There is currently no checking that all symbols are used; that would be
// nice to have.
module sym =
    let Alignment = "Alignment"
    let Arc = "Arc"
    let Argument = "Argument"
    let ArgumentV1 = "ArgumentV1"
    let Arguments = "Arguments"
    let BTreeMap = "BTreeMap"
    let BTreeSet = "BTreeSet"
    let BinaryHeap = "BinaryHeap"
    let Borrow = "Borrow"
    let C = "C"
    let CString = "CString"
    let Center = "Center"
    let Clone = "Clone"
    let Copy = "Copy"
    let Count = "Count"
    let Debug = "Debug"
    let DebugStruct = "DebugStruct"
    let DebugTuple = "DebugTuple"
    let Decodable = "Decodable"
    let Decoder = "Decoder"
    let Default = "Default"
    let Deref = "Deref"
    let Encodable = "Encodable"
    let Encoder = "Encoder"
    let Eq = "Eq"
    let Equal = "Equal"
    let Err = "Err"
    let Error = "Error"
    let FormatSpec = "FormatSpec"
    let Formatter = "Formatter"
    let From = "From"
    let Future = "Future"
    let FxHashMap = "FxHashMap"
    let FxHashSet = "FxHashSet"
    let GlobalAlloc = "GlobalAlloc"
    let Hash = "Hash"
    let HashMap = "HashMap"
    let HashSet = "HashSet"
    let Hasher = "Hasher"
    let Implied = "Implied"
    let Input = "Input"
    let IntoIterator = "IntoIterator"
    let Is = "Is"
    let ItemContext = "ItemContext"
    let Iterator = "Iterator"
    let Layout = "Layout"
    let Left = "Left"
    let LinkedList = "LinkedList"
    let LintPass = "LintPass"
    let None = "None"
    let Ok = "Ok"
    let Option = "Option"
    let Ord = "Ord"
    let Ordering = "Ordering"
    let OsStr = "OsStr"
    let OsString = "OsString"
    let Output = "Output"
    let Param = "Param"
    let PartialEq = "PartialEq"
    let PartialOrd = "PartialOrd"
    let Path = "Path"
    let PathBuf = "PathBuf"
    let Pending = "Pending"
    let Pin = "Pin"
    let Poll = "Poll"
    let ProcMacro = "ProcMacro"
    let ProcMacroHack = "ProcMacroHack"
    let ProceduralMasqueradeDummyType = "ProceduralMasqueradeDummyType"
    let Range = "Range"
    let RangeFrom = "RangeFrom"
    let RangeFull = "RangeFull"
    let RangeInclusive = "RangeInclusive"
    let RangeTo = "RangeTo"
    let RangeToInclusive = "RangeToInclusive"
    let Rc = "Rc"
    let Ready = "Ready"
    let Receiver = "Receiver"
    let Result = "Result"
    let Return = "Return"
    let Right = "Right"
    let RustcDecodable = "RustcDecodable"
    let RustcEncodable = "RustcEncodable"
    let Send = "Send"
    let Some = "Some"
    let StructuralEq = "StructuralEq"
    let StructuralPartialEq = "StructuralPartialEq"
    let Sync = "Sync"
    let Target = "Target"
    let ToOwned = "ToOwned"
    let ToString = "ToString"
    let Try = "Try"
    let Ty = "Ty"
    let TyCtxt = "TyCtxt"
    let TyKind = "TyKind"
    let Unknown = "Unknown"
    let Vec = "Vec"
    let Yield = "Yield"
    let _DECLS = "_DECLS"
    let _Self = "_Self"
    let __D = "__D"
    let __H = "__H"
    let __S = "__S"
    let __next = "__next"
    let __try_var = "__try_var"
    let _d = "_d"
    let _e = "_e"
    let _task_context = "_task_context"
    let a32 = "a32"
    let aarch64_target_feature = "aarch64_target_feature"
    let abi = "abi"
    let abi_amdgpu_kernel = "abi_amdgpu_kernel"
    let abi_avr_interrupt = "abi_avr_interrupt"
    let abi_c_cmse_nonsecure_call = "abi_c_cmse_nonsecure_call"
    let abi_efiapi = "abi_efiapi"
    let abi_msp430_interrupt = "abi_msp430_interrupt"
    let abi_ptx = "abi_ptx"
    let abi_sysv64 = "abi_sysv64"
    let abi_thiscall = "abi_thiscall"
    let abi_unadjusted = "abi_unadjusted"
    let abi_vectorcall = "abi_vectorcall"
    let abi_x86_interrupt = "abi_x86_interrupt"
    let abort = "abort"
    let aborts = "aborts"
    let add = "add"
    let add_assign = "add_assign"
    let add_with_overflow = "add_with_overflow"
    let address = "address"
    let advanced_slice_patterns = "advanced_slice_patterns"
    let adx_target_feature = "adx_target_feature"
    let alias = "alias"
    let align = "align"
    let align_offset = "align_offset"
    let alignstack = "alignstack"
    let all = "all"
    let alloc = "alloc"
    let alloc_error_handler = "alloc_error_handler"
    let alloc_layout = "alloc_layout"
    let alloc_zeroed = "alloc_zeroed"
    let allocator = "allocator"
    let allocator_internals = "allocator_internals"
    let allow = "allow"
    let allow_fail = "allow_fail"
    let allow_internal_unsafe = "allow_internal_unsafe"
    let allow_internal_unstable = "allow_internal_unstable"
    let allowed = "allowed"
    let always = "always"
    let ``and`` = "and"
    let and_then = "and_then"
    let any = "any"
    let arbitrary_enum_discriminant = "arbitrary_enum_discriminant"
    let arbitrary_self_types = "arbitrary_self_types"
    let arith_offset = "arith_offset"
    let arm = "arm"
    let arm_target_feature = "arm_target_feature"
    let array = "array"
    let arrays = "arrays"
    let as_ptr = "as_ptr"
    let as_str = "as_str"
    let asm = "asm"
    let ``assert`` = "assert"
    let assert_inhabited = "assert_inhabited"
    let assert_macro = "assert_macro"
    let assert_receiver_is_total_eq = "assert_receiver_is_total_eq"
    let assert_uninit_valid = "assert_uninit_valid"
    let assert_zero_valid = "assert_zero_valid"
    let associated_consts = "associated_consts"
    let associated_type_bounds = "associated_type_bounds"
    let associated_type_defaults = "associated_type_defaults"
    let associated_types = "associated_types"
    let assume = "assume"
    let assume_init = "assume_init"
    let async_await = "async_await"
    let async_closure = "async_closure"
    let atomics = "atomics"
    let att_syntax = "att_syntax"
    let attr = "attr"
    let attr_literals = "attr_literals"
    let attributes = "attributes"
    let augmented_assignments = "augmented_assignments"
    let auto_traits = "auto_traits"
    let automatically_derived = "automatically_derived"
    let avx512_target_feature = "avx512_target_feature"
    let await_macro = "await_macro"
    let bang = "bang"
    let begin_panic = "begin_panic"
    let bench = "bench"
    let bin = "bin"
    let bind_by_move_pattern_guards = "bind_by_move_pattern_guards"
    let bindings_after_at = "bindings_after_at"
    let bitand = "bitand"
    let bitand_assign = "bitand_assign"
    let bitor = "bitor"
    let bitor_assign = "bitor_assign"
    let bitreverse = "bitreverse"
    let bitxor = "bitxor"
    let bitxor_assign = "bitxor_assign"
    let block = "block"
    let bool = "bool"
    let borrowck_graphviz_format = "borrowck_graphviz_format"
    let borrowck_graphviz_postflow = "borrowck_graphviz_postflow"
    let borrowck_graphviz_preflow = "borrowck_graphviz_preflow"
    let box_free = "box_free"
    let box_patterns = "box_patterns"
    let box_syntax = "box_syntax"
    let braced_empty_structs = "braced_empty_structs"
    let breakpoint = "breakpoint"
    let bridge = "bridge"
    let bswap = "bswap"
    let c_str = "c_str"
    let c_unwind = "c_unwind"
    let c_variadic = "c_variadic"
    let call = "call"
    let call_mut = "call_mut"
    let call_once = "call_once"
    let caller_location = "caller_location"
    let capture_disjoint_fields = "capture_disjoint_fields"
    let cdylib = "cdylib"
    let ceilf32 = "ceilf32"
    let ceilf64 = "ceilf64"
    let cfg = "cfg"
    let cfg_accessible = "cfg_accessible"
    let cfg_attr = "cfg_attr"
    let cfg_attr_multi = "cfg_attr_multi"
    let cfg_doctest = "cfg_doctest"
    let cfg_eval = "cfg_eval"
    let cfg_panic = "cfg_panic"
    let cfg_sanitize = "cfg_sanitize"
    let cfg_target_feature = "cfg_target_feature"
    let cfg_target_has_atomic = "cfg_target_has_atomic"
    let cfg_target_thread_local = "cfg_target_thread_local"
    let cfg_target_vendor = "cfg_target_vendor"
    let cfg_version = "cfg_version"
    let char = "char"
    let client = "client"
    let clippy = "clippy"
    let clone = "clone"
    let clone_closures = "clone_closures"
    let clone_from = "clone_from"
    let closure = "closure"
    let closure_to_fn_coercion = "closure_to_fn_coercion"
    let cmp = "cmp"
    let cmpxchg16b_target_feature = "cmpxchg16b_target_feature"
    let cmse_nonsecure_entry = "cmse_nonsecure_entry"
    let coerce_unsized = "coerce_unsized"
    let cold = "cold"
    let column = "column"
    let compile_error = "compile_error"
    let compiler_builtins = "compiler_builtins"
    let concat = "concat"
    let concat_idents = "concat_idents"
    let conservative_impl_trait = "conservative_impl_trait"
    let console = "console"
    let const_allocate = "const_allocate"
    let const_compare_raw_pointers = "const_compare_raw_pointers"
    let const_constructor = "const_constructor"
    let const_eval_limit = "const_eval_limit"
    let const_evaluatable_checked = "const_evaluatable_checked"
    let const_extern_fn = "const_extern_fn"
    let const_fn = "const_fn"

    let const_fn_floating_point_arithmetic = "const_fn_floating_point_arithmetic"

    let const_fn_fn_ptr_basics = "const_fn_fn_ptr_basics"
    let const_fn_transmute = "const_fn_transmute"
    let const_fn_union = "const_fn_union"
    let const_generic_defaults = "const_generic_defaults"
    let const_generics = "const_generics"
    let const_generics_defaults = "const_generics_defaults"
    let const_if_match = "const_if_match"
    let const_impl_trait = "const_impl_trait"
    let const_in_array_repeat_expressions = "const_in_array_repeat_expressions"
    let const_indexing = "const_indexing"
    let const_let = "const_let"
    let const_loop = "const_loop"
    let const_mut_refs = "const_mut_refs"
    let const_panic = "const_panic"
    let const_precise_live_drops = "const_precise_live_drops"
    let const_ptr = "const_ptr"
    let const_raw_ptr_deref = "const_raw_ptr_deref"
    let const_raw_ptr_to_usize_cast = "const_raw_ptr_to_usize_cast"
    let const_refs_to_cell = "const_refs_to_cell"
    let const_slice_ptr = "const_slice_ptr"
    let const_trait_bound_opt_out = "const_trait_bound_opt_out"
    let const_trait_impl = "const_trait_impl"
    let const_transmute = "const_transmute"
    let constant = "constant"
    let constructor = "constructor"
    let contents = "contents"
    let context = "context"
    let convert = "convert"
    let copy = "copy"
    let copy_closures = "copy_closures"
    let copy_nonoverlapping = "copy_nonoverlapping"
    let copysignf32 = "copysignf32"
    let copysignf64 = "copysignf64"
    let core = "core"
    let core_intrinsics = "core_intrinsics"
    let core_panic = "core_panic"
    let core_panic_2015_macro = "core_panic_2015_macro"
    let core_panic_macro = "core_panic_macro"
    let cosf32 = "cosf32"
    let cosf64 = "cosf64"
    let crate_id = "crate_id"
    let crate_in_paths = "crate_in_paths"
    let crate_local = "crate_local"
    let crate_name = "crate_name"
    let crate_type = "crate_type"
    let crate_visibility_modifier = "crate_visibility_modifier"
    let crt_dash_static = "crt-static"
    let cstring_type = "cstring_type"
    let ctlz = "ctlz"
    let ctlz_nonzero = "ctlz_nonzero"
    let ctpop = "ctpop"
    let cttz = "cttz"
    let cttz_nonzero = "cttz_nonzero"
    let custom_attribute = "custom_attribute"
    let custom_derive = "custom_derive"
    let custom_inner_attributes = "custom_inner_attributes"
    let custom_test_frameworks = "custom_test_frameworks"
    let d = "d"
    let dead_code = "dead_code"
    let dealloc = "dealloc"
    let debug = "debug"
    let debug_assert_macro = "debug_assert_macro"
    let debug_assertions = "debug_assertions"
    let debug_struct = "debug_struct"
    let debug_trait = "debug_trait"
    let debug_trait_builder = "debug_trait_builder"
    let debug_tuple = "debug_tuple"
    let decl_macro = "decl_macro"
    let declare_lint_pass = "declare_lint_pass"
    let decode = "decode"
    let default_alloc_error_handler = "default_alloc_error_handler"
    let default_lib_allocator = "default_lib_allocator"
    let default_type_parameter_fallback = "default_type_parameter_fallback"
    let default_type_params = "default_type_params"
    let delay_span_bug_from_inside_query = "delay_span_bug_from_inside_query"
    let deny = "deny"
    let deprecated = "deprecated"
    let deref = "deref"
    let deref_method = "deref_method"
    let deref_mut = "deref_mut"
    let deref_target = "deref_target"
    let derive = "derive"
    let destructuring_assignment = "destructuring_assignment"
    let diagnostic = "diagnostic"
    let direct = "direct"
    let discriminant_kind = "discriminant_kind"
    let discriminant_type = "discriminant_type"
    let discriminant_value = "discriminant_value"
    let dispatch_from_dyn = "dispatch_from_dyn"
    let div = "div"
    let div_assign = "div_assign"
    let doc = "doc"
    let doc_alias = "doc_alias"
    let doc_cfg = "doc_cfg"
    let doc_keyword = "doc_keyword"
    let doc_masked = "doc_masked"
    let doc_notable_trait = "doc_notable_trait"
    let doc_spotlight = "doc_spotlight"
    let doctest = "doctest"
    let document_private_items = "document_private_items"
    let dotdot_in_tuple_patterns = "dotdot_in_tuple_patterns"
    let dotdoteq_in_patterns = "dotdoteq_in_patterns"
    let dreg = "dreg"
    let dreg_low16 = "dreg_low16"
    let dreg_low8 = "dreg_low8"
    let drop = "drop"
    let drop_in_place = "drop_in_place"
    let drop_types_in_const = "drop_types_in_const"
    let dropck_eyepatch = "dropck_eyepatch"
    let dropck_parametricity = "dropck_parametricity"
    let dylib = "dylib"
    let dyn_metadata = "dyn_metadata"
    let dyn_trait = "dyn_trait"
    let edition_macro_pats = "edition_macro_pats"
    let eh_catch_typeinfo = "eh_catch_typeinfo"
    let eh_personality = "eh_personality"
    let emit_enum = "emit_enum"
    let emit_enum_variant = "emit_enum_variant"
    let emit_enum_variant_arg = "emit_enum_variant_arg"
    let emit_struct = "emit_struct"
    let emit_struct_field = "emit_struct_field"
    let enable = "enable"
    let enclosing_scope = "enclosing_scope"
    let encode = "encode"
    let env = "env"
    let eq = "eq"
    let ermsb_target_feature = "ermsb_target_feature"
    let err = "err"
    let exact_div = "exact_div"
    let except = "except"
    let exchange_malloc = "exchange_malloc"
    let exclusive_range_pattern = "exclusive_range_pattern"
    let exhaustive_integer_patterns = "exhaustive_integer_patterns"
    let exhaustive_patterns = "exhaustive_patterns"
    let existential_type = "existential_type"
    let exp2f32 = "exp2f32"
    let exp2f64 = "exp2f64"
    let expect = "expect"
    let expected = "expected"
    let expf32 = "expf32"
    let expf64 = "expf64"
    let export_name = "export_name"
    let expr = "expr"
    let extended_key_value_attributes = "extended_key_value_attributes"
    let extern_absolute_paths = "extern_absolute_paths"
    let extern_crate_item_prelude = "extern_crate_item_prelude"
    let extern_crate_self = "extern_crate_self"
    let extern_in_paths = "extern_in_paths"
    let extern_prelude = "extern_prelude"
    let extern_types = "extern_types"
    let external_doc = "external_doc"
    let f = "f"
    let f16c_target_feature = "f16c_target_feature"
    let f32 = "f32"
    let f32_runtime = "f32_runtime"
    let f64 = "f64"
    let f64_runtime = "f64_runtime"
    let fabsf32 = "fabsf32"
    let fabsf64 = "fabsf64"
    let fadd_fast = "fadd_fast"
    let fdiv_fast = "fdiv_fast"
    let feature = "feature"
    let ffi = "ffi"
    let ffi_const = "ffi_const"
    let ffi_pure = "ffi_pure"
    let ffi_returns_twice = "ffi_returns_twice"
    let field = "field"
    let field_init_shorthand = "field_init_shorthand"
    let file = "file"
    let fill = "fill"
    let finish = "finish"
    let flags = "flags"
    let float_to_int_unchecked = "float_to_int_unchecked"
    let floorf32 = "floorf32"
    let floorf64 = "floorf64"
    let fmaf32 = "fmaf32"
    let fmaf64 = "fmaf64"
    let fmt = "fmt"
    let fmt_internals = "fmt_internals"
    let fmul_fast = "fmul_fast"
    let fn_align = "fn_align"
    let fn_must_use = "fn_must_use"
    let fn_mut = "fn_mut"
    let fn_once = "fn_once"
    let fn_once_output = "fn_once_output"
    let forbid = "forbid"
    let forget = "forget"
    let format = "format"
    let format_args = "format_args"
    let format_args_capture = "format_args_capture"
    let format_args_nl = "format_args_nl"
    let format_macro = "format_macro"
    let freeze = "freeze"
    let freg = "freg"
    let frem_fast = "frem_fast"
    let from = "from"
    let from_desugaring = "from_desugaring"
    let from_error = "from_error"
    let from_generator = "from_generator"
    let from_method = "from_method"
    let from_ok = "from_ok"
    let from_size_align_unchecked = "from_size_align_unchecked"
    let from_trait = "from_trait"
    let from_usize = "from_usize"
    let fsub_fast = "fsub_fast"
    let fundamental = "fundamental"
    let future = "future"
    let future_trait = "future_trait"
    let ge = "ge"
    let gen_future = "gen_future"
    let gen_kill = "gen_kill"
    let generator = "generator"
    let generator_state = "generator_state"
    let generators = "generators"
    let generic_associated_types = "generic_associated_types"
    let generic_param_attrs = "generic_param_attrs"
    let get_context_ = "get_context"
    let global_allocator = "global_allocator"
    let global_asm = "global_asm"
    let globs = "globs"
    let gt = "gt"
    let half_open_range_patterns = "half_open_range_patterns"
    let hash = "hash"
    let hashmap_type = "hashmap_type"
    let hashset_type = "hashset_type"
    let hexagon_target_feature = "hexagon_target_feature"
    let hidden = "hidden"
    let homogeneous_aggregate = "homogeneous_aggregate"
    let html_favicon_url = "html_favicon_url"
    let html_logo_url = "html_logo_url"
    let html_no_source = "html_no_source"
    let html_playground_url = "html_playground_url"
    let html_root_url = "html_root_url"
    let hwaddress = "hwaddress"
    let i = "i"
    let i128 = "i128"
    let i128_type = "i128_type"
    let i16 = "i16"
    let i32 = "i32"
    let i64 = "i64"
    let i8 = "i8"
    let ident = "ident"
    let if_let = "if_let"
    let if_let_guard = "if_let_guard"
    let if_while_or_patterns = "if_while_or_patterns"
    let ignore = "ignore"
    let impl_header_lifetime_elision = "impl_header_lifetime_elision"
    let impl_lint_pass = "impl_lint_pass"
    let impl_macros = "impl_macros"
    let impl_trait_in_bindings = "impl_trait_in_bindings"
    let import_shadowing = "import_shadowing"
    let in_band_lifetimes = "in_band_lifetimes"
    let ``include`` = "include"
    let include_bytes = "include_bytes"
    let include_str = "include_str"
    let inclusive_range_syntax = "inclusive_range_syntax"
    let index = "index"
    let index_mut = "index_mut"
    let infer_outlives_requirements = "infer_outlives_requirements"

    let infer_static_outlives_requirements = "infer_static_outlives_requirements"

    let inherent_associated_types = "inherent_associated_types"
    let inlateout = "inlateout"
    let ``inline`` = "inline"
    let inline_const = "inline_const"
    let inout = "inout"
    let instruction_set = "instruction_set"
    let intel = "intel"
    let into_iter = "into_iter"
    let into_result = "into_result"
    let into_trait = "into_trait"
    let intra_doc_pointers = "intra_doc_pointers"
    let intrinsics = "intrinsics"
    let irrefutable_let_patterns = "irrefutable_let_patterns"
    let isa_attribute = "isa_attribute"
    let isize = "isize"
    let issue = "issue"
    let issue_5723_bootstrap = "issue_5723_bootstrap"
    let issue_tracker_base_url = "issue_tracker_base_url"
    let item = "item"
    let item_like_imports = "item_like_imports"
    let iter = "iter"
    let keyword = "keyword"
    let kind = "kind"
    let kreg = "kreg"
    let label = "label"
    let label_break_value = "label_break_value"
    let lang = "lang"
    let lang_items = "lang_items"
    let lateout = "lateout"
    let lazy_normalization_consts = "lazy_normalization_consts"
    let le = "le"
    let let_chains = "let_chains"
    let lhs = "lhs"
    let lib = "lib"
    let libc = "libc"
    let lifetime = "lifetime"
    let likely = "likely"
    let line = "line"
    let link = "link"
    let link_args = "link_args"
    let link_cfg = "link_cfg"
    let link_llvm_intrinsics = "link_llvm_intrinsics"
    let link_name = "link_name"
    let link_ordinal = "link_ordinal"
    let link_section = "link_section"
    let linkage = "linkage"
    let lint_reasons = "lint_reasons"
    let literal = "literal"
    let llvm_asm = "llvm_asm"
    let local = "local"
    let local_inner_macros = "local_inner_macros"
    let log10f32 = "log10f32"
    let log10f64 = "log10f64"
    let log2f32 = "log2f32"
    let log2f64 = "log2f64"
    let log_syntax = "log_syntax"
    let logf32 = "logf32"
    let logf64 = "logf64"
    let loop_break_value = "loop_break_value"
    let lt = "lt"
    let macro_at_most_once_rep = "macro_at_most_once_rep"
    let macro_attributes_in_derive_output = "macro_attributes_in_derive_output"
    let macro_escape = "macro_escape"
    let macro_export = "macro_export"
    let macro_lifetime_matcher = "macro_lifetime_matcher"
    let macro_literal_matcher = "macro_literal_matcher"
    let macro_reexport = "macro_reexport"
    let macro_use = "macro_use"
    let macro_vis_matcher = "macro_vis_matcher"
    let macros_in_extern = "macros_in_extern"
    let main = "main"
    let managed_boxes = "managed_boxes"
    let manually_drop = "manually_drop"
    let map = "map"
    let marker = "marker"
    let marker_trait_attr = "marker_trait_attr"
    let masked = "masked"
    let match_beginning_vert = "match_beginning_vert"
    let match_default_bindings = "match_default_bindings"
    let maxnumf32 = "maxnumf32"
    let maxnumf64 = "maxnumf64"
    let may_dangle = "may_dangle"
    let maybe_uninit = "maybe_uninit"
    let maybe_uninit_uninit = "maybe_uninit_uninit"
    let maybe_uninit_zeroed = "maybe_uninit_zeroed"
    let mem_uninitialized = "mem_uninitialized"
    let mem_zeroed = "mem_zeroed"
    let member_constraints = "member_constraints"
    let memory = "memory"
    let message = "message"
    let meta = "meta"
    let metadata_type = "metadata_type"
    let min_align_of = "min_align_of"
    let min_align_of_val = "min_align_of_val"
    let min_const_fn = "min_const_fn"
    let min_const_generics = "min_const_generics"
    let min_const_unsafe_fn = "min_const_unsafe_fn"
    let min_specialization = "min_specialization"
    let min_type_alias_impl_trait = "min_type_alias_impl_trait"
    let minnumf32 = "minnumf32"
    let minnumf64 = "minnumf64"
    let mips_target_feature = "mips_target_feature"
    let misc = "misc"
    let ``module`` = "module"
    let module_path = "module_path"
    let more_struct_aliases = "more_struct_aliases"
    let movbe_target_feature = "movbe_target_feature"
    let move_ref_pattern = "move_ref_pattern"
    let mul = "mul"
    let mul_assign = "mul_assign"
    let mul_with_overflow = "mul_with_overflow"
    let must_use = "must_use"
    let mut_ptr = "mut_ptr"
    let mut_slice_ptr = "mut_slice_ptr"
    let naked = "naked"
    let naked_functions = "naked_functions"
    let name = "name"
    let ne = "ne"
    let nearbyintf32 = "nearbyintf32"
    let nearbyintf64 = "nearbyintf64"
    let needs_allocator = "needs_allocator"
    let needs_drop = "needs_drop"
    let needs_panic_runtime = "needs_panic_runtime"
    let neg = "neg"
    let negate_unsigned = "negate_unsigned"
    let negative_impls = "negative_impls"
    let never = "never"
    let never_type = "never_type"
    let never_type_fallback = "never_type_fallback"
    let ``new`` = "new"
    let new_unchecked = "new_unchecked"
    let next = "next"
    let nll = "nll"
    let no = "no"
    let no_builtins = "no_builtins"
    let no_core = "no_core"
    let no_crate_inject = "no_crate_inject"
    let no_debug = "no_debug"
    let no_default_passes = "no_default_passes"
    let no_implicit_prelude = "no_implicit_prelude"
    let no_inline = "no_inline"
    let no_link = "no_link"
    let no_main = "no_main"
    let no_mangle = "no_mangle"
    let no_niche = "no_niche"
    let no_sanitize = "no_sanitize"
    let no_stack_check = "no_stack_check"
    let no_start = "no_start"
    let no_std = "no_std"
    let nomem = "nomem"
    let non_ascii_idents = "non_ascii_idents"
    let non_exhaustive = "non_exhaustive"
    let non_modrs_mods = "non_modrs_mods"
    let none_error = "none_error"
    let nontemporal_store = "nontemporal_store"
    let nontrapping_dash_fptoint = "nontrapping-fptoint"
    let noop_method_borrow = "noop_method_borrow"
    let noop_method_clone = "noop_method_clone"
    let noop_method_deref = "noop_method_deref"
    let noreturn = "noreturn"
    let nostack = "nostack"
    let not = "not"
    let notable_trait = "notable_trait"
    let note = "note"
    let object_safe_for_dispatch = "object_safe_for_dispatch"
    let ``of`` = "of"
    let offset = "offset"
    let omit_gdb_pretty_printer_section = "omit_gdb_pretty_printer_section"
    let on = "on"
    let on_unimplemented = "on_unimplemented"
    let oom = "oom"
    let opaque = "opaque"
    let ops = "ops"
    let opt_out_copy = "opt_out_copy"
    let optimize = "optimize"
    let optimize_attribute = "optimize_attribute"
    let optin_builtin_traits = "optin_builtin_traits"
    let option = "option"
    let option_env = "option_env"
    let option_type = "option_type"
    let options = "options"
    let ``or`` = "or"
    let or_patterns = "or_patterns"
    let other = "other"
    let out = "out"
    let overlapping_marker_traits = "overlapping_marker_traits"
    let owned_box = "owned_box"
    let packed = "packed"
    let panic = "panic"
    let panic_2015 = "panic_2015"
    let panic_2021 = "panic_2021"
    let panic_abort = "panic_abort"
    let panic_bounds_check = "panic_bounds_check"
    let panic_handler = "panic_handler"
    let panic_impl = "panic_impl"
    let panic_implementation = "panic_implementation"
    let panic_info = "panic_info"
    let panic_location = "panic_location"
    let panic_runtime = "panic_runtime"
    let panic_str = "panic_str"
    let panic_unwind = "panic_unwind"
    let panicking = "panicking"
    let param_attrs = "param_attrs"
    let parent_trait = "parent_trait"
    let partial_cmp = "partial_cmp"
    let partial_ord = "partial_ord"
    let passes = "passes"
    let pat = "pat"
    let pat_param = "pat_param"
    let path = "path"
    let pattern_parentheses = "pattern_parentheses"
    let phantom_data = "phantom_data"
    let pin = "pin"
    let pinned = "pinned"
    let platform_intrinsics = "platform_intrinsics"
    let plugin = "plugin"
    let plugin_registrar = "plugin_registrar"
    let plugins = "plugins"
    let pointee_trait = "pointee_trait"
    let pointer = "pointer"
    let pointer_trait = "pointer_trait"
    let pointer_trait_fmt = "pointer_trait_fmt"
    let poll = "poll"
    let position = "position"
    let post_dash_lto = "post-lto"
    let powerpc_target_feature = "powerpc_target_feature"
    let powf32 = "powf32"
    let powf64 = "powf64"
    let powif32 = "powif32"
    let powif64 = "powif64"
    let pre_dash_lto = "pre-lto"
    let precise_pointer_size_matching = "precise_pointer_size_matching"
    let precision = "precision"
    let pref_align_of = "pref_align_of"
    let prefetch_read_data = "prefetch_read_data"
    let prefetch_read_instruction = "prefetch_read_instruction"
    let prefetch_write_data = "prefetch_write_data"
    let prefetch_write_instruction = "prefetch_write_instruction"
    let prelude = "prelude"
    let prelude_import = "prelude_import"
    let preserves_flags = "preserves_flags"
    let primitive = "primitive"
    let proc_dash_macro = "proc-macro"
    let proc_macro = "proc_macro"
    let proc_macro_attribute = "proc_macro_attribute"
    let proc_macro_def_site = "proc_macro_def_site"
    let proc_macro_derive = "proc_macro_derive"
    let proc_macro_expr = "proc_macro_expr"
    let proc_macro_gen = "proc_macro_gen"
    let proc_macro_hygiene = "proc_macro_hygiene"
    let proc_macro_internals = "proc_macro_internals"
    let proc_macro_mod = "proc_macro_mod"
    let proc_macro_non_items = "proc_macro_non_items"
    let proc_macro_path_invoc = "proc_macro_path_invoc"
    let profiler_builtins = "profiler_builtins"
    let profiler_runtime = "profiler_runtime"
    let ptr_guaranteed_eq = "ptr_guaranteed_eq"
    let ptr_guaranteed_ne = "ptr_guaranteed_ne"
    let ptr_offset_from = "ptr_offset_from"
    let pub_macro_rules = "pub_macro_rules"
    let pub_restricted = "pub_restricted"
    let ``pure`` = "pure"
    let pushpop_unsafe = "pushpop_unsafe"
    let qreg = "qreg"
    let qreg_low4 = "qreg_low4"
    let qreg_low8 = "qreg_low8"
    let quad_precision_float = "quad_precision_float"
    let question_mark = "question_mark"
    let quote = "quote"
    let range_inclusive_new = "range_inclusive_new"
    let raw_dylib = "raw_dylib"
    let raw_identifiers = "raw_identifiers"
    let raw_ref_op = "raw_ref_op"
    let re_rebalance_coherence = "re_rebalance_coherence"
    let read_enum = "read_enum"
    let read_enum_variant = "read_enum_variant"
    let read_enum_variant_arg = "read_enum_variant_arg"
    let read_struct = "read_struct"
    let read_struct_field = "read_struct_field"
    let readonly = "readonly"
    let realloc = "realloc"
    let reason = "reason"
    let receiver = "receiver"
    let recursion_limit = "recursion_limit"
    let reexport_test_harness_main = "reexport_test_harness_main"
    let reference = "reference"
    let reflect = "reflect"
    let reg = "reg"
    let reg16 = "reg16"
    let reg32 = "reg32"
    let reg64 = "reg64"
    let reg_abcd = "reg_abcd"
    let reg_byte = "reg_byte"
    let reg_thumb = "reg_thumb"
    let register_attr = "register_attr"
    let register_tool = "register_tool"
    let relaxed_adts = "relaxed_adts"
    let relaxed_struct_unsize = "relaxed_struct_unsize"
    let rem = "rem"
    let rem_assign = "rem_assign"
    let repr = "repr"
    let repr128 = "repr128"
    let repr_align = "repr_align"
    let repr_align_enum = "repr_align_enum"
    let repr_no_niche = "repr_no_niche"
    let repr_packed = "repr_packed"
    let repr_simd = "repr_simd"
    let repr_transparent = "repr_transparent"
    let result = "result"
    let result_type = "result_type"
    let rhs = "rhs"
    let rintf32 = "rintf32"
    let rintf64 = "rintf64"
    let riscv_target_feature = "riscv_target_feature"
    let rlib = "rlib"
    let rotate_left = "rotate_left"
    let rotate_right = "rotate_right"
    let roundf32 = "roundf32"
    let roundf64 = "roundf64"
    let rt = "rt"
    let rtm_target_feature = "rtm_target_feature"
    let rust = "rust"
    let rust_2015 = "rust_2015"
    let rust_2015_preview = "rust_2015_preview"
    let rust_2018 = "rust_2018"
    let rust_2018_preview = "rust_2018_preview"
    let rust_2021 = "rust_2021"
    let rust_2021_preview = "rust_2021_preview"
    let rust_begin_unwind = "rust_begin_unwind"
    let rust_eh_catch_typeinfo = "rust_eh_catch_typeinfo"
    let rust_eh_personality = "rust_eh_personality"
    let rust_eh_register_frames = "rust_eh_register_frames"
    let rust_eh_unregister_frames = "rust_eh_unregister_frames"
    let rust_oom = "rust_oom"
    let rustc = "rustc"
    let rustc_allocator = "rustc_allocator"
    let rustc_allocator_nounwind = "rustc_allocator_nounwind"
    let rustc_allow_const_fn_unstable = "rustc_allow_const_fn_unstable"
    let rustc_args_required_const = "rustc_args_required_const"
    let rustc_attrs = "rustc_attrs"
    let rustc_builtin_macro = "rustc_builtin_macro"
    let rustc_capture_analysis = "rustc_capture_analysis"
    let rustc_clean = "rustc_clean"
    let rustc_const_stable = "rustc_const_stable"
    let rustc_const_unstable = "rustc_const_unstable"
    let rustc_conversion_suggestion = "rustc_conversion_suggestion"
    let rustc_def_path = "rustc_def_path"
    let rustc_deprecated = "rustc_deprecated"
    let rustc_diagnostic_item = "rustc_diagnostic_item"
    let rustc_diagnostic_macros = "rustc_diagnostic_macros"
    let rustc_dirty = "rustc_dirty"
    let rustc_dummy = "rustc_dummy"
    let rustc_dump_env_program_clauses = "rustc_dump_env_program_clauses"
    let rustc_dump_program_clauses = "rustc_dump_program_clauses"
    let rustc_dump_user_substs = "rustc_dump_user_substs"
    let rustc_error = "rustc_error"
    let rustc_expected_cgu_reuse = "rustc_expected_cgu_reuse"
    let rustc_if_this_changed = "rustc_if_this_changed"
    let rustc_inherit_overflow_checks = "rustc_inherit_overflow_checks"
    let rustc_layout = "rustc_layout"

    let rustc_layout_scalar_valid_range_end = "rustc_layout_scalar_valid_range_end"

    let rustc_layout_scalar_valid_range_start = "rustc_layout_scalar_valid_range_start"

    let rustc_legacy_const_generics = "rustc_legacy_const_generics"
    let rustc_macro_transparency = "rustc_macro_transparency"
    let rustc_mir = "rustc_mir"

    let rustc_nonnull_optimization_guaranteed = "rustc_nonnull_optimization_guaranteed"

    let rustc_object_lifetime_default = "rustc_object_lifetime_default"
    let rustc_on_unimplemented = "rustc_on_unimplemented"
    let rustc_outlives = "rustc_outlives"
    let rustc_paren_sugar = "rustc_paren_sugar"
    let rustc_partition_codegened = "rustc_partition_codegened"
    let rustc_partition_reused = "rustc_partition_reused"
    let rustc_peek = "rustc_peek"
    let rustc_peek_definite_init = "rustc_peek_definite_init"
    let rustc_peek_indirectly_mutable = "rustc_peek_indirectly_mutable"
    let rustc_peek_liveness = "rustc_peek_liveness"
    let rustc_peek_maybe_init = "rustc_peek_maybe_init"
    let rustc_peek_maybe_uninit = "rustc_peek_maybe_uninit"
    let rustc_polymorphize_error = "rustc_polymorphize_error"
    let rustc_private = "rustc_private"
    let rustc_proc_macro_decls = "rustc_proc_macro_decls"
    let rustc_promotable = "rustc_promotable"
    let rustc_regions = "rustc_regions"
    let rustc_reservation_impl = "rustc_reservation_impl"
    let rustc_serialize = "rustc_serialize"
    let rustc_specialization_trait = "rustc_specialization_trait"
    let rustc_stable = "rustc_stable"
    let rustc_std_internal_symbol = "rustc_std_internal_symbol"
    let rustc_symbol_name = "rustc_symbol_name"
    let rustc_synthetic = "rustc_synthetic"
    let rustc_test_marker = "rustc_test_marker"
    let rustc_then_this_would_need = "rustc_then_this_would_need"

    let rustc_unsafe_specialization_marker = "rustc_unsafe_specialization_marker"

    let rustc_variance = "rustc_variance"
    let rustdoc = "rustdoc"
    let rustfmt = "rustfmt"
    let rvalue_static_promotion = "rvalue_static_promotion"
    let sanitize = "sanitize"
    let sanitizer_runtime = "sanitizer_runtime"
    let saturating_add = "saturating_add"
    let saturating_sub = "saturating_sub"
    let self_in_typedefs = "self_in_typedefs"
    let self_struct_ctor = "self_struct_ctor"
    let semitransparent = "semitransparent"
    let send_trait = "send_trait"
    let shl = "shl"
    let shl_assign = "shl_assign"
    let should_panic = "should_panic"
    let shr = "shr"
    let shr_assign = "shr_assign"
    let simd = "simd"
    let simd_add = "simd_add"
    let simd_and = "simd_and"
    let simd_bitmask = "simd_bitmask"
    let simd_cast = "simd_cast"
    let simd_ceil = "simd_ceil"
    let simd_div = "simd_div"
    let simd_eq = "simd_eq"
    let simd_extract = "simd_extract"
    let simd_fabs = "simd_fabs"
    let simd_fcos = "simd_fcos"
    let simd_fexp = "simd_fexp"
    let simd_fexp2 = "simd_fexp2"
    let simd_ffi = "simd_ffi"
    let simd_flog = "simd_flog"
    let simd_flog10 = "simd_flog10"
    let simd_flog2 = "simd_flog2"
    let simd_floor = "simd_floor"
    let simd_fma = "simd_fma"
    let simd_fmax = "simd_fmax"
    let simd_fmin = "simd_fmin"
    let simd_fpow = "simd_fpow"
    let simd_fpowi = "simd_fpowi"
    let simd_fsin = "simd_fsin"
    let simd_fsqrt = "simd_fsqrt"
    let simd_gather = "simd_gather"
    let simd_ge = "simd_ge"
    let simd_gt = "simd_gt"
    let simd_insert = "simd_insert"
    let simd_le = "simd_le"
    let simd_lt = "simd_lt"
    let simd_mul = "simd_mul"
    let simd_ne = "simd_ne"
    let simd_neg = "simd_neg"
    let simd_or = "simd_or"
    let simd_reduce_add_ordered = "simd_reduce_add_ordered"
    let simd_reduce_add_unordered = "simd_reduce_add_unordered"
    let simd_reduce_all = "simd_reduce_all"
    let simd_reduce_and = "simd_reduce_and"
    let simd_reduce_any = "simd_reduce_any"
    let simd_reduce_max = "simd_reduce_max"
    let simd_reduce_max_nanless = "simd_reduce_max_nanless"
    let simd_reduce_min = "simd_reduce_min"
    let simd_reduce_min_nanless = "simd_reduce_min_nanless"
    let simd_reduce_mul_ordered = "simd_reduce_mul_ordered"
    let simd_reduce_mul_unordered = "simd_reduce_mul_unordered"
    let simd_reduce_or = "simd_reduce_or"
    let simd_reduce_xor = "simd_reduce_xor"
    let simd_rem = "simd_rem"
    let simd_saturating_add = "simd_saturating_add"
    let simd_saturating_sub = "simd_saturating_sub"
    let simd_scatter = "simd_scatter"
    let simd_select = "simd_select"
    let simd_select_bitmask = "simd_select_bitmask"
    let simd_shl = "simd_shl"
    let simd_shr = "simd_shr"
    let simd_sub = "simd_sub"
    let simd_xor = "simd_xor"
    let since = "since"
    let sinf32 = "sinf32"
    let sinf64 = "sinf64"
    let size = "size"
    let size_of = "size_of"
    let size_of_val = "size_of_val"
    let sized = "sized"
    let skip = "skip"
    let slice = "slice"
    let slice_alloc = "slice_alloc"
    let slice_patterns = "slice_patterns"
    let slice_u8 = "slice_u8"
    let slice_u8_alloc = "slice_u8_alloc"
    let slicing_syntax = "slicing_syntax"
    let soft = "soft"
    let specialization = "specialization"
    let speed = "speed"
    let spotlight = "spotlight"
    let sqrtf32 = "sqrtf32"
    let sqrtf64 = "sqrtf64"
    let sreg = "sreg"
    let sreg_low16 = "sreg_low16"
    let sse4a_target_feature = "sse4a_target_feature"
    let stable = "stable"
    let staged_api = "staged_api"
    let start = "start"
    let state = "state"
    let static_in_const = "static_in_const"
    let static_nobundle = "static_nobundle"
    let static_recursion = "static_recursion"
    let staticlib = "staticlib"
    let std = "std"
    let std_inject = "std_inject"
    let std_panic = "std_panic"
    let std_panic_2015_macro = "std_panic_2015_macro"
    let std_panic_macro = "std_panic_macro"
    let stmt = "stmt"
    let stmt_expr_attributes = "stmt_expr_attributes"
    let stop_after_dataflow = "stop_after_dataflow"
    let str = "str"
    let str_alloc = "str_alloc"
    let string_type = "string_type"
    let stringify = "stringify"
    let struct_field_attributes = "struct_field_attributes"
    let struct_inherit = "struct_inherit"
    let struct_variant = "struct_variant"
    let structural_match = "structural_match"
    let structural_peq = "structural_peq"
    let structural_teq = "structural_teq"
    let sty = "sty"
    let sub = "sub"
    let sub_assign = "sub_assign"
    let sub_with_overflow = "sub_with_overflow"
    let suggestion = "suggestion"
    let sym = "sym"
    let sync = "sync"
    let sync_trait = "sync_trait"
    let t32 = "t32"
    let target_arch = "target_arch"
    let target_endian = "target_endian"
    let target_env = "target_env"
    let target_family = "target_family"
    let target_feature = "target_feature"
    let target_feature_11 = "target_feature_11"
    let target_has_atomic = "target_has_atomic"
    let target_has_atomic_equal_alignment = "target_has_atomic_equal_alignment"
    let target_has_atomic_load_store = "target_has_atomic_load_store"
    let target_os = "target_os"
    let target_pointer_width = "target_pointer_width"
    let target_target_vendor = "target_target_vendor"
    let target_thread_local = "target_thread_local"
    let target_vendor = "target_vendor"
    let task = "task"
    let tbm_target_feature = "tbm_target_feature"
    let termination = "termination"
    let termination_trait = "termination_trait"
    let termination_trait_test = "termination_trait_test"
    let test = "test"
    let test_2018_feature = "test_2018_feature"
    let test_accepted_feature = "test_accepted_feature"
    let test_case = "test_case"
    let test_removed_feature = "test_removed_feature"
    let test_runner = "test_runner"
    let then_with = "then_with"
    let thread = "thread"
    let thread_local = "thread_local"
    let tool_attributes = "tool_attributes"
    let tool_lints = "tool_lints"
    let trace_macros = "trace_macros"
    let track_caller = "track_caller"
    let trait_alias = "trait_alias"
    let transmute = "transmute"
    let transparent = "transparent"
    let transparent_enums = "transparent_enums"
    let transparent_unions = "transparent_unions"
    let trivial_bounds = "trivial_bounds"
    let truncf32 = "truncf32"
    let truncf64 = "truncf64"
    let try_blocks = "try_blocks"
    let try_from_trait = "try_from_trait"
    let try_into_trait = "try_into_trait"
    let try_trait = "try_trait"
    let tt = "tt"
    let tuple = "tuple"
    let tuple_from_req = "tuple_from_req"
    let tuple_indexing = "tuple_indexing"
    let two_phase = "two_phase"
    let ty = "ty"
    let type_alias_enum_variants = "type_alias_enum_variants"
    let type_alias_impl_trait = "type_alias_impl_trait"
    let type_ascription = "type_ascription"
    let type_id = "type_id"
    let type_length_limit = "type_length_limit"
    let type_macros = "type_macros"
    let type_name = "type_name"
    let u128 = "u128"
    let u16 = "u16"
    let u32 = "u32"
    let u64 = "u64"
    let u8 = "u8"
    let unaligned_volatile_load = "unaligned_volatile_load"
    let unaligned_volatile_store = "unaligned_volatile_store"
    let unboxed_closures = "unboxed_closures"
    let unchecked_add = "unchecked_add"
    let unchecked_div = "unchecked_div"
    let unchecked_mul = "unchecked_mul"
    let unchecked_rem = "unchecked_rem"
    let unchecked_shl = "unchecked_shl"
    let unchecked_shr = "unchecked_shr"
    let unchecked_sub = "unchecked_sub"
    let underscore_const_names = "underscore_const_names"
    let underscore_imports = "underscore_imports"
    let underscore_lifetimes = "underscore_lifetimes"
    let uniform_paths = "uniform_paths"
    let unit = "unit"
    let universal_impl_trait = "universal_impl_trait"
    let unix = "unix"
    let unlikely = "unlikely"
    let unmarked_api = "unmarked_api"
    let unpin = "unpin"
    let unreachable = "unreachable"
    let unreachable_code = "unreachable_code"
    let unrestricted_attribute_tokens = "unrestricted_attribute_tokens"
    let unsafe_block_in_unsafe_fn = "unsafe_block_in_unsafe_fn"
    let unsafe_cell = "unsafe_cell"
    let unsafe_no_drop_flag = "unsafe_no_drop_flag"
    let unsize = "unsize"
    let unsized_fn_params = "unsized_fn_params"
    let unsized_locals = "unsized_locals"
    let unsized_tuple_coercion = "unsized_tuple_coercion"
    let unstable = "unstable"
    let untagged_unions = "untagged_unions"
    let unused_qualifications = "unused_qualifications"
    let unwind = "unwind"
    let unwind_attributes = "unwind_attributes"
    let unwrap = "unwrap"
    let unwrap_or = "unwrap_or"
    let use_extern_macros = "use_extern_macros"
    let use_nested_groups = "use_nested_groups"
    let used = "used"
    let usize = "usize"
    let v1 = "v1"
    let va_arg = "va_arg"
    let va_copy = "va_copy"
    let va_end = "va_end"
    let va_list = "va_list"
    let va_start = "va_start"
    let ``val`` = "val"
    let var = "var"
    let variant_count = "variant_count"
    let vec = "vec"
    let vec_type = "vec_type"
    let vecdeque_type = "vecdeque_type"
    let version = "version"
    let vis = "vis"
    let visible_private_types = "visible_private_types"
    let volatile = "volatile"
    let volatile_copy_memory = "volatile_copy_memory"

    let volatile_copy_nonoverlapping_memory = "volatile_copy_nonoverlapping_memory"

    let volatile_load = "volatile_load"
    let volatile_set_memory = "volatile_set_memory"
    let volatile_store = "volatile_store"
    let vreg = "vreg"
    let vreg_low16 = "vreg_low16"
    let warn = "warn"
    let wasm_abi = "wasm_abi"
    let wasm_import_module = "wasm_import_module"
    let wasm_target_feature = "wasm_target_feature"
    let while_let = "while_let"
    let width = "width"
    let windows = "windows"
    let windows_subsystem = "windows_subsystem"
    let wrapping_add = "wrapping_add"
    let wrapping_mul = "wrapping_mul"
    let wrapping_sub = "wrapping_sub"
    let write_bytes = "write_bytes"
    let xmm_reg = "xmm_reg"
    let ymm_reg = "ymm_reg"
    let zmm_reg = "zmm_reg"

(*

type Symbol with
    member self.is_special(): bool =
        self <= kw.Underscore

    member self.is_used_keyword_always(): bool =
        self >= kw.As && self <= kw.While

    member self.is_used_keyword_conditional(edition: impl FnOnce(): Edition): bool =
        (self >= kw.Async && self <= kw.Dyn) && edition() >= Edition.Edition2018

    member self.is_unused_keyword_always(): bool =
        self >= kw.Abstract && self <= kw.Yield

    member self.is_unused_keyword_conditional(edition: impl FnOnce(): Edition): bool =
        self = kw.Try && edition() >= Edition.Edition2018

    member self.is_reserved(edition: impl Copy + FnOnce(): Edition): bool =
        self.is_special()
            || self.is_used_keyword_always()
            || self.is_unused_keyword_always()
            || self.is_used_keyword_conditional(edition)
            || self.is_unused_keyword_conditional(edition)

    /// A keyword or reserved identifier that can be used as a path segment.
    member self.is_path_segment_keyword(): bool =
        self = kw.Super
            || self = kw.SelfLower
            || self = kw.SelfUpper
            || self = kw.Crate
            || self = kw.PathRoot
            || self = kw.DollarCrate

    /// Returns `true` if the symbol is `true` or `false`.
    member self.is_bool_lit(): bool =
        self = kw.True || self = kw.False

    /// Returns `true` if this symbol can be a raw identifier.
    member self.can_be_raw(): bool =
        self <> kw.Empty && self <> kw.Underscore && not(self.is_path_segment_keyword())


type Ident with
    // Returns `true` for reserved identifiers used internally for elided lifetimes,
    // unnamed method parameters, root module, error recovery etc.
    member self.is_special(): bool =
        self.name.is_special()

    /// Returns `true` if the token is a keyword used in the language.
    member self.is_used_keyword(): bool =
        // Note: `span.edition()` is relatively expensive, don't call it unless necessary.
        self.name.is_used_keyword_always()
            || self.name.is_used_keyword_conditional(fun () -> self.span.edition())

    /// Returns `true` if the token is a keyword reserved for possible future use.
    member self.is_unused_keyword(): bool =
        // Note: `span.edition()` is relatively expensive, don't call it unless necessary.
        self.name.is_unused_keyword_always()
            || self.name.is_unused_keyword_conditional(fun () -> self.span.edition())

    /// Returns `true` if the token is either a special identifier or a keyword.
    member self.is_reserved(): bool =
        // Note: `span.edition()` is relatively expensive, don't call it unless necessary.
        self.name.is_reserved(fun () -> self.span.edition())

    /// A keyword or reserved identifier that can be used as a path segment.
    member self.is_path_segment_keyword(): bool =
        self.name.is_path_segment_keyword()

    /// We see this identifier in a normal identifier position, like variable name or a type.
    /// How was it written originally? Did it use the raw form? Let's try to guess.
    member self.is_raw_guess(): bool =
        self.name.can_be_raw() && self.is_reserved()

*)
