// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package snowdevicemanagement

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelTask = "CancelTask"

// CancelTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelTask for more information on using the CancelTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelTaskRequest method.
//	req, resp := client.CancelTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CancelTask
func (c *SnowDeviceManagement) CancelTaskRequest(input *CancelTaskInput) (req *request.Request, output *CancelTaskOutput) {
	op := &request.Operation{
		Name:       opCancelTask,
		HTTPMethod: "POST",
		HTTPPath:   "/task/{taskId}/cancel",
	}

	if input == nil {
		input = &CancelTaskInput{}
	}

	output = &CancelTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelTask API operation for AWS Snow Device Management.
//
// Sends a cancel request for a specified task. You can cancel a task only if
// it's still in a QUEUED state. Tasks that are already running can't be cancelled.
//
// A task might still run if it's processed from the queue before the CancelTask
// operation changes the task's state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation CancelTask for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CancelTask
func (c *SnowDeviceManagement) CancelTask(input *CancelTaskInput) (*CancelTaskOutput, error) {
	req, out := c.CancelTaskRequest(input)
	return out, req.Send()
}

// CancelTaskWithContext is the same as CancelTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) CancelTaskWithContext(ctx aws.Context, input *CancelTaskInput, opts ...request.Option) (*CancelTaskOutput, error) {
	req, out := c.CancelTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTask = "CreateTask"

// CreateTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTask for more information on using the CreateTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTaskRequest method.
//	req, resp := client.CreateTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CreateTask
func (c *SnowDeviceManagement) CreateTaskRequest(input *CreateTaskInput) (req *request.Request, output *CreateTaskOutput) {
	op := &request.Operation{
		Name:       opCreateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/task",
	}

	if input == nil {
		input = &CreateTaskInput{}
	}

	output = &CreateTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTask API operation for AWS Snow Device Management.
//
// Instructs one or more devices to start a task, such as unlocking or rebooting.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation CreateTask for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CreateTask
func (c *SnowDeviceManagement) CreateTask(input *CreateTaskInput) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	return out, req.Send()
}

// CreateTaskWithContext is the same as CreateTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) CreateTaskWithContext(ctx aws.Context, input *CreateTaskInput, opts ...request.Option) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDevice = "DescribeDevice"

// DescribeDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDevice for more information on using the DescribeDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDeviceRequest method.
//	req, resp := client.DescribeDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDevice
func (c *SnowDeviceManagement) DescribeDeviceRequest(input *DescribeDeviceInput) (req *request.Request, output *DescribeDeviceOutput) {
	op := &request.Operation{
		Name:       opDescribeDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/managed-device/{managedDeviceId}/describe",
	}

	if input == nil {
		input = &DescribeDeviceInput{}
	}

	output = &DescribeDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDevice API operation for AWS Snow Device Management.
//
// Checks device-specific information, such as the device type, software version,
// IP addresses, and lock status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation DescribeDevice for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDevice
func (c *SnowDeviceManagement) DescribeDevice(input *DescribeDeviceInput) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	return out, req.Send()
}

// DescribeDeviceWithContext is the same as DescribeDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) DescribeDeviceWithContext(ctx aws.Context, input *DescribeDeviceInput, opts ...request.Option) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeviceEc2Instances = "DescribeDeviceEc2Instances"

// DescribeDeviceEc2InstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeviceEc2Instances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeviceEc2Instances for more information on using the DescribeDeviceEc2Instances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDeviceEc2InstancesRequest method.
//	req, resp := client.DescribeDeviceEc2InstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDeviceEc2Instances
func (c *SnowDeviceManagement) DescribeDeviceEc2InstancesRequest(input *DescribeDeviceEc2InstancesInput) (req *request.Request, output *DescribeDeviceEc2InstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeDeviceEc2Instances,
		HTTPMethod: "POST",
		HTTPPath:   "/managed-device/{managedDeviceId}/resources/ec2/describe",
	}

	if input == nil {
		input = &DescribeDeviceEc2InstancesInput{}
	}

	output = &DescribeDeviceEc2InstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeviceEc2Instances API operation for AWS Snow Device Management.
//
// Checks the current state of the Amazon EC2 instances. The output is similar
// to describeDevice, but the results are sourced from the device cache in the
// Amazon Web Services Cloud and include a subset of the available fields.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation DescribeDeviceEc2Instances for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDeviceEc2Instances
func (c *SnowDeviceManagement) DescribeDeviceEc2Instances(input *DescribeDeviceEc2InstancesInput) (*DescribeDeviceEc2InstancesOutput, error) {
	req, out := c.DescribeDeviceEc2InstancesRequest(input)
	return out, req.Send()
}

// DescribeDeviceEc2InstancesWithContext is the same as DescribeDeviceEc2Instances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeviceEc2Instances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) DescribeDeviceEc2InstancesWithContext(ctx aws.Context, input *DescribeDeviceEc2InstancesInput, opts ...request.Option) (*DescribeDeviceEc2InstancesOutput, error) {
	req, out := c.DescribeDeviceEc2InstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExecution = "DescribeExecution"

// DescribeExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExecution for more information on using the DescribeExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeExecutionRequest method.
//	req, resp := client.DescribeExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeExecution
func (c *SnowDeviceManagement) DescribeExecutionRequest(input *DescribeExecutionInput) (req *request.Request, output *DescribeExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/task/{taskId}/execution/{managedDeviceId}",
	}

	if input == nil {
		input = &DescribeExecutionInput{}
	}

	output = &DescribeExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExecution API operation for AWS Snow Device Management.
//
// Checks the status of a remote task running on one or more target devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation DescribeExecution for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeExecution
func (c *SnowDeviceManagement) DescribeExecution(input *DescribeExecutionInput) (*DescribeExecutionOutput, error) {
	req, out := c.DescribeExecutionRequest(input)
	return out, req.Send()
}

// DescribeExecutionWithContext is the same as DescribeExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) DescribeExecutionWithContext(ctx aws.Context, input *DescribeExecutionInput, opts ...request.Option) (*DescribeExecutionOutput, error) {
	req, out := c.DescribeExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTask = "DescribeTask"

// DescribeTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTask for more information on using the DescribeTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTaskRequest method.
//	req, resp := client.DescribeTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeTask
func (c *SnowDeviceManagement) DescribeTaskRequest(input *DescribeTaskInput) (req *request.Request, output *DescribeTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeTask,
		HTTPMethod: "POST",
		HTTPPath:   "/task/{taskId}",
	}

	if input == nil {
		input = &DescribeTaskInput{}
	}

	output = &DescribeTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTask API operation for AWS Snow Device Management.
//
// Checks the metadata for a given task on a device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation DescribeTask for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeTask
func (c *SnowDeviceManagement) DescribeTask(input *DescribeTaskInput) (*DescribeTaskOutput, error) {
	req, out := c.DescribeTaskRequest(input)
	return out, req.Send()
}

// DescribeTaskWithContext is the same as DescribeTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) DescribeTaskWithContext(ctx aws.Context, input *DescribeTaskInput, opts ...request.Option) (*DescribeTaskOutput, error) {
	req, out := c.DescribeTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeviceResources = "ListDeviceResources"

// ListDeviceResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceResources for more information on using the ListDeviceResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeviceResourcesRequest method.
//	req, resp := client.ListDeviceResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources
func (c *SnowDeviceManagement) ListDeviceResourcesRequest(input *ListDeviceResourcesInput) (req *request.Request, output *ListDeviceResourcesOutput) {
	op := &request.Operation{
		Name:       opListDeviceResources,
		HTTPMethod: "GET",
		HTTPPath:   "/managed-device/{managedDeviceId}/resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeviceResourcesInput{}
	}

	output = &ListDeviceResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceResources API operation for AWS Snow Device Management.
//
// Returns a list of the Amazon Web Services resources available for a device.
// Currently, Amazon EC2 instances are the only supported resource type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation ListDeviceResources for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources
func (c *SnowDeviceManagement) ListDeviceResources(input *ListDeviceResourcesInput) (*ListDeviceResourcesOutput, error) {
	req, out := c.ListDeviceResourcesRequest(input)
	return out, req.Send()
}

// ListDeviceResourcesWithContext is the same as ListDeviceResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListDeviceResourcesWithContext(ctx aws.Context, input *ListDeviceResourcesInput, opts ...request.Option) (*ListDeviceResourcesOutput, error) {
	req, out := c.ListDeviceResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeviceResourcesPages iterates over the pages of a ListDeviceResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeviceResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDeviceResources operation.
//	pageNum := 0
//	err := client.ListDeviceResourcesPages(params,
//	    func(page *snowdevicemanagement.ListDeviceResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SnowDeviceManagement) ListDeviceResourcesPages(input *ListDeviceResourcesInput, fn func(*ListDeviceResourcesOutput, bool) bool) error {
	return c.ListDeviceResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeviceResourcesPagesWithContext same as ListDeviceResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListDeviceResourcesPagesWithContext(ctx aws.Context, input *ListDeviceResourcesInput, fn func(*ListDeviceResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeviceResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeviceResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeviceResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDevicesRequest method.
//	req, resp := client.ListDevicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices
func (c *SnowDeviceManagement) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/managed-devices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for AWS Snow Device Management.
//
// Returns a list of all devices on your Amazon Web Services account that have
// Amazon Web Services Snow Device Management enabled in the Amazon Web Services
// Region where the command is run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation ListDevices for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices
func (c *SnowDeviceManagement) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicesPages iterates over the pages of a ListDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDevices operation.
//	pageNum := 0
//	err := client.ListDevicesPages(params,
//	    func(page *snowdevicemanagement.ListDevicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SnowDeviceManagement) ListDevicesPages(input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool) error {
	return c.ListDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicesPagesWithContext same as ListDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListDevicesPagesWithContext(ctx aws.Context, input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExecutions = "ListExecutions"

// ListExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExecutions for more information on using the ListExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExecutionsRequest method.
//	req, resp := client.ListExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions
func (c *SnowDeviceManagement) ListExecutionsRequest(input *ListExecutionsInput) (req *request.Request, output *ListExecutionsOutput) {
	op := &request.Operation{
		Name:       opListExecutions,
		HTTPMethod: "GET",
		HTTPPath:   "/executions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExecutionsInput{}
	}

	output = &ListExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExecutions API operation for AWS Snow Device Management.
//
// Returns the status of tasks for one or more target devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation ListExecutions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions
func (c *SnowDeviceManagement) ListExecutions(input *ListExecutionsInput) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	return out, req.Send()
}

// ListExecutionsWithContext is the same as ListExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListExecutionsWithContext(ctx aws.Context, input *ListExecutionsInput, opts ...request.Option) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExecutionsPages iterates over the pages of a ListExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExecutions operation.
//	pageNum := 0
//	err := client.ListExecutionsPages(params,
//	    func(page *snowdevicemanagement.ListExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SnowDeviceManagement) ListExecutionsPages(input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool) error {
	return c.ListExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExecutionsPagesWithContext same as ListExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListExecutionsPagesWithContext(ctx aws.Context, input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTagsForResource
func (c *SnowDeviceManagement) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Snow Device Management.
//
// Returns a list of tags for a managed device or task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTagsForResource
func (c *SnowDeviceManagement) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTasks = "ListTasks"

// ListTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTasks for more information on using the ListTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTasksRequest method.
//	req, resp := client.ListTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks
func (c *SnowDeviceManagement) ListTasksRequest(input *ListTasksInput) (req *request.Request, output *ListTasksOutput) {
	op := &request.Operation{
		Name:       opListTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/tasks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	output = &ListTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTasks API operation for AWS Snow Device Management.
//
// Returns a list of tasks that can be filtered by state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation ListTasks for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks
func (c *SnowDeviceManagement) ListTasks(input *ListTasksInput) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	return out, req.Send()
}

// ListTasksWithContext is the same as ListTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListTasksWithContext(ctx aws.Context, input *ListTasksInput, opts ...request.Option) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTasksPages iterates over the pages of a ListTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTasks operation.
//	pageNum := 0
//	err := client.ListTasksPages(params,
//	    func(page *snowdevicemanagement.ListTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SnowDeviceManagement) ListTasksPages(input *ListTasksInput, fn func(*ListTasksOutput, bool) bool) error {
	return c.ListTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTasksPagesWithContext same as ListTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) ListTasksPagesWithContext(ctx aws.Context, input *ListTasksInput, fn func(*ListTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/TagResource
func (c *SnowDeviceManagement) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Snow Device Management.
//
// Adds or replaces tags on a device or task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/TagResource
func (c *SnowDeviceManagement) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/UntagResource
func (c *SnowDeviceManagement) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Snow Device Management.
//
// Removes a tag from a device or task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Snow Device Management's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/UntagResource
func (c *SnowDeviceManagement) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SnowDeviceManagement) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelTaskInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the task that you are attempting to cancel. You can retrieve a
	// task ID by using the ListTasks operation.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *CancelTaskInput) SetTaskId(v string) *CancelTaskInput {
	s.TaskId = &v
	return s
}

type CancelTaskOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the task that you are attempting to cancel.
	TaskId *string `locationName:"taskId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTaskOutput) GoString() string {
	return s.String()
}

// SetTaskId sets the TaskId field's value.
func (s *CancelTaskOutput) SetTaskId(v string) *CancelTaskOutput {
	s.TaskId = &v
	return s
}

// The physical capacity of the Amazon Web Services Snow Family device.
type Capacity struct {
	_ struct{} `type:"structure"`

	// The amount of capacity available for use on the device.
	Available *int64 `locationName:"available" type:"long"`

	// The name of the type of capacity, such as memory.
	Name *string `locationName:"name" type:"string"`

	// The total capacity on the device.
	Total *int64 `locationName:"total" type:"long"`

	// The unit of measure for the type of capacity.
	Unit *string `locationName:"unit" type:"string"`

	// The amount of capacity used on the device.
	Used *int64 `locationName:"used" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Capacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Capacity) GoString() string {
	return s.String()
}

// SetAvailable sets the Available field's value.
func (s *Capacity) SetAvailable(v int64) *Capacity {
	s.Available = &v
	return s
}

// SetName sets the Name field's value.
func (s *Capacity) SetName(v string) *Capacity {
	s.Name = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *Capacity) SetTotal(v int64) *Capacity {
	s.Total = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Capacity) SetUnit(v string) *Capacity {
	s.Unit = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *Capacity) SetUsed(v int64) *Capacity {
	s.Used = &v
	return s
}

// The command given to the device to execute.
type Command struct {
	_ struct{} `type:"structure"`

	// Reboots the device.
	Reboot *Reboot `locationName:"reboot" type:"structure"`

	// Unlocks the device.
	Unlock *Unlock `locationName:"unlock" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Command) GoString() string {
	return s.String()
}

// SetReboot sets the Reboot field's value.
func (s *Command) SetReboot(v *Reboot) *Command {
	s.Reboot = v
	return s
}

// SetUnlock sets the Unlock field's value.
func (s *Command) SetUnlock(v *Unlock) *Command {
	s.Unlock = v
	return s
}

// The options for how a device's CPU is configured.
type CpuOptions struct {
	_ struct{} `type:"structure"`

	// The number of cores that the CPU can use.
	CoreCount *int64 `locationName:"coreCount" type:"integer"`

	// The number of threads per core in the CPU.
	ThreadsPerCore *int64 `locationName:"threadsPerCore" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CpuOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CpuOptions) GoString() string {
	return s.String()
}

// SetCoreCount sets the CoreCount field's value.
func (s *CpuOptions) SetCoreCount(v int64) *CpuOptions {
	s.CoreCount = &v
	return s
}

// SetThreadsPerCore sets the ThreadsPerCore field's value.
func (s *CpuOptions) SetThreadsPerCore(v int64) *CpuOptions {
	s.ThreadsPerCore = &v
	return s
}

type CreateTaskInput struct {
	_ struct{} `type:"structure"`

	// A token ensuring that the action is called only once with the specified details.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The task to be performed. Only one task is executed on a device at a time.
	//
	// Command is a required field
	Command *Command `locationName:"command" type:"structure" required:"true"`

	// A description of the task and its targets.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Optional metadata that you assign to a resource. You can use tags to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of managed device IDs.
	//
	// Targets is a required field
	Targets []*string `locationName:"targets" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTaskInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Command == nil {
		invalidParams.Add(request.NewErrParamRequired("Command"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTaskInput) SetClientToken(v string) *CreateTaskInput {
	s.ClientToken = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *CreateTaskInput) SetCommand(v *Command) *CreateTaskInput {
	s.Command = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTaskInput) SetDescription(v string) *CreateTaskInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTaskInput) SetTags(v map[string]*string) *CreateTaskInput {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateTaskInput) SetTargets(v []*string) *CreateTaskInput {
	s.Targets = v
	return s
}

type CreateTaskOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task that you created.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// The ID of the task that you created.
	TaskId *string `locationName:"taskId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskOutput) GoString() string {
	return s.String()
}

// SetTaskArn sets the TaskArn field's value.
func (s *CreateTaskOutput) SetTaskArn(v string) *CreateTaskOutput {
	s.TaskArn = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *CreateTaskOutput) SetTaskId(v string) *CreateTaskOutput {
	s.TaskId = &v
	return s
}

type DescribeDeviceEc2InstancesInput struct {
	_ struct{} `type:"structure"`

	// A list of instance IDs associated with the managed device.
	//
	// InstanceIds is a required field
	InstanceIds []*string `locationName:"instanceIds" type:"list" required:"true"`

	// The ID of the managed device.
	//
	// ManagedDeviceId is a required field
	ManagedDeviceId *string `location:"uri" locationName:"managedDeviceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceEc2InstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceEc2InstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeviceEc2InstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeviceEc2InstancesInput"}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}
	if s.ManagedDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedDeviceId"))
	}
	if s.ManagedDeviceId != nil && len(*s.ManagedDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DescribeDeviceEc2InstancesInput) SetInstanceIds(v []*string) *DescribeDeviceEc2InstancesInput {
	s.InstanceIds = v
	return s
}

// SetManagedDeviceId sets the ManagedDeviceId field's value.
func (s *DescribeDeviceEc2InstancesInput) SetManagedDeviceId(v string) *DescribeDeviceEc2InstancesInput {
	s.ManagedDeviceId = &v
	return s
}

type DescribeDeviceEc2InstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of structures containing information about each instance.
	Instances []*InstanceSummary `locationName:"instances" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceEc2InstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceEc2InstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeDeviceEc2InstancesOutput) SetInstances(v []*InstanceSummary) *DescribeDeviceEc2InstancesOutput {
	s.Instances = v
	return s
}

type DescribeDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the device that you are checking the information of.
	//
	// ManagedDeviceId is a required field
	ManagedDeviceId *string `location:"uri" locationName:"managedDeviceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeviceInput"}
	if s.ManagedDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedDeviceId"))
	}
	if s.ManagedDeviceId != nil && len(*s.ManagedDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedDeviceId sets the ManagedDeviceId field's value.
func (s *DescribeDeviceInput) SetManagedDeviceId(v string) *DescribeDeviceInput {
	s.ManagedDeviceId = &v
	return s
}

type DescribeDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the job used when ordering the device.
	AssociatedWithJob *string `locationName:"associatedWithJob" type:"string"`

	// The hardware specifications of the device.
	DeviceCapacities []*Capacity `locationName:"deviceCapacities" type:"list"`

	// The current state of the device.
	DeviceState *string `locationName:"deviceState" type:"string" enum:"UnlockState"`

	// The type of Amazon Web Services Snow Family device.
	DeviceType *string `locationName:"deviceType" type:"string"`

	// When the device last contacted the Amazon Web Services Cloud. Indicates that
	// the device is online.
	LastReachedOutAt *time.Time `locationName:"lastReachedOutAt" type:"timestamp"`

	// When the device last pushed an update to the Amazon Web Services Cloud. Indicates
	// when the device cache was refreshed.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the device.
	ManagedDeviceArn *string `locationName:"managedDeviceArn" type:"string"`

	// The ID of the device that you checked the information for.
	ManagedDeviceId *string `locationName:"managedDeviceId" min:"1" type:"string"`

	// The network interfaces available on the device.
	PhysicalNetworkInterfaces []*PhysicalNetworkInterface `locationName:"physicalNetworkInterfaces" type:"list"`

	// The software installed on the device.
	Software *SoftwareInformation `locationName:"software" type:"structure"`

	// Optional metadata that you assign to a resource. You can use tags to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceOutput) GoString() string {
	return s.String()
}

// SetAssociatedWithJob sets the AssociatedWithJob field's value.
func (s *DescribeDeviceOutput) SetAssociatedWithJob(v string) *DescribeDeviceOutput {
	s.AssociatedWithJob = &v
	return s
}

// SetDeviceCapacities sets the DeviceCapacities field's value.
func (s *DescribeDeviceOutput) SetDeviceCapacities(v []*Capacity) *DescribeDeviceOutput {
	s.DeviceCapacities = v
	return s
}

// SetDeviceState sets the DeviceState field's value.
func (s *DescribeDeviceOutput) SetDeviceState(v string) *DescribeDeviceOutput {
	s.DeviceState = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *DescribeDeviceOutput) SetDeviceType(v string) *DescribeDeviceOutput {
	s.DeviceType = &v
	return s
}

// SetLastReachedOutAt sets the LastReachedOutAt field's value.
func (s *DescribeDeviceOutput) SetLastReachedOutAt(v time.Time) *DescribeDeviceOutput {
	s.LastReachedOutAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeDeviceOutput) SetLastUpdatedAt(v time.Time) *DescribeDeviceOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetManagedDeviceArn sets the ManagedDeviceArn field's value.
func (s *DescribeDeviceOutput) SetManagedDeviceArn(v string) *DescribeDeviceOutput {
	s.ManagedDeviceArn = &v
	return s
}

// SetManagedDeviceId sets the ManagedDeviceId field's value.
func (s *DescribeDeviceOutput) SetManagedDeviceId(v string) *DescribeDeviceOutput {
	s.ManagedDeviceId = &v
	return s
}

// SetPhysicalNetworkInterfaces sets the PhysicalNetworkInterfaces field's value.
func (s *DescribeDeviceOutput) SetPhysicalNetworkInterfaces(v []*PhysicalNetworkInterface) *DescribeDeviceOutput {
	s.PhysicalNetworkInterfaces = v
	return s
}

// SetSoftware sets the Software field's value.
func (s *DescribeDeviceOutput) SetSoftware(v *SoftwareInformation) *DescribeDeviceOutput {
	s.Software = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeDeviceOutput) SetTags(v map[string]*string) *DescribeDeviceOutput {
	s.Tags = v
	return s
}

type DescribeExecutionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the managed device.
	//
	// ManagedDeviceId is a required field
	ManagedDeviceId *string `location:"uri" locationName:"managedDeviceId" min:"1" type:"string" required:"true"`

	// The ID of the task that the action is describing.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExecutionInput"}
	if s.ManagedDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedDeviceId"))
	}
	if s.ManagedDeviceId != nil && len(*s.ManagedDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedDeviceId", 1))
	}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedDeviceId sets the ManagedDeviceId field's value.
func (s *DescribeExecutionInput) SetManagedDeviceId(v string) *DescribeExecutionInput {
	s.ManagedDeviceId = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeExecutionInput) SetTaskId(v string) *DescribeExecutionInput {
	s.TaskId = &v
	return s
}

type DescribeExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the execution.
	ExecutionId *string `locationName:"executionId" min:"1" type:"string"`

	// When the status of the execution was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The ID of the managed device that the task is being executed on.
	ManagedDeviceId *string `locationName:"managedDeviceId" min:"1" type:"string"`

	// When the execution began.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`

	// The current state of the execution.
	State *string `locationName:"state" type:"string" enum:"ExecutionState"`

	// The ID of the task being executed on the device.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExecutionOutput) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *DescribeExecutionOutput) SetExecutionId(v string) *DescribeExecutionOutput {
	s.ExecutionId = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeExecutionOutput) SetLastUpdatedAt(v time.Time) *DescribeExecutionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetManagedDeviceId sets the ManagedDeviceId field's value.
func (s *DescribeExecutionOutput) SetManagedDeviceId(v string) *DescribeExecutionOutput {
	s.ManagedDeviceId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *DescribeExecutionOutput) SetStartedAt(v time.Time) *DescribeExecutionOutput {
	s.StartedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeExecutionOutput) SetState(v string) *DescribeExecutionOutput {
	s.State = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeExecutionOutput) SetTaskId(v string) *DescribeExecutionOutput {
	s.TaskId = &v
	return s
}

type DescribeTaskInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the task to be described.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeTaskInput) SetTaskId(v string) *DescribeTaskInput {
	s.TaskId = &v
	return s
}

type DescribeTaskOutput struct {
	_ struct{} `type:"structure"`

	// When the task was completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// When the CreateTask operation was called.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The description provided of the task and managed devices.
	Description *string `locationName:"description" min:"1" type:"string"`

	// When the state of the task was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The current state of the task.
	State *string `locationName:"state" type:"string" enum:"TaskState"`

	// Optional metadata that you assign to a resource. You can use tags to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The managed devices that the task was sent to.
	Targets []*string `locationName:"targets" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// The ID of the task.
	TaskId *string `locationName:"taskId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskOutput) GoString() string {
	return s.String()
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *DescribeTaskOutput) SetCompletedAt(v time.Time) *DescribeTaskOutput {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeTaskOutput) SetCreatedAt(v time.Time) *DescribeTaskOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeTaskOutput) SetDescription(v string) *DescribeTaskOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeTaskOutput) SetLastUpdatedAt(v time.Time) *DescribeTaskOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeTaskOutput) SetState(v string) *DescribeTaskOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeTaskOutput) SetTags(v map[string]*string) *DescribeTaskOutput {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *DescribeTaskOutput) SetTargets(v []*string) *DescribeTaskOutput {
	s.Targets = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *DescribeTaskOutput) SetTaskArn(v string) *DescribeTaskOutput {
	s.TaskArn = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeTaskOutput) SetTaskId(v string) *DescribeTaskOutput {
	s.TaskId = &v
	return s
}

// Identifying information about the device.
type DeviceSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the job used to order the device.
	AssociatedWithJob *string `locationName:"associatedWithJob" type:"string"`

	// The Amazon Resource Name (ARN) of the device.
	ManagedDeviceArn *string `locationName:"managedDeviceArn" type:"string"`

	// The ID of the device.
	ManagedDeviceId *string `locationName:"managedDeviceId" min:"1" type:"string"`

	// Optional metadata that you assign to a resource. You can use tags to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSummary) GoString() string {
	return s.String()
}

// SetAssociatedWithJob sets the AssociatedWithJob field's value.
func (s *DeviceSummary) SetAssociatedWithJob(v string) *DeviceSummary {
	s.AssociatedWithJob = &v
	return s
}

// SetManagedDeviceArn sets the ManagedDeviceArn field's value.
func (s *DeviceSummary) SetManagedDeviceArn(v string) *DeviceSummary {
	s.ManagedDeviceArn = &v
	return s
}

// SetManagedDeviceId sets the ManagedDeviceId field's value.
func (s *DeviceSummary) SetManagedDeviceId(v string) *DeviceSummary {
	s.ManagedDeviceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeviceSummary) SetTags(v map[string]*string) *DeviceSummary {
	s.Tags = v
	return s
}

// Describes a parameter used to set up an Amazon Elastic Block Store (Amazon
// EBS) volume in a block device mapping.
type EbsInstanceBlockDevice struct {
	_ struct{} `type:"structure"`

	// When the attachment was initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp"`

	// A value that indicates whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The attachment state.
	Status *string `locationName:"status" type:"string" enum:"AttachmentStatus"`

	// The ID of the Amazon EBS volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbsInstanceBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbsInstanceBlockDevice) GoString() string {
	return s.String()
}

// SetAttachTime sets the AttachTime field's value.
func (s *EbsInstanceBlockDevice) SetAttachTime(v time.Time) *EbsInstanceBlockDevice {
	s.AttachTime = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *EbsInstanceBlockDevice) SetDeleteOnTermination(v bool) *EbsInstanceBlockDevice {
	s.DeleteOnTermination = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EbsInstanceBlockDevice) SetStatus(v string) *EbsInstanceBlockDevice {
	s.Status = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *EbsInstanceBlockDevice) SetVolumeId(v string) *EbsInstanceBlockDevice {
	s.VolumeId = &v
	return s
}

// The summary of a task execution on a specified device.
type ExecutionSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the execution.
	ExecutionId *string `locationName:"executionId" min:"1" type:"string"`

	// The ID of the managed device that the task is being executed on.
	ManagedDeviceId *string `locationName:"managedDeviceId" min:"1" type:"string"`

	// The state of the execution.
	State *string `locationName:"state" type:"string" enum:"ExecutionState"`

	// The ID of the task.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionSummary) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *ExecutionSummary) SetExecutionId(v string) *ExecutionSummary {
	s.ExecutionId = &v
	return s
}

// SetManagedDeviceId sets the ManagedDeviceId field's value.
func (s *ExecutionSummary) SetManagedDeviceId(v string) *ExecutionSummary {
	s.ManagedDeviceId = &v
	return s
}

// SetState sets the State field's value.
func (s *ExecutionSummary) SetState(v string) *ExecutionSummary {
	s.State = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *ExecutionSummary) SetTaskId(v string) *ExecutionSummary {
	s.TaskId = &v
	return s
}

// The description of an instance. Currently, Amazon EC2 instances are the only
// supported instance type.
type Instance struct {
	_ struct{} `type:"structure"`

	// The Amazon Machine Image (AMI) launch index, which you can use to find this
	// instance in the launch group.
	AmiLaunchIndex *int64 `locationName:"amiLaunchIndex" type:"integer"`

	// Any block device mapping entries for the instance.
	BlockDeviceMappings []*InstanceBlockDeviceMapping `locationName:"blockDeviceMappings" type:"list"`

	// The CPU options for the instance.
	CpuOptions *CpuOptions `locationName:"cpuOptions" type:"structure"`

	// When the instance was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the AMI used to launch the instance.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The private IPv4 address assigned to the instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The public IPv4 address assigned to the instance.
	PublicIpAddress *string `locationName:"publicIpAddress" type:"string"`

	// The device name of the root device volume (for example, /dev/sda1).
	RootDeviceName *string `locationName:"rootDeviceName" type:"string"`

	// The security groups for the instance.
	SecurityGroups []*SecurityGroupIdentifier `locationName:"securityGroups" type:"list"`

	// The description of the current state of an instance.
	State *InstanceState `locationName:"state" type:"structure"`

	// When the instance was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Instance) GoString() string {
	return s.String()
}

// SetAmiLaunchIndex sets the AmiLaunchIndex field's value.
func (s *Instance) SetAmiLaunchIndex(v int64) *Instance {
	s.AmiLaunchIndex = &v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *Instance) SetBlockDeviceMappings(v []*InstanceBlockDeviceMapping) *Instance {
	s.BlockDeviceMappings = v
	return s
}

// SetCpuOptions sets the CpuOptions field's value.
func (s *Instance) SetCpuOptions(v *CpuOptions) *Instance {
	s.CpuOptions = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Instance) SetCreatedAt(v time.Time) *Instance {
	s.CreatedAt = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *Instance) SetImageId(v string) *Instance {
	s.ImageId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Instance) SetInstanceId(v string) *Instance {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Instance) SetInstanceType(v string) *Instance {
	s.InstanceType = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *Instance) SetPrivateIpAddress(v string) *Instance {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIpAddress sets the PublicIpAddress field's value.
func (s *Instance) SetPublicIpAddress(v string) *Instance {
	s.PublicIpAddress = &v
	return s
}

// SetRootDeviceName sets the RootDeviceName field's value.
func (s *Instance) SetRootDeviceName(v string) *Instance {
	s.RootDeviceName = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *Instance) SetSecurityGroups(v []*SecurityGroupIdentifier) *Instance {
	s.SecurityGroups = v
	return s
}

// SetState sets the State field's value.
func (s *Instance) SetState(v *InstanceState) *Instance {
	s.State = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Instance) SetUpdatedAt(v time.Time) *Instance {
	s.UpdatedAt = &v
	return s
}

// The description of a block device mapping.
type InstanceBlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The block device name.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The parameters used to automatically set up Amazon Elastic Block Store (Amazon
	// EBS) volumes when the instance is launched.
	Ebs *EbsInstanceBlockDevice `locationName:"ebs" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceBlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceBlockDeviceMapping) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *InstanceBlockDeviceMapping) SetDeviceName(v string) *InstanceBlockDeviceMapping {
	s.DeviceName = &v
	return s
}

// SetEbs sets the Ebs field's value.
func (s *InstanceBlockDeviceMapping) SetEbs(v *EbsInstanceBlockDevice) *InstanceBlockDeviceMapping {
	s.Ebs = v
	return s
}

// The description of the current state of an instance.
type InstanceState struct {
	_ struct{} `type:"structure"`

	// The state of the instance as a 16-bit unsigned integer.
	//
	// The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal
	// values between 256 and 65,535. These numerical values are used for internal
	// purposes and should be ignored.
	//
	// The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal
	// values between 0 and 255.
	//
	// The valid values for the instance state code are all in the range of the
	// low byte. These values are:
	//
	//    * 0 : pending
	//
	//    * 16 : running
	//
	//    * 32 : shutting-down
	//
	//    * 48 : terminated
	//
	//    * 64 : stopping
	//
	//    * 80 : stopped
	//
	// You can ignore the high byte value by zeroing out all of the bits above 2^8
	// or 256 in decimal.
	Code *int64 `locationName:"code" type:"integer"`

	// The current state of the instance.
	Name *string `locationName:"name" type:"string" enum:"InstanceStateName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceState) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *InstanceState) SetCode(v int64) *InstanceState {
	s.Code = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceState) SetName(v string) *InstanceState {
	s.Name = &v
	return s
}

// The details about the instance.
type InstanceSummary struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the instance.
	Instance *Instance `locationName:"instance" type:"structure"`

	// When the instance summary was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceSummary) GoString() string {
	return s.String()
}

// SetInstance sets the Instance field's value.
func (s *InstanceSummary) SetInstance(v *Instance) *InstanceSummary {
	s.Instance = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *InstanceSummary) SetLastUpdatedAt(v time.Time) *InstanceSummary {
	s.LastUpdatedAt = &v
	return s
}

// An unexpected error occurred while processing the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDeviceResourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the managed device that you are listing the resources of.
	//
	// ManagedDeviceId is a required field
	ManagedDeviceId *string `location:"uri" locationName:"managedDeviceId" min:"1" type:"string" required:"true"`

	// The maximum number of resources per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token to continue to the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// A structure used to filter the results by type of resource.
	Type *string `location:"querystring" locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeviceResourcesInput"}
	if s.ManagedDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedDeviceId"))
	}
	if s.ManagedDeviceId != nil && len(*s.ManagedDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedDeviceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedDeviceId sets the ManagedDeviceId field's value.
func (s *ListDeviceResourcesInput) SetManagedDeviceId(v string) *ListDeviceResourcesInput {
	s.ManagedDeviceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceResourcesInput) SetMaxResults(v int64) *ListDeviceResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceResourcesInput) SetNextToken(v string) *ListDeviceResourcesInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListDeviceResourcesInput) SetType(v string) *ListDeviceResourcesInput {
	s.Type = &v
	return s
}

type ListDeviceResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token to continue to the next page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A structure defining the resource's type, Amazon Resource Name (ARN), and
	// ID.
	Resources []*ResourceSummary `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceResourcesOutput) SetNextToken(v string) *ListDeviceResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListDeviceResourcesOutput) SetResources(v []*ResourceSummary) *ListDeviceResourcesOutput {
	s.Resources = v
	return s
}

type ListDevicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the job used to order the device.
	JobId *string `location:"querystring" locationName:"jobId" min:"1" type:"string"`

	// The maximum number of devices to list per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token to continue to the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *ListDevicesInput) SetJobId(v string) *ListDevicesInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDevicesInput) SetMaxResults(v int64) *ListDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesInput) SetNextToken(v string) *ListDevicesInput {
	s.NextToken = &v
	return s
}

type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// A list of device structures that contain information about the device.
	Devices []*DeviceSummary `locationName:"devices" type:"list"`

	// A pagination token to continue to the next page of devices.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*DeviceSummary) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesOutput) SetNextToken(v string) *ListDevicesOutput {
	s.NextToken = &v
	return s
}

type ListExecutionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of tasks to list per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token to continue to the next page of tasks.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// A structure used to filter the tasks by their current state.
	State *string `location:"querystring" locationName:"state" type:"string" enum:"ExecutionState"`

	// The ID of the task.
	//
	// TaskId is a required field
	TaskId *string `location:"querystring" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExecutionsInput) SetMaxResults(v int64) *ListExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsInput) SetNextToken(v string) *ListExecutionsInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *ListExecutionsInput) SetState(v string) *ListExecutionsInput {
	s.State = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *ListExecutionsInput) SetTaskId(v string) *ListExecutionsInput {
	s.TaskId = &v
	return s
}

type ListExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of executions. Each execution contains the task ID, the device that
	// the task is executing on, the execution ID, and the status of the execution.
	Executions []*ExecutionSummary `locationName:"executions" type:"list"`

	// A pagination token to continue to the next page of executions.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsOutput) GoString() string {
	return s.String()
}

// SetExecutions sets the Executions field's value.
func (s *ListExecutionsOutput) SetExecutions(v []*ExecutionSummary) *ListExecutionsOutput {
	s.Executions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsOutput) SetNextToken(v string) *ListExecutionsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the device or task.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags for the device or task.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTasksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of tasks per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token to continue to the next page of tasks.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// A structure used to filter the list of tasks.
	State *string `location:"querystring" locationName:"state" type:"string" enum:"TaskState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTasksInput) SetMaxResults(v int64) *ListTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksInput) SetNextToken(v string) *ListTasksInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *ListTasksInput) SetState(v string) *ListTasksInput {
	s.State = &v
	return s
}

type ListTasksOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token to continue to the next page of tasks.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of task structures containing details about each task.
	Tasks []*TaskSummary `locationName:"tasks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksOutput) SetNextToken(v string) *ListTasksOutput {
	s.NextToken = &v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *ListTasksOutput) SetTasks(v []*TaskSummary) *ListTasksOutput {
	s.Tasks = v
	return s
}

// The details about the physical network interface for the device.
type PhysicalNetworkInterface struct {
	_ struct{} `type:"structure"`

	// The default gateway of the device.
	DefaultGateway *string `locationName:"defaultGateway" type:"string"`

	// The IP address of the device.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// A value that describes whether the IP address is dynamic or persistent.
	IpAddressAssignment *string `locationName:"ipAddressAssignment" type:"string" enum:"IpAddressAssignment"`

	// The MAC address of the device.
	MacAddress *string `locationName:"macAddress" type:"string"`

	// The netmask used to divide the IP address into subnets.
	Netmask *string `locationName:"netmask" type:"string"`

	// The physical connector type.
	PhysicalConnectorType *string `locationName:"physicalConnectorType" type:"string" enum:"PhysicalConnectorType"`

	// The physical network interface ID.
	PhysicalNetworkInterfaceId *string `locationName:"physicalNetworkInterfaceId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhysicalNetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhysicalNetworkInterface) GoString() string {
	return s.String()
}

// SetDefaultGateway sets the DefaultGateway field's value.
func (s *PhysicalNetworkInterface) SetDefaultGateway(v string) *PhysicalNetworkInterface {
	s.DefaultGateway = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *PhysicalNetworkInterface) SetIpAddress(v string) *PhysicalNetworkInterface {
	s.IpAddress = &v
	return s
}

// SetIpAddressAssignment sets the IpAddressAssignment field's value.
func (s *PhysicalNetworkInterface) SetIpAddressAssignment(v string) *PhysicalNetworkInterface {
	s.IpAddressAssignment = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *PhysicalNetworkInterface) SetMacAddress(v string) *PhysicalNetworkInterface {
	s.MacAddress = &v
	return s
}

// SetNetmask sets the Netmask field's value.
func (s *PhysicalNetworkInterface) SetNetmask(v string) *PhysicalNetworkInterface {
	s.Netmask = &v
	return s
}

// SetPhysicalConnectorType sets the PhysicalConnectorType field's value.
func (s *PhysicalNetworkInterface) SetPhysicalConnectorType(v string) *PhysicalNetworkInterface {
	s.PhysicalConnectorType = &v
	return s
}

// SetPhysicalNetworkInterfaceId sets the PhysicalNetworkInterfaceId field's value.
func (s *PhysicalNetworkInterface) SetPhysicalNetworkInterfaceId(v string) *PhysicalNetworkInterface {
	s.PhysicalNetworkInterfaceId = &v
	return s
}

// A structure used to reboot the device.
type Reboot struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Reboot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Reboot) GoString() string {
	return s.String()
}

// The request references a resource that doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A summary of a resource available on the device.
type ResourceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the resource.
	Id *string `locationName:"id" type:"string"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceSummary) SetArn(v string) *ResourceSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResourceSummary) SetId(v string) *ResourceSummary {
	s.Id = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceSummary) SetResourceType(v string) *ResourceSummary {
	s.ResourceType = &v
	return s
}

// Information about the device's security group.
type SecurityGroupIdentifier struct {
	_ struct{} `type:"structure"`

	// The security group ID.
	GroupId *string `locationName:"groupId" type:"string"`

	// The security group name.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupIdentifier) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *SecurityGroupIdentifier) SetGroupId(v string) *SecurityGroupIdentifier {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *SecurityGroupIdentifier) SetGroupName(v string) *SecurityGroupIdentifier {
	s.GroupName = &v
	return s
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the software on the device.
type SoftwareInformation struct {
	_ struct{} `type:"structure"`

	// The state of the software that is installed or that is being installed on
	// the device.
	InstallState *string `locationName:"installState" type:"string"`

	// The version of the software currently installed on the device.
	InstalledVersion *string `locationName:"installedVersion" type:"string"`

	// The version of the software being installed on the device.
	InstallingVersion *string `locationName:"installingVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareInformation) GoString() string {
	return s.String()
}

// SetInstallState sets the InstallState field's value.
func (s *SoftwareInformation) SetInstallState(v string) *SoftwareInformation {
	s.InstallState = &v
	return s
}

// SetInstalledVersion sets the InstalledVersion field's value.
func (s *SoftwareInformation) SetInstalledVersion(v string) *SoftwareInformation {
	s.InstalledVersion = &v
	return s
}

// SetInstallingVersion sets the InstallingVersion field's value.
func (s *SoftwareInformation) SetInstallingVersion(v string) *SoftwareInformation {
	s.InstallingVersion = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the device or task.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Optional metadata that you assign to a resource. You can use tags to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Information about the task assigned to one or many devices.
type TaskSummary struct {
	_ struct{} `type:"structure"`

	// The state of the task assigned to one or many devices.
	State *string `locationName:"state" type:"string" enum:"TaskState"`

	// Optional metadata that you assign to a resource. You can use tags to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// The task ID.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskSummary) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *TaskSummary) SetState(v string) *TaskSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TaskSummary) SetTags(v map[string]*string) *TaskSummary {
	s.Tags = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *TaskSummary) SetTaskArn(v string) *TaskSummary {
	s.TaskArn = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *TaskSummary) SetTaskId(v string) *TaskSummary {
	s.TaskId = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure used to unlock a device.
type Unlock struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Unlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Unlock) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the device or task.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Optional metadata that you assign to a resource. You can use tags to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AttachmentStatusAttaching is a AttachmentStatus enum value
	AttachmentStatusAttaching = "ATTACHING"

	// AttachmentStatusAttached is a AttachmentStatus enum value
	AttachmentStatusAttached = "ATTACHED"

	// AttachmentStatusDetaching is a AttachmentStatus enum value
	AttachmentStatusDetaching = "DETACHING"

	// AttachmentStatusDetached is a AttachmentStatus enum value
	AttachmentStatusDetached = "DETACHED"
)

// AttachmentStatus_Values returns all elements of the AttachmentStatus enum
func AttachmentStatus_Values() []string {
	return []string{
		AttachmentStatusAttaching,
		AttachmentStatusAttached,
		AttachmentStatusDetaching,
		AttachmentStatusDetached,
	}
}

const (
	// ExecutionStateQueued is a ExecutionState enum value
	ExecutionStateQueued = "QUEUED"

	// ExecutionStateInProgress is a ExecutionState enum value
	ExecutionStateInProgress = "IN_PROGRESS"

	// ExecutionStateCanceled is a ExecutionState enum value
	ExecutionStateCanceled = "CANCELED"

	// ExecutionStateFailed is a ExecutionState enum value
	ExecutionStateFailed = "FAILED"

	// ExecutionStateSucceeded is a ExecutionState enum value
	ExecutionStateSucceeded = "SUCCEEDED"

	// ExecutionStateRejected is a ExecutionState enum value
	ExecutionStateRejected = "REJECTED"

	// ExecutionStateTimedOut is a ExecutionState enum value
	ExecutionStateTimedOut = "TIMED_OUT"
)

// ExecutionState_Values returns all elements of the ExecutionState enum
func ExecutionState_Values() []string {
	return []string{
		ExecutionStateQueued,
		ExecutionStateInProgress,
		ExecutionStateCanceled,
		ExecutionStateFailed,
		ExecutionStateSucceeded,
		ExecutionStateRejected,
		ExecutionStateTimedOut,
	}
}

const (
	// InstanceStateNamePending is a InstanceStateName enum value
	InstanceStateNamePending = "PENDING"

	// InstanceStateNameRunning is a InstanceStateName enum value
	InstanceStateNameRunning = "RUNNING"

	// InstanceStateNameShuttingDown is a InstanceStateName enum value
	InstanceStateNameShuttingDown = "SHUTTING_DOWN"

	// InstanceStateNameTerminated is a InstanceStateName enum value
	InstanceStateNameTerminated = "TERMINATED"

	// InstanceStateNameStopping is a InstanceStateName enum value
	InstanceStateNameStopping = "STOPPING"

	// InstanceStateNameStopped is a InstanceStateName enum value
	InstanceStateNameStopped = "STOPPED"
)

// InstanceStateName_Values returns all elements of the InstanceStateName enum
func InstanceStateName_Values() []string {
	return []string{
		InstanceStateNamePending,
		InstanceStateNameRunning,
		InstanceStateNameShuttingDown,
		InstanceStateNameTerminated,
		InstanceStateNameStopping,
		InstanceStateNameStopped,
	}
}

const (
	// IpAddressAssignmentDhcp is a IpAddressAssignment enum value
	IpAddressAssignmentDhcp = "DHCP"

	// IpAddressAssignmentStatic is a IpAddressAssignment enum value
	IpAddressAssignmentStatic = "STATIC"
)

// IpAddressAssignment_Values returns all elements of the IpAddressAssignment enum
func IpAddressAssignment_Values() []string {
	return []string{
		IpAddressAssignmentDhcp,
		IpAddressAssignmentStatic,
	}
}

const (
	// PhysicalConnectorTypeRj45 is a PhysicalConnectorType enum value
	PhysicalConnectorTypeRj45 = "RJ45"

	// PhysicalConnectorTypeSfpPlus is a PhysicalConnectorType enum value
	PhysicalConnectorTypeSfpPlus = "SFP_PLUS"

	// PhysicalConnectorTypeQsfp is a PhysicalConnectorType enum value
	PhysicalConnectorTypeQsfp = "QSFP"

	// PhysicalConnectorTypeRj452 is a PhysicalConnectorType enum value
	PhysicalConnectorTypeRj452 = "RJ45_2"

	// PhysicalConnectorTypeWifi is a PhysicalConnectorType enum value
	PhysicalConnectorTypeWifi = "WIFI"
)

// PhysicalConnectorType_Values returns all elements of the PhysicalConnectorType enum
func PhysicalConnectorType_Values() []string {
	return []string{
		PhysicalConnectorTypeRj45,
		PhysicalConnectorTypeSfpPlus,
		PhysicalConnectorTypeQsfp,
		PhysicalConnectorTypeRj452,
		PhysicalConnectorTypeWifi,
	}
}

const (
	// TaskStateInProgress is a TaskState enum value
	TaskStateInProgress = "IN_PROGRESS"

	// TaskStateCanceled is a TaskState enum value
	TaskStateCanceled = "CANCELED"

	// TaskStateCompleted is a TaskState enum value
	TaskStateCompleted = "COMPLETED"
)

// TaskState_Values returns all elements of the TaskState enum
func TaskState_Values() []string {
	return []string{
		TaskStateInProgress,
		TaskStateCanceled,
		TaskStateCompleted,
	}
}

const (
	// UnlockStateUnlocked is a UnlockState enum value
	UnlockStateUnlocked = "UNLOCKED"

	// UnlockStateLocked is a UnlockState enum value
	UnlockStateLocked = "LOCKED"

	// UnlockStateUnlocking is a UnlockState enum value
	UnlockStateUnlocking = "UNLOCKING"
)

// UnlockState_Values returns all elements of the UnlockState enum
func UnlockState_Values() []string {
	return []string{
		UnlockStateUnlocked,
		UnlockStateLocked,
		UnlockStateUnlocking,
	}
}
