/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.code.plugin;

import com.anthropic.code.plugin.services.MCPService;
import com.anthropic.code.plugin.services.MCPServiceKt;
import com.anthropic.code.plugin.settings.PluginSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ProxyTtyConnector;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010#\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u001d\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/anthropic/code/plugin/TerminalUtil;", "", "<init>", "()V", "ESC_MOVE_TO_FOCUS_SETTING_ID", "", "defaultEscMovesFocusSetting", "", "Ljava/lang/Boolean;", "captureEscapeKeyForTerminal", "", "project", "Lcom/intellij/openapi/project/Project;", "mcpService", "Lcom/anthropic/code/plugin/services/MCPService;", "configureTerminalSettings", "findClaudeTerminal", "Lcom/intellij/terminal/ui/TerminalWidget;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "processIds", "", "", "isClaudeCliProcess", "process", "Ljava/lang/Process;", "isClaudeCliProcessHandle", "handle", "Ljava/lang/ProcessHandle;", "IGNORE_DUPLICATE_OPEN_CLAUDE_ELAPSED_TIME_MS", "lastOpenedClaudeTimestampMs", "openClaudeInTerminal", "DEBOUNCE_SHIFT_ENTER_ELAPSED_TIME_MS", "lastShiftEnterTimestampMs", "setupShiftEnterHandler", "focusClaudeInTerminal", "runningMcpServerPorts", "", "", "getRunningMcpServerPorts", "()Ljava/util/Map;", "claude-code-jetbrains-plugin"})
@SourceDebugExtension(value={"SMAP\nTerminalUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUtil.kt\ncom/anthropic/code/plugin/TerminalUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n11383#2,9:242\n13309#2:251\n13310#2:253\n11392#2:254\n3792#2:255\n4307#2,2:256\n1#3:252\n1549#4:258\n1620#4,3:259\n*S KotlinDebug\n*F\n+ 1 TerminalUtil.kt\ncom/anthropic/code/plugin/TerminalUtil\n*L\n62#1:242,9\n62#1:251\n62#1:253\n62#1:254\n96#1:255\n96#1:256,2\n62#1:252\n97#1:258\n97#1:259,3\n*E\n"})
public final class TerminalUtil {
    @NotNull
    public static final TerminalUtil INSTANCE = new TerminalUtil();
    @NotNull
    private static final String ESC_MOVE_TO_FOCUS_SETTING_ID = "terminal.escape.moves.focus.to.editor";
    @Nullable
    private static Boolean defaultEscMovesFocusSetting;
    private static final long IGNORE_DUPLICATE_OPEN_CLAUDE_ELAPSED_TIME_MS = 6000L;
    private static long lastOpenedClaudeTimestampMs;
    private static final long DEBOUNCE_SHIFT_ENTER_ELAPSED_TIME_MS = 200L;
    private static long lastShiftEnterTimestampMs;
    @NotNull
    private static final Map<String, Integer> runningMcpServerPorts;

    private TerminalUtil() {
    }

    public final void captureEscapeKeyForTerminal(@NotNull Project project, @NotNull MCPService mcpService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mcpService, (String)"mcpService");
        try {
            boolean isConnected = !mcpService.getMcpServerInfos().isEmpty();
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Terminal");
            if (isConnected && toolWindow != null) {
                if (defaultEscMovesFocusSetting == null) {
                    defaultEscMovesFocusSetting = AdvancedSettings.Companion.getBoolean(ESC_MOVE_TO_FOCUS_SETTING_ID);
                }
                AdvancedSettings.Companion.setBoolean(ESC_MOVE_TO_FOCUS_SETTING_ID, false);
            } else {
                Boolean bl = defaultEscMovesFocusSetting;
                if (bl != null) {
                    boolean it = bl;
                    boolean bl2 = false;
                    AdvancedSettings.Companion.setBoolean(ESC_MOVE_TO_FOCUS_SETTING_ID, it);
                    defaultEscMovesFocusSetting = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void configureTerminalSettings(@NotNull Project project, @NotNull MCPService mcpService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mcpService, (String)"mcpService");
        this.captureEscapeKeyForTerminal(project, mcpService);
        PluginSettings settings = PluginSettings.Companion.getInstance();
        if (settings.getEnableOptEnterNewLine()) {
            TerminalOptionsProvider.Companion.getInstance().setUseOptionAsMetaKey(true);
        }
        this.setupShiftEnterHandler(project, mcpService);
    }

    /*
     * WARNING - void declaration
     */
    private final TerminalWidget findClaudeTerminal(ToolWindow toolWindow, List<Long> processIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Object[] $this$mapNotNull$iv;
        Content[] contentArray = toolWindow.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] objectArray = contentArray;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        int $i$f$forEach = 0;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            TerminalWidget terminalWidget;
            block12: {
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                Content content = (Content)element$iv$iv;
                boolean bl2 = false;
                if (TerminalToolWindowManager.findWidgetByContent((Content)content) == null) {
                    terminalWidget = null;
                } else {
                    block11: {
                        try {
                            Process process;
                            TerminalWidget widget;
                            JBTerminalWidget terminalWidget2 = JBTerminalWidget.asJediTermWidget((TerminalWidget)widget);
                            if (terminalWidget2 != null) {
                                ProcessTtyConnector processTtyConnector = terminalWidget2.getProcessTtyConnector();
                                Process process2 = process = processTtyConnector != null ? processTtyConnector.getProcess() : null;
                                if (process == null || !INSTANCE.isClaudeCliProcess(process, processIds)) break block11;
                                terminalWidget = widget;
                                break block12;
                            }
                            TtyConnector ttyConnector = widget.getTtyConnector();
                            if (ttyConnector instanceof ProxyTtyConnector) {
                                TtyConnector ttyConnector2 = ((ProxyTtyConnector)ttyConnector).getConnector();
                                ProcessTtyConnector processTtyConnector = ttyConnector2 instanceof ProcessTtyConnector ? (ProcessTtyConnector)ttyConnector2 : null;
                                v5 = processTtyConnector != null ? processTtyConnector.getProcess() : null;
                            } else {
                                v5 = process = ttyConnector instanceof ProcessTtyConnector ? ((ProcessTtyConnector)ttyConnector).getProcess() : null;
                            }
                            if (process == null || !INSTANCE.isClaudeCliProcess(process, processIds)) break block11;
                            terminalWidget = widget;
                            break block12;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    terminalWidget = null;
                }
            }
            if (terminalWidget == null) continue;
            TerminalWidget it$iv$iv = terminalWidget;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List matchingTerminals = (List)destination$iv$iv;
        if (!((Collection)matchingTerminals).isEmpty()) {
            return (TerminalWidget)CollectionsKt.first((List)matchingTerminals);
        }
        Content[] contentArray2 = toolWindow.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray2, (String)"getContents(...)");
        $this$mapNotNull$iv = contentArray2;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Content it = (Content)element$iv$iv;
            boolean bl = false;
            String string = it.getTabName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTabName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"Claude Code", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Content element$iv$iv = (Content)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TerminalToolWindowManager.findWidgetByContent((Content)it));
        }
        return (TerminalWidget)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
    }

    private final boolean isClaudeCliProcess(Process process, List<Long> processIds) {
        if (!process.isAlive()) {
            return false;
        }
        try {
            ProcessHandle processHandle = process.toHandle();
            Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"toHandle(...)");
            if (this.isClaudeCliProcessHandle(processHandle, processIds)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            long terminalPid = process.pid();
            Stream<ProcessHandle> allProcesses = ProcessHandle.allProcesses();
            return allProcesses.anyMatch(arg_0 -> TerminalUtil.isClaudeCliProcess$lambda$5(arg_0 -> TerminalUtil.isClaudeCliProcess$lambda$4(terminalPid, processIds, arg_0), arg_0));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final boolean isClaudeCliProcessHandle(ProcessHandle handle, List<Long> processIds) {
        Ref.BooleanRef foundProcess = new Ref.BooleanRef();
        if (processIds.contains(handle.pid())) {
            foundProcess.element = true;
        } else {
            handle.descendants().forEach(arg_0 -> TerminalUtil.isClaudeCliProcessHandle$lambda$7(arg_0 -> TerminalUtil.isClaudeCliProcessHandle$lambda$6(processIds, foundProcess, arg_0), arg_0));
        }
        return foundProcess.element;
    }

    @Nullable
    public final TerminalWidget openClaudeInTerminal(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        long elapsedTime = System.currentTimeMillis() - lastOpenedClaudeTimestampMs;
        if (elapsedTime <= 6000L) {
            return null;
        }
        lastOpenedClaudeTimestampMs = System.currentTimeMillis();
        String projectBasePath = project.getBasePath();
        if (projectBasePath != null) {
            TerminalToolWindowManager terminalManager = TerminalToolWindowManager.getInstance((Project)project);
            TerminalWidget terminalWidget = terminalManager.createShellWidget(projectBasePath, "Claude Code", true, true);
            Intrinsics.checkNotNullExpressionValue((Object)terminalWidget, (String)"createShellWidget(...)");
            TerminalWidget terminalWidget2 = terminalWidget;
            String claudeCommand = PluginSettings.Companion.getInstance().getClaudeCommand();
            terminalWidget2.sendCommandToExecute(claudeCommand);
            terminalManager.getToolWindow().activate(null);
            return terminalWidget2;
        }
        return null;
    }

    private final void setupShiftEnterHandler(Project project, MCPService mcpService) {
        ApplicationManager.getApplication().invokeLater(() -> TerminalUtil.setupShiftEnterHandler$lambda$10(mcpService, project));
    }

    public final boolean focusClaudeInTerminal(@NotNull MCPService mcpService, @NotNull Project project) {
        List<Long> processIds;
        TerminalWidget claudeTerminal;
        Intrinsics.checkNotNullParameter((Object)mcpService, (String)"mcpService");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Terminal");
        if (toolWindow != null && (claudeTerminal = this.findClaudeTerminal(toolWindow, processIds = MCPServiceKt.getRunningProcessIds(mcpService))) != null) {
            Object object;
            ContentManager contentManager;
            block3: {
                ContentManager contentManager2 = toolWindow.getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getContentManager(...)");
                contentManager = contentManager2;
                Content[] contentArray = contentManager.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                for (Object object2 : (Object[])contentArray) {
                    Content content = (Content)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)TerminalToolWindowManager.findWidgetByContent((Content)content), (Object)claudeTerminal)) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            Content content = (Content)object;
            if (content != null) {
                Content content2 = content;
                boolean bl = false;
                contentManager.setSelectedContent(content2);
            }
            toolWindow.activate(null);
            return true;
        }
        return false;
    }

    @NotNull
    public final Map<String, Integer> getRunningMcpServerPorts() {
        return runningMcpServerPorts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClaudeCliProcess$lambda$4(long $terminalPid, List $processIds, ProcessHandle handle) {
        if (handle.pid() != $terminalPid) return false;
        Intrinsics.checkNotNull((Object)handle);
        if (!INSTANCE.isClaudeCliProcessHandle(handle, $processIds)) return false;
        return true;
    }

    private static final boolean isClaudeCliProcess$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit isClaudeCliProcessHandle$lambda$6(List $processIds, Ref.BooleanRef $foundProcess, ProcessHandle childHandle) {
        if ($processIds.contains(childHandle.pid())) {
            $foundProcess.element = true;
        }
        return Unit.INSTANCE;
    }

    private static final void isClaudeCliProcessHandle$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupShiftEnterHandler$lambda$10$lambda$8(TerminalWidget $widget, KeyEvent e) {
        if (e.getKeyCode() == 10 && e.isShiftDown() && !e.isAltDown()) {
            long elapsedTime = System.currentTimeMillis() - lastShiftEnterTimestampMs;
            if (elapsedTime > 200L) {
                TtyConnector ttyConnector = $widget.getTtyConnector();
                if (ttyConnector != null) {
                    ttyConnector.write("\n");
                }
                lastShiftEnterTimestampMs = System.currentTimeMillis();
            }
            e.consume();
        }
        return Unit.INSTANCE;
    }

    private static final void setupShiftEnterHandler$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void setupShiftEnterHandler$lambda$10(MCPService $mcpService, Project $project) {
        try {
            TerminalWidget widget;
            List<Long> processIds = MCPServiceKt.getRunningProcessIds($mcpService);
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance($project).getToolWindow("Terminal");
            if (toolWindow == null || processIds.isEmpty()) {
                return;
            }
            TerminalWidget terminalWidget = widget = INSTANCE.findClaudeTerminal(toolWindow, processIds);
            if ((terminalWidget != null ? terminalWidget.getTtyConnector() : null) != null) {
                JBTerminalPanel terminalPanel;
                JBTerminalWidget jBTerminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)widget);
                JBTerminalPanel jBTerminalPanel = terminalPanel = jBTerminalWidget != null ? jBTerminalWidget.getTerminalPanel() : null;
                if (jBTerminalPanel != null) {
                    jBTerminalPanel.addPreKeyEventHandler(arg_0 -> TerminalUtil.setupShiftEnterHandler$lambda$10$lambda$9(arg_0 -> TerminalUtil.setupShiftEnterHandler$lambda$10$lambda$8(widget, arg_0), arg_0));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        runningMcpServerPorts = new LinkedHashMap();
    }
}

