/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Flow;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0083\u0001\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0004\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0004\u0012\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f0\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\"2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010#\u001a\u0004\u0018\u00010\u00002\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020&R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Flow;", "previousFlow", "approvedTypeStatements", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentTypeStatement;", "implications", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;", "assignmentIndex", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "", "directAliasMap", "backwardsAliasMap", "Lkotlinx/collections/immutable/PersistentSet;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;)V", "getImplications$semantics", "()Lkotlinx/collections/immutable/PersistentMap;", "getAssignmentIndex$semantics", "getDirectAliasMap$semantics", "level", "knownVariables", "", "getKnownVariables", "()Ljava/util/Set;", "allVariablesForDebug", "getAllVariablesForDebug", "unwrapVariable", "variable", "getTypeStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "getImplications", "", "lowestCommonAncestor", "other", "fork", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;", "semantics"})
@SourceDebugExtension(value={"SMAP\nFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Flow.kt\norg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1586#2:122\n1661#2,3:123\n*S KotlinDebug\n*F\n+ 1 Flow.kt\norg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow\n*L\n43#1:122\n43#1:123,3\n*E\n"})
public final class PersistentFlow
extends Flow {
    @Nullable
    private final PersistentFlow previousFlow;
    @NotNull
    private final PersistentMap<DataFlowVariable, PersistentTypeStatement> approvedTypeStatements;
    @NotNull
    private final PersistentMap<DataFlowVariable, PersistentList<Implication>> implications;
    @NotNull
    private final PersistentMap<RealVariable, Integer> assignmentIndex;
    @NotNull
    private final PersistentMap<RealVariable, RealVariable> directAliasMap;
    @NotNull
    private final PersistentMap<RealVariable, PersistentSet<RealVariable>> backwardsAliasMap;
    private final int level;

    public PersistentFlow(@Nullable PersistentFlow previousFlow, @NotNull PersistentMap<DataFlowVariable, PersistentTypeStatement> approvedTypeStatements, @NotNull PersistentMap<DataFlowVariable, ? extends PersistentList<Implication>> implications, @NotNull PersistentMap<RealVariable, Integer> assignmentIndex, @NotNull PersistentMap<RealVariable, RealVariable> directAliasMap, @NotNull PersistentMap<RealVariable, ? extends PersistentSet<RealVariable>> backwardsAliasMap) {
        Intrinsics.checkNotNullParameter(approvedTypeStatements, "approvedTypeStatements");
        Intrinsics.checkNotNullParameter(implications, "implications");
        Intrinsics.checkNotNullParameter(assignmentIndex, "assignmentIndex");
        Intrinsics.checkNotNullParameter(directAliasMap, "directAliasMap");
        Intrinsics.checkNotNullParameter(backwardsAliasMap, "backwardsAliasMap");
        this.previousFlow = previousFlow;
        this.approvedTypeStatements = approvedTypeStatements;
        this.implications = implications;
        this.assignmentIndex = assignmentIndex;
        this.directAliasMap = directAliasMap;
        this.backwardsAliasMap = backwardsAliasMap;
        this.level = this.previousFlow != null ? this.previousFlow.level + 1 : 0;
    }

    @NotNull
    public final PersistentMap<DataFlowVariable, PersistentList<Implication>> getImplications$semantics() {
        return this.implications;
    }

    @NotNull
    public final PersistentMap<RealVariable, Integer> getAssignmentIndex$semantics() {
        return this.assignmentIndex;
    }

    @NotNull
    public final PersistentMap<RealVariable, RealVariable> getDirectAliasMap$semantics() {
        return this.directAliasMap;
    }

    @Override
    @NotNull
    public Set<DataFlowVariable> getKnownVariables() {
        return SetsKt.plus(this.approvedTypeStatements.keySet(), this.directAliasMap.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<DataFlowVariable> getAllVariablesForDebug() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.flatten(this.implications.values());
        Set<DataFlowVariable> set = SetsKt.plus(this.getKnownVariables(), this.implications.keySet());
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Implication implication = (Implication)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEffect().getVariable());
        }
        return SetsKt.plus(set, (List)destination$iv$iv);
    }

    @Override
    @NotNull
    public RealVariable unwrapVariable(@NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter(variable, "variable");
        RealVariable realVariable = (RealVariable)this.directAliasMap.get(variable);
        if (realVariable == null) {
            realVariable = variable;
        }
        return realVariable;
    }

    @Override
    @Nullable
    public TypeStatement getTypeStatement(@NotNull DataFlowVariable variable) {
        Intrinsics.checkNotNullParameter(variable, "variable");
        PersistentTypeStatement persistentTypeStatement = (PersistentTypeStatement)this.approvedTypeStatements.get(this.unwrapVariable(variable));
        return persistentTypeStatement != null ? PersistentTypeStatement.copy$default(persistentTypeStatement, variable, null, null, 6, null) : null;
    }

    @Override
    @Nullable
    public Collection<Implication> getImplications(@NotNull DataFlowVariable variable) {
        Intrinsics.checkNotNullParameter(variable, "variable");
        return (Collection)this.implications.get(variable);
    }

    @Nullable
    public final PersistentFlow lowestCommonAncestor(@NotNull PersistentFlow other) {
        Intrinsics.checkNotNullParameter(other, "other");
        PersistentFlow left = this;
        PersistentFlow right = other;
        while (left.level > right.level) {
            if (left.previousFlow != null) continue;
            return null;
        }
        while (right.level > left.level) {
            if (right.previousFlow != null) continue;
            return null;
        }
        while (!Intrinsics.areEqual(left, right)) {
            if (left.previousFlow == null) {
                return null;
            }
            if (right.previousFlow != null) continue;
            return null;
        }
        return left;
    }

    @NotNull
    public final MutableFlow fork() {
        return new MutableFlow(this, this.approvedTypeStatements.builder(), this.implications.builder(), this.assignmentIndex.builder(), this.directAliasMap.builder(), this.backwardsAliasMap.builder());
    }
}

