/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeHiddenCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001@B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J-\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J/\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0010H\u0000R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002JE\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001eJ'\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010!J7\u0010\"\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010$H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020'*\u0004\u0018\u00010(H\u0002JM\u0010)\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00100JE\u00101\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00103J5\u00104\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00105R\u001a\u00106\u001a\u0004\u0018\u000107*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0018\u0010:\u001a\u00020$*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001a\u0010=\u001a\u0004\u0018\u00010\u0012*\u0002078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "syntaxKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$DestructuringSyntax;", "Lorg/jetbrains/kotlin/KtSourceElement;", "originalDestructuringDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "checkFullFormLanguageFeature", "source", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkSquareBracketsLanguageFeature", "checkSquareBracketsLanguageFeature$checkers", "findSquareBracket", "checkChangingMeaningOfShortSyntax", "originalDestructuringDeclarationType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "componentIndex", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;ILorg/jetbrains/kotlin/KtSourceElement;)V", "associatedPropertyName", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;I)Lorg/jetbrains/kotlin/name/Name;", "checkInitializer", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "isMissingInitializer", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "reportGivenDiagnostic", "destructuringDeclarationType", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "property", "componentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;)V", "checkComponentTypeMismatch", "destructuringDeclaration", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/declarations/FirVariable;Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;)V", "reportDefaultDiagnostics", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;)V", "explicitReceiverOfQualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "getExplicitReceiverOfQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "unwrapped", "getUnwrapped", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "resolvedVariable", "getResolvedVariable", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "DestructuringSyntax", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDestructuringDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDestructuringDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n70#2:407\n296#3,2:408\n1586#3:410\n1661#3,3:411\n*S KotlinDebug\n*F\n+ 1 FirDestructuringDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker\n*L\n238#1:407\n239#1:408,2\n304#1:410\n304#1:411,3\n*E\n"})
public final class FirDestructuringDeclarationChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDestructuringDeclarationChecker INSTANCE = new FirDestructuringDeclarationChecker();

    private FirDestructuringDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        ConeDiagnostic diagnostic;
        FirElement firElement;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        KtSourceElement ktSourceElement = declaration.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            this.checkInitializer(reporter, context2, source, declaration.getInitializer());
            this.checkSquareBracketsLanguageFeature$checkers(context2, reporter, source);
            return;
        }
        if (Intrinsics.areEqual(declaration.getName(), SpecialNames.DESTRUCT)) {
            this.checkSquareBracketsLanguageFeature$checkers(context2, reporter, source);
        }
        if (!Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        FirExpression firExpression = declaration.getInitializer();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
        if (firQualifiedAccessExpression == null) {
            return;
        }
        FirQualifiedAccessExpression initializer = firQualifiedAccessExpression;
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = this.getExplicitReceiverOfQualifiedAccess(initializer);
        if (firQualifiedAccessExpression2 == null) {
            return;
        }
        FirQualifiedAccessExpression originalExpression2 = firQualifiedAccessExpression2;
        FirVariable firVariable = this.getResolvedVariable(originalExpression2);
        if (firVariable == null) {
            return;
        }
        FirVariable originalDestructuringDeclaration = firVariable;
        FirVariable firVariable2 = originalDestructuringDeclaration;
        if (firVariable2 instanceof FirProperty) {
            FirExpression firExpression2;
            Object object = ((FirProperty)originalDestructuringDeclaration).getInitializer();
            if (Intrinsics.areEqual(object != null && (object = ((FirExpression)object).getSource()) != null ? ((KtSourceElement)object).getElementType() : null, KtNodeTypes.FOR)) {
                FirQualifiedAccessExpression iterator2;
                FirExpression firExpression3 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
                FirQualifiedAccessExpression firQualifiedAccessExpression3 = iterator2 = firExpression3 != null ? this.getExplicitReceiverOfQualifiedAccess(firExpression3) : null;
                FirVariable firVariable3 = firQualifiedAccessExpression3 != null ? this.getResolvedVariable(firQualifiedAccessExpression3) : null;
                FirPureAbstractElement firPureAbstractElement = firVariable3 instanceof FirProperty ? (FirProperty)firVariable3 : null;
                firExpression2 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null ? this.getExplicitReceiverOfQualifiedAccess((FirExpression)firPureAbstractElement) : null;
            } else {
                firExpression2 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
            }
            firElement = firExpression2;
        } else {
            firElement = firVariable2 instanceof FirValueParameter ? (FirElement)originalDestructuringDeclaration : null;
        }
        if (firElement == null) {
            return;
        }
        FirElement originalDestructuringDeclarationOrInitializer = firElement;
        DestructuringSyntax syntax = this.syntaxKind(source, originalDestructuringDeclaration);
        if (syntax == DestructuringSyntax.ParensFull) {
            this.checkFullFormLanguageFeature(context2, reporter, source);
        }
        if (!(initializer instanceof FirComponentCall)) {
            return;
        }
        KtSingleValueToken ktSingleValueToken = KtTokens.EQ;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "EQ");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, ktSingleValueToken, 0, 1, false, 10, null);
        if (ktSourceElement2 != null) {
            KtSourceElement it = ktSourceElement2;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), TuplesKt.to(LanguageFeature.EnableNameBasedDestructuringShortForm, context2.getLanguageVersionSettings()), null, 16, null);
        }
        if (this.isMissingInitializer(originalDestructuringDeclarationOrInitializer)) {
            return;
        }
        KtSourceElement ktSourceElement3 = originalDestructuringDeclarationOrInitializer.getSource();
        if (ktSourceElement3 == null) {
            return;
        }
        KtSourceElement originalDestructuringDeclarationOrInitializerSource = ktSourceElement3;
        FirElement bl = originalDestructuringDeclarationOrInitializer;
        ConeKotlinType coneKotlinType = bl instanceof FirVariable ? FirTypeUtilsKt.getConeType(((FirVariable)originalDestructuringDeclarationOrInitializer).getReturnTypeRef()) : (bl instanceof FirExpression ? FirTypeUtilsKt.getResolvedType((FirExpression)originalDestructuringDeclarationOrInitializer) : null);
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType originalDestructuringDeclarationType = coneKotlinType;
        FirNamedReference reference2 = ((FirComponentCall)initializer).getCalleeReference();
        ConeDiagnostic coneDiagnostic = diagnostic = FirReferenceUtilsKt.isError(reference2) ? ((FirDiagnosticHolder)((Object)reference2)).getDiagnostic() : null;
        if (diagnostic != null) {
            this.reportGivenDiagnostic(reporter, context2, originalDestructuringDeclarationOrInitializerSource, originalDestructuringDeclarationType, diagnostic, declaration, (FirComponentCall)initializer);
        }
        this.checkComponentTypeMismatch(reporter, context2, originalDestructuringDeclarationOrInitializerSource, declaration, originalDestructuringDeclaration, (FirComponentCall)initializer);
        if (syntax == DestructuringSyntax.ParensShort) {
            this.checkChangingMeaningOfShortSyntax(context2, reporter, declaration, originalDestructuringDeclarationType, ((FirComponentCall)initializer).getComponentIndex(), source);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DestructuringSyntax syntaxKind(KtSourceElement $this$syntaxKind, FirVariable originalDestructuringDeclaration) {
        DestructuringSyntax destructuringSyntax;
        KtSourceElement ktSourceElement = originalDestructuringDeclaration.getSource();
        boolean hasOpeningSquareBracket = (ktSourceElement != null ? this.findSquareBracket(ktSourceElement) : null) != null;
        TokenSet tokenSet = KtTokens.VAL_VAR;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "VAL_VAR");
        boolean hasValVar = FirSourceUtilsKt.getChild$default($this$syntaxKind, tokenSet, 0, 1, false, 10, null) != null;
        boolean bl = hasOpeningSquareBracket;
        if (bl) {
            boolean bl2 = hasValVar;
            if (bl2) {
                destructuringSyntax = DestructuringSyntax.SquareBracketsFull;
                return destructuringSyntax;
            } else {
                if (bl2) throw new NoWhenBranchMatchedException();
                destructuringSyntax = DestructuringSyntax.SquareBracketsShort;
            }
            return destructuringSyntax;
        } else {
            if (bl) throw new NoWhenBranchMatchedException();
            boolean bl3 = hasValVar;
            if (bl3) {
                destructuringSyntax = DestructuringSyntax.ParensFull;
                return destructuringSyntax;
            } else {
                if (bl3) throw new NoWhenBranchMatchedException();
                destructuringSyntax = DestructuringSyntax.ParensShort;
            }
        }
        return destructuringSyntax;
    }

    private final void checkFullFormLanguageFeature(CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source) {
        block1: {
            if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.NameBasedDestructuring)) {
                return;
            }
            TokenSet tokenSet = KtTokens.VAL_VAR;
            Intrinsics.checkNotNullExpressionValue(tokenSet, "VAL_VAR");
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getChild$default(source, tokenSet, 0, 1, false, 10, null);
            if (ktSourceElement == null) break block1;
            KtSourceElement it = ktSourceElement;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), TuplesKt.to(LanguageFeature.NameBasedDestructuring, context2.getLanguageVersionSettings()), null, 16, null);
        }
    }

    public final void checkSquareBracketsLanguageFeature$checkers(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(source, "source");
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.NameBasedDestructuring)) {
            return;
        }
        KtSourceElement lBracket = this.findSquareBracket(source);
        if (lBracket != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)lBracket, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), TuplesKt.to(LanguageFeature.NameBasedDestructuring, context2.getLanguageVersionSettings()), null, 16, null);
        }
    }

    private final KtSourceElement findSquareBracket(KtSourceElement $this$findSquareBracket) {
        KtSourceElement ktSourceElement;
        IElementType iElementType = $this$findSquareBracket.getElementType();
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
            Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "LBRACKET");
            ktSourceElement = FirSourceUtilsKt.getChild$default($this$findSquareBracket, ktSingleValueToken, 0, 1, false, 10, null);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_PARAMETER)) {
            IElementType iElementType2 = KtNodeTypes.DESTRUCTURING_DECLARATION;
            Intrinsics.checkNotNullExpressionValue(iElementType2, "DESTRUCTURING_DECLARATION");
            KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default($this$findSquareBracket, iElementType2, 0, 1, false, 10, null);
            ktSourceElement = ktSourceElement2 != null ? this.findSquareBracket(ktSourceElement2) : null;
        } else {
            ktSourceElement = null;
        }
        return ktSourceElement;
    }

    private final void checkChangingMeaningOfShortSyntax(CheckerContext context2, DiagnosticReporter reporter, FirProperty declaration, ConeKotlinType originalDestructuringDeclarationType, int componentIndex, KtSourceElement source) {
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.DeprecateNameMismatchInShortDestructuringWithParentheses) || LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.EnableNameBasedDestructuringShortForm)) {
            return;
        }
        if (Intrinsics.areEqual(declaration.getName(), SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDESTRUCTURING_SHORT_FORM_UNDERSCORE(), null, 8, null);
            return;
        }
        Name propertyName = this.associatedPropertyName(context2, originalDestructuringDeclarationType, componentIndex);
        if (propertyName == null) {
            if (componentIndex == 1) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDESTRUCTURING_SHORT_FORM_OF_NON_DATA_CLASS(), (Object)originalDestructuringDeclarationType, (Object)declaration.getName(), null, 32, null);
            }
        } else if (!Intrinsics.areEqual(propertyName, declaration.getName())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDESTRUCTURING_SHORT_FORM_NAME_MISMATCH(), (Object)declaration.getName(), (Object)propertyName, null, 32, null);
        }
    }

    private final Name associatedPropertyName(CheckerContext context2, ConeKotlinType $this$associatedPropertyName, int componentIndex) {
        Name name2;
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, $this$associatedPropertyName));
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$isData$iv = classSymbol;
        boolean $i$f$isData = false;
        if ($this$isData$iv.getRawStatus().isData()) {
            FirConstructorSymbol constructor;
            Object object;
            Object v1;
            block10: {
                Iterable $this$firstOrNull$iv = FirScopeKt.getDeclaredConstructors(FirHelpersKt.declaredMemberScope(context2, classSymbol));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                    boolean bl = false;
                    if (!it.isPrimary()) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            name2 = (object = (constructor = (FirConstructorSymbol)v1)) != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null && (object = (FirValueParameterSymbol)CollectionsKt.getOrNull(object, componentIndex - 1)) != null ? ((FirVariableSymbol)object).getName() : null;
        } else if (Intrinsics.areEqual(classSymbol.getClassId(), StandardClassIds.INSTANCE.getMapEntry())) {
            switch (componentIndex) {
                case 1: {
                    name2 = StandardNames.MAP_ENTRY_KEY;
                    break;
                }
                case 2: {
                    name2 = StandardNames.MAP_ENTRY_VALUE;
                    break;
                }
                default: {
                    name2 = null;
                    break;
                }
            }
        } else {
            name2 = null;
        }
        return name2;
    }

    private final void checkInitializer(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source, FirExpression initializer) {
        if (this.isMissingInitializer(initializer)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION(), null, 8, null);
        }
    }

    private final boolean isMissingInitializer(FirElement $this$isMissingInitializer) {
        return $this$isMissingInitializer == null || $this$isMissingInitializer instanceof FirErrorExpression && ((FirErrorExpression)$this$isMissingInitializer).getDiagnostic() instanceof ConeSyntaxDiagnostic;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportGivenDiagnostic(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source, ConeKotlinType destructuringDeclarationType, ConeDiagnostic diagnostic, FirProperty property2, FirComponentCall componentCall) {
        ConeDiagnostic coneDiagnostic = diagnostic;
        if (coneDiagnostic instanceof ConeUnresolvedNameError) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeUnresolvedNameError)diagnostic).getName(), (Object)destructuringDeclarationType, null, 32, null);
        } else if (coneDiagnostic instanceof ConeHiddenCandidateError) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeHiddenCandidateError)diagnostic).getCandidate().getCallInfo().getName(), (Object)destructuringDeclarationType, null, 32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableWrongReceiver) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCallCandidate)CollectionsKt.first((Iterable)((ConeInapplicableWrongReceiver)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, null, 32, null);
        } else if (coneDiagnostic instanceof ConeAmbiguityError && CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability())) {
            Collection<FirBasedSymbol<?>> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
            Name name2 = ((ConeAmbiguityError)diagnostic).getName();
            KtDiagnosticFactory3<Name, Collection<FirBasedSymbol<?>>, ConeKotlinType> ktDiagnosticFactory3 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_AMBIGUITY();
            AbstractKtSourceElement abstractKtSourceElement = source;
            DiagnosticReporter diagnosticReporter = reporter;
            DiagnosticContext diagnosticContext2 = context2;
            boolean $i$f$map = false;
            void var11_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory3, (Object)name2, collection, (Object)destructuringDeclarationType, null, 64, null);
        } else if (coneDiagnostic instanceof ConeAmbiguityError) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeAmbiguityError)diagnostic).getName(), (Object)destructuringDeclarationType, null, 32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
            if (ConeTypeUtilsKt.isMarkedNullable(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, destructuringDeclarationType))) {
                DiagnosticContext diagnosticContext3 = context2;
                AbstractKtSourceElement abstractKtSourceElement = source;
                KtDiagnosticFactory2<Name, ConeKotlinType> ktDiagnosticFactory2 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_ON_NULLABLE();
                FirBasedSymbol<?> firBasedSymbol = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol();
                Intrinsics.checkNotNull(firBasedSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
                KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext3, reporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)((FirNamedFunctionSymbol)firBasedSymbol).getCallableId().getCallableName(), (Object)destructuringDeclarationType, null, 32, null);
            } else {
                this.reportDefaultDiagnostics(reporter, context2, diagnostic, componentCall);
            }
        } else if (coneDiagnostic instanceof ConeConstraintSystemHasContradiction) {
            ConeKotlinType componentType = FirTypeUtilsKt.getResolvedType(componentCall);
            if (componentType instanceof ConeErrorType) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCallCandidate)CollectionsKt.first((Iterable)((ConeConstraintSystemHasContradiction)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, null, 32, null);
                return;
            }
        } else if (coneDiagnostic instanceof ConeVisibilityError) {
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(((ConeVisibilityError)diagnostic).getSymbol(), property2.getSource(), context2.getSession()), context2);
        } else {
            this.reportDefaultDiagnostics(reporter, context2, diagnostic, componentCall);
        }
    }

    private final void checkComponentTypeMismatch(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source, FirProperty property2, FirVariable destructuringDeclaration, FirComponentCall componentCall) {
        ConeKotlinType componentType = FirTypeUtilsKt.getResolvedType(componentCall);
        ConeKotlinType expectedType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)componentType, (KotlinTypeMarker)expectedType, false, 8, null)) {
            KtSourceElement typeMismatchSource = destructuringDeclaration instanceof FirValueParameter ? property2.getSource() : source;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeMismatchSource, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_RETURN_TYPE_MISMATCH(), (Object)componentCall.getCalleeReference().getName(), (Object)componentType, (Object)expectedType, null, 64, null);
        }
    }

    private final void reportDefaultDiagnostics(DiagnosticReporter reporter, CheckerContext context2, ConeDiagnostic diagnostic, FirComponentCall componentCall) {
        for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics$default(diagnostic, context2.getSession(), componentCall.getSource(), null, null, 8, null)) {
            reporter.report(coneDiagnostic, context2);
        }
    }

    private final FirQualifiedAccessExpression getExplicitReceiverOfQualifiedAccess(FirExpression $this$explicitReceiverOfQualifiedAccess) {
        FirExpression firExpression = $this$explicitReceiverOfQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$explicitReceiverOfQualifiedAccess : null;
        FirExpression firExpression2 = firExpression != null && (firExpression = firExpression.getExplicitReceiver()) != null ? this.getUnwrapped(firExpression) : null;
        return firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
    }

    private final FirExpression getUnwrapped(FirExpression $this$unwrapped) {
        FirExpression firExpression = $this$unwrapped;
        return firExpression instanceof FirSmartCastExpression ? ((FirSmartCastExpression)$this$unwrapped).getOriginalExpression() : (firExpression instanceof FirWrappedExpression ? ((FirWrappedExpression)$this$unwrapped).getExpression() : $this$unwrapped);
    }

    private final FirVariable getResolvedVariable(FirQualifiedAccessExpression $this$resolvedVariable) {
        FirVariableSymbol firVariableSymbol = FirReferenceUtilsKt.toResolvedVariableSymbol$default($this$resolvedVariable.getCalleeReference(), false, 1, null);
        if (firVariableSymbol == null) {
            return null;
        }
        FirVariableSymbol symbol = firVariableSymbol;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(symbol, FirResolvePhase.BODY_RESOLVE);
        return (FirVariable)symbol.getFir();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$DestructuringSyntax;", "", "<init>", "(Ljava/lang/String;I)V", "ParensShort", "ParensFull", "SquareBracketsShort", "SquareBracketsFull", "checkers"})
    private static final class DestructuringSyntax
    extends Enum<DestructuringSyntax> {
        public static final /* enum */ DestructuringSyntax ParensShort = new DestructuringSyntax();
        public static final /* enum */ DestructuringSyntax ParensFull = new DestructuringSyntax();
        public static final /* enum */ DestructuringSyntax SquareBracketsShort = new DestructuringSyntax();
        public static final /* enum */ DestructuringSyntax SquareBracketsFull = new DestructuringSyntax();
        private static final /* synthetic */ DestructuringSyntax[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DestructuringSyntax[] values() {
            return (DestructuringSyntax[])$VALUES.clone();
        }

        public static DestructuringSyntax valueOf(String value2) {
            return Enum.valueOf(DestructuringSyntax.class, value2);
        }

        @NotNull
        public static EnumEntries<DestructuringSyntax> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = destructuringSyntaxArray = new DestructuringSyntax[]{DestructuringSyntax.ParensShort, DestructuringSyntax.ParensFull, DestructuringSyntax.SquareBracketsShort, DestructuringSyntax.SquareBracketsFull};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

