/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class ArgumentListNode
extends Node {
    public ObjectList<Node> items = new ObjectList(1);
    public ObjectList<TypeInfo> expected_types;
    public ByteList decl_styles;
    public boolean is_bracket_selector = false;

    public ArgumentListNode(Node item, int pos) {
        super(pos);
        this.items.add(item);
    }

    @Override
    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    public int size() {
        return this.items.size();
    }

    @Override
    public int pos() {
        return this.items.size() != 0 ? this.items.last().pos() : 0;
    }

    @Override
    public boolean isLiteralInteger() {
        return this.items.size() == 1 && this.items.first().isLiteralInteger();
    }

    @Override
    public String toString() {
        return "ArgumentList";
    }

    public void addType(TypeInfo type) {
        if (this.expected_types == null) {
            this.expected_types = new ObjectList(2);
        }
        this.expected_types.push_back(type);
    }

    public void addDeclStyle(int style) {
        if (this.decl_styles == null) {
            this.decl_styles = new ByteList(2);
        }
        this.decl_styles.push_back((byte)style);
    }

    @Override
    public boolean hasSideEffect() {
        for (Node n : this.items) {
            if (!n.hasSideEffect()) continue;
            return true;
        }
        return false;
    }
}

