//! Expose all known instructions as Rust `struct`s; this is generated in
//! `build.rs`.
//!
//! See also: [`Inst`], an `enum` containing all these instructions.

use crate::Fixed;
use crate::api::{AsReg, CodeSink, KnownOffsetTable, RegisterVisitor, Registers, TrapCode};
use crate::gpr::{self, Gpr, Size};
use crate::imm::{Extension, Imm8, Imm16, Imm32, Imm64, Simm8, Simm32};
use crate::mem::{Amode, GprMem, XmmMem};
use crate::rex::RexPrefix;
use crate::vex::VexPrefix;
use crate::xmm::Xmm;

// Include code generated by the `meta` crate.
include!(concat!(env!("OUT_DIR"), "/assembler.rs"));
