/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.metrics.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class RollupResponseTranslator {
    public static SearchResponse verifyResponse(MultiSearchResponse.Item normalResponse) throws Exception {
        if (normalResponse.isFailure()) {
            throw normalResponse.getFailure();
        }
        return normalResponse.getResponse();
    }

    public static SearchResponse translateResponse(MultiSearchResponse mSearchResponse, AggregationReduceContext.Builder reduceContextBuilder) throws Exception {
        MultiSearchResponse.Item[] rolledMsearch = mSearchResponse.getResponses();
        assert (rolledMsearch.length > 0);
        ArrayList<SearchResponse> responses = new ArrayList<SearchResponse>();
        for (MultiSearchResponse.Item item : rolledMsearch) {
            if (item.isFailure()) {
                Exception e = item.getFailure();
                if (e instanceof IndexNotFoundException) {
                    throw new ResourceNotFoundException("Index [" + ((IndexNotFoundException)e).getIndex().getName() + "] was not found, likely because it was deleted while the request was in-flight. Rollup does not support partial search results, please try the request again.", new Object[0]);
                }
                throw e;
            }
            responses.add(item.getResponse());
        }
        assert (responses.size() > 0);
        return RollupResponseTranslator.doCombineResponse(null, responses, reduceContextBuilder);
    }

    public static SearchResponse combineResponses(MultiSearchResponse mSearchResponse, AggregationReduceContext.Builder reduceContextBuilder) throws Exception {
        MultiSearchResponse.Item[] msearchResponses = mSearchResponse.getResponses();
        assert (msearchResponses.length >= 2);
        boolean first = true;
        SearchResponse liveResponse = null;
        ArrayList<SearchResponse> rolledResponses = new ArrayList<SearchResponse>();
        for (MultiSearchResponse.Item item : msearchResponses) {
            if (item.isFailure()) {
                Exception e = item.getFailure();
                if (e instanceof IndexNotFoundException) {
                    throw new ResourceNotFoundException("Index [" + String.valueOf(((IndexNotFoundException)e).getIndex()) + "] was not found, likely because it was deleted while the request was in-flight. Rollup does not support partial search results, please try the request again.", (Throwable)e, new Object[0]);
                }
                throw e;
            }
            if (first) {
                liveResponse = item.getResponse();
            } else {
                rolledResponses.add(item.getResponse());
            }
            first = false;
        }
        if (rolledResponses.isEmpty() && liveResponse != null) {
            liveResponse.mustIncRef();
            return liveResponse;
        }
        if (rolledResponses.isEmpty()) {
            throw new ResourceNotFoundException("No indices (live or rollup) found during rollup search", new Object[0]);
        }
        return RollupResponseTranslator.doCombineResponse(liveResponse, rolledResponses, reduceContextBuilder);
    }

    private static SearchResponse doCombineResponse(SearchResponse liveResponse, List<SearchResponse> rolledResponses, AggregationReduceContext.Builder reduceContextBuilder) {
        InternalAggregations liveAggs = liveResponse != null ? liveResponse.getAggregations() : InternalAggregations.EMPTY;
        int missingRollupAggs = rolledResponses.stream().mapToInt(searchResponse -> {
            if (searchResponse == null || searchResponse.getAggregations() == null || searchResponse.getAggregations().asList().size() == 0) {
                return 1;
            }
            return 0;
        }).sum();
        if (missingRollupAggs == rolledResponses.size()) {
            return RollupResponseTranslator.mergeFinalResponse(liveResponse, rolledResponses, InternalAggregations.EMPTY);
        }
        if (missingRollupAggs > 0 && missingRollupAggs != rolledResponses.size()) {
            throw new RuntimeException("Expected to find aggregations in rollup response, but none found.");
        }
        InternalAggregations currentTree = InternalAggregations.EMPTY;
        AggregationReduceContext finalReduceContext = reduceContextBuilder.forFinalReduction();
        for (SearchResponse rolledResponse : rolledResponses) {
            ArrayList<InternalAggregation> unrolledAggs = new ArrayList<InternalAggregation>(rolledResponse.getAggregations().asList().size());
            for (Aggregation agg : rolledResponse.getAggregations()) {
                if (!(agg instanceof InternalFilter)) {
                    throw new RuntimeException("Expected [" + agg.getName() + "] to be a FilterAggregation, but was [" + agg.getClass().getSimpleName() + "]");
                }
                unrolledAggs.addAll(RollupResponseTranslator.unrollAgg(((InternalFilter)agg).getAggregations(), liveAggs, currentTree));
            }
            InternalAggregations finalUnrolledAggs = InternalAggregations.from(unrolledAggs);
            currentTree = InternalAggregations.reduce(Arrays.asList(currentTree, finalUnrolledAggs), (AggregationReduceContext)finalReduceContext);
        }
        if (liveAggs.asList().size() != 0) {
            currentTree = InternalAggregations.reduce(Arrays.asList(currentTree, liveAggs), (AggregationReduceContext)finalReduceContext);
        }
        return RollupResponseTranslator.mergeFinalResponse(liveResponse, rolledResponses, currentTree);
    }

    private static SearchResponse mergeFinalResponse(SearchResponse liveResponse, List<SearchResponse> rolledResponses, InternalAggregations aggs) {
        int totalShards = rolledResponses.stream().mapToInt(SearchResponse::getTotalShards).sum();
        int sucessfulShards = rolledResponses.stream().mapToInt(SearchResponse::getSuccessfulShards).sum();
        int skippedShards = rolledResponses.stream().mapToInt(SearchResponse::getSkippedShards).sum();
        long took = rolledResponses.stream().mapToLong(r -> r.getTook().getMillis()).sum();
        boolean isTimedOut = rolledResponses.stream().anyMatch(SearchResponse::isTimedOut);
        boolean isTerminatedEarly = rolledResponses.stream().filter(r -> r.isTerminatedEarly() != null).anyMatch(SearchResponse::isTerminatedEarly);
        int numReducePhases = rolledResponses.stream().mapToInt(SearchResponse::getNumReducePhases).sum();
        if (liveResponse != null) {
            totalShards += liveResponse.getTotalShards();
            sucessfulShards += liveResponse.getSuccessfulShards();
            skippedShards += liveResponse.getSkippedShards();
            took = Math.max(took, liveResponse.getTook().getMillis());
            isTimedOut = isTimedOut && liveResponse.isTimedOut();
            isTerminatedEarly = isTerminatedEarly && liveResponse.isTerminatedEarly() != false;
            numReducePhases += liveResponse.getNumReducePhases();
        }
        return new SearchResponse(SearchHits.EMPTY_WITH_TOTAL_HITS, aggs, null, isTimedOut, Boolean.valueOf(isTerminatedEarly), null, numReducePhases, null, totalShards, sucessfulShards, skippedShards, took, ShardSearchFailure.EMPTY_ARRAY, rolledResponses.get(0).getClusters());
    }

    private static List<InternalAggregation> unrollAgg(InternalAggregations rolled, InternalAggregations original, InternalAggregations currentTree) {
        return rolled.asList().stream().filter(subAgg -> !subAgg.getName().endsWith("._count")).map(agg -> {
            long count = -1L;
            if (!(agg instanceof InternalMultiBucketAggregation)) {
                count = RollupResponseTranslator.getAggCount((Aggregation)agg, rolled);
            }
            return RollupResponseTranslator.unrollAgg(agg, original.get(agg.getName()), currentTree.get(agg.getName()), count);
        }).collect(Collectors.toList());
    }

    protected static InternalAggregation unrollAgg(InternalAggregation rolled, InternalAggregation originalAgg, InternalAggregation currentTree, long count) {
        if (rolled instanceof InternalMultiBucketAggregation) {
            return RollupResponseTranslator.unrollMultiBucket((InternalMultiBucketAggregation)rolled, (InternalMultiBucketAggregation)originalAgg, (InternalMultiBucketAggregation)currentTree);
        }
        if (rolled instanceof InternalNumericMetricsAggregation.SingleValue) {
            return RollupResponseTranslator.unrollMetric((InternalNumericMetricsAggregation.SingleValue)rolled, count);
        }
        throw new RuntimeException("Unable to unroll aggregation tree.  Aggregation [" + rolled.getName() + "] is of type [" + rolled.getClass().getSimpleName() + "] which is currently unsupported.");
    }

    private static InternalAggregation unrollMultiBucket(InternalMultiBucketAggregation rolled, InternalMultiBucketAggregation original, InternalMultiBucketAggregation currentTree) {
        if (rolled instanceof InternalDateHistogram) {
            return RollupResponseTranslator.unrollMultiBucket(rolled, original, currentTree, (bucket, bucketCount, subAggs) -> {
                long key = ((InternalDateHistogram)rolled).getKey((MultiBucketsAggregation.Bucket)bucket).longValue();
                DocValueFormat formatter = ((InternalDateHistogram.Bucket)bucket).getFormatter();
                assert (bucketCount >= 0L);
                return new InternalDateHistogram.Bucket(key, bucketCount.longValue(), ((InternalDateHistogram.Bucket)bucket).getKeyed(), formatter, subAggs);
            });
        }
        if (rolled instanceof InternalHistogram) {
            return RollupResponseTranslator.unrollMultiBucket(rolled, original, currentTree, (bucket, bucketCount, subAggs) -> {
                long key = ((InternalHistogram)rolled).getKey((MultiBucketsAggregation.Bucket)bucket).longValue();
                DocValueFormat formatter = ((InternalHistogram.Bucket)bucket).getFormatter();
                assert (bucketCount >= 0L);
                return new InternalHistogram.Bucket((double)key, bucketCount.longValue(), ((InternalHistogram.Bucket)bucket).getKeyed(), formatter, subAggs);
            });
        }
        if (rolled instanceof StringTerms) {
            return RollupResponseTranslator.unrollMultiBucket(rolled, original, currentTree, (bucket, bucketCount, subAggs) -> {
                BytesRef key = new BytesRef(bucket.getKeyAsString().getBytes(StandardCharsets.UTF_8));
                assert (bucketCount >= 0L);
                return new StringTerms.Bucket(key, bucketCount.longValue(), subAggs, false, 0L, DocValueFormat.RAW);
            });
        }
        if (rolled instanceof LongTerms) {
            return RollupResponseTranslator.unrollMultiBucket(rolled, original, currentTree, (bucket, bucketCount, subAggs) -> {
                long key = (Long)bucket.getKey();
                assert (bucketCount >= 0L);
                return new LongTerms.Bucket(key, bucketCount.longValue(), subAggs, false, 0L, DocValueFormat.RAW);
            });
        }
        throw new RuntimeException("Unable to unroll aggregation tree.  Aggregation [" + rolled.getName() + "] is of type [" + rolled.getClass().getSimpleName() + "] which is currently unsupported.");
    }

    private static <A extends InternalMultiBucketAggregation<A, B>, B extends InternalMultiBucketAggregation.InternalBucket, T extends InternalMultiBucketAggregation<A, B>> InternalAggregation unrollMultiBucket(T source, T original, T currentTree, TriFunction<InternalMultiBucketAggregation.InternalBucket, Long, InternalAggregations, B> bucketFactory) {
        HashMap originalKeys = new HashMap();
        HashMap currentKeys = new HashMap();
        if (original != null) {
            original.getBuckets().forEach(b -> originalKeys.put(b.getKey(), b));
        }
        if (currentTree != null) {
            currentTree.getBuckets().forEach(b -> currentKeys.put(b.getKey(), b));
        }
        List buckets = source.getBuckets().stream().filter(b -> !originalKeys.containsKey(b.getKey())).map(bucket -> {
            long bucketCount = RollupResponseTranslator.getAggCount((Aggregation)source, bucket.getAggregations());
            if (bucketCount == 0L) {
                return null;
            }
            if (currentKeys.containsKey(bucket.getKey()) && ((InternalMultiBucketAggregation.InternalBucket)currentKeys.get(bucket.getKey())).getDocCount() != 0L) {
                bucketCount = 0L;
            }
            InternalAggregations subAggs = RollupResponseTranslator.unrollSubAggsFromMulti(bucket, (InternalMultiBucketAggregation.InternalBucket)originalKeys.get(bucket.getKey()), (InternalMultiBucketAggregation.InternalBucket)currentKeys.get(bucket.getKey()));
            return (InternalMultiBucketAggregation.InternalBucket)bucketFactory.apply(bucket, (Object)bucketCount, (Object)subAggs);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return source.create(buckets);
    }

    private static InternalAggregations unrollSubAggsFromMulti(InternalMultiBucketAggregation.InternalBucket bucket, InternalMultiBucketAggregation.InternalBucket original, InternalMultiBucketAggregation.InternalBucket currentTree) {
        return InternalAggregations.from(bucket.getAggregations().asList().stream().filter(subAgg -> !subAgg.getName().endsWith("._count")).map(subAgg -> {
            long count = RollupResponseTranslator.getAggCount((Aggregation)subAgg, bucket.getAggregations());
            InternalAggregation originalSubAgg = null;
            if (original != null && original.getAggregations() != null) {
                originalSubAgg = original.getAggregations().get(subAgg.getName());
            }
            InternalAggregation currentSubAgg = null;
            if (currentTree != null && currentTree.getAggregations() != null) {
                currentSubAgg = currentTree.getAggregations().get(subAgg.getName());
            }
            return RollupResponseTranslator.unrollAgg(subAgg, originalSubAgg, currentSubAgg, count);
        }).collect(Collectors.toList()));
    }

    private static InternalAggregation unrollMetric(InternalNumericMetricsAggregation.SingleValue metric, long count) {
        if (metric instanceof Max || metric instanceof Min) {
            return metric;
        }
        if (metric instanceof Sum) {
            if (count != -1L) {
                return new InternalAvg(metric.getName().replace(".value", ""), metric.value(), count, DocValueFormat.RAW, metric.getMetadata());
            }
            return metric;
        }
        throw new RuntimeException("Unable to unroll metric.  Aggregation [" + metric.getName() + "] is of type [" + metric.getClass().getSimpleName() + "] which is currently unsupported.");
    }

    private static long getAggCount(Aggregation agg, InternalAggregations aggregations) {
        String countPath = null;
        if (agg.getType().equals("date_histogram") || agg.getType().equals("histogram") || agg.getType().equals("sterms") || agg.getType().equals("lterms")) {
            countPath = RollupField.formatCountAggName((String)agg.getName());
        } else if (agg.getType().equals("sum")) {
            countPath = RollupField.formatCountAggName((String)agg.getName().replace(".value", ""));
        }
        if (countPath != null && aggregations.get(countPath) != null) {
            assert (aggregations.get(countPath) instanceof Sum);
            return (long)((Sum)aggregations.get(countPath)).value();
        }
        return -1L;
    }
}

