/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchServiceSettings;

public class AlibabaCloudSearchEmbeddingsServiceSettings
implements ServiceSettings {
    public static final String NAME = "alibabacloud_search_embeddings_service_settings";
    private final AlibabaCloudSearchServiceSettings commonSettings;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;

    public static AlibabaCloudSearchEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        AlibabaCloudSearchServiceSettings commonServiceSettings = AlibabaCloudSearchServiceSettings.fromMap(map, context);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AlibabaCloudSearchEmbeddingsServiceSettings(commonServiceSettings, similarity, dims, maxInputTokens);
    }

    public AlibabaCloudSearchEmbeddingsServiceSettings(AlibabaCloudSearchServiceSettings commonSettings, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens) {
        this.commonSettings = commonSettings;
        this.similarity = similarity;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
    }

    public AlibabaCloudSearchEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.commonSettings = new AlibabaCloudSearchServiceSettings(in);
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.dimensions = in.readOptionalVInt();
        this.maxInputTokens = in.readOptionalVInt();
    }

    public AlibabaCloudSearchServiceSettings getCommonSettings() {
        return this.commonSettings;
    }

    public SimilarityMeasure getSimilarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public Integer getMaxInputTokens() {
        return this.maxInputTokens;
    }

    public String modelId() {
        return this.commonSettings.modelId();
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.commonSettings.toXContentFragment(builder, params);
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        builder.endObject();
        return builder;
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_ALIBABACLOUD_SEARCH_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.commonSettings.writeTo(out);
        out.writeOptionalEnum((Enum)this.similarity);
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalVInt(this.maxInputTokens);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlibabaCloudSearchEmbeddingsServiceSettings that = (AlibabaCloudSearchEmbeddingsServiceSettings)o;
        return Objects.equals(this.commonSettings, that.commonSettings) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens);
    }

    public int hashCode() {
        return Objects.hash(this.commonSettings, this.similarity, this.dimensions, this.maxInputTokens);
    }
}

