/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.elastic;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.elastic.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.external.request.elastic.ElasticInferenceServiceSparseEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsModel;

public class ElasticInferenceServiceSparseEmbeddingsRequest
implements ElasticInferenceServiceRequest {
    private final URI uri;
    private final ElasticInferenceServiceSparseEmbeddingsModel model;
    private final Truncator.TruncationResult truncationResult;
    private final Truncator truncator;

    public ElasticInferenceServiceSparseEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult truncationResult, ElasticInferenceServiceSparseEmbeddingsModel model) {
        this.truncator = truncator;
        this.truncationResult = truncationResult;
        this.model = Objects.requireNonNull(model);
        this.uri = model.uri();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        String requestEntity = Strings.toString((ToXContent)new ElasticInferenceServiceSparseEmbeddingsRequestEntity(this.truncationResult.input()));
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestEntity.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader((Header)new BasicHeader("Content-Type", XContentType.JSON.mediaType()));
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new ElasticInferenceServiceSparseEmbeddingsRequest(this.truncator, truncatedInput, this.model);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }
}

