/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.GetInferenceServicesAction;

public class TransportGetInferenceServicesAction
extends HandledTransportAction<GetInferenceServicesAction.Request, GetInferenceServicesAction.Response> {
    private final InferenceServiceRegistry serviceRegistry;

    @Inject
    public TransportGetInferenceServicesAction(TransportService transportService, ActionFilters actionFilters, InferenceServiceRegistry serviceRegistry) {
        super("cluster:monitor/xpack/inference/services/get", transportService, actionFilters, GetInferenceServicesAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.serviceRegistry = serviceRegistry;
    }

    protected void doExecute(Task task, GetInferenceServicesAction.Request request, ActionListener<GetInferenceServicesAction.Response> listener) {
        if (request.getTaskType() == TaskType.ANY) {
            this.getAllServiceConfigurations(listener);
        } else {
            this.getServiceConfigurationsForTaskType(request.getTaskType(), listener);
        }
    }

    private void getServiceConfigurationsForTaskType(TaskType requestedTaskType, ActionListener<GetInferenceServicesAction.Response> listener) {
        Set<Map.Entry<String, InferenceService>> filteredServices = this.serviceRegistry.getServices().entrySet().stream().filter(service -> ((InferenceService)service.getValue()).hideFromConfigurationApi() == false && ((InferenceService)service.getValue()).supportedTaskTypes().contains(requestedTaskType)).collect(Collectors.toSet());
        this.getServiceConfigurationsForServices(filteredServices, (ActionListener<List<InferenceServiceConfiguration>>)listener.delegateFailureAndWrap((delegate, configurations) -> delegate.onResponse((Object)new GetInferenceServicesAction.Response(configurations))));
    }

    private void getAllServiceConfigurations(ActionListener<GetInferenceServicesAction.Response> listener) {
        Set<Map.Entry<String, InferenceService>> availableServices = this.serviceRegistry.getServices().entrySet().stream().filter(service -> ((InferenceService)service.getValue()).hideFromConfigurationApi() == false).collect(Collectors.toSet());
        this.getServiceConfigurationsForServices(availableServices, (ActionListener<List<InferenceServiceConfiguration>>)listener.delegateFailureAndWrap((delegate, configurations) -> delegate.onResponse((Object)new GetInferenceServicesAction.Response(configurations))));
    }

    private void getServiceConfigurationsForServices(Set<Map.Entry<String, InferenceService>> services, ActionListener<List<InferenceServiceConfiguration>> listener) {
        try {
            ArrayList<InferenceServiceConfiguration> serviceConfigurations = new ArrayList<InferenceServiceConfiguration>();
            for (Map.Entry<String, InferenceService> service : services) {
                serviceConfigurations.add(service.getValue().getConfiguration());
            }
            listener.onResponse(serviceConfigurations.stream().toList());
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

