/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.DataStreamDeprecationChecks;
import org.elasticsearch.xpack.deprecation.IndexDeprecationChecks;
import org.elasticsearch.xpack.deprecation.NodeDeprecationChecks;

public class DeprecationChecks {
    public static final Setting<List<String>> SKIP_DEPRECATIONS_SETTING = Setting.stringListSetting((String)"deprecation.skip_deprecated_settings", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static List<Function<ClusterState, DeprecationIssue>> CLUSTER_SETTINGS_CHECKS = List.of();
    static final List<NodeDeprecationCheck<Settings, PluginsAndModules, ClusterState, XPackLicenseState, DeprecationIssue>> NODE_SETTINGS_CHECKS = List.of(NodeDeprecationChecks::checkMultipleDataPaths, NodeDeprecationChecks::checkDataPathsList, NodeDeprecationChecks::checkSharedDataPathSetting, NodeDeprecationChecks::checkReservedPrefixedRealmNames, NodeDeprecationChecks::checkSingleDataNodeWatermarkSetting, NodeDeprecationChecks::checkExporterUseIngestPipelineSettings, NodeDeprecationChecks::checkExporterPipelineMasterTimeoutSetting, NodeDeprecationChecks::checkExporterCreateLegacyTemplateSetting, NodeDeprecationChecks::checkMonitoringSettingHistoryDuration, NodeDeprecationChecks::checkMonitoringSettingHistoryDuration, NodeDeprecationChecks::checkMonitoringSettingCollectIndexRecovery, NodeDeprecationChecks::checkMonitoringSettingCollectIndices, NodeDeprecationChecks::checkMonitoringSettingCollectCcrTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectEnrichStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectIndexRecoveryStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectIndexStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectMlJobStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectNodeStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectClusterStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersHost, NodeDeprecationChecks::checkMonitoringSettingExportersBulkTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersConnectionTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersConnectionReadTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersAuthUsername, NodeDeprecationChecks::checkMonitoringSettingExportersAuthPass, NodeDeprecationChecks::checkMonitoringSettingExportersSSL, NodeDeprecationChecks::checkMonitoringSettingExportersProxyBase, NodeDeprecationChecks::checkMonitoringSettingExportersSniffEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersHeaders, NodeDeprecationChecks::checkMonitoringSettingExportersTemplateTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersMasterTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersType, NodeDeprecationChecks::checkMonitoringSettingExportersAlertsEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersAlertsBlacklist, NodeDeprecationChecks::checkMonitoringSettingExportersIndexNameTimeFormat, NodeDeprecationChecks::checkMonitoringSettingDecommissionAlerts, NodeDeprecationChecks::checkMonitoringSettingEsCollectionEnabled, NodeDeprecationChecks::checkMonitoringSettingCollectionEnabled, NodeDeprecationChecks::checkMonitoringSettingCollectionInterval, NodeDeprecationChecks::checkScriptContextCache, NodeDeprecationChecks::checkScriptContextCompilationsRateLimitSetting, NodeDeprecationChecks::checkScriptContextCacheSizeSetting, NodeDeprecationChecks::checkScriptContextCacheExpirationSetting, NodeDeprecationChecks::checkEnforceDefaultTierPreferenceSetting, NodeDeprecationChecks::checkLifecyleStepMasterTimeoutSetting, NodeDeprecationChecks::checkEqlEnabledSetting, NodeDeprecationChecks::checkNodeAttrData, NodeDeprecationChecks::checkWatcherBulkConcurrentRequestsSetting);
    static List<BiFunction<IndexMetadata, ClusterState, DeprecationIssue>> INDEX_SETTINGS_CHECKS = List.of(IndexDeprecationChecks::oldIndicesCheck, IndexDeprecationChecks::translogRetentionSettingCheck, IndexDeprecationChecks::checkIndexDataPath, IndexDeprecationChecks::storeTypeSettingCheck, IndexDeprecationChecks::frozenIndexSettingCheck, IndexDeprecationChecks::deprecatedCamelCasePattern, IndexDeprecationChecks::checkSourceModeInMapping);
    static List<BiFunction<DataStream, ClusterState, DeprecationIssue>> DATA_STREAM_CHECKS = List.of(DataStreamDeprecationChecks::oldIndicesCheck);

    private DeprecationChecks() {
    }

    static <T> List<DeprecationIssue> filterChecks(List<T> checks, Function<T, DeprecationIssue> mapper) {
        return checks.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface NodeDeprecationCheck<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

