/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityParams;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponseStream;
import org.elasticsearch.repositories.blobstore.testkit.integrity.TransportRepositoryVerifyIntegrityCoordinationAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;

@ServerlessScope(value=Scope.INTERNAL)
public class RestRepositoryVerifyIntegrityAction
extends BaseRestHandler {
    public static final NodeFeature REPOSITORY_VERIFY_INTEGRITY_FEATURE = new NodeFeature("snapshot.repository_verify_integrity");

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_snapshot/{repository}/_verify_integrity"));
    }

    public String getName() {
        return "repository_verify_integrity";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        RepositoryVerifyIntegrityParams requestParams = new RepositoryVerifyIntegrityParams(request);
        return channel -> {
            RepositoryVerifyIntegrityResponseStream responseStream = new RepositoryVerifyIntegrityResponseStream((RestChannel)channel);
            new RestCancellableNodeClient(client, request.getHttpChannel()).execute(TransportRepositoryVerifyIntegrityCoordinationAction.INSTANCE, (ActionRequest)new TransportRepositoryVerifyIntegrityCoordinationAction.Request(requestParams, responseStream), responseStream.getCompletionListener());
        };
    }
}

