/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class RescorerBuilder<RB extends RescorerBuilder<RB>>
implements VersionedNamedWriteable,
ToXContentObject,
Rewriteable<RescorerBuilder<RB>> {
    public static final int DEFAULT_WINDOW_SIZE = 10;
    protected Integer windowSize;
    private static final ParseField WINDOW_SIZE_FIELD = new ParseField("window_size", new String[0]);

    public RescorerBuilder() {
    }

    protected RescorerBuilder(StreamInput in) throws IOException {
        this.windowSize = in.readOptionalVInt();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.windowSize);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public RB windowSize(int windowSize) {
        this.windowSize = windowSize;
        return (RB)this;
    }

    public Integer windowSize() {
        return this.windowSize;
    }

    public static RescorerBuilder<?> parseFromXContent(XContentParser parser, Consumer<String> rescorerNameConsumer) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        RescorerBuilder rescorer = null;
        Integer windowSize = null;
        String rescorerType = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (WINDOW_SIZE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    windowSize = parser.intValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "rescore doesn't support [" + fieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName == null) continue;
                rescorer = (RescorerBuilder)parser.namedObject(RescorerBuilder.class, fieldName, null);
                rescorerNameConsumer.accept(fieldName);
                rescorerType = fieldName;
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + String.valueOf(token) + "] after [" + fieldName + "]", new Object[0]);
        }
        if (rescorer == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing rescore type", new Object[0]);
        }
        if (windowSize != null) {
            rescorer.windowSize(windowSize);
        } else if (rescorer.isWindowSizeRequired()) {
            throw new ParsingException(parser.getTokenLocation(), "window_size is required for rescorer of type [" + rescorerType + "]", new Object[0]);
        }
        return rescorer;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.windowSize != null) {
            builder.field("window_size", this.windowSize);
        }
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public ActionRequestValidationException validate(SearchSourceBuilder source, ActionRequestValidationException validationException) {
        return validationException;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    protected boolean isWindowSizeRequired() {
        return false;
    }

    public final RescoreContext buildContext(SearchExecutionContext context) throws IOException {
        if (this.isWindowSizeRequired()) assert (this.windowSize != null);
        int finalWindowSize = this.windowSize == null ? 10 : this.windowSize;
        return this.innerBuildContext(finalWindowSize, context);
    }

    protected abstract RescoreContext innerBuildContext(int var1, SearchExecutionContext var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.windowSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RescorerBuilder other = (RescorerBuilder)obj;
        return Objects.equals(this.windowSize, other.windowSize);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }
}

