/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.sandbox.search.ProfilerCollectorResult;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.MaxScoreCollector;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScriptScoreQuery;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.search.ESToParentBlockJoinQuery;
import org.elasticsearch.lucene.grouping.SinglePassGroupingCollector;
import org.elasticsearch.lucene.grouping.TopFieldGroups;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregatorCollector;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.query.CollectorResult;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.query.PartialHitCountCollector;
import org.elasticsearch.search.query.QueryPhaseCollector;
import org.elasticsearch.search.query.QueryPhaseResult;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.sort.SortAndFormats;

abstract class QueryPhaseCollectorManager
implements CollectorManager<Collector, QueryPhaseResult> {
    private final Weight postFilterWeight;
    private final QueryPhaseCollector.TerminateAfterChecker terminateAfterChecker;
    private final CollectorManager<AggregatorCollector, Void> aggsCollectorManager;
    private final Float minScore;
    private final boolean profile;

    QueryPhaseCollectorManager(Weight postFilterWeight, QueryPhaseCollector.TerminateAfterChecker terminateAfterChecker, CollectorManager<AggregatorCollector, Void> aggsCollectorManager, Float minScore, boolean profile) {
        this.postFilterWeight = postFilterWeight;
        this.terminateAfterChecker = terminateAfterChecker;
        this.aggsCollectorManager = aggsCollectorManager;
        this.minScore = minScore;
        this.profile = profile;
    }

    String getTopDocsProfilerReason() {
        return "search_top_hits";
    }

    abstract DocValueFormat[] getSortValueFormats();

    public final Collector newCollector() throws IOException {
        if (this.profile) {
            InternalProfileCollector topDocsProfileCollector = new InternalProfileCollector(this.newTopDocsCollector(), this.getTopDocsProfilerReason(), new InternalProfileCollector[0]);
            if (this.aggsCollectorManager == null) {
                return new InternalProfileCollector(new QueryPhaseCollector(topDocsProfileCollector, this.postFilterWeight, this.terminateAfterChecker, null, this.minScore), "search_query_phase", topDocsProfileCollector);
            }
            InternalProfileCollector aggsProfileCollector = new InternalProfileCollector(this.aggsCollectorManager.newCollector(), "aggregation", new InternalProfileCollector[0]);
            return new InternalProfileCollector(new QueryPhaseCollector(topDocsProfileCollector, this.postFilterWeight, this.terminateAfterChecker, aggsProfileCollector, this.minScore), "search_query_phase", topDocsProfileCollector, aggsProfileCollector);
        }
        return new QueryPhaseCollector(this.newTopDocsCollector(), this.postFilterWeight, this.terminateAfterChecker, this.aggsCollectorManager == null ? null : this.aggsCollectorManager.newCollector(), this.minScore);
    }

    protected abstract Collector newTopDocsCollector() throws IOException;

    public final QueryPhaseResult reduce(Collection<Collector> collectors) throws IOException {
        boolean terminatedAfter = false;
        CollectorResult collectorResult = null;
        ArrayList<Collector> topDocsCollectors = new ArrayList<Collector>();
        ArrayList<AggregatorCollector> aggsCollectors = new ArrayList<AggregatorCollector>();
        if (this.profile) {
            ArrayList resultsPerProfiler = new ArrayList();
            ArrayList<CollectorResult> topDocsCollectorResults = new ArrayList<CollectorResult>();
            ArrayList<CollectorResult> aggsCollectorResults = new ArrayList<CollectorResult>();
            for (Collector collector : collectors) {
                InternalProfileCollector profileCollector = (InternalProfileCollector)collector;
                resultsPerProfiler.add(profileCollector.getCollectorTree());
                QueryPhaseCollector queryPhaseCollector = (QueryPhaseCollector)profileCollector.getWrappedCollector();
                if (queryPhaseCollector.isTerminatedAfter()) {
                    terminatedAfter = true;
                }
                InternalProfileCollector profileTopDocsCollector = (InternalProfileCollector)queryPhaseCollector.getTopDocsCollector();
                topDocsCollectorResults.add(profileTopDocsCollector.getCollectorTree());
                topDocsCollectors.add(profileTopDocsCollector.getWrappedCollector());
                if (this.aggsCollectorManager == null) continue;
                InternalProfileCollector profileAggsCollector = (InternalProfileCollector)queryPhaseCollector.getAggsCollector();
                aggsCollectorResults.add(profileAggsCollector.getCollectorTree());
                aggsCollectors.add((AggregatorCollector)profileAggsCollector.getWrappedCollector());
            }
            ArrayList<CollectorResult> childrenResults = new ArrayList<CollectorResult>();
            childrenResults.add(QueryPhaseCollectorManager.reduceCollectorResults(topDocsCollectorResults, Collections.emptyList()));
            if (this.aggsCollectorManager != null) {
                childrenResults.add(QueryPhaseCollectorManager.reduceCollectorResults(aggsCollectorResults, Collections.emptyList()));
            }
            collectorResult = QueryPhaseCollectorManager.reduceCollectorResults(resultsPerProfiler, Collections.unmodifiableList(childrenResults));
        } else {
            for (Collector collector : collectors) {
                QueryPhaseCollector queryPhaseCollector = (QueryPhaseCollector)collector;
                topDocsCollectors.add(queryPhaseCollector.getTopDocsCollector());
                aggsCollectors.add((AggregatorCollector)queryPhaseCollector.getAggsCollector());
                if (!queryPhaseCollector.isTerminatedAfter()) continue;
                terminatedAfter = true;
            }
        }
        if (this.aggsCollectorManager != null) {
            this.aggsCollectorManager.reduce(aggsCollectors);
        }
        TopDocsAndMaxScore topDocsAndMaxScore = this.reduceTopDocsCollectors(topDocsCollectors);
        return new QueryPhaseResult(topDocsAndMaxScore, this.getSortValueFormats(), terminatedAfter, collectorResult);
    }

    abstract TopDocsAndMaxScore reduceTopDocsCollectors(Collection<Collector> var1) throws IOException;

    private static CollectorResult reduceCollectorResults(Collection<CollectorResult> collectorResults, List<CollectorResult> children) {
        long totalTime = collectorResults.stream().map(ProfilerCollectorResult::getTime).reduce(0L, Long::sum);
        String collectorName = collectorResults.iterator().next().getName();
        String reason = collectorResults.iterator().next().getReason();
        return new CollectorResult(collectorName, reason, totalTime, children);
    }

    static CollectorManager<Collector, QueryPhaseResult> createQueryPhaseCollectorManager(Weight postFilterWeight, CollectorManager<AggregatorCollector, Void> aggsCollectorManager, SearchContext searchContext, boolean hasFilterCollector) throws IOException {
        QueryPhaseCollector.TerminateAfterChecker terminateAfterChecker = QueryPhaseCollector.resolveTerminateAfterChecker(searchContext.terminateAfter());
        IndexReader reader = searchContext.searcher().getIndexReader();
        Query query = searchContext.rewrittenQuery();
        if (searchContext.size() == 0) {
            return new EmptyHits(postFilterWeight, terminateAfterChecker, aggsCollectorManager, searchContext.minimumScore(), searchContext.getProfilers() != null, searchContext.sort(), searchContext.trackTotalHitsUpTo());
        }
        int totalNumDocs = Math.max(1, reader.numDocs());
        if (searchContext.scrollContext() == null) {
            boolean rescore;
            int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
            boolean bl = rescore = !searchContext.rescore().isEmpty();
            if (rescore) {
                assert (searchContext.sort() == null);
                for (RescoreContext rescoreContext : searchContext.rescore()) {
                    numDocs = Math.max(numDocs, rescoreContext.getWindowSize());
                }
            }
            if (searchContext.collapse() == null) {
                return new WithHits(postFilterWeight, terminateAfterChecker, aggsCollectorManager, searchContext.minimumScore(), searchContext.getProfilers() != null, reader, query, searchContext.sort(), (ScoreDoc)searchContext.searchAfter(), numDocs, searchContext.trackScores(), searchContext.trackTotalHitsUpTo(), hasFilterCollector);
            }
            boolean trackScores = searchContext.sort() == null || searchContext.trackScores();
            return QueryPhaseCollectorManager.forCollapsing(postFilterWeight, terminateAfterChecker, aggsCollectorManager, searchContext.minimumScore(), searchContext.getProfilers() != null, searchContext.collapse(), searchContext.sort(), numDocs, trackScores, searchContext.searchAfter());
        }
        int trackTotalHitsUpTo = searchContext.scrollContext().totalHits != null ? -1 : Integer.MAX_VALUE;
        int numDocs = Math.min(searchContext.size(), totalNumDocs);
        return QueryPhaseCollectorManager.forScroll(postFilterWeight, terminateAfterChecker, aggsCollectorManager, searchContext.minimumScore(), searchContext.getProfilers() != null, reader, query, searchContext.sort(), numDocs, searchContext.trackScores(), trackTotalHitsUpTo, hasFilterCollector, searchContext.scrollContext(), searchContext.numberOfShards());
    }

    private static WithHits forScroll(Weight postFilterWeight, QueryPhaseCollector.TerminateAfterChecker terminateAfterChecker, CollectorManager<AggregatorCollector, Void> aggsCollectorManager, Float minScore, boolean profile, IndexReader reader, Query query, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore, int trackTotalHitsUpTo, boolean hasFilterCollector, final ScrollContext scrollContext, final int numberOfShards) throws IOException {
        return new WithHits(postFilterWeight, terminateAfterChecker, aggsCollectorManager, minScore, profile, reader, query, sortAndFormats, scrollContext.lastEmittedDoc, numHits, trackMaxScore, trackTotalHitsUpTo, hasFilterCollector){

            @Override
            public TopDocsAndMaxScore reduceTopDocsCollectors(Collection<Collector> collectors) throws IOException {
                TopDocsAndMaxScore topDocs = super.reduceTopDocsCollectors(collectors);
                if (scrollContext.totalHits == null) {
                    scrollContext.totalHits = topDocs.topDocs.totalHits;
                    scrollContext.maxScore = topDocs.maxScore;
                } else {
                    topDocs.topDocs.totalHits = scrollContext.totalHits;
                    topDocs.maxScore = scrollContext.maxScore;
                }
                if (numberOfShards == 1 && topDocs.topDocs.scoreDocs.length > 0) {
                    scrollContext.lastEmittedDoc = topDocs.topDocs.scoreDocs[topDocs.topDocs.scoreDocs.length - 1];
                }
                return topDocs;
            }
        };
    }

    private static QueryPhaseCollectorManager forCollapsing(Weight postFilterWeight, QueryPhaseCollector.TerminateAfterChecker terminateAfterChecker, CollectorManager<AggregatorCollector, Void> aggsCollectorManager, Float minScore, boolean profile, CollapseContext collapseContext, final @Nullable SortAndFormats sortAndFormats, int numHits, final boolean trackMaxScore, @Nullable FieldDoc after) {
        assert (numHits > 0);
        assert (collapseContext != null);
        Sort sort = sortAndFormats == null ? Sort.RELEVANCE : sortAndFormats.sort;
        final SinglePassGroupingCollector<?> topDocsCollector = collapseContext.createTopDocs(sort, numHits, after);
        final MaxScoreCollector maxScoreCollector = trackMaxScore ? new MaxScoreCollector() : null;
        return new QueryPhaseCollectorManager(postFilterWeight, terminateAfterChecker, aggsCollectorManager, minScore, profile){
            boolean newCollectorCalled;
            {
                super(postFilterWeight, terminateAfterChecker, (CollectorManager<AggregatorCollector, Void>)aggsCollectorManager, minScore, profile);
                this.newCollectorCalled = false;
            }

            @Override
            protected Collector newTopDocsCollector() {
                assert (!this.newCollectorCalled) : "Field collapsing does not support concurrent execution";
                this.newCollectorCalled = true;
                return MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, maxScoreCollector});
            }

            @Override
            protected TopDocsAndMaxScore reduceTopDocsCollectors(Collection<Collector> collectors) throws IOException {
                assert (collectors.size() == 1) : "Field collapsing does not support concurrent execution";
                TopFieldGroups topDocs = topDocsCollector.getTopGroups(0);
                float maxScore = QueryPhaseCollectorManager.getMaxScore((TopDocs)topDocs, sortAndFormats, trackMaxScore, Collections.singletonList(maxScoreCollector));
                return new TopDocsAndMaxScore((TopDocs)topDocs, maxScore);
            }

            @Override
            protected DocValueFormat[] getSortValueFormats() {
                DocValueFormat[] docValueFormatArray;
                if (sortAndFormats == null) {
                    DocValueFormat[] docValueFormatArray2 = new DocValueFormat[1];
                    docValueFormatArray = docValueFormatArray2;
                    docValueFormatArray2[0] = DocValueFormat.RAW;
                } else {
                    docValueFormatArray = sortAndFormats.formats;
                }
                return docValueFormatArray;
            }
        };
    }

    private static float getMaxScore(TopDocs topDocs, SortAndFormats sortAndFormats, boolean trackMaxScore, Collection<MaxScoreCollector> maxScoreCollectors) {
        if (sortAndFormats == null) {
            return topDocs.scoreDocs.length == 0 ? Float.NaN : topDocs.scoreDocs[0].score;
        }
        if (trackMaxScore) {
            return maxScoreCollectors.stream().map(MaxScoreCollector::getMaxScore).reduce(Float.valueOf(Float.NEGATIVE_INFINITY), (f1, f2) -> {
                if (Float.isNaN(f1.floatValue())) {
                    return f2;
                }
                if (Float.isNaN(f2.floatValue())) {
                    return f1;
                }
                return Float.valueOf(Math.max(f1.floatValue(), f2.floatValue()));
            }).floatValue();
        }
        return Float.NaN;
    }

    static int shortcutTotalHitCount(IndexReader reader, Query query) throws IOException {
        while (true) {
            if (query instanceof ConstantScoreQuery) {
                query = ((ConstantScoreQuery)query).getQuery();
                continue;
            }
            if (!(query instanceof BoostQuery)) break;
            query = ((BoostQuery)query).getQuery();
        }
        if (query.getClass() == MatchAllDocsQuery.class) {
            return reader.numDocs();
        }
        if (query.getClass() == TermQuery.class && !reader.hasDeletions()) {
            Term term = ((TermQuery)query).getTerm();
            int count = 0;
            for (LeafReaderContext context : reader.leaves()) {
                count += context.reader().docFreq(term);
            }
            return count;
        }
        if (query.getClass() == FieldExistsQuery.class && !reader.hasDeletions()) {
            String field = ((FieldExistsQuery)query).getField();
            int count = 0;
            for (LeafReaderContext context : reader.leaves()) {
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                if (fieldInfo == null) continue;
                if (fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                    return -1;
                }
                if (fieldInfo.getPointIndexDimensionCount() > 0) {
                    PointValues points = context.reader().getPointValues(field);
                    if (points == null) continue;
                    count += points.getDocCount();
                    continue;
                }
                if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                    Terms terms = context.reader().terms(field);
                    if (terms == null) continue;
                    count += terms.getDocCount();
                    continue;
                }
                return -1;
            }
            return count;
        }
        return -1;
    }

    static boolean hasInfMaxScore(Query query) {
        MaxScoreQueryVisitor visitor = new MaxScoreQueryVisitor();
        query.visit((QueryVisitor)visitor);
        return visitor.hasInfMaxScore;
    }

    private static final class EmptyHits
    extends QueryPhaseCollectorManager {
        private final PartialHitCountCollector.HitsThresholdChecker hitsThresholdChecker;
        private final SortAndFormats sortAndFormats;

        EmptyHits(Weight postFilterWeight, QueryPhaseCollector.TerminateAfterChecker terminateAfterChecker, CollectorManager<AggregatorCollector, Void> aggsCollectorManager, Float minScore, boolean profile, @Nullable SortAndFormats sortAndFormats, int trackTotalHitsUpTo) {
            super(postFilterWeight, terminateAfterChecker, aggsCollectorManager, minScore, profile);
            this.sortAndFormats = sortAndFormats;
            this.hitsThresholdChecker = new PartialHitCountCollector.HitsThresholdChecker(trackTotalHitsUpTo == -1 ? 0 : trackTotalHitsUpTo);
        }

        protected PartialHitCountCollector newTopDocsCollector() {
            return new PartialHitCountCollector(this.hitsThresholdChecker);
        }

        @Override
        protected TopDocsAndMaxScore reduceTopDocsCollectors(Collection<Collector> collectors) {
            int totalHitCount = 0;
            boolean earlyTerminated = false;
            for (Collector collector : collectors) {
                PartialHitCountCollector partialHitCountCollector = (PartialHitCountCollector)collector;
                totalHitCount += partialHitCountCollector.getTotalHits();
                if (!partialHitCountCollector.hasEarlyTerminated()) continue;
                earlyTerminated = true;
            }
            TotalHits totalHits = new TotalHits((long)totalHitCount, earlyTerminated ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO);
            Object topDocs = this.sortAndFormats != null ? new TopFieldDocs(totalHits, Lucene.EMPTY_SCORE_DOCS, this.sortAndFormats.sort.getSort()) : new TopDocs(totalHits, Lucene.EMPTY_SCORE_DOCS);
            return new TopDocsAndMaxScore((TopDocs)topDocs, Float.NaN);
        }

        @Override
        protected String getTopDocsProfilerReason() {
            return "search_count";
        }

        @Override
        protected DocValueFormat[] getSortValueFormats() {
            return null;
        }
    }

    private static class WithHits
    extends QueryPhaseCollectorManager {
        private final SortAndFormats sortAndFormats;
        private final boolean trackMaxScore;
        private final TotalHits shortcutTotalHits;
        private final CollectorManager<? extends TopDocsCollector<?>, ? extends TopDocs> topDocsManager;

        WithHits(Weight postFilterWeight, QueryPhaseCollector.TerminateAfterChecker terminateAfterChecker, CollectorManager<AggregatorCollector, Void> aggsCollectorManager, Float minScore, boolean profile, IndexReader reader, Query query, @Nullable SortAndFormats sortAndFormats, @Nullable ScoreDoc searchAfter, int numHits, boolean trackMaxScore, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super(postFilterWeight, terminateAfterChecker, aggsCollectorManager, minScore, profile);
            int hitCountThreshold;
            this.sortAndFormats = sortAndFormats;
            this.trackMaxScore = trackMaxScore;
            if ((sortAndFormats == null || SortField.FIELD_SCORE.equals((Object)sortAndFormats.sort.getSort()[0])) && WithHits.hasInfMaxScore(query)) {
                hitCountThreshold = Integer.MAX_VALUE;
                this.shortcutTotalHits = null;
            } else if (trackTotalHitsUpTo == -1) {
                hitCountThreshold = 1;
                this.shortcutTotalHits = Lucene.TOTAL_HITS_GREATER_OR_EQUAL_TO_ZERO;
            } else {
                int hitCount;
                int n = hitCount = hasFilterCollector ? -1 : WithHits.shortcutTotalHitCount(reader, query);
                if (hitCount == -1) {
                    hitCountThreshold = trackTotalHitsUpTo;
                    this.shortcutTotalHits = null;
                } else {
                    hitCountThreshold = 1;
                    this.shortcutTotalHits = new TotalHits((long)hitCount, TotalHits.Relation.EQUAL_TO);
                }
            }
            this.topDocsManager = sortAndFormats == null ? new TopScoreDocCollectorManager(numHits, searchAfter, hitCountThreshold) : new TopFieldCollectorManager(sortAndFormats.sort, numHits, (FieldDoc)searchAfter, hitCountThreshold);
        }

        @Override
        protected Collector newTopDocsCollector() throws IOException {
            if (this.trackMaxScore) {
                return MultiCollector.wrap((Collector[])new Collector[]{this.topDocsManager.newCollector(), new MaxScoreCollector()});
            }
            return this.topDocsManager.newCollector();
        }

        @Override
        protected TopDocsAndMaxScore reduceTopDocsCollectors(Collection<Collector> collectors) throws IOException {
            ArrayList<MaxScoreCollector> maxScoreCollectors;
            ArrayList<TopDocsCollector> topDocsCollectors = new ArrayList<TopDocsCollector>();
            if (this.trackMaxScore) {
                maxScoreCollectors = new ArrayList<MaxScoreCollector>();
                for (Collector collector : collectors) {
                    MultiCollector mc = (MultiCollector)collector;
                    topDocsCollectors.add((TopDocsCollector)mc.getCollectors()[0]);
                    maxScoreCollectors.add((MaxScoreCollector)mc.getCollectors()[1]);
                }
            } else {
                maxScoreCollectors = null;
                for (Collector collector : collectors) {
                    topDocsCollectors.add((TopDocsCollector)collector);
                }
            }
            CollectorManager<? extends TopDocsCollector<?>, ? extends TopDocs> tdcm = this.topDocsManager;
            TopDocs topDocs = (TopDocs)tdcm.reduce(topDocsCollectors);
            if (this.shortcutTotalHits != null) {
                if (topDocs instanceof TopFieldDocs) {
                    TopFieldDocs fieldDocs = (TopFieldDocs)topDocs;
                    topDocs = new TopFieldDocs(this.shortcutTotalHits, fieldDocs.scoreDocs, fieldDocs.fields);
                } else {
                    topDocs = new TopDocs(this.shortcutTotalHits, topDocs.scoreDocs);
                }
            }
            float maxScore = QueryPhaseCollectorManager.getMaxScore(topDocs, this.sortAndFormats, this.trackMaxScore, maxScoreCollectors);
            return new TopDocsAndMaxScore(topDocs, maxScore);
        }

        @Override
        protected final DocValueFormat[] getSortValueFormats() {
            return this.sortAndFormats == null ? null : this.sortAndFormats.formats;
        }
    }

    private static class MaxScoreQueryVisitor
    extends QueryVisitor {
        private boolean hasInfMaxScore;

        private MaxScoreQueryVisitor() {
        }

        public void visitLeaf(Query query) {
            this.checkMaxScoreInfo(query);
        }

        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (occur != BooleanClause.Occur.MUST) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            this.checkMaxScoreInfo(parent);
            return this;
        }

        void checkMaxScoreInfo(Query query) {
            if (query instanceof FunctionScoreQuery || query instanceof ScriptScoreQuery || query instanceof SpanQuery) {
                this.hasInfMaxScore = true;
            } else if (query instanceof ESToParentBlockJoinQuery) {
                ESToParentBlockJoinQuery q = (ESToParentBlockJoinQuery)query;
                this.hasInfMaxScore |= q.getScoreMode() != ScoreMode.None;
            }
        }
    }
}

