/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.dfs.DfsKnnResults;
import org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.dfs.DfsProfiler;
import org.elasticsearch.search.profile.dfs.DfsTimingType;
import org.elasticsearch.search.profile.query.ProfileCollectorManager;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.vectors.KnnSearchBuilder;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.search.vectors.ProfilingQuery;
import org.elasticsearch.tasks.TaskCancelledException;

public class DfsPhase {
    private DfsPhase() {
    }

    public static void execute(SearchContext context) {
        try {
            DfsPhase.collectStatistics(context);
            DfsPhase.executeKnnVectorQuery(context);
            if (context.getProfilers() != null) {
                context.dfsResult().profileResult(context.getProfilers().getDfsProfiler().buildDfsPhaseResults());
            }
        }
        catch (Exception e) {
            throw new DfsPhaseExecutionException(context.shardTarget(), "Exception during dfs phase", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectStatistics(final SearchContext context) throws IOException {
        final DfsProfiler profiler = context.getProfilers() == null ? null : context.getProfilers().getDfsProfiler();
        final HashMap<String, CollectionStatistics> fieldStatistics = new HashMap<String, CollectionStatistics>();
        final HashMap stats = new HashMap();
        IndexSearcher searcher = new IndexSearcher(context.searcher().getIndexReader()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
                if (context.isCancelled()) {
                    throw new TaskCancelledException("cancelled");
                }
                Timer timer = DfsPhase.maybeStartTimer(profiler, DfsTimingType.TERM_STATISTICS);
                try {
                    TermStatistics ts = super.termStatistics(term, docFreq, totalTermFreq);
                    if (ts != null) {
                        stats.put(term, ts);
                    }
                    TermStatistics termStatistics = ts;
                    return termStatistics;
                }
                finally {
                    if (timer != null) {
                        timer.stop();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CollectionStatistics collectionStatistics(String field) throws IOException {
                if (context.isCancelled()) {
                    throw new TaskCancelledException("cancelled");
                }
                Timer timer = DfsPhase.maybeStartTimer(profiler, DfsTimingType.COLLECTION_STATISTICS);
                try {
                    CollectionStatistics cs = super.collectionStatistics(field);
                    if (cs != null) {
                        fieldStatistics.put(field, cs);
                    }
                    CollectionStatistics collectionStatistics = cs;
                    return collectionStatistics;
                }
                finally {
                    if (timer != null) {
                        timer.stop();
                    }
                }
            }
        };
        if (profiler != null) {
            profiler.start();
        }
        try {
            Timer timer = DfsPhase.maybeStartTimer(profiler, DfsTimingType.CREATE_WEIGHT);
            try {
                searcher.createWeight(context.rewrittenQuery(), ScoreMode.COMPLETE, 1.0f);
            }
            finally {
                if (timer != null) {
                    timer.stop();
                }
            }
            for (RescoreContext rescoreContext : context.rescore()) {
                for (ParsedQuery parsedQuery : rescoreContext.getParsedQueries()) {
                    Query rewritten;
                    timer = DfsPhase.maybeStartTimer(profiler, DfsTimingType.REWRITE);
                    try {
                        rewritten = searcher.rewrite(parsedQuery.query());
                    }
                    finally {
                        if (timer != null) {
                            timer.stop();
                        }
                    }
                    timer = DfsPhase.maybeStartTimer(profiler, DfsTimingType.CREATE_WEIGHT);
                    try {
                        searcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                    }
                    finally {
                        if (timer == null) continue;
                        timer.stop();
                    }
                }
            }
        }
        finally {
            if (profiler != null) {
                profiler.stop();
            }
        }
        Term[] terms = stats.keySet().toArray(new Term[0]);
        TermStatistics[] termStatistics = new TermStatistics[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            termStatistics[i] = (TermStatistics)stats.get(terms[i]);
        }
        context.dfsResult().termsStatistics(terms, termStatistics).fieldStatistics(fieldStatistics).maxDoc(context.searcher().getIndexReader().maxDoc());
    }

    private static Timer maybeStartTimer(DfsProfiler profiler, DfsTimingType dtt) {
        if (profiler != null) {
            return profiler.startTimer(dtt);
        }
        return null;
    }

    private static void executeKnnVectorQuery(SearchContext context) throws IOException {
        SearchSourceBuilder source = context.request().source();
        if (source == null || source.knnSearch().isEmpty()) {
            return;
        }
        SearchExecutionContext searchExecutionContext = context.getSearchExecutionContext();
        List<KnnSearchBuilder> knnSearch = source.knnSearch();
        List<KnnVectorQueryBuilder> knnVectorQueryBuilders = knnSearch.stream().map(KnnSearchBuilder::toQueryBuilder).toList();
        knnVectorQueryBuilders.forEach(knnVectorQueryBuilder -> knnVectorQueryBuilder.boost(1.0f));
        if (context.request().getAliasFilter().getQueryBuilder() != null) {
            for (KnnVectorQueryBuilder knnVectorQueryBuilder2 : knnVectorQueryBuilders) {
                knnVectorQueryBuilder2.addFilterQuery(context.request().getAliasFilter().getQueryBuilder());
            }
        }
        ArrayList<DfsKnnResults> knnResults = new ArrayList<DfsKnnResults>(knnVectorQueryBuilders.size());
        for (int i = 0; i < knnSearch.size(); ++i) {
            String knnField = knnVectorQueryBuilders.get(i).getFieldName();
            String knnNestedPath = searchExecutionContext.nestedLookup().getNestedParent(knnField);
            Query knnQuery = searchExecutionContext.toQuery(knnVectorQueryBuilders.get(i)).query();
            knnResults.add(DfsPhase.singleKnnSearch(knnQuery, knnSearch.get(i).k(), context.getProfilers(), context.searcher(), knnNestedPath));
        }
        context.dfsResult().knnResults(knnResults);
    }

    static DfsKnnResults singleKnnSearch(Query knnQuery, int k, Profilers profilers, ContextIndexSearcher searcher, String nestedPath) throws IOException {
        TopDocs topDocs;
        TopScoreDocCollectorManager topDocsCollectorManager = new TopScoreDocCollectorManager(k, null, Integer.MAX_VALUE);
        if (profilers == null) {
            topDocs = (TopDocs)searcher.search(knnQuery, topDocsCollectorManager);
        } else {
            QueryProfiler knnProfiler = profilers.getDfsProfiler().addQueryProfiler();
            searcher.setProfiler(knnProfiler);
            ProfileCollectorManager ipcm = new ProfileCollectorManager(topDocsCollectorManager, "search_top_hits");
            topDocs = (TopDocs)searcher.search(knnQuery, ipcm);
            if (knnQuery instanceof ProfilingQuery) {
                ProfilingQuery profilingQuery = (ProfilingQuery)knnQuery;
                profilingQuery.profile(knnProfiler);
            }
            knnProfiler.setCollectorResult(ipcm.getCollectorTree());
        }
        if (profilers != null) {
            searcher.setProfiler(profilers.getCurrentQueryProfiler());
        }
        return new DfsKnnResults(nestedPath, topDocs.scoreDocs);
    }
}

