/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.RemoteClusterAware;

public final class SearchShardTarget
implements Writeable,
Comparable<SearchShardTarget> {
    private final Text nodeId;
    private final ShardId shardId;
    private final String clusterAlias;

    public SearchShardTarget(StreamInput in) throws IOException {
        this.nodeId = in.readBoolean() ? in.readText() : null;
        this.shardId = new ShardId(in);
        this.clusterAlias = in.readOptionalString();
    }

    public SearchShardTarget(String nodeId, ShardId shardId, @Nullable String clusterAlias) {
        this.nodeId = nodeId == null ? null : new Text(nodeId);
        this.shardId = shardId;
        this.clusterAlias = clusterAlias;
    }

    @Nullable
    public String getNodeId() {
        return this.nodeId != null ? this.nodeId.string() : null;
    }

    public Text getNodeIdText() {
        return this.nodeId;
    }

    public String getIndex() {
        return this.shardId.getIndexName();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public String getFullyQualifiedIndexName() {
        return RemoteClusterAware.buildRemoteIndexName(this.clusterAlias, this.getIndex());
    }

    @Override
    public int compareTo(SearchShardTarget o) {
        int i = this.shardId.getIndexName().compareTo(o.getIndex());
        if (i == 0) {
            i = this.shardId.getId() - o.shardId.id();
        }
        return i;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.nodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeText(this.nodeId);
        }
        this.shardId.writeTo(out);
        out.writeOptionalString(this.clusterAlias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardTarget that = (SearchShardTarget)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.shardId, this.clusterAlias);
    }

    public String toString() {
        String shardToString = "[" + RemoteClusterAware.buildRemoteIndexName(this.clusterAlias, this.shardId.getIndexName()) + "][" + this.shardId.getId() + "]";
        if (this.nodeId == null) {
            return "[_na_]" + shardToString;
        }
        return "[" + String.valueOf(this.nodeId) + "]" + shardToString;
    }
}

