/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class RescoreDocIds
implements Writeable {
    public static final RescoreDocIds EMPTY = new RescoreDocIds(Map.of());
    private final Map<Integer, Set<Integer>> docIds;

    public RescoreDocIds(Map<Integer, Set<Integer>> docIds) {
        this.docIds = docIds;
    }

    public RescoreDocIds(StreamInput in) throws IOException {
        this.docIds = in.readMap(StreamInput::readVInt, i -> i.readCollectionAsSet(StreamInput::readVInt));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.docIds, StreamOutput::writeVInt, (o, v) -> o.writeCollection(v, StreamOutput::writeVInt));
    }

    public Set<Integer> getId(int index) {
        return this.docIds.get(index);
    }
}

