/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.ingest.IngestDocMetadata;
import org.elasticsearch.script.CtxMap;

class IngestCtxMap
extends CtxMap<IngestDocMetadata> {
    IngestCtxMap(String index, String id, long version, String routing, VersionType versionType, ZonedDateTime timestamp, Map<String, Object> source) {
        super(new HashMap<String, Object>(source), new IngestDocMetadata(index, id, version, routing, versionType, timestamp));
    }

    IngestCtxMap(Map<String, Object> source, IngestDocMetadata metadata) {
        super(source, metadata);
    }

    @Override
    protected boolean directSourceAccess() {
        return true;
    }

    public static ZonedDateTime getTimestamp(Map<String, Object> ingestMetadata) {
        if (ingestMetadata == null) {
            return null;
        }
        Object ts = ingestMetadata.get("timestamp");
        if (ts instanceof ZonedDateTime) {
            ZonedDateTime timestamp = (ZonedDateTime)ts;
            return timestamp;
        }
        if (ts instanceof String) {
            String str = (String)ts;
            return ZonedDateTime.parse(str);
        }
        return null;
    }
}

