/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class TaskSettingsConfiguration
implements Writeable,
ToXContentObject {
    private final TaskType taskType;
    private final Map<String, SettingsConfiguration> configuration;
    static final ParseField TASK_TYPE_FIELD = new ParseField("task_type", new String[0]);
    static final ParseField CONFIGURATION_FIELD = new ParseField("configuration", new String[0]);
    private static final ConstructingObjectParser<TaskSettingsConfiguration, Void> PARSER = new ConstructingObjectParser("task_configuration", true, args -> new Builder().setTaskType(TaskType.fromString((String)args[0])).setConfiguration((Map)args[1]).build());

    private TaskSettingsConfiguration(TaskType taskType, Map<String, SettingsConfiguration> configuration) {
        this.taskType = taskType;
        this.configuration = configuration;
    }

    public TaskSettingsConfiguration(StreamInput in) throws IOException {
        this.taskType = in.readEnum(TaskType.class);
        this.configuration = in.readMap(SettingsConfiguration::new);
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public Map<String, SettingsConfiguration> getConfiguration() {
        return this.configuration;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TASK_TYPE_FIELD.getPreferredName(), (Enum)this.taskType);
        builder.field(CONFIGURATION_FIELD.getPreferredName(), this.configuration);
        builder.endObject();
        return builder;
    }

    public static TaskSettingsConfiguration fromXContent(XContentParser parser) throws IOException {
        return (TaskSettingsConfiguration)PARSER.parse(parser, null);
    }

    public static TaskSettingsConfiguration fromXContentBytes(BytesReference source, XContentType xContentType) {
        TaskSettingsConfiguration taskSettingsConfiguration;
        block8: {
            XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, source, xContentType);
            try {
                taskSettingsConfiguration = TaskSettingsConfiguration.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse task configuration", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return taskSettingsConfiguration;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.taskType);
        out.writeMapValues(this.configuration);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TASK_TYPE_FIELD.getPreferredName(), this.taskType);
        map.put(CONFIGURATION_FIELD.getPreferredName(), this.configuration);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSettingsConfiguration that = (TaskSettingsConfiguration)o;
        return Objects.equals(this.taskType, that.taskType) && Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.taskType, this.configuration);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TASK_TYPE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), CONFIGURATION_FIELD);
    }

    public static class Builder {
        private TaskType taskType;
        private Map<String, SettingsConfiguration> configuration;

        public Builder setTaskType(TaskType taskType) {
            this.taskType = taskType;
            return this;
        }

        public Builder setConfiguration(Map<String, SettingsConfiguration> configuration) {
            this.configuration = configuration;
            return this;
        }

        public TaskSettingsConfiguration build() {
            return new TaskSettingsConfiguration(this.taskType, this.configuration);
        }
    }
}

