/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettingsConfiguration;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class InferenceServiceConfiguration
implements Writeable,
ToXContentObject {
    private final String provider;
    private final List<TaskSettingsConfiguration> taskTypes;
    private final Map<String, SettingsConfiguration> configuration;
    static final ParseField PROVIDER_FIELD = new ParseField("provider", new String[0]);
    static final ParseField TASK_TYPES_FIELD = new ParseField("task_types", new String[0]);
    static final ParseField CONFIGURATION_FIELD = new ParseField("configuration", new String[0]);
    private static final ConstructingObjectParser<InferenceServiceConfiguration, Void> PARSER = new ConstructingObjectParser("inference_service_configuration", true, args -> {
        ArrayList taskTypes = (ArrayList)args[1];
        return new Builder().setProvider((String)args[0]).setTaskTypes((List)args[1]).setConfiguration((Map)args[2]).build();
    });

    private InferenceServiceConfiguration(String provider, List<TaskSettingsConfiguration> taskTypes, Map<String, SettingsConfiguration> configuration) {
        this.provider = provider;
        this.taskTypes = taskTypes;
        this.configuration = configuration;
    }

    public InferenceServiceConfiguration(StreamInput in) throws IOException {
        this.provider = in.readString();
        this.taskTypes = in.readCollectionAsList(TaskSettingsConfiguration::new);
        this.configuration = in.readMap(SettingsConfiguration::new);
    }

    public String getProvider() {
        return this.provider;
    }

    public List<TaskSettingsConfiguration> getTaskTypes() {
        return this.taskTypes;
    }

    public Map<String, SettingsConfiguration> getConfiguration() {
        return this.configuration;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PROVIDER_FIELD.getPreferredName(), this.provider);
        builder.field(TASK_TYPES_FIELD.getPreferredName(), this.taskTypes);
        builder.field(CONFIGURATION_FIELD.getPreferredName(), this.configuration);
        builder.endObject();
        return builder;
    }

    public static InferenceServiceConfiguration fromXContent(XContentParser parser) throws IOException {
        return (InferenceServiceConfiguration)PARSER.parse(parser, null);
    }

    public static InferenceServiceConfiguration fromXContentBytes(BytesReference source, XContentType xContentType) {
        InferenceServiceConfiguration inferenceServiceConfiguration;
        block8: {
            XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, source, xContentType);
            try {
                inferenceServiceConfiguration = InferenceServiceConfiguration.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse inference service configuration", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return inferenceServiceConfiguration;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.provider);
        out.writeCollection(this.taskTypes);
        out.writeMapValues(this.configuration);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PROVIDER_FIELD.getPreferredName(), this.provider);
        map.put(TASK_TYPES_FIELD.getPreferredName(), this.taskTypes);
        map.put(CONFIGURATION_FIELD.getPreferredName(), this.configuration);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceServiceConfiguration that = (InferenceServiceConfiguration)o;
        return this.provider.equals(that.provider) && Objects.equals(this.taskTypes, that.taskTypes) && Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.taskTypes, this.configuration);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PROVIDER_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> TaskSettingsConfiguration.fromXContent(p), TASK_TYPES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), CONFIGURATION_FIELD);
    }

    public static class Builder {
        private String provider;
        private List<TaskSettingsConfiguration> taskTypes;
        private Map<String, SettingsConfiguration> configuration;

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder setTaskTypes(List<TaskSettingsConfiguration> taskTypes) {
            this.taskTypes = taskTypes;
            return this;
        }

        public Builder setConfiguration(Map<String, SettingsConfiguration> configuration) {
            this.configuration = configuration;
            return this;
        }

        public InferenceServiceConfiguration build() {
            return new InferenceServiceConfiguration(this.provider, this.taskTypes, this.configuration);
        }
    }
}

