/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.FloatArrayList;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.BinarizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.BinaryQuantizer;
import org.elasticsearch.index.codec.vectors.ES816BinaryFlatVectorsScorer;
import org.elasticsearch.index.codec.vectors.ES816BinaryQuantizedVectorsReader;
import org.elasticsearch.index.codec.vectors.OffHeapBinarizedVectorValues;

@SuppressForbidden(reason="Lucene classes")
public class ES816BinaryQuantizedVectorsWriter
extends FlatVectorsWriter {
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ES816BinaryQuantizedVectorsWriter.class);
    private final SegmentWriteState segmentWriteState;
    private final List<FieldWriter> fields = new ArrayList<FieldWriter>();
    private final IndexOutput meta;
    private final IndexOutput binarizedVectorData;
    private final FlatVectorsWriter rawVectorDelegate;
    private final ES816BinaryFlatVectorsScorer vectorsScorer;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ES816BinaryQuantizedVectorsWriter(ES816BinaryFlatVectorsScorer vectorsScorer, FlatVectorsWriter rawVectorDelegate, SegmentWriteState state) throws IOException {
        super((FlatVectorsScorer)vectorsScorer);
        this.vectorsScorer = vectorsScorer;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vemb");
        String binarizedVectorDataFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"veb");
        this.rawVectorDelegate = rawVectorDelegate;
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.binarizedVectorData = state.directory.createOutput(binarizedVectorDataFileName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.meta, (String)"ES816BinaryQuantizedVectorsFormatMeta", (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            CodecUtil.writeIndexHeader((DataOutput)this.binarizedVectorData, (String)"ES816BinaryQuantizedVectorsFormatData", (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        FlatFieldVectorsWriter rawVectorDelegate = this.rawVectorDelegate.addField(fieldInfo);
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            FieldWriter fieldWriter = new FieldWriter(fieldInfo, (FlatFieldVectorsWriter<float[]>)rawVectorDelegate);
            this.fields.add(fieldWriter);
            return fieldWriter;
        }
        return rawVectorDelegate;
    }

    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.rawVectorDelegate.flush(maxDoc, sortMap);
        for (FieldWriter field : this.fields) {
            if (VectorSimilarityFunction.COSINE == field.fieldInfo.getVectorSimilarityFunction()) {
                field.normalizeVectors();
            }
            int vectorCount = field.flatFieldVectorsWriter.getVectors().size();
            float[] clusterCenter = new float[field.dimensionSums.length];
            if (vectorCount > 0) {
                for (int i = 0; i < field.dimensionSums.length; ++i) {
                    clusterCenter[i] = field.dimensionSums[i] / (float)vectorCount;
                }
                if (VectorSimilarityFunction.COSINE == field.fieldInfo.getVectorSimilarityFunction()) {
                    VectorUtil.l2normalize((float[])clusterCenter);
                }
            }
            if (this.segmentWriteState.infoStream.isEnabled("BVEC")) {
                this.segmentWriteState.infoStream.message("BVEC", "Vectors' count:" + vectorCount);
            }
            int descritizedDimension = BQVectorUtils.discretize(field.fieldInfo.getVectorDimension(), 64);
            BinaryQuantizer quantizer = new BinaryQuantizer(field.fieldInfo.getVectorDimension(), descritizedDimension, field.fieldInfo.getVectorSimilarityFunction());
            if (sortMap == null) {
                this.writeField(field, clusterCenter, maxDoc, quantizer);
            } else {
                this.writeSortingField(field, clusterCenter, maxDoc, sortMap, quantizer);
            }
            field.finish();
        }
    }

    private void writeField(FieldWriter fieldData, float[] clusterCenter, int maxDoc, BinaryQuantizer quantizer) throws IOException {
        long vectorDataOffset = this.binarizedVectorData.alignFilePointer(4);
        this.writeBinarizedVectors(fieldData, clusterCenter, quantizer);
        long vectorDataLength = this.binarizedVectorData.getFilePointer() - vectorDataOffset;
        float centroidDp = fieldData.getVectors().size() > 0 ? VectorUtil.dotProduct((float[])clusterCenter, (float[])clusterCenter) : 0.0f;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, clusterCenter, centroidDp, fieldData.getDocsWithFieldSet());
    }

    private void writeBinarizedVectors(FieldWriter fieldData, float[] clusterCenter, BinaryQuantizer scalarQuantizer) throws IOException {
        byte[] vector = new byte[BQVectorUtils.discretize(fieldData.fieldInfo.getVectorDimension(), 64) / 8];
        int correctionsCount = scalarQuantizer.getSimilarity() != VectorSimilarityFunction.EUCLIDEAN ? 3 : 2;
        ByteBuffer correctionsBuffer = ByteBuffer.allocate(4 * correctionsCount).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < fieldData.getVectors().size(); ++i) {
            float[] v = fieldData.getVectors().get(i);
            float[] corrections = scalarQuantizer.quantizeForIndex(v, vector, clusterCenter);
            this.binarizedVectorData.writeBytes(vector, vector.length);
            for (int j = 0; j < corrections.length; ++j) {
                correctionsBuffer.putFloat(corrections[j]);
            }
            this.binarizedVectorData.writeBytes(correctionsBuffer.array(), correctionsBuffer.array().length);
            correctionsBuffer.rewind();
        }
    }

    private void writeSortingField(FieldWriter fieldData, float[] clusterCenter, int maxDoc, Sorter.DocMap sortMap, BinaryQuantizer scalarQuantizer) throws IOException {
        int[] ordMap = new int[fieldData.getDocsWithFieldSet().cardinality()];
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        ES816BinaryQuantizedVectorsWriter.mapOldOrdToNewOrd((DocsWithFieldSet)fieldData.getDocsWithFieldSet(), (Sorter.DocMap)sortMap, null, (int[])ordMap, (DocsWithFieldSet)newDocsWithField);
        long vectorDataOffset = this.binarizedVectorData.alignFilePointer(4);
        this.writeSortedBinarizedVectors(fieldData, clusterCenter, ordMap, scalarQuantizer);
        long quantizedVectorLength = this.binarizedVectorData.getFilePointer() - vectorDataOffset;
        float centroidDp = VectorUtil.dotProduct((float[])clusterCenter, (float[])clusterCenter);
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, quantizedVectorLength, clusterCenter, centroidDp, newDocsWithField);
    }

    private void writeSortedBinarizedVectors(FieldWriter fieldData, float[] clusterCenter, int[] ordMap, BinaryQuantizer scalarQuantizer) throws IOException {
        byte[] vector = new byte[BQVectorUtils.discretize(fieldData.fieldInfo.getVectorDimension(), 64) / 8];
        int correctionsCount = scalarQuantizer.getSimilarity() != VectorSimilarityFunction.EUCLIDEAN ? 3 : 2;
        ByteBuffer correctionsBuffer = ByteBuffer.allocate(4 * correctionsCount).order(ByteOrder.LITTLE_ENDIAN);
        for (int ordinal : ordMap) {
            float[] v = fieldData.getVectors().get(ordinal);
            float[] corrections = scalarQuantizer.quantizeForIndex(v, vector, clusterCenter);
            this.binarizedVectorData.writeBytes(vector, vector.length);
            for (int i = 0; i < corrections.length; ++i) {
                correctionsBuffer.putFloat(corrections[i]);
            }
            this.binarizedVectorData.writeBytes(correctionsBuffer.array(), correctionsBuffer.array().length);
            correctionsBuffer.rewind();
        }
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, float[] clusterCenter, float centroidDp, DocsWithFieldSet docsWithField) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVInt(field.getVectorDimension());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        int count = docsWithField.cardinality();
        this.meta.writeVInt(count);
        if (count > 0) {
            ByteBuffer buffer = ByteBuffer.allocate(field.getVectorDimension() * 4).order(ByteOrder.LITTLE_ENDIAN);
            buffer.asFloatBuffer().put(clusterCenter);
            this.meta.writeBytes(buffer.array(), buffer.array().length);
            this.meta.writeInt(Float.floatToIntBits(centroidDp));
        }
        OrdToDocDISIReaderConfiguration.writeStoredMeta((int)16, (IndexOutput)this.meta, (IndexOutput)this.binarizedVectorData, (int)count, (int)maxDoc, (DocsWithFieldSet)docsWithField);
    }

    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.rawVectorDelegate.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter((IndexOutput)this.meta);
        }
        if (this.binarizedVectorData != null) {
            CodecUtil.writeFooter((IndexOutput)this.binarizedVectorData);
        }
    }

    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            float[] mergedCentroid = new float[fieldInfo.getVectorDimension()];
            int vectorCount = ES816BinaryQuantizedVectorsWriter.mergeAndRecalculateCentroids(mergeState, fieldInfo, mergedCentroid);
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
            float[] centroid = mergedCentroid;
            if (this.segmentWriteState.infoStream.isEnabled("BVEC")) {
                this.segmentWriteState.infoStream.message("BVEC", "Vectors' count:" + vectorCount);
            }
            int descritizedDimension = BQVectorUtils.discretize(fieldInfo.getVectorDimension(), 64);
            FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues((FieldInfo)fieldInfo, (MergeState)mergeState);
            if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                floatVectorValues = new NormalizedFloatVectorValues(floatVectorValues);
            }
            BinarizedFloatVectorValues binarizedVectorValues = new BinarizedFloatVectorValues(floatVectorValues, new BinaryQuantizer(fieldInfo.getVectorDimension(), descritizedDimension, fieldInfo.getVectorSimilarityFunction()), centroid);
            long vectorDataOffset = this.binarizedVectorData.alignFilePointer(4);
            DocsWithFieldSet docsWithField = ES816BinaryQuantizedVectorsWriter.writeBinarizedVectorData(this.binarizedVectorData, binarizedVectorValues);
            long vectorDataLength = this.binarizedVectorData.getFilePointer() - vectorDataOffset;
            float centroidDp = docsWithField.cardinality() > 0 ? VectorUtil.dotProduct((float[])centroid, (float[])centroid) : 0.0f;
            this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, centroid, centroidDp, docsWithField);
        } else {
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
        }
    }

    static DocsWithFieldSet writeBinarizedVectorAndQueryData(IndexOutput binarizedVectorData, IndexOutput binarizedQueryData, FloatVectorValues floatVectorValues, float[] centroid, BinaryQuantizer binaryQuantizer) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        byte[] toIndex = new byte[BQVectorUtils.discretize(floatVectorValues.dimension(), 64) / 8];
        byte[] toQuery = new byte[BQVectorUtils.discretize(floatVectorValues.dimension(), 64) / 8 * 4];
        int queryCorrectionCount = binaryQuantizer.getSimilarity() != VectorSimilarityFunction.EUCLIDEAN ? 5 : 3;
        ByteBuffer queryCorrectionsBuffer = ByteBuffer.allocate(4 * queryCorrectionCount + 2).order(ByteOrder.LITTLE_ENDIAN);
        int docV = floatVectorValues.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            BinaryQuantizer.QueryAndIndexResults r = binaryQuantizer.quantizeQueryAndIndex(floatVectorValues.vectorValue(), toIndex, toQuery, centroid);
            binarizedVectorData.writeBytes(toIndex, toIndex.length);
            float[] corrections = r.indexFeatures();
            for (int i = 0; i < corrections.length; ++i) {
                binarizedVectorData.writeInt(Float.floatToIntBits(corrections[i]));
            }
            docsWithField.add(docV);
            binarizedQueryData.writeBytes(toQuery, toQuery.length);
            BinaryQuantizer.QueryFactors factors = r.queryFeatures();
            queryCorrectionsBuffer.putFloat(factors.distToC());
            queryCorrectionsBuffer.putFloat(factors.lower());
            queryCorrectionsBuffer.putFloat(factors.width());
            if (binaryQuantizer.getSimilarity() != VectorSimilarityFunction.EUCLIDEAN) {
                queryCorrectionsBuffer.putFloat(factors.normVmC());
                queryCorrectionsBuffer.putFloat(factors.vDotC());
            }
            assert (factors.quantizedSum() >= 0 && factors.quantizedSum() <= 65535);
            queryCorrectionsBuffer.putShort((short)factors.quantizedSum());
            binarizedQueryData.writeBytes(queryCorrectionsBuffer.array(), queryCorrectionsBuffer.array().length);
            queryCorrectionsBuffer.rewind();
            docV = floatVectorValues.nextDoc();
        }
        return docsWithField;
    }

    static DocsWithFieldSet writeBinarizedVectorData(IndexOutput output, BinarizedByteVectorValues binarizedByteVectorValues) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        int docV = binarizedByteVectorValues.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            byte[] binaryValue = binarizedByteVectorValues.vectorValue();
            output.writeBytes(binaryValue, binaryValue.length);
            float[] corrections = binarizedByteVectorValues.getCorrectiveTerms();
            for (int i = 0; i < corrections.length; ++i) {
                output.writeInt(Float.floatToIntBits(corrections[i]));
            }
            docsWithField.add(docV);
            docV = binarizedByteVectorValues.nextDoc();
        }
        return docsWithField;
    }

    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            float cDotC;
            float[] mergedCentroid = new float[fieldInfo.getVectorDimension()];
            int vectorCount = ES816BinaryQuantizedVectorsWriter.mergeAndRecalculateCentroids(mergeState, fieldInfo, mergedCentroid);
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
            float[] centroid = mergedCentroid;
            float f = cDotC = vectorCount > 0 ? VectorUtil.dotProduct((float[])centroid, (float[])centroid) : 0.0f;
            if (this.segmentWriteState.infoStream.isEnabled("BVEC")) {
                this.segmentWriteState.infoStream.message("BVEC", "Vectors' count:" + vectorCount);
            }
            return this.mergeOneFieldToIndex(this.segmentWriteState, fieldInfo, mergeState, centroid, cDotC);
        }
        return this.rawVectorDelegate.mergeOneFieldToIndex(fieldInfo, mergeState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(SegmentWriteState segmentWriteState, FieldInfo fieldInfo, MergeState mergeState, float[] centroid, float cDotC) throws IOException {
        BinarizedCloseableRandomVectorScorerSupplier binarizedCloseableRandomVectorScorerSupplier;
        block13: {
            DocsWithFieldSet docsWithField;
            boolean success;
            IndexOutput tempScoreQuantizedVectorData;
            IndexOutput tempQuantizedVectorData;
            BinaryQuantizer quantizer;
            long vectorDataOffset;
            block14: {
                block12: {
                    vectorDataOffset = this.binarizedVectorData.alignFilePointer(4);
                    int descritizedDimension = BQVectorUtils.discretize(fieldInfo.getVectorDimension(), 64);
                    quantizer = new BinaryQuantizer(fieldInfo.getVectorDimension(), descritizedDimension, fieldInfo.getVectorSimilarityFunction());
                    tempQuantizedVectorData = null;
                    tempScoreQuantizedVectorData = null;
                    success = false;
                    try {
                        tempQuantizedVectorData = segmentWriteState.directory.createTempOutput(this.binarizedVectorData.getName(), "temp", segmentWriteState.context);
                        tempScoreQuantizedVectorData = segmentWriteState.directory.createTempOutput(this.binarizedVectorData.getName(), "score_temp", segmentWriteState.context);
                        FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues((FieldInfo)fieldInfo, (MergeState)mergeState);
                        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                            floatVectorValues = new NormalizedFloatVectorValues(floatVectorValues);
                        }
                        docsWithField = ES816BinaryQuantizedVectorsWriter.writeBinarizedVectorAndQueryData(tempQuantizedVectorData, tempScoreQuantizedVectorData, floatVectorValues, centroid, quantizer);
                        CodecUtil.writeFooter((IndexOutput)tempQuantizedVectorData);
                        CodecUtil.writeFooter((IndexOutput)tempScoreQuantizedVectorData);
                        success = true;
                        if (!success) break block12;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{tempQuantizedVectorData, tempScoreQuantizedVectorData});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{tempQuantizedVectorData, tempScoreQuantizedVectorData});
                            if (tempQuantizedVectorData != null) {
                                IOUtils.deleteFilesIgnoringExceptions((Directory)segmentWriteState.directory, (String[])new String[]{tempQuantizedVectorData.getName()});
                            }
                            if (tempScoreQuantizedVectorData != null) {
                                IOUtils.deleteFilesIgnoringExceptions((Directory)segmentWriteState.directory, (String[])new String[]{tempScoreQuantizedVectorData.getName()});
                            }
                        }
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{tempQuantizedVectorData, tempScoreQuantizedVectorData});
                    break block14;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{tempQuantizedVectorData, tempScoreQuantizedVectorData});
                if (tempQuantizedVectorData != null) {
                    IOUtils.deleteFilesIgnoringExceptions((Directory)segmentWriteState.directory, (String[])new String[]{tempQuantizedVectorData.getName()});
                }
                if (tempScoreQuantizedVectorData != null) {
                    IOUtils.deleteFilesIgnoringExceptions((Directory)segmentWriteState.directory, (String[])new String[]{tempScoreQuantizedVectorData.getName()});
                }
            }
            IndexInput binarizedDataInput = null;
            IndexInput binarizedScoreDataInput = null;
            success = false;
            try {
                binarizedDataInput = segmentWriteState.directory.openInput(tempQuantizedVectorData.getName(), segmentWriteState.context);
                this.binarizedVectorData.copyBytes((DataInput)binarizedDataInput, binarizedDataInput.length() - (long)CodecUtil.footerLength());
                long vectorDataLength = this.binarizedVectorData.getFilePointer() - vectorDataOffset;
                CodecUtil.retrieveChecksum((IndexInput)binarizedDataInput);
                binarizedScoreDataInput = segmentWriteState.directory.openInput(tempScoreQuantizedVectorData.getName(), segmentWriteState.context);
                this.writeMeta(fieldInfo, segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, centroid, cDotC, docsWithField);
                IndexInput finalBinarizedDataInput = binarizedDataInput;
                IndexInput finalBinarizedScoreDataInput = binarizedScoreDataInput;
                OffHeapBinarizedVectorValues.DenseOffHeapVectorValues vectorValues = new OffHeapBinarizedVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), centroid, cDotC, quantizer, fieldInfo.getVectorSimilarityFunction(), this.vectorsScorer, finalBinarizedDataInput);
                RandomVectorScorerSupplier scorerSupplier = this.vectorsScorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), new OffHeapBinarizedQueryVectorValues(finalBinarizedScoreDataInput, fieldInfo.getVectorDimension(), docsWithField.cardinality(), fieldInfo.getVectorSimilarityFunction()), vectorValues);
                String tempQuantizedVectorDataName = tempQuantizedVectorData.getName();
                String tempScoreQuantizedVectorDataName = tempScoreQuantizedVectorData.getName();
                success = true;
                binarizedCloseableRandomVectorScorerSupplier = new BinarizedCloseableRandomVectorScorerSupplier(scorerSupplier, (RandomAccessVectorValues)vectorValues, () -> {
                    IOUtils.close((Closeable[])new Closeable[]{finalBinarizedDataInput, finalBinarizedScoreDataInput});
                    IOUtils.deleteFilesIgnoringExceptions((Directory)segmentWriteState.directory, (String[])new String[]{tempQuantizedVectorDataName, tempScoreQuantizedVectorDataName});
                });
                if (success) break block13;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{binarizedDataInput, binarizedScoreDataInput});
                    IOUtils.deleteFilesIgnoringExceptions((Directory)segmentWriteState.directory, (String[])new String[]{tempQuantizedVectorData.getName(), tempScoreQuantizedVectorData.getName()});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{binarizedDataInput, binarizedScoreDataInput});
            IOUtils.deleteFilesIgnoringExceptions((Directory)segmentWriteState.directory, (String[])new String[]{tempQuantizedVectorData.getName(), tempScoreQuantizedVectorData.getName()});
        }
        return binarizedCloseableRandomVectorScorerSupplier;
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.meta, this.binarizedVectorData, this.rawVectorDelegate});
    }

    static float[] getCentroid(KnnVectorsReader vectorsReader, String fieldName) {
        if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            PerFieldKnnVectorsFormat.FieldsReader candidateReader = (PerFieldKnnVectorsFormat.FieldsReader)vectorsReader;
            vectorsReader = candidateReader.getFieldReader(fieldName);
        }
        if (vectorsReader instanceof ES816BinaryQuantizedVectorsReader) {
            ES816BinaryQuantizedVectorsReader reader = (ES816BinaryQuantizedVectorsReader)vectorsReader;
            return reader.getCentroid(fieldName);
        }
        return null;
    }

    static int mergeAndRecalculateCentroids(MergeState mergeState, FieldInfo fieldInfo, float[] mergedCentroid) throws IOException {
        boolean recalculate = false;
        int totalVectorCount = 0;
        for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
            KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
            if (knnVectorsReader == null || knnVectorsReader.getFloatVectorValues(fieldInfo.name) == null) continue;
            float[] centroid = ES816BinaryQuantizedVectorsWriter.getCentroid(knnVectorsReader, fieldInfo.name);
            int vectorCount = knnVectorsReader.getFloatVectorValues(fieldInfo.name).size();
            if (vectorCount == 0) continue;
            totalVectorCount += vectorCount;
            if (centroid == null || mergeState.liveDocs[i] != null) {
                recalculate = true;
                break;
            }
            for (int j = 0; j < centroid.length; ++j) {
                int n = j;
                mergedCentroid[n] = mergedCentroid[n] + centroid[j] * (float)vectorCount;
            }
        }
        if (recalculate) {
            return ES816BinaryQuantizedVectorsWriter.calculateCentroid(mergeState, fieldInfo, mergedCentroid);
        }
        for (int j = 0; j < mergedCentroid.length; ++j) {
            mergedCentroid[j] = mergedCentroid[j] / (float)totalVectorCount;
        }
        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
            VectorUtil.l2normalize((float[])mergedCentroid);
        }
        return totalVectorCount;
    }

    static int calculateCentroid(MergeState mergeState, FieldInfo fieldInfo, float[] centroid) throws IOException {
        int i;
        assert (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32));
        Arrays.fill(centroid, 0.0f);
        int count = 0;
        for (i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
            FloatVectorValues vectorValues;
            KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
            if (knnVectorsReader == null || (vectorValues = mergeState.knnVectorsReaders[i].getFloatVectorValues(fieldInfo.name)) == null) continue;
            int doc = vectorValues.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                float[] vector = vectorValues.vectorValue();
                for (int j = 0; j < vector.length; ++j) {
                    int n = j;
                    centroid[n] = centroid[n] + vector[j];
                }
                doc = vectorValues.nextDoc();
            }
            count += vectorValues.size();
        }
        if (count == 0) {
            return count;
        }
        i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (float)count;
        }
        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
            VectorUtil.l2normalize((float[])centroid);
        }
        return count;
    }

    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    static class FieldWriter
    extends FlatFieldVectorsWriter<float[]> {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private boolean finished;
        private final FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter;
        private final float[] dimensionSums;
        private final FloatArrayList magnitudes = new FloatArrayList();

        FieldWriter(FieldInfo fieldInfo, FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter) {
            this.fieldInfo = fieldInfo;
            this.flatFieldVectorsWriter = flatFieldVectorsWriter;
            this.dimensionSums = new float[fieldInfo.getVectorDimension()];
        }

        public List<float[]> getVectors() {
            return this.flatFieldVectorsWriter.getVectors();
        }

        public void normalizeVectors() {
            for (int i = 0; i < this.flatFieldVectorsWriter.getVectors().size(); ++i) {
                float[] vector = (float[])this.flatFieldVectorsWriter.getVectors().get(i);
                float magnitude = this.magnitudes.get(i);
                int j = 0;
                while (j < vector.length) {
                    int n = j++;
                    vector[n] = vector[n] / magnitude;
                }
            }
        }

        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.flatFieldVectorsWriter.getDocsWithFieldSet();
        }

        public void finish() throws IOException {
            if (this.finished) {
                return;
            }
            assert (this.flatFieldVectorsWriter.isFinished());
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished && this.flatFieldVectorsWriter.isFinished();
        }

        public void addValue(int docID, float[] vectorValue) throws IOException {
            this.flatFieldVectorsWriter.addValue(docID, (Object)vectorValue);
            if (this.fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                float dp = VectorUtil.dotProduct((float[])vectorValue, (float[])vectorValue);
                float divisor = (float)Math.sqrt(dp);
                this.magnitudes.add(divisor);
                for (int i = 0; i < vectorValue.length; ++i) {
                    int n = i;
                    this.dimensionSums[n] = this.dimensionSums[n] + vectorValue[i] / divisor;
                }
            } else {
                for (int i = 0; i < vectorValue.length; ++i) {
                    int n = i;
                    this.dimensionSums[n] = this.dimensionSums[n] + vectorValue[i];
                }
            }
        }

        public float[] copyValue(float[] vectorValue) {
            throw new UnsupportedOperationException();
        }

        public long ramBytesUsed() {
            long size = SHALLOW_SIZE;
            size += this.flatFieldVectorsWriter.ramBytesUsed();
            size += RamUsageEstimator.sizeOf((float[])this.dimensionSums);
            return size += this.magnitudes.ramBytesUsed();
        }
    }

    static final class NormalizedFloatVectorValues
    extends FloatVectorValues {
        private final FloatVectorValues values;
        private final float[] normalizedVector;
        int curDoc = -1;

        NormalizedFloatVectorValues(FloatVectorValues values) {
            this.values = values;
            this.normalizedVector = new float[values.dimension()];
        }

        public int dimension() {
            return this.values.dimension();
        }

        public int size() {
            return this.values.size();
        }

        public float[] vectorValue() {
            return this.normalizedVector;
        }

        public VectorScorer scorer(float[] query) {
            throw new UnsupportedOperationException();
        }

        public int docID() {
            return this.values.docID();
        }

        public int nextDoc() throws IOException {
            this.curDoc = this.values.nextDoc();
            if (this.curDoc != Integer.MAX_VALUE) {
                System.arraycopy(this.values.vectorValue(), 0, this.normalizedVector, 0, this.normalizedVector.length);
                VectorUtil.l2normalize((float[])this.normalizedVector);
            }
            return this.curDoc;
        }

        public int advance(int target) throws IOException {
            this.curDoc = this.values.advance(target);
            if (this.curDoc != Integer.MAX_VALUE) {
                System.arraycopy(this.values.vectorValue(), 0, this.normalizedVector, 0, this.normalizedVector.length);
                VectorUtil.l2normalize((float[])this.normalizedVector);
            }
            return this.curDoc;
        }
    }

    static class BinarizedFloatVectorValues
    extends BinarizedByteVectorValues {
        private float[] corrections;
        private final byte[] binarized;
        private final float[] centroid;
        private final FloatVectorValues values;
        private final BinaryQuantizer quantizer;
        private int lastDoc;

        BinarizedFloatVectorValues(FloatVectorValues delegate, BinaryQuantizer quantizer, float[] centroid) {
            this.values = delegate;
            this.quantizer = quantizer;
            this.binarized = new byte[BQVectorUtils.discretize(delegate.dimension(), 64) / 8];
            this.centroid = centroid;
            this.lastDoc = -1;
        }

        @Override
        public float[] getCorrectiveTerms() {
            return this.corrections;
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.binarized;
        }

        @Override
        public int dimension() {
            return this.values.dimension();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        public int docID() {
            return this.values.docID();
        }

        public int nextDoc() throws IOException {
            int doc = this.values.nextDoc();
            if (doc != Integer.MAX_VALUE) {
                this.binarize();
            }
            this.lastDoc = doc;
            return doc;
        }

        public int advance(int target) throws IOException {
            int doc = this.values.advance(target);
            if (doc != Integer.MAX_VALUE) {
                this.binarize();
            }
            this.lastDoc = doc;
            return doc;
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            throw new UnsupportedOperationException();
        }

        private void binarize() throws IOException {
            if (this.lastDoc == this.docID()) {
                return;
            }
            this.corrections = this.quantizer.quantizeForIndex(this.values.vectorValue(), this.binarized, this.centroid);
        }
    }

    static class OffHeapBinarizedQueryVectorValues {
        private final IndexInput slice;
        private final int dimension;
        private final int size;
        protected final byte[] binaryValue;
        protected final ByteBuffer byteBuffer;
        private final int byteSize;
        protected final float[] correctiveValues;
        private int sumQuantizationValues;
        private int lastOrd = -1;
        private final int correctiveValuesSize;
        private final VectorSimilarityFunction vectorSimilarityFunction;

        OffHeapBinarizedQueryVectorValues(IndexInput data, int dimension, int size, VectorSimilarityFunction vectorSimilarityFunction) {
            this.slice = data;
            this.dimension = dimension;
            this.size = size;
            this.vectorSimilarityFunction = vectorSimilarityFunction;
            this.correctiveValuesSize = vectorSimilarityFunction != VectorSimilarityFunction.EUCLIDEAN ? 5 : 3;
            int binaryDimensions = BQVectorUtils.discretize(dimension, 64) / 8 * 4;
            this.byteBuffer = ByteBuffer.allocate(binaryDimensions);
            this.binaryValue = this.byteBuffer.array();
            this.correctiveValues = new float[this.correctiveValuesSize];
            this.byteSize = binaryDimensions + 4 * this.correctiveValuesSize + 2;
        }

        public float getCentroidDistance(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.correctiveValues[0];
            }
            this.readCorrectiveValues(targetOrd);
            return this.correctiveValues[0];
        }

        public float getLower(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.correctiveValues[1];
            }
            this.readCorrectiveValues(targetOrd);
            return this.correctiveValues[1];
        }

        public float getWidth(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.correctiveValues[2];
            }
            this.readCorrectiveValues(targetOrd);
            return this.correctiveValues[2];
        }

        public float getNormVmC(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.correctiveValues[3];
            }
            this.readCorrectiveValues(targetOrd);
            return this.correctiveValues[3];
        }

        public float getVDotC(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.correctiveValues[4];
            }
            this.readCorrectiveValues(targetOrd);
            return this.correctiveValues[4];
        }

        private void readCorrectiveValues(int targetOrd) throws IOException {
            this.vectorValue(targetOrd);
        }

        public int sumQuantizedValues(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.sumQuantizationValues;
            }
            this.vectorValue(targetOrd);
            return this.sumQuantizationValues;
        }

        public int size() {
            return this.size;
        }

        public int dimension() {
            return this.dimension;
        }

        public OffHeapBinarizedQueryVectorValues copy() throws IOException {
            return new OffHeapBinarizedQueryVectorValues(this.slice.clone(), this.dimension, this.size, this.vectorSimilarityFunction);
        }

        public IndexInput getSlice() {
            return this.slice;
        }

        public byte[] vectorValue(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.binaryValue;
            }
            this.slice.seek((long)targetOrd * (long)this.byteSize);
            this.slice.readBytes(this.binaryValue, 0, this.binaryValue.length);
            this.slice.readFloats(this.correctiveValues, 0, this.correctiveValuesSize);
            this.sumQuantizationValues = Short.toUnsignedInt(this.slice.readShort());
            this.lastOrd = targetOrd;
            return this.binaryValue;
        }
    }

    static class BinarizedCloseableRandomVectorScorerSupplier
    implements CloseableRandomVectorScorerSupplier {
        private final RandomVectorScorerSupplier supplier;
        private final RandomAccessVectorValues vectorValues;
        private final Closeable onClose;

        BinarizedCloseableRandomVectorScorerSupplier(RandomVectorScorerSupplier supplier, RandomAccessVectorValues vectorValues, Closeable onClose) {
            this.supplier = supplier;
            this.onClose = onClose;
            this.vectorValues = vectorValues;
        }

        public RandomVectorScorer scorer(int ord) throws IOException {
            return this.supplier.scorer(ord);
        }

        public RandomVectorScorerSupplier copy() throws IOException {
            return this.supplier.copy();
        }

        public void close() throws IOException {
            this.onClose.close();
        }

        public int totalVectorCount() {
            return this.vectorValues.size();
        }
    }
}

