/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class LocalAllocateDangledIndices {
    private static final Logger logger = LogManager.getLogger(LocalAllocateDangledIndices.class);
    public static final String ACTION_NAME = "internal:gateway/local/allocate_dangled";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexMetadataVerifier indexMetadataVerifier;

    @Inject
    public LocalAllocateDangledIndices(TransportService transportService, ClusterService clusterService, AllocationService allocationService, IndexMetadataVerifier indexMetadataVerifier) {
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.indexMetadataVerifier = indexMetadataVerifier;
        transportService.registerRequestHandler(ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, AllocateDangledRequest::new, new AllocateDangledRequestHandler());
    }

    public void allocateDangled(Collection<IndexMetadata> indices, ActionListener<AllocateDangledResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        DiscoveryNode masterNode = clusterState.nodes().getMasterNode();
        if (masterNode == null) {
            listener.onFailure(new MasterNotDiscoveredException());
            return;
        }
        AllocateDangledRequest request = new AllocateDangledRequest(this.clusterService.localNode(), indices.toArray(new IndexMetadata[indices.size()]));
        this.transportService.sendRequest(masterNode, ACTION_NAME, request, new ActionListenerResponseHandler<AllocateDangledResponse>(listener, AllocateDangledResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    class AllocateDangledRequestHandler
    implements TransportRequestHandler<AllocateDangledRequest> {
        AllocateDangledRequestHandler() {
        }

        @Override
        public void messageReceived(final AllocateDangledRequest request, TransportChannel channel, Task task) throws Exception {
            Object[] indexNames = new String[request.indices.length];
            for (int i = 0; i < request.indices.length; ++i) {
                indexNames[i] = request.indices[i].getIndex().getName();
            }
            String source = "allocation dangled indices " + Arrays.toString(indexNames);
            final AllocationActionListener listener = new AllocationActionListener(new ChannelActionListener(channel), LocalAllocateDangledIndices.this.transportService.getThreadPool().getThreadContext());
            LocalAllocateDangledIndices.this.submitUnbatchedTask(source, new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    if (currentState.blocks().disableStatePersistence()) {
                        return currentState;
                    }
                    Metadata.Builder metadata = Metadata.builder(currentState.metadata());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder(LocalAllocateDangledIndices.this.allocationService.getShardRoutingRoleStrategy(), currentState.routingTable());
                    IndexVersion minIndexCompatibilityVersion = currentState.nodes().getMinSupportedIndexVersion();
                    IndexVersion maxIndexCompatibilityVersion = currentState.nodes().getMaxDataNodeCompatibleIndexVersion();
                    boolean importNeeded = false;
                    StringBuilder sb = new StringBuilder();
                    for (IndexMetadata indexMetadata : request.indices) {
                        IndexMetadata newIndexMetadata;
                        if (indexMetadata.getCompatibilityVersion().before(minIndexCompatibilityVersion)) {
                            logger.warn("ignoring dangled index [{}] on node [{}] since it's current compatibility version [{}] is not supported by at least one node in the cluster minVersion [{}]", (Object)indexMetadata.getIndex(), (Object)request.fromNode, (Object)indexMetadata.getCompatibilityVersion(), (Object)minIndexCompatibilityVersion);
                            continue;
                        }
                        if (indexMetadata.getCompatibilityVersion().after(maxIndexCompatibilityVersion)) {
                            logger.warn("ignoring dangled index [{}] on node [{}] since its current compatibility version [{}] is later than the maximum supported index version in the cluster [{}]", (Object)indexMetadata.getIndex(), (Object)request.fromNode, (Object)indexMetadata.getCompatibilityVersion(), (Object)maxIndexCompatibilityVersion);
                            continue;
                        }
                        if (currentState.metadata().hasIndex(indexMetadata.getIndex().getName())) continue;
                        if (currentState.metadata().hasAlias(indexMetadata.getIndex().getName())) {
                            logger.warn("ignoring dangled index [{}] on node [{}] due to an existing alias with the same name", (Object)indexMetadata.getIndex(), (Object)request.fromNode);
                            continue;
                        }
                        if (currentState.metadata().indexGraveyard().containsIndex(indexMetadata.getIndex())) {
                            logger.warn("ignoring dangled index [{}] on node [{}] since it was recently deleted", (Object)indexMetadata.getIndex(), (Object)request.fromNode);
                            continue;
                        }
                        importNeeded = true;
                        try {
                            newIndexMetadata = LocalAllocateDangledIndices.this.indexMetadataVerifier.verifyIndexMetadata(indexMetadata, minIndexCompatibilityVersion);
                            newIndexMetadata = IndexMetadata.builder(newIndexMetadata).settings(Settings.builder().put(newIndexMetadata.getSettings()).put("index.history.uuid", UUIDs.randomBase64UUID())).build();
                        }
                        catch (Exception ex) {
                            logger.warn(() -> Strings.format((String)"found dangled index [%s] on node [%s]. This index cannot be upgraded to the latest version, adding as closed", (Object[])new Object[]{indexMetadata.getIndex(), request2.fromNode}), (Throwable)ex);
                            newIndexMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.CLOSE).version(indexMetadata.getVersion() + 1L).build();
                        }
                        metadata.put(newIndexMetadata, false);
                        blocks.addBlocks(newIndexMetadata);
                        if (newIndexMetadata.getState() == IndexMetadata.State.OPEN || MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata)) {
                            routingTableBuilder.addAsFromDangling(newIndexMetadata);
                        }
                        sb.append("[").append(newIndexMetadata.getIndex()).append("/").append(newIndexMetadata.getState()).append("]");
                    }
                    if (!importNeeded) {
                        listener.reroute().onResponse(null);
                        return currentState;
                    }
                    logger.info("importing dangled indices {} from [{}]", (Object)sb.toString(), (Object)request.fromNode);
                    RoutingTable routingTable = routingTableBuilder.build();
                    ClusterState updatedState = ClusterState.builder(currentState).metadata(metadata).blocks(blocks).routingTable(routingTable).build();
                    return LocalAllocateDangledIndices.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTable).build(), "dangling indices allocated", listener.reroute());
                }

                @Override
                public void onFailure(Exception e) {
                    listener.clusterStateUpdate().onFailure(e);
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    listener.clusterStateUpdate().onResponse(new AllocateDangledResponse());
                }
            });
        }
    }

    public static class AllocateDangledRequest
    extends TransportRequest {
        DiscoveryNode fromNode;
        IndexMetadata[] indices;

        public AllocateDangledRequest(StreamInput in) throws IOException {
            super(in);
            this.fromNode = new DiscoveryNode(in);
            this.indices = in.readArray(IndexMetadata::readFrom, IndexMetadata[]::new);
        }

        AllocateDangledRequest(DiscoveryNode fromNode, IndexMetadata[] indices) {
            this.fromNode = fromNode;
            this.indices = indices;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.fromNode.writeTo(out);
            out.writeArray(this.indices);
        }
    }

    public static class AllocateDangledResponse
    extends TransportResponse {
        private AllocateDangledResponse(StreamInput in) throws IOException {
            if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
                in.readBoolean();
            }
        }

        private AllocateDangledResponse() {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
                out.writeBoolean(true);
            }
        }
    }
}

