/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.elasticsearch.common.MacAddressProvider;
import org.elasticsearch.common.RandomBasedUUIDGenerator;
import org.elasticsearch.common.SecureRandomHolder;
import org.elasticsearch.common.TimeBasedKOrderedUUIDGenerator;
import org.elasticsearch.common.TimeBasedUUIDGenerator;
import org.elasticsearch.common.UUIDGenerator;
import org.elasticsearch.common.settings.SecureString;

public class UUIDs {
    private static final AtomicInteger sequenceNumber = new AtomicInteger(SecureRandomHolder.INSTANCE.nextInt());
    public static final Supplier<Long> DEFAULT_TIMESTAMP_SUPPLIER = System::currentTimeMillis;
    public static final Supplier<Integer> DEFAULT_SEQUENCE_ID_SUPPLIER = sequenceNumber::incrementAndGet;
    public static final Supplier<byte[]> DEFAULT_MAC_ADDRESS_SUPPLIER = MacAddressProvider::getSecureMungedAddress;
    private static final UUIDGenerator RANDOM_UUID_GENERATOR = new RandomBasedUUIDGenerator();
    private static final UUIDGenerator TIME_BASED_K_ORDERED_GENERATOR = new TimeBasedKOrderedUUIDGenerator(DEFAULT_TIMESTAMP_SUPPLIER, DEFAULT_SEQUENCE_ID_SUPPLIER, DEFAULT_MAC_ADDRESS_SUPPLIER);
    private static final UUIDGenerator TIME_UUID_GENERATOR = new TimeBasedUUIDGenerator(DEFAULT_TIMESTAMP_SUPPLIER, DEFAULT_SEQUENCE_ID_SUPPLIER, DEFAULT_MAC_ADDRESS_SUPPLIER);
    public static final int TIME_BASED_UUID_STRING_LENGTH = 20;
    public static final int RANDOM_BASED_UUID_STRING_LENGTH = 22;

    public static String base64UUID() {
        return TIME_UUID_GENERATOR.getBase64UUID();
    }

    public static String base64TimeBasedKOrderedUUID() {
        return TIME_BASED_K_ORDERED_GENERATOR.getBase64UUID();
    }

    public static String base64TimeBasedUUID() {
        return TIME_UUID_GENERATOR.getBase64UUID();
    }

    public static String randomBase64UUID(Random random) {
        return RandomBasedUUIDGenerator.getBase64UUID(random);
    }

    public static String randomBase64UUID() {
        return RANDOM_UUID_GENERATOR.getBase64UUID();
    }

    public static SecureString randomBase64UUIDSecureString() {
        return RandomBasedUUIDGenerator.getBase64UUIDSecureString();
    }
}

